﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentNotesList = function(name)
{
	this.componentPagesList = componentPagesList;
	this.componentPagesList(name);

	this.p_checkMarkers = true;
	this.p_checkPNG = true;

	this.buttonVisible = true;
};

componentNotesList.prototype = new componentPagesList();
componentNotesList.prototype.type = "componentNotesList";

componentNotesList.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL); 

		this.imagesNameArr = [this.bckgTop, this.bckgMiddle, this.bckgBottom, this.buttonCloseOut, this.buttonCloseOver];
		this.getPreloadImagesArr();
	};
	this.captureMouseEvents();
	PlayerInterface.Execute("makeNoteInUELO", this.id);
};

componentNotesList.prototype.onCreate = function(obj)
{
	this.setImagesIntoHTMLObj();
};

componentNotesList.prototype.setImagesIntoHTMLObj = function()
{
	var bckgTopImg = document.getElementById(this.id + "_bckgTopImg");
	var bckgMiddleImg = document.getElementById(this.id + "_bckgMiddleImg");
	var bckgBottomImg = document.getElementById(this.id + "_bckgBottomImg");
	var closeButtonImg = document.getElementById(this.id + "_closeButtonImg");

	bckgTopImg.src = this.resourcesURL + this.bckgTop;
	bckgMiddleImg.src = this.resourcesURL + this.bckgMiddle;
	bckgBottomImg.src = this.resourcesURL + this.bckgBottom;
	closeButtonImg.src = this.resourcesURL + this.buttonCloseOut;
};

componentNotesList.prototype.onPaint = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) {
		this.deleteAllRows();
		this.setValuesIntoInput();
	};
	this.setDivElements();
};

componentNotesList.prototype.onAfterLoad = function(obj)
{
	this.deleteAllRows();
	this.setValuesIntoInput();
	return;
};

componentNotesList.prototype.componentNotesListBaseSetDivElements = componentNotesList.prototype.setDivElements;
componentNotesList.prototype.setDivElements = function(obj)
{
	this.componentNotesListBaseSetDivElements();

	var pagesTableDiv = document.getElementById(this.id + "_pagesTableDiv");
	var titleDiv = document.getElementById(this.id + "_titleDiv");
	var titleObj = document.getElementById(this.id + "_titleObj");
	var closeButtonDiv = document.getElementById(this.id + "_closeButtonDiv");

	if (pagesTableDiv) {
		pagesTableDiv.style.left = 0;
		pagesTableDiv.style.top = this.bckgTopH;
		pagesTableDiv.style.height = eval(this.h-this.bckgTopH-this.bckgBottomHeight);
		pagesTableDiv.style.width = eval(this.w-1);
		pagesTableDiv.style.clip = 'rect(0px '+eval(this.w-1)+'px '+eval(this.h-this.bckgTopH-this.bckgBottomHeight)+'px 0px)';
	};

	if (closeButtonDiv) {
		var buttonCloseOutH = getImageHeight(this.buttonCloseOut);
		var buttonCloseOutW = getImageWidth(this.buttonCloseOut);
		if (this.dir == "rtl") {
			closeButtonDiv.style.left = 40-buttonCloseOutW;
		} else {
			closeButtonDiv.style.left = this.w-40;
		};
		closeButtonDiv.style.top = 0;
		closeButtonDiv.style.height = buttonCloseOutH;
		closeButtonDiv.style.width = buttonCloseOutW;
		closeButtonDiv.style.clip = 'rect(0px '+buttonCloseOutW+'px '+buttonCloseOutH+'px 0px)';
	};

	if (titleDiv) {
		if (this.dir == "rtl") {
			titleDiv.style.left = 10;
		} else {
			titleDiv.style.left = 10;
		};
		titleDiv.style.top = 0;
		titleDiv.style.height = this.bckgTopH;
		titleDiv.style.width = this.w-20;
		titleDiv.style.clip = 'rect(0px '+eval(this.w-20)+'px '+this.bckgTopH+'px 0px)';

		var font = getProjectFont(this.titleAllowGF == 1, this.titleFontFamily, this.titleFontSize, this.titleFontColor );
		titleObj.style.fontFamily = font.family;
		titleObj.style.fontSize = getFontSize(font.size, 'px');
		titleObj.style.color = font.color;

		if (this.headerBold) {
			var headerText = titleObj.innerHTML;
			titleObj.innerHTML = '<b>'+headerText+'</b>';
		};
	};
};

componentNotesList.prototype.fillInput = function(value, ind)
{
	var cellNoWidth = 30;
	var table 	= document.getElementById(this.id+"_pagesTable");
	var row 				= table.insertRow(table.rows.length);
	var cell_1 				= row.insertCell(0);
	cell_1.style.width 		= cellNoWidth;

	var font = getProjectFont(this.allowGF == 1, this.fontFamily, this.fontSize, this.fontColor );
	cell_1.style.fontFamily = font.family;
	cell_1.style.fontSize 	= getFontSize(font.size, 'px');
	cell_1.style.color  	= font.color;

	cell_1.style.textAlign 	= "center";
	cell_1.innerHTML 		= eval(ind+1);

	var cell_2 			= row.insertCell(1);
	cell_2.innerHTML 	= '<input id="'+this.id+'_'+ind+'_input" style="border: 1px solid #000000; width:'+eval(this.w-cellNoWidth*2)+'px" maxlength="'+this.maxCharEnter+'" value="'+value+'" onBlur="pc.'+this.id+'.saveTexts();">';
};

componentNotesList.prototype.onUnLoad = function(e)
{
	this.saveTexts();
};

componentNotesList.prototype.saveTexts = function(e)
{
	var t = '';
	var sep = '';

	for (var i = 0; i < this.fieldsNumber; i++) {
		var input 	= document.getElementById(this.id+'_'+i+"_input");
		if (i != 0) sep = '#$#';
		t += sep;
		if (input) {
			t += input.value;
		};
	};
	PlayerInterface.Execute("updateNoteInUELO", this.id, t);
};

componentNotesList.prototype.setValuesIntoInput = function(e)
{
	var pagesArr = new Array();
	var params = '';

	if (PageInterface.GetValue("state") != psDesigning && lms) {
		var noteObj = PlayerInterface.Execute("getNoteFromUELO", this.id);
		if (noteObj){
			params = unescape(noteObj.note);
		};
		if (typeof(params) != 'undefined') pagesArr = params.split('#$#');
	};
	for (var i = 0; i < this.fieldsNumber; i++) {
		if (pagesArr != '' && pagesArr != 'undefined'){
			if(typeof(pagesArr[i]) == 'undefined') pagesArr[i] = '';
			this.fillInput(pagesArr[i], i);
		} else {
			this.fillInput('', i);
		};
	};
};

componentNotesList.prototype.ccomponentNotesListBaseUnselectable = componentNotesList.prototype.unselectable;
componentNotesList.prototype.unselectable = function()
{
	this.ccomponentNotesListBaseUnselectable();
	for (var i = 0; i < this.fieldsNumber; i++){
		var input 	= document.getElementById(this.id+'_'+i+"_input");
		if (input){
			input.unselectable = "";
		};
	};
};
