
var tree = null;
var selected = null;
var showSimpleStatusInTree = false;

function findTreeItem(idx)
{
    for (var i in TreeHandler.all) {
		if (TreeHandler.all[i].idx == idx) return TreeHandler.all[i];
	};
	return tree;
};

function findTreeIcon(status)
{
    switch (status) {
		case "C" : return TreeConfig.pageCompleted; break;
		case "P" : return TreeConfig.pagePass; break;
		case "F" : return TreeConfig.pageFail; break;
		case "I" : return TreeConfig.pageIncomplete; break;
		default : return TreeConfig.pageNotAtt; break;
	};
};

function insertTree()
{
	var struct = getStruct();
	if (typeof(struct) == 'undefined' || struct == null) return; //pg2-GIUB
	var item = struct.rootItem();
	var p = getPlayer();
	tree = new Tree(item["title"], null);
	tree.idx = item["index"];
	tree.pidx = item["parent"];

	for (var i = 0; i < struct.length(); i++) {
		if (struct.item(i)["visible"] == "1") {
			var item = struct.item(i);
			if (item) { //pg2-if item exists
				//var o = new TreeItem(item["title"], "javascript:getPlayer().gotoPage(" + item["gix"] + ");", findTreeItem(item["parent"])); //pg2-old
				var o = new TreeItem(item["title" + p.courseVersion], "javascript:getPlayer().gotoPage(" + item["gix"] + ");", findTreeItem(item["parent"]),findTreeIcon(item["status"])); //pg2- to bylo u KR
				o.idx = item["index"];
				o.gix = item["gix"];
				o.pidx = item["parent"];
			};
		};
	};
	
	document.write(tree);
	
	var player = getPlayer(); //pg2-bsh -otherwise statuses will not be repainted in tree
	if (player) {
		if (player.reinitializeTree == true) {
			initialize();
			player.reinitializeTree = false;
		};
	};
};

function setCourseVersion(vindex)
{
	var struct = getStruct();
	for (var i in TreeHandler.all) {
		for (var j = 0; j < struct.length(); j++) {
			var item = struct.item(j);
			if (item) { //pg2-if item exists
				if (TreeHandler.all[i].gix == item["gix"]) {
					var o = document.getElementById(TreeHandler.all[i].id + '-title');
					if (o) o.innerHTML = item["title" + vindex];
					o = document.getElementById(TreeHandler.all[i].id + '-anchor'); //pg2-update 'hint' too
					if (o) o.title = item["title" + vindex];
				};
			};
		};
	};
};
	
function setStatus(gix)	
{
	for (var i in TreeHandler.all) {
		if (TreeHandler.all[i].gix == gix) {
			var item = getStruct().findItem(gix);
			if (item) {
				var icon = TreeConfig.pageNotAtt;
				switch (item["status"]) {
					case "C": icon = TreeConfig.pageCompleted;
						break;
					case "I": icon = TreeConfig.pageIncomplete;
						break;
					case "P": icon = (showSimpleStatusInTree) ? TreeConfig.pageCompleted : TreeConfig.pagePass;
						break;
					case "F": icon = (showSimpleStatusInTree) ? TreeConfig.pageCompleted : TreeConfig.pageFail;
						break;
				};
				document.getElementById(TreeHandler.all[i].id + '-icon').src = icon;
			};
		};
	};
};

function initialize()
{
	for (var i in TreeHandler.all) {
		setStatus(TreeHandler.all[i].gix);
	};
};
	
function selectedNode(gix)
{
	if (selected) {
		setStatus(selected.gix);
		document.getElementById(selected.id).className = "tree-item";
	};
	selected = null;
	
	while (!selected && gix >= 0) {
		for (var i in TreeHandler.all) {
			if (TreeHandler.all[i].gix == gix) {
				setStatus(gix);
				document.getElementById(TreeHandler.all[i].id).className = "tree-item-select";
				selected = TreeHandler.all[i];
				TreeHandler.all[i].focus();
				return;
			};
		};
		gix--;
	};
};

function expandMyParents(gix)
{
	var struct = getStruct();
	var structLength = struct.length();
	var parentsGixArray = new Array();
	var counter = 0;
	var parent = null;

	for (var j = 0; j < structLength; j++) {
		for (var i = 0; i < structLength; i++) {
			if (struct.item(i)["gix"] == gix) {
				gix = struct.findPageGixByIndex(struct.item(i)["parent"]);
				parentsGixArray[parentsGixArray.length] = gix;
				break;
			};
		};
		if (gix == 0) break;
	};
	for (var i in TreeHandler.all) {
		for (var j=0; j < parentsGixArray.length; j++) {
			if (parentsGixArray[j] && parentsGixArray[j] == TreeHandler.all[i].gix) {
				TreeHandler.all[i].expand();
			};
		};
	};
};

function openAll()
{
    for (var i in TreeHandler.all) {
		if (TreeHandler.all[i].pidx == tree.idx) TreeHandler.all[i].expandAll();
	};
};

function closeAll()
{
    for (var i in TreeHandler.all) {
		if (TreeHandler.all[i].pidx == tree.idx) TreeHandler.all[i].collapseAll();
	};
};
