/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentTransitions = function(name)
{
	this.componentElement = componentText;
	this.componentElement(name);
	this.text = this.addChild(new componentText(null));

	this.transitionEnterType = 0;
	this.stepTrans = 0;
	this.cookie = new Cookie();

	this.timerID = null; //pg2
};

componentTransitions.prototype = new componentText;
componentTransitions.prototype.type = "componentTransitions";

componentTransitions.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();

	if (PageInterface.GetValue("state") == psDesigning) {
		var text = this.text.replace(/^(<.*>)(.*)(<\/.*>)$/,'$2');
		this.text = "<table width='100%' height='100%' cellspacing=2 cellpadding=0 border=0 style='border-color: #A4A4A4; border-style: solid; border-width: 2px'>";
		this.text += "<tr><td width='9' style='border-color: #820000; border-style: solid; border-width: 1px; background-color: #D20000; text-align: left; font-family: Verdana, Tahoma, Arial; font-size: 7pt; padding: 1px'><img src='../resources/arrow.gif' width='9' height='10' border='0' align='left'></td><td height='15' style='border-color: #A4A4A4; border-style: solid; border-width: 1px; background-color: #F5F5F5; text-align: center; font-family: Verdana, Tahoma, Arial; font-size: 7pt; padding: 1px'><b>"+text+"</b></td></tr>";
		this.text += "</table>";
	} else
	if (is.ie) {
		var transitionArr = this.transitionList.split("||");
		if (this.transitionList != "") {
			if (this.random) {
				var rand = Math.floor(Math.random() * transitionArr.length);
				this.transitionEnterType = parseInt(transitionArr[rand]);
			} else {
				this.stepTrans = parseInt(this.cookie.get(this.id+'TRANS'));
				if (!this.stepTrans) this.stepTrans = 0;
				this.transitionEnterType = parseInt(transitionArr[this.stepTrans]);

				this.stepTrans++;
				if (this.stepTrans >= transitionArr.length)
					this.stepTrans = 0;
			};

			page.style.visibility = "hidden";
			if (this.transitionEnterType < 24) {
				document.body.style.filter = "revealTrans(duration=3, transition="+this.transitionEnterType+");";
			} else
			if (this.transitionEnterType > 23) {
				switch (this.transitionEnterType) {
					case 24:
						document.body.style.filter = "progid:DXImageTransform.Microsoft.Pixelate(duration=3);";
						break;
					case 25:
						document.body.style.filter = "progid:DXImageTransform.Microsoft.gradientWipe(duration=3);";
						break;
					case 26:
						document.body.style.filter = "progid:DXImageTransform.Microsoft.Spiral(duration=3, GridSizeX=205, GridSizeY=205);";
						break;
					case 27:
						document.body.style.filter = "progid:DXImageTransform.Microsoft.Wheel((duration=3, spokes=10);";
						break;
					case 28:
						document.body.style.filter = "progid:DXImageTransform.Microsoft.RadialWipe(duration=3);";
						break;
					case 29:
						document.body.style.filter = "progid:DXImageTransform.Microsoft.Iris((duration=3);";
						break;
				};
			};
		};
	};
};

componentTransitions.prototype.playTransition = function(obj)
{
	window.clearTimeout(this.timerID); //pg2
	this.timerID = null;

	if (this.transitionList != "") {
		page.filters[0].Apply();
		page.style.visibility = "visible";
		page.filters[0].Play();
	};
};

componentTransitions.prototype.onAfterLoad = function(obj)
{
	if (is.ie){
		this.timerID = window.setTimeout('pc.' + this.id + '.playTransition();', 500); //pg2- added 'this.timerID'
	};
};

componentTransitions.prototype.onUnLoad = function(obj)
{
	if (this.timerID != null) { //pg2
		window.clearTimeout(this.timerID);
		this.timerID = null;
	};
};

componentTransitions.prototype.onFree = function()
{
	if (!this.random) this.cookie.set(this.id+'TRANS', this.stepTrans);
};
