﻿/*
 * Copyright (C) 2003,2004 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

ScormLMS = function()
{
	this.startTime = new Date();
  
	this.err;
	this.errDescription;

  // Define exception / error codes
	this._NoError = 0;
	this._GeneralException = 101;
	this._InvalidArgumentError = 201;
	this._NotInitialized = 301;
	this._NotImplementedError = 401;
	this._CompletedLock = false;
	
	this.STATUS_NOT_ATTEMPTED = "not attempted";
	this.STATUS_INCOMPLETE = "incomplete";
	this.STATUS_COMPLETED = "completed";
	this.STATUS_PASSED = "passed";
	this.STATUS_FAILED = "failed";
  
	this.apiHandle = null;
	
	this.LMSInitialize("");
};

ScormLMS.prototype.name = "Scorm13";

ScormLMS.prototype.setTime = function()
{
	this.LMSSetValue("cmi.session_time", this.formatTime("timeinterval", 
		this.calculateTimeToString(this.startTime, new Date()).toString().split(":")));
};

ScormLMS.prototype.setScore = function(score)
{
	this.LMSSetValue("cmi.score.raw", score);
};

ScormLMS.prototype.getScore = function()
{
	return this.LMSGetValue("cmi.score.raw");
};

ScormLMS.prototype.free = function()
{
	this.LMSCommit("");
	this.LMSTerminate("");
};

ScormLMS.prototype.LMSGetValue = function(command)
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSGetValue was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	// CALL GetValue
	result = api13.GetValue(command);
	// Needed for Netscape
	if (result == null) result = "";
	
	this.err = this.getErrorHandler();
	
	return result.toString();
};

ScormLMS.prototype.LMSSetValue = function(command, value)
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSSetValue was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	var result = api13.SetValue(command, value);
	this.err = this.getErrorHandler();
	
	return result.toString();
};

ScormLMS.prototype.LMSInitialize = function(iInParameter)
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSInitialize was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	// call the LMSInitialize function that should be implemented by the API
	
	// Fail if: No parameter, OR if the parameter is anything other than
	// an empty string
	var result;
	if ((iInParameter == null) || ((iInParameter != null) && (iInParameter.length != 0))) {
		result = api13.Initialize(iInParameter, false);
	} else {
		result = api13.Initialize(iInParameter, true);
	}
	
	this.err = this.getErrorHandler();
	
	return result.toString();
};

ScormLMS.prototype.getAPIHandle = function()
{
	if (!this.apiHandle) this.apiHandle = this.getAPI();
	return this.apiHandle;
}

ScormLMS.prototype.findAPI = function(win)
{
	// Search the window hierarchy for an object named "API"
	// Look in the current window (win) and recursively look in any child frames

	try {
		if (win && win.API_1484_11 != null) return win.API_1484_11;
	} catch(e) {}
	
	if (win && win.length > 0 ) {
		for (var i = 0; i < win.length; i++) {
			var theAPI = this.findAPI(win.frames[i]);
			if (theAPI != null) {
				return theAPI;
			}
		}
	}
	return null;
}

ScormLMS.prototype.getAPI = function()
{
	// start at the topmost window - findAPI will recurse down through
	// all of the child frames
	var theAPI = this.findAPI(parent);
	var isOpener=false;
	if (theAPI == null) {
		theAPI = this.findAPI(window.top);
	}
	// the API wasn't found in the current window's hierarchy.  If the
	// current window has an opener (was launched by another window),
	// check the opener's window hierarchy.
	if (theAPI == null) {
		var tempWin = window.parent.opener;
		if (tempWin != null) isOpener = true;
		while (isOpener) {
			if (tempWin.top) theAPI = this.findAPI(tempWin.top);
			if (theAPI != null) break;
			tempWin = tempWin.parent.opener;
			if (tempWin != null) isOpener = true;
			else isOpener = false;
		}
	}
	return theAPI;
}

ScormLMS.prototype.getErrorHandler = function()
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nErrorHandler was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	// CALL GetLastError
	var result = api13.GetLastError().toString();
	if (result != this._NoError) {
		// an error was encountered so display the error description
		this.errDescription = api13.GetErrorString(result);
		if (typeof(log) != 'undefined') log.error("ScormLMS::getErrorHandler "+result+":"+this.errDescription);
	}
	return result.toString();
};

ScormLMS.prototype.LMSCommit = function(iInParameter)
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSCommit was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	if ((iInParameter == null) || ((iInParameter != null) && (iInParameter.length != 0))) {
		result = api13.Commit(iInParameter, false);
	} else {
		result = api13.Commit(iInParameter, true);
	}
	this.err = this.getErrorHandler();
	return result.toString();
};

ScormLMS.prototype.LMSTerminate = function(iInParameter)
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSTerminate was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	if ((iInParameter == null) || ((iInParameter != null) && (iInParameter.length != 0))) {
		result = api13.Terminate(iInParameter, false);
	} else {
		result = api13.Terminate(iInParameter, true);
	}
	this.err = this.getErrorHandler();
	return result.toString();
};

//adl.nav.request (request(continue, previous, choice, exit, exitAll, abandon, abandonAll, _none_), RW) Navigation request to be processed immediately following Terminate()

ScormLMS.prototype.nextSCO = function()
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSTerminate was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	this.LMSSetValue("adl.nav.request", "continue");
	this.err = this.getErrorHandler();
	window.location.href = "about:blank";
};

ScormLMS.prototype.prevSCO = function()
{
	var api13 = this.getAPIHandle();
	
	if (api13 == null) {
		alert("Unable to locate the LMS's API Implementation.\nLMSTerminate was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	}
	
	this.LMSSetValue("adl.nav.request", "previous");
	this.err = this.getErrorHandler();
	window.location.href = "about:blank";
};

ScormLMS.prototype.getCMIValue = function(name)
{
	return this.LMSGetValue(name);
}

ScormLMS.prototype.formatTime = function(format, timearr)
{
	//tools.js
	return formatTime(format, new Date(this.startTime.getFullYear(), this.startTime.getMonth(),
		this.startTime.getDate(), timearr[0], timearr[1], timearr[2]));
};

ScormLMS.prototype.calculateTimeToString = function(dateStart, dateEnd)
{
	//tools.js
	return calculateTimeToString(dateStart, dateEnd);
};

ScormLMS.prototype.timeToString = function(cDate)
{
	//tools.js
	return formatTime("time", date);
};

ScormLMS.prototype.getStudentName = function()
{
	return this.LMSGetValue("cmi.learner_name");
};
var lms = new ScormLMS();
