﻿module Syllabify {
    export class Syllabify extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        Words: any[];
        numberOfChecked: number;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            this.createSyllabifyElements();
            this.numberOfChecked = 0;
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createSyllabifyElements() {
            this.Words = [];
            for (var i = 0; i < this.Elements.SyllabifyElements.el.length; i++) {
                var posX = this.Elements.SyllabifyElements.el[i].pos.x;
                var posY = this.Elements.SyllabifyElements.el[i].pos.y;
                var Lines = [];
                for (var j = 0; j < this.Elements.SyllabifyElements.el[i].text.length-1; j++) {
                    var el = this.game.add.text(posX, posY, this.Elements.SyllabifyElements.el[i].text[j], this.Elements.SyllabifyElements.Options.Style);
                    posX += el.width+10;
                    var line = EU.drawLine("red", posX - 5, posY, posX - 5, posY + el.height, this, el.height / 10);
                    line.alpha = 0.2;
                    line.inputEnabled = true;
                    line.name = "unchecked";
                    line.events.onInputDown.add(this.onLineClicked, this);
                    this.addChild(line);
                    this.addChild(el);
                    Lines.push(line);
                }
                var el = this.game.add.text(posX, posY,
                    this.Elements.SyllabifyElements.el[i].text[this.Elements.SyllabifyElements.el[i].text.length - 1],
                    this.Elements.SyllabifyElements.Options.Style);
                this.addChild(el);
                this.Words.push(Lines);
            }
        }

        onLineClicked(el: Phaser.Sprite, pointer) {
            if (el.name == "unchecked") {
                el.name = "checked";
                el.alpha = 1;
                this.numberOfChecked++;
            }
            else {
                el.name = "unchecked";
                el.alpha = 0.2;
                this.numberOfChecked--;
            }

            this.checkIfEverythingIsCorrect();
        }

        checkIfLinesAreCorrect() {
            for (var i = 0; i < this.Elements.SyllabifyElements.el.length; i++) {
                for (var j = 0; j < this.Elements.SyllabifyElements.el[i].answer.length; j++) {
                    var correct = false;
                    for (var k = 0; k < this.Elements.SyllabifyElements.el[i].answer[j].length; k++) {
                        if (this.Words[i][this.Elements.SyllabifyElements.el[i].answer[j][k]].name == "checked") {
                            correct = true;
                            break;
                        }
                    }
                    if (correct == false) return false;
                }
            }
            return true;
        }

        calculateMaxChecked() {
            var points = 0;
            for (var i = 0; i < this.Elements.SyllabifyElements.el.length; i++) {
                points += this.Elements.SyllabifyElements.el[i].answer.length;
            }
            return points;
        }

        checkIfEverythingIsCorrect() {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this)
                && EU.checkIfFillsAreCorrect(this)
                && this.checkIfLinesAreCorrect()
                && this.numberOfChecked == this.calculateMaxChecked()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        }

    }
} 