/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentHotspot = function(name)
{
	this.__componentImage = __componentImage;
	this.__componentImage(name);

	//required by hints
	this.hintRectangle = null;
	this.hintImage = null;
	this.hintTextAll = null;

	this.timerID = null;
	this.allowGF = true;
};

componentHotspot.prototype = new __componentImage();
componentHotspot.prototype.type = "componentHotspot";

componentHotspot.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = (page.allowCommunication()) ? PlayerInterface.GetValue("resourcesStatus") : PageInterface.GetValue("resourcesStatus");
	this.resourcesURL = (this.disableOnlineOfflineMix) ? resourcesURL : ((page.allowCommunication()) ? PlayerInterface.GetValue("resourcesURL") : PageInterface.GetValue("resourcesURL"));

    this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [this.hintImageSrc, this.hintImageSrcUpRight, this.hintImageSrcUpLeft, this.hintImageSrcDownLeft, this.hintImageSrcDownRight, this.src];
	this.getPreloadImagesArr();
};

componentHotspot.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();

	if (this.showBorderWithHint){
		this.setBorder('transparent', 0);
	};

	var font = {};
	font.family = this.hintTextFontFamily;
	font.size = this.hintTextFontSize;
	font.color = this.hintTextFontColor;

	if (this.allowGF && project.globalFormating && this.isDefaultFont(font) && !this.isDefaultFont(project.font)) {
		this.hintTextFontFamily = project.font.family;
		this.hintTextFontSize = project.font.size;
		this.hintTextFontColor = project.font.color;
	};
};

componentHotspot.prototype.isDefaultFont = function(font)
{
	var result = true;
	if (font.family != 'Arial') {
		result = false;
	} else
	if (font.size != 2) {
		result = false;
	} else
	if (font.color.replace(/#/g, "") != '000000') {
		result = false;
	};
	return result;
};

//get text dimensions
componentHotspot.prototype.getFontDimensions = function(sContent, sFont, sFontSize)
{
	if (!sFont) sFont 	= "";
	if (!sFontSize) sFontSize = "1";

	switch (sFontSize) {
		case "1": sFontSize = "8pt"; break;
		case "2": sFontSize = "10pt"; break;
		case "3": sFontSize = "12pt"; break;
		case "4": sFontSize = "14pt"; break;
		case "5": sFontSize = "18pt"; break;
		case "6": sFontSize = "24pt"; break;
		case "7": sFontSize = "36pt"; break;
	};

	var elem = document.getElementById(this.id+"_textSize");
	elem.style.fontFamily = sFont;
	elem.style.fontSize = sFontSize;
	elem.innerHTML = sContent;

	return { width:elem.offsetWidth, height:elem.offsetHeight };
};

componentHotspot.prototype.showTrainingFromApplicationHint = function (e)
{
	if (typeof(e) == "undefined") e = true;
	if (this.timerID != null) window.clearTimeout(this.timerID);

	if (!this.visible) return;

	if (e != false && pc.sim_work && typeof(pc.sim_work.simPoints) != "undefined") {
		pc.sim_work.outerChange = true;
		pc.sim_work.simPoints = 0;
		pc.sim_work.outerChange = false;
	};

	var hintRectangleWidth = this.hintWidth;
	var hintRectangleHeight = this.hintHeight;

	if (this.hintWidth == 0 || this.hintHeight == 0) {
		var textSize = this.getFontDimensions(this.hintText, this.hintTextFontFamily, this.hintTextFontSize);
		hintRectangleWidth = this.multiplier * (textSize.width + (parseInt(this.borderHintWidth)*2)) + 10;
		hintRectangleHeight = (textSize.height + (parseInt(this.borderHintWidth)*2)) / this.multiplier + 10;
	};

	switch (this.hintPosition) {
		case "nw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX - hintRectangleWidth;
			var rectangleY = imageY - hintRectangleHeight;
			var src = this.hintImageSrcUpLeft;
			break;
		case "ne":
			var imageX = this.x + this.w;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY - hintRectangleHeight;
			var src = this.hintImageSrcUpRight;
			break;
		case "se":
			var imageX = this.x + this.w;
			var imageY = this.y + this.h;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = this.hintImageSrcDownLeft;
			break;
		case "sw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y + this.h;
			var rectangleX = imageX - hintRectangleWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = this.hintImageSrcDownRight;
			break;
	};

	this.hintImage = page.addChild(new componentImage(this.id + "_hintArrow"));
	this.hintImage.x = imageX;
	this.hintImage.y = imageY;
	this.hintImage.w = this.hintImageWidth;
	this.hintImage.h = this.hintImageHeight;
	this.hintImage.cursor = "default";
	this.hintImage.src = src;
	this.hintImage.cursor = "default";
	this.hintImage.borderColor = "transparent";
	this.hintImage.borderWidth = 0;
	this.hintImage.step = 0;
	this.hintImage.visibleIf = "";
	this.hintImage.infoText = "Put an image here";
	this.hintImage.contentMode = 0;
	this.hintImage.stayOnTop = false;
	this.hintImage.alphaOpacity = "100";
	this.hintImage.altHint = "";
	this.hintImage.layer = 1;
	this.hintImage.disableOnlineOfflineMix = false;
	this.hintImage.automaticHideTimerInterval = 0;
    this.hintImage.setBorder(this.hintImage.borderColor, this.hintImage.borderWidth);
	this.hintImage.p_checkMarkers = this.p_checkMarkers;
	this.hintImage.p_checkPNG = this.p_checkPNG;
	this.hintImage.pngFix = this.pngFix;
	this.hintImage.show();
	page.setOnTop(this.hintImage);

	if (this.anotherPopup == "-") {	
		this.hintTextAll = page.addChild(new componentText(this.id + "_hintText"));
		this.hintTextAll.x = rectangleX;
		this.hintTextAll.y = rectangleY;
		this.hintTextAll.w = hintRectangleWidth + (this.borderHintWidth*2);
		this.hintTextAll.h = hintRectangleHeight + (this.borderHintWidth*2);
		this.hintTextAll.align = this.hintTextAlign;
		this.hintTextAll.valign = this.hintTextValign;
		this.hintTextAll.font.family = this.hintTextFontFamily;
		this.hintTextAll.font.size = this.hintTextFontSize;
		this.hintTextAll.font.color = this.hintTextFontColor; 
		this.hintTextAll.bgColor = this.bgHintColor;
		this.hintTextAll.wrap = this.hintTextWrap;
		this.hintTextAll.padding = this.borderHintWidth+2;
		this.hintTextAll.text = this.hintText;
		this.hintTextAll.cursor = "default";
		this.hintTextAll.borderColor = this.borderHintColor;
		this.hintTextAll.borderWidth = this.borderHintWidth;
		this.hintTextAll.lineHeight = this.hintTextLineHeight;
		this.hintTextAll.step = 0;
		this.hintTextAll.visibleIf = "";
		this.hintTextAll.contentMode = 0;
		this.hintTextAll.stayOnTop = false;
		this.hintTextAll.alphaOpacity = "100";
		this.hintTextAll.altHint = "";
		this.hintTextAll.layer = 1;
		this.hintTextAll.disableOnlineOfflineMix = false;
		this.hintTextAll.automaticHideTimerInterval = 0;
		this.hintTextAll.allowGF = this.allowGF;
		this.hintTextAll.p_checkMarkers = this.p_checkMarkers;
		this.hintTextAll.p_checkPNG = this.p_checkPNG;
		this.hintTextAll.pngFix = this.pngFix;
		this.hintTextAll.setBorder(this.hintTextAll.borderColor, this.hintTextAll.borderWidth);
		this.hintTextAll.show();

		page.setOnTop(this.hintTextAll);
	} else
	if (page.all[this.anotherPopup]){		
		var popup = page.all[this.anotherPopup];		
		if (popup) {
			popup.invokedFromDetectComponent = true; //pg2- do not repaint twice and overwrite text to standard one defined for (and within) popup component - just as in detect components
			if (popup.execution) {
				var popupContent = popup.findContentObj();				
				if (popupContent) popupContent.innerHTML = this.hintText; //pg2-if
			} else {
				popup.text.text = this.hintText;
			};
			if (popup.visible) popup.paint(); else popup.show();					
		};
		if (popup.visible) popup.paint(); else popup.show();
	};
	if (this.showBorderWithHint){
		this.setBorder(this.borderColor, this.borderWidth);
	};
};

componentHotspot.prototype.componentHotspotBaseShowObject = componentHotspot.prototype.show;
componentHotspot.prototype.show = function()
{
	this.componentHotspotBaseShowObject();

	if (this.showHints && !this.hintShowInStep) {
		if (this.timerID != null) window.clearTimeout(this.timerID);
		var condition = true;
		try {
			condition = ((eval(unescape(this.visibleIf)) == true) || (this.visibleIf == ''));
		} catch(e) {
			condition = true;
			if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.show() eval execution error\nMessage:\n' + e.message);
		};
		if (condition) this.timerID = window.setTimeout('pc.' + this.id + '.showTrainingFromApplicationHint();', this.hintTime); 
	};

	if (!this.doNotSetOnTop) PageInterface.Execute("setOnTop", this); //pg2-move on top, 'cause with pages preloader, going back to previously visited page, could cause that instad of hotspot, input will intercept all mouse events
};

componentHotspot.prototype.componentHotspotBaseHideObject = componentHotspot.prototype.hide;
componentHotspot.prototype.hide = function()
{
	this.componentHotspotBaseHideObject();
	if (this.showHints) { 
		if (this.hintRectangle != null) this.hintRectangle.hide();
		if (this.hintImage != null) this.hintImage.hide();
		if (this.hintTextAll != null) this.hintTextAll.hide();
		if (this.anotherPopup != '-') {
			var popup = PageInterface.GetValue("getChild", this.anotherPopup);
			if (popup) popup.hide();
		};
		//if (this.timerID != null) window.clearTimeout(this.timerID); //pg2-moved below
	};
	if (this.timerID != null) window.clearTimeout(this.timerID); //pg2
	this.timerID = null;
};

componentHotspot.prototype.onFree = function()
{
	if (this.timerID != null) 
		window.clearTimeout(this.timerID);
};

componentHotspot.prototype.showHint = function(e)
{
	this.showTrainingFromApplicationHint(e);
};

componentHotspot.prototype.isReady = function()
{
	var isLoaded = true
	for (var i=0; i < this.imagesNameArr.length; i++){
		isLoaded = preloadImage(this, "_"+i);
		if (!isLoaded) return false;
	};
	this.isLoaded = isLoaded;
	return this.isLoaded;
};
