﻿module FillShuffle {
    export class FillShuffle extends Base.BasicGroup {
        Elements: any;
        PREFIX: any;
        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }
        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.Prefix;
            this.loadGraphics();
            this.game.load.start()
        }
        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }
        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }
        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            EU.createStaticElements(this);
            this.createButtons();
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        }
        createButtons() {
            var el = this.game.add.text(725, 670, "CHECK", { font: "60px Arial", fill: 'blue', });
            el.setShadow(5, 5, "lightblue");
            el.inputEnabled = true;
            el.events.onInputDown.add(this.check, this);
            this.addChild(el);


        }
        check() {
              
        if (this.Elements.FillElements) {
            EU.killKeyboard();
            EU.setGameCompletion(this.parent, 0);           
            var allcompleted = true;
            for (var i = 0; i < this.Elements.FillElements.el.length; i++) {
                if (!this.Elements.FillElements.el[i].name || this.Elements.FillElements.el[i].name.text != this.Elements.FillElements.el[i].Answer) {
                    var el
                    if (this.Elements.FillElements.Options.SmallBox) {
                       el = this.game.add.text(this.Elements.FillElements.el[i].pos.x, this.Elements.FillElements.el[i].pos.y + 50, this.Elements.FillElements.el[i].Answer, { font: "30px Arial", fill: 'green', });
                    }
                    else {
                        el = this.game.add.text(this.Elements.FillElements.el[i].pos.x, this.Elements.FillElements.el[i].pos.y + 50, this.Elements.FillElements.el[i].Answer, { font: "60px Arial", fill: 'green', });
             
                    }
                    el.setShadow(5, 5, "lightgreen");                  
                    this.addChild(el);
                    allcompleted = false;
                } 

            }
            if (allcompleted)
                EU.setGameCompletion(this.parent,1);
            return true;
            
            }
        }
        checkIfEverythingIsCorrect()
        {
            EU.setGameCompletion(this.parent, 0);
            for (var i = 0; i < this.Elements.FillElements.el.length; i++) {
                if (!this.Elements.FillElements.el[i].name || this.Elements.FillElements.el[i].name.text != this.Elements.FillElements.el[i].Answer) {
                    return false;
                }

            }
            EU.setGameCompletion(this.parent, 1);
        }
    
        
    }
}