/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

__warningPopup = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	this.imWarningPopup = true;
	this.hidePage = true;
	this.popupH = 200;
	this.popupW = 300;
	this.warningIco = "___.warningIco.gif";
	this.infoIco = "___.infoIco.gif";
	this.closeIco = "___.close.gif";
	this.imageIco = this.warningIco;
	this.buttonYesVisible =  true;
	this.buttonNoVisible =  false;
	this.popupType = 1; // 1-warning, 2-info
	this.popupTimer = null;
	this.popupChangePosTimer = 4000;
	this.enableJumping = true;
	this.breakTimer = null;
	this.breakTime = 15*60; //in seconds
	
	this.buttonOKVisible =  true;
	this.okFunction = 'PlayerInterface.SetValue("setStudentLessonBreak"); this.hide();'

	this.buttonCancelVisible =  false;
	this.cancelFunction = 'this.ImActiveNow();';
	var lang = getLang(); //pg2
	if (lang != null) {
		this.setOKCaption(lang.getMessage("PAGE_POPUP_OK"));
		this.setCancelCaption(lang.getMessage("PAGE_POPUP_CANCEL"));
		this.setMessage(lang.getMessage("PAGE_POPUP_WARNING_TEXT"));
	} else {
		this.setOKCaption('Ok');
		this.setCancelCaption('Cancel');
		this.setMessage('You are inactive.<br>Close this window to return to the course.');
	};
};

__warningPopup.prototype = new componentElement();
__warningPopup.prototype.type = "__warningPopup";

__warningPopup.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};

	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [	this.warningIco, this.infoIco ];
	this.getPreloadImagesArr();
};

__warningPopup.prototype.onCreate = function()
{
	var newdiv = document.createElement('div');
	newdiv.setAttribute("id", this.id+"_popup");
	newdiv.style.position = "absolute";
	newdiv.style.backgroundColor = "#ACAE00";
	newdiv.style.border = "1px solid red";
	newdiv.style.width = this.popupW;
	newdiv.style.top = parseInt((this.h/2) - (this.popupH/2));
	newdiv.style.left = parseInt((this.w/2) - (this.popupW/2));
	newdiv.style.zIndex = 1000;

	var img = document.createElement('img');
	img.src = this.resourcesURL + this.imageIco;
	img.align = "left";
	newdiv.appendChild(img);

	var div = document.createElement('div');
	div.style.paddingTop = "10px";
	div.innerHTML = this.message;
	newdiv.appendChild(div);

	if (this.buttonOKVisible || this.buttonCancelVisible)
	{
		var buttonsDiv = document.createElement('div');
		buttonsDiv.style.paddingTop = "10px";
		buttonsDiv.style.textAlign = "center";
		buttonsDiv.style.clear = "both";

		if (this.buttonOKVisible)
		{
			var input = document.createElement('input');
			input.setAttribute("id", this.id+"_OKButton");
			input.type = "button";
			input.value = this.buttonOKCaption;
			input.onclick = this.okPressed;
			buttonsDiv.appendChild(input);
		};
		if (this.buttonCancelVisible)
		{
			var input = document.createElement('input');
			input.setAttribute("id", this.id+"_CancelButton");
			input.type = "button";
			input.value = this.buttonCancelCaption;
			input.onclick = this.cancelPressed;
			buttonsDiv.appendChild(input);
		}
		newdiv.appendChild(buttonsDiv);
	}

	this.obj.appendChild(newdiv);
};

__warningPopup.prototype.addEventToObj = function(node, eventName, func)
{
	if(node.addEventListener)
	{
		node.addEventListener(eventName, func, false);
	}
	else{
		node.attachEvent('on' + eventName, func);
	}
}

__warningPopup.prototype.setMessage = function(newMessage)
{
	this.message = newMessage;
}

__warningPopup.prototype.setOKCaption = function(newOKCaption)
{
	this.buttonOKCaption = newOKCaption;
}

__warningPopup.prototype.setCancelCaption = function(newCancelCaption)
{
	this.buttonCancelCaption = newCancelCaption;
}

__warningPopup.prototype.setOKFunction = function(newFunction)
{
	this.okFunction = newFunction;
}

__warningPopup.prototype.setCancelFunction = function(newFunction)
{
	this.cancelFunction = newFunction;
}

__warningPopup.prototype.setPopupType = function(typeInt, yesVisible, noVisible)
{
	this.popupType = typeInt;
	this.buttonOKVisible =  yesVisible;
	this.buttonCancelVisible =  noVisible;
	var lang = getLang();

	switch (this.popupType) {
		case 1 :
				this.imageIco = this.warningIco;
				if (lang != null) //pg2
					this.setMessage(lang.getMessage("PAGE_POPUP_WARNING_TEXT"));
				else
					this.setMessage('You are inactive.<br>Close this window to return to the course.');
			break;
		case 2 :
				this.imageIco = this.infoIco;
				if (lang != null) //pg2
					this.setMessage(lang.getMessage("PAGE_POPUP_INFO_TEXT"));
				else
					this.setMessage('Do you want to take a breake?');
			break;
	};
};

__warningPopup.prototype.baseShow = __warningPopup.prototype.show;
__warningPopup.prototype.show = function()
{
	this.baseShow();
	this.setOnTop();
	this.runJumpingTimer();
};

__warningPopup.prototype.moveRandomInactiveWindow = function()
{
	var pageBody = PlayerInterface.connectedPage.body;
	if (pageBody) {
		var obj = document.getElementById(this.id+"_popup");
		if (obj){
			var availH = pageBody.clientHeight - this.popupH;
			var availW = pageBody.clientWidth - this.popupW;

			obj.style.top = Math.random()*availH;
			obj.style.left = Math.random()*availW;

			this.runJumpingTimer();
		};
	};
};

__warningPopup.prototype.clearJumpingTimer = function()
{
	window.clearTimeout(this.popupTimer);
	this.popupTimer = null;
};
__warningPopup.prototype.runJumpingTimer = function()
{
	if (!this.enableJumping) return;
	this.clearJumpingTimer();
	this.popupTimer = setTimeout('pc.'+this.id+'.moveRandomInactiveWindow();', this.popupChangePosTimer);  
};
__warningPopup.prototype.okPressedAction = function()
{
	try
	{
		eval(this.okFunction);
	}catch(e)
	{
	}
}
__warningPopup.prototype.cancelPressedAction = function()
{
	try
	{
		eval(this.cancelFunction);
	}catch(e)
	{
	}
}
__warningPopup.prototype.okPressed = function()
{
	var id = this.id.replace("_OKButton", ""); 
	var comp = PageInterface.GetValue("getChild", id);
	if (comp)
	{
		comp.okPressedAction();
	}
}
__warningPopup.prototype.cancelPressed = function()
{
	var id = this.id.replace("_CancelButton", ""); 
	var comp = PageInterface.GetValue("getChild", id);
	if (comp)
	{
		comp.cancelPressedAction();
	}
};
__warningPopup.prototype.ImActiveNow = function()
{
	PlayerInterface.SetValue("setStudentActive", new Date());
	this.hide();
};
__warningPopup.prototype.baseHide = __warningPopup.prototype.hide;
__warningPopup.prototype.hide = function()
{
	this.clearJumpingTimer();
	this.baseHide();
}
__warningPopup.prototype.onResize = function()
{
	var pageBody = PlayerInterface.connectedPage.body;

	this.style.height = pageBody.clientHeight;
	this.style.width = pageBody.clientWidth;
	this.style.clip = 'rect(0px, '+this.style.width+', '+this.style.height+', 0px)';

	var obj = document.getElementById(this.id+"_popup");
	if (obj){
		obj.style.top = pageBody.clientHeight/2 - this.popupH/2;
		obj.style.left = pageBody.clientWidth/2 - this.popupW/2;

		this.runJumpingTimer();
	};
};
