/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("selectionControl.js");

MarkerItem = function()
{
	this.position = -1;
	this.text = null;
};

MarkerItem.prototype.toString = function()
{
	var result = this.position + "," + escape(this.text);
	return result;
};

SelectionControl = function(soo, svo, g)
{
	this.compareArrTXT = new Array();
	this.compareArrHTML = new Array();
	this.generated = false;
	this.gecko = g || false;

	this.sourceObj = soo || null;
	this.saverObj = svo || null;
};

SelectionControl.prototype.create = function()
{
	if (this.gecko) {
	} else {
	};
};

SelectionControl.prototype.init = function()
{
	if (this.sourceObj && this.saverObj) {
	} else {
		return;
	};
	if (this.gecko) {
	} else {
		var oDoc = this.saverObj.contentWindow || this.saverObj.contentDocument;
		if (oDoc.document) {
			oDoc = oDoc.document;
		};
		if (oDoc.body) {
			oDoc.body.innerHTML = this.sourceObj.innerHTML;
		};
	};
	this.generateCA();
};

SelectionControl.prototype.generateCA = function()
{
	this.compareArrTXT = new Array();
	this.compareArrHTML = new Array();

	if (this.gecko) {
	} else {
		this.moveToTable(this.sourceObj.innerText, this.compareArrTXT);
		this.moveToTable(this.sourceObj.innerHTML, this.compareArrHTML);
		this.generated = true;
	};
};

SelectionControl.prototype.moveToTable = function(value, table)
{
	var in_tag = false;
	for (var i=0; i<value.length; i++) {
		var charAtI = value.charAt(i);
		if (charAtI == '<') in_tag = true;
		if (!in_tag) {
			table[table.length] = new Array(i, charAtI);
		};
		if (charAtI == '>') in_tag = false;
	};
};

SelectionControl.prototype.getIdsFromSelection = function(rng)
{
	var result = new Array();
	var elem = document.createElement('span');
	elem.innerHTML = rng.htmlText;

	for (var i=0; i<elem.childNodes.length; i++) {
		var child = elem.childNodes(i);
		if (typeof(child.id) != "undefined" && child.id != "") {
			result[result.length] = child.id;
		};
	};
	return result;
};

SelectionControl.prototype.wrongSelection = function(ids)
{
	var result = false;
	for (var i=0; i<page.children.length; i++) {
		var child = page.children[i];
		for (var j=0; j<ids.length; j++) {
			if (child.id == ids[j]) {
				result = true;
				return result;
			};
		};
	};
	return result;
};

SelectionControl.prototype.getMarkerFromSelection = function(obj)
{
	var result = new MarkerItem();
	return result; //pg2-context_menu_test - todo -fix in IE, then try to restore block
	
	if (document.selection) { //pg2-context_menu_test
		var sel = document.selection;
		if (sel && sel.type.toLowerCase() == 'text') {
			var sel_rng = sel.createRange();
			var text = sel_rng.text;
			if (obj.innerText.indexOf(text) != -1 && !this.wrongSelection(this.getIdsFromSelection(sel_rng))) {
				result.text = sel_rng.text;

				var lastInnerHTML = obj.innerHTML;
				sel_rng.text = "_[#]_";
				result.position = obj.innerText.indexOf("_[#]_");
				obj.innerHTML = lastInnerHTML;
			};
		};
	} else
	if (window.getSelection) { //pg2-context_menu_test
		var html;
		var sel = window.getSelection();
		if (sel) {
			var test = sel.toString();
			/*if (sel.rangeCount) {
				var frag = sel.getRangeAt(0).cloneContents();
				var el = document.createElement("div");
				el.appendChild(frag);
				html = el.innerHTML;
			};*/
		};
	};
	return result;
};

SelectionControl.prototype.markText = function(obj, item, color)
{
	if (item && item.position != -1 && item.text != null) {
		var arr_pos = -1;
		for (var i=0; i<this.compareArrTXT.length; i++) {
			if (this.compareArrTXT[i][0] == item.position) {
				arr_pos = i;
				break;
			};
		};
		if (arr_pos != -1) {
			var new_val = "";

			for (var i=arr_pos; i<arr_pos + item.text.length; i++) {
				new_val += this.compareArrTXT[i][1];
			};

			if (new_val == item.text) {
				var oDoc = this.saverObj.contentWindow || this.saverObj.contentDocument;
				if (oDoc.document) {
					oDoc = oDoc.document;
					if (oDoc.body) {
						oDoc.body.innerHTML = obj.innerHTML;
					};
				};
				var s_pos = this.compareArrTXT[arr_pos][0];
				if (this.compareArrTXT[arr_pos + item.text.length]) {
					var e_pos = this.compareArrTXT[arr_pos + item.text.length][0];
				} else {
					var e_pos = this.compareArrTXT[arr_pos + item.text.length - 1][0];
					e_pos++;
				};
				var l_pos = this.compareArrTXT[this.compareArrTXT.length - 1][0];
				if (oDoc.body) {
					var sel_rng = oDoc.body.createTextRange();
					sel_rng.moveStart("character", s_pos);
					sel_rng.moveEnd("character", e_pos - l_pos - 1);
					try {
						sel_rng.select();
					} catch(e) {};
				};
				if (oDoc.execCommand) {
					oDoc.execCommand("BackColor", false, color);
				};
				if (oDoc.body) {
					obj.innerHTML = oDoc.body.innerHTML;
				};
			};
		};
	};
};
