/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentText = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.markers = "";
	this.selectionControl = null;
};

componentText.prototype = new __componentText;
componentText.prototype.type = "componentText";

componentText.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();

	this.contentObj = this.findContentObj();
	this.selectionControl = new SelectionControl(this.contentObj, document.getElementById("__selection_saver"), is.moz);
	this.selectionControl.create();
	this.selectionControl.init();
};

componentText.prototype.initMarkers = function(obj)
{
	var markersArr = this.markers.split(';');
	for (var i=0; i<markersArr.length; i++) {
		var itemArr = markersArr[i].split(',');
		var marker = new MarkerItem();
		marker.position = parseInt(itemArr[0]);
		marker.text = unescape(itemArr[1]);

		this.selectionControl.markText(this.contentObj, marker, page.selectionColor);
		this.reinit();
		this.selectionControl.init();
	};
};

componentText.prototype.componentTextBaseOnCreate = componentText.prototype.onCreate;
componentText.prototype.onCreate = function(obj)
{
	this.componentTextBaseOnCreate();

	if (this.scrollable) {
		this.scrollOffset = 14;
		this.stopPropagation = true;
	};
};

componentText.prototype.onSetPoints = function()
{
	this.onPaint();
};

componentText.prototype.scrollWindow = function(obj)
{
	window.scrollTo(0, this.y);
};

componentText.prototype.doStartStopSelect = function(getm)
{
	if (!page.enableSelection) return; //if (!page.enableSelection) return; //pg2-context_menu_test -removed, replaced with right click context menu //pg2-context_menu_ON-OFF -removed 'config.disableRightClick'
	if (typeof(this.selectionControl) == 'undefined' || this.selectionControl == null) return; //pg2-d'n'd feedback and mousemove restore -just have found it...some leftover after KG

	if (getm) {
		this.contentObj = this.findContentObj();
		var marker = this.selectionControl.getMarkerFromSelection(this.contentObj);
		if (typeof(marker.text) == "undefined" || marker.text == null || this.contentObj.innerText.indexOf(marker.text) == -1) {
			marker.text = "";
		};
		if (marker.text != "" && marker.position != -1) {
			this.selectionControl.markText(this.contentObj, marker, page.selectionColor);
			this.reinit();
			this.selectionControl.init();
			//kr - set to more uniqe separator
			//this.markers += ((this.markers != "") ? ";#;" : "") + marker.toString();
			this.markers += ((this.markers != "") ? ";" : "") + marker.toString();
		} else {
			this.unselectable(!this.selEnabled);
		};
	} else {
		this.unselectable(!this.selEnabled);
	};
};

componentText.prototype.load = function()
{
	this.markers = null;
	var item = page.getMarker(this.id);
	if (item) {
		this.markers = item.selections;
	};
	if (this.markers == null) this.markers = "";
};

componentText.prototype.unload = function()
{
	page.setMarker(this.id, this.markers);
};

componentText.prototype.componentTextBaseEventMouseDown = componentText.prototype.eventMouseDown;
componentText.prototype.eventMouseDown = function(e)
{
	this.selEnabled = true;
	this.doStartStopSelect();
	return this.componentTextBaseEventMouseDown(e);
};

componentText.prototype.componentTextBaseEventMouseUp = componentText.prototype.eventMouseUp;
componentText.prototype.eventMouseUp = function(e)
{
	this.doStartStopSelect(true);
	this.selEnabled = false;
	return this.componentTextBaseEventMouseUp(e);
};

componentText.prototype.changeTextProperties = function(font, size, color, bold, underline, italic)
{
	this.contentObj = this.findContentObj();
	var obj = (this.contentObj) ? this.contentObj : this.obj;

	if (obj && obj.style) {
		obj.style.fontFamily = (font != "") ? unescape(font) : "Arial";
		obj.style.fontSize = ((size != "") ? getFontSize(size, "px") : getFontSize(2, "px")) + "px";
		obj.style.color = (color != "") ? unescape(color) : "#000000";
		obj.style.fontWeight = (bold == 1) ? "bold" : "normal";
		obj.style.fontStyle = (italic == 1) ? "italic" : "normal";
		obj.style.textDecoration = (underline == 1) ? "underline" : "none";

		for (var i = 0; i < obj.childNodes.length; i++) {
			var item = obj.childNodes[i];
			if (item.style) {
				item.style.fontFamily = (font != "") ? unescape(font) : "Arial";
				item.style.fontSize = ((size != "") ? getFontSize(size, "px") : getFontSize(2, "px")) + "px";
				item.style.color = (color != "") ? unescape(color) : "#000000";
				item.style.fontWeight = (bold == 1) ? "bold" : "normal";
				item.style.fontStyle = (italic == 1) ? "italic" : "normal";
				item.style.textDecoration = (underline == 1) ? "underline" : "none";
			};
		};
	};
};
