/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("playerInterface.js");

var psNormal = 0;
var psDesigning = 1;
var psPreview = 2;
var psView = 3;

WBTPlayerInterface = function()
{
	this.connectedPlayer = null;
	this.connectedStruct = null;
	this.connectedLMS = null;
	this.connectedUELO = null;
	this.connectedSW = null;
	this.connectedProject = null;
	this.connectedPage = null;
	this.textMarkers = new Array();

	this.showErrors = true;
	this.showInPopup = false;
	/* error code */
	this.EC_INTERFACE_NOT_INITIALIZED = "WBTPlayerInterface error. Interface not initialized.\nYou must initialize the interface first.";
	this.EC_INTERFACE_NOT_SUPPROT_MOP_GET = "WBTPlayerInterface error. %s. Instruction %s is not suported.";
	this.EC_INTERFACE_NOT_SUPPROT_MOP_SET = "WBTPlayerInterface error. %s. Instruction %s is not suported.";
	this.EC_EXECUTION_INSTRUCTION = "WBTPlayerInterface error. %s. Instruction execution error.\nCheck it: [%s]\n%s";
	this.EC_COMUNICATION_NOT_INIT = "WBTPlayerInterface error. Could not establish remote control session.\n%s";
	this.EC_COM_NOT_INIT_STR = "Unable to locate the %s implementation.\nInitialize was not successful.";
	this.EC_EXECUTION_COM_NI = "WBTPlayerInterface error. Instruction execution error. %s not initialized.";
	this.UELO_NOT_INITIALIZED = "Page doesn't exist in UELO. Please run preview again.";
};

WBTPlayerInterface.prototype.Initialize = function(obj)
{
	var result = true;
	this.connectedPage = obj;

	if (!this.connectedPage) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Page")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Page")));
			};
		};
	} else {
		obj.connected = true;
	};

	if (!this.connectedPage.allowCommunication()) return false;

	if (lms && typeof(lms.enableChangePage) == 'function') {
		lms.enableChangePage();
	};

	this.initStruct();
	if (!this.connectedStruct) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Struct")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Struct")));
			};
		};
	};
	this.initProject();
	if (!this.connectedProject) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Project")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Project")));
			};
		};
	};
	this.initPlayer();
	if (!this.connectedPlayer) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Player")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "Player")));
			};
		};
	};
	this.initLMS();
	if (!this.connectedLMS) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "LMS")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "LMS")));
			};
		};
	};
	this.initUELO();
	if (!this.connectedUELO) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "UELO")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "UELO")));
			};
		};
	};
	this.initSW();
	if (!this.connectedSW) {
		result = false;
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "SW")));
			} else {
				error(formatString(this.EC_COMUNICATION_NOT_INIT, formatString(this.EC_COM_NOT_INIT_STR, "SW")));
			};
		};
	};

	if (!this.connectedUELO.initialized && (this.connectedLMS.name == "lmsScorm" ||
		this.connectedLMS.name == "lmsWBTS" || this.connectedLMS.name == "lmsExplorer" ||
		this.connectedLMS.name == "lmsExam"))
	{
		if (!this.connectedUELO.initialized) {
			this.connectedUELO.sco_gix = this.connectedProject.pageGlobalIndex;
			this.connectedUELO.updateUELOFromSDMultiple(this.connectedLMS.lessonStatus,
				this.connectedLMS.getLastUserAnswer());
			this.connectedUELO.initialized = true;
		};
	};
	return result;
};

WBTPlayerInterface.prototype.CompleteInitialization = function(obj) //pg2-speed up
{
	if (this.connectedUELO && this.connectedPage) {
		this.connectedUELO.CompleteInitialization(this.connectedPage.p_globalIndex);
	};
};

WBTPlayerInterface.prototype.initStruct = function()
{
	this.connectedStruct = getStruct();
};

WBTPlayerInterface.prototype.initProject = function()
{
	this.connectedProject = project;
};

WBTPlayerInterface.prototype.initPlayer = function()
{
	this.connectedPlayer = getPlayer();
};

WBTPlayerInterface.prototype.initLMS = function()
{
	this.connectedLMS = getLMS();
};

WBTPlayerInterface.prototype.initUELO = function()
{
	this.connectedUELO = getUELO();
};

WBTPlayerInterface.prototype.initSW = function()
{
	this.connectedSW = getSW();
};

WBTPlayerInterface.prototype.userHasChances = function(el)
{
	var intCount = 0;
	var pageBaseTryCount = this.connectedPage.getBaseTryCount();
	//pg2-in another case there is a wrong result (on page's startup there is returned that user has no chances!!!)
	var answLeft = this.connectedPage.countAnswers;
	var totalAttempts = this.connectedPage._countAnswers;
	var pageStatus = this.connectedPage.pageStatus;
	var usrHasChances = (
							(totalAttempts == 0 && pageStatus != "passed") || 
							(totalAttempts > 0 && 
								(answLeft > 0 || 
								(isNaN(answLeft) && this.connectedLMS.name == 'lmsExplorer')) //pg2-profiles_exe -in case of EXE with profiles from WBTS/EIS, answLeft is not defined and set to NaN (TODO- check why)
							)
						);
	//alert('03. totalAttempts: ' + totalAttempts + ', pageStatus: ' + pageStatus + ', answLeft: ' + answLeft + ', usrHasChances: ' + usrHasChances + '\n\n' + this.connectedPage.countAnswers + ', lmsName: ' + this.connectedLMS.name); //pg2-test_profile

	for (var i in pc) {
		var child = pc[i];
		if (child.interactions && typeof(child.className) != "undefined" && child.className == "element" && child.id.indexOf("WBTObject") != 0) { //pg2-otherwise with writeQuestin on the page, hiding ok button won't work //pg2-test_inter
			intCount++;
			var interId = child.id+"_"+this.connectedPage.p_globalIndex;
			var ia = this.connectedUELO.findInteraction(this.connectedPage.p_globalIndex, interId);
			if (ia) {
				if (ia.tryNumber < pageBaseTryCount || pageBaseTryCount == 0) {
					//return true; //pg2-removed
					if (this.connectedLMS && this.connectedLMS.name == "LMSApp") { //pg2-in pagePreview or coursePreview
						return (usrHasChances && pageStatus != "passed");
					} else {
						return true; //pg2-old
					};
				};
			};
		};
	};
	return usrHasChances; //(pageBaseTryCount == 0 || intCount == 0); //pg2-replace
};

WBTPlayerInterface.prototype.isQuizPageToReset = function(gix) //pg2- in case of drawing questions, if previously elements were locked after given answer, page must be reseted
{
	var res = false;
	if (!this.connectedUELO) return true; //pg2- if page is hidden and shown inside iframe, return true
	for (var i=0; i < this.connectedUELO.pages.length; i++) {
		var obj = this.connectedUELO.pages[i];
		if (obj.globalIndex == gix) {
			res = (obj.isQuizPageToReset || obj.blockRestorePage); //pg2-qr -added blockRestorePage
			if (typeof(res) == "undefined") {
				res = false;
			} else {
				obj.isQuizPageToReset = false; //immediately set to false, 'cause 'above' this method, page will be reseted
			};
			break;
		};
	};
	return res;
};

WBTPlayerInterface.prototype.getUeloPageStatus = function(gix) //pg2-required to modyfication is page.js (qr-completion)
{
	var res = "C";
	if (!this.connectedUELO) return res;
	for (var i=0; i < this.connectedUELO.pages.length; i++) {
		var obj = this.connectedUELO.pages[i];
		if (obj.globalIndex == gix) {
			res = obj.status;
			break;
		};
	};
	return res;
};

WBTPlayerInterface.prototype.checkInterface = function()
{
	if (this.connectedPage && !this.connectedPage.allowCommunication()) return false;

	if (!this.connectedPlayer) {
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_EXECUTION_COM_NI, "Player"));
			} else {
				error(formatString(this.EC_EXECUTION_COM_NI, "Player"));
			};
		};
		return false;
	};
	if (!this.connectedLMS) {
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_EXECUTION_COM_NI, "LMS"));
			} else {
				error(formatString(this.EC_EXECUTION_COM_NI, "LMS"));
			};
		};
		return false;
	};
	
	if (!this.connectedUELO) {
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_EXECUTION_COM_NI, "UELO"));
			} else {
				error(formatString(this.EC_EXECUTION_COM_NI, "UELO"));
			};
		};
		return false;
	};
	if (!this.connectedSW) {
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(formatString(this.EC_EXECUTION_COM_NI, "SW"));
			} else {
				error(formatString(this.EC_EXECUTION_COM_NI, "SW"));
			};
		};
		return false;
	};
	if (!this.connectedPage) {
		if (this.showErrors) {
			if (this.showInPopup) {
				this.showMessegeInPopup(this.EC_INTERFACE_NOT_INITIALIZED);
			} else {
				error(this.EC_INTERFACE_NOT_INITIALIZED);
			};
		};
		return false;
	};
	return true;
};

WBTPlayerInterface.prototype.GetValue = function(name)
{
	if (!this.checkInterface()) return null;
	switch (name) {
		case "getConst":
			if (arguments[1] && typeof(arguments[1]) == "string") {
				switch (arguments[1]) {
					case "STATUS_NOT_ATTEMPTED":
						return this.connectedLMS.STATUS_NOT_ATTEMPTED;
					case "STATUS_BROWSED":
						return this.connectedLMS.STATUS_BROWSED;
					case "STATUS_INCOMPLETE":
						return this.connectedLMS.STATUS_INCOMPLETE;
					case "STATUS_FAILED":
						return this.connectedLMS.STATUS_FAILED;
					case "STATUS_COMPLETED":
						return this.connectedLMS.STATUS_COMPLETED;
					case "STATUS_PASSED":
						return this.connectedLMS.STATUS_PASSED;
				};
				return null;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.getConst", arguments[1], "The second argument must by string."));
				return false;
			};

		case "userHasChances":
			if (this.connectedLMS.name == "lmsScorm"
					|| this.connectedLMS.name == "lmsWBTS"
					|| this.connectedLMS.name == "lmsExam") {
				if (this.GetValue("getTryNumber") < this.connectedPage._countAnswers || this.connectedPage._countAnswers == 0) {
					return true;
				};
			} else {
				return this.userHasChances();
			};
			return false;

		case "userHasTry":
			if (this.connectedLMS.name == "lmsScorm"
					|| this.connectedLMS.name == "lmsWBTS"
					|| this.connectedLMS.name == "lmsExplorer"
					|| this.connectedLMS.name == "lmsExam") {
				if (this.GetValue("getStatus") != "passed" && (this.GetValue("getTryNumber") < this.connectedPage._countAnswers)) {
					return true;
				};
			} else {
				for (var i in pc) {
					var o = pc[i];
					if (o.interactions && typeof(o.className) != "undefined" && o.className == "element" && o.id.indexOf("WBTObject") != 0) { //pg2-test_inter
						var ia = this.connectedUELO.AddInteractionToPage(this.connectedPage.p_globalIndex, o.id, o.type);
						if (ia) {
							if ((ia.status != 'P') && (ia.tryNumber < this.connectedPage._countAnswers)) {
								return true;
							};
						};
					};
				};
			};
			return false;

		case "getPoints":
			//do uelo
			if (typeof(this.connectedLMS.getPoints) == "undefined") return 0; //pg2- if there is no such a method...
			return this.connectedLMS.getPoints();

		case "getStatus":
			//do uelo
			if (this.connectedLMS.name == "LMSApp") {
				return this.connectedLMS.LMSGetValue(this.connectedPage.p_globalIndex, "status");
			} else {
				return this.connectedLMS.getStatus();
			};

		case "getUELOStatus":
			//do uelo
			return this.connectedUELO.getPageStatus(this.connectedPage.p_globalIndex);

		case "getLastUserAnswer":
			//do uelo
			if (typeof(this.connectedLMS.getLastUserAnswer) == "undefined") return ""; //pg2- if there is no such a method...
			return this.connectedLMS.getLastUserAnswer();

		case "getUserAnswer":
			//do uelo
			var ans = this.connectedUELO.GetPageStudentAnswer(this.connectedPage.p_globalIndex, (this.connectedLMS.name == "lmsExam"));
			if (ans == "") ans = this.connectedPage.getAnswerString();
			return ans;

		case "getTryNumber":
			if (typeof(this.connectedLMS.getTryNumber) == "undefined") return 0; //pg2- if there is no such a method...
			var result = this.connectedLMS.getTryNumber(arguments[1]);
			result = (result == E_NOTIMPL) ? 0 : result;
			return result;

		case "isRegistred":
			//do uelo
			if (this.connectedPage.state == psNormal) {
				return (this.connectedPlayer.gix == this.connectedPage.p_globalIndex);
			} else return true;

		case "lessonType":
			return this.connectedPage.pageType;

		case "getCourseVersion":
			return this.connectedPlayer.courseVersion;

		case "userName":
			return this.connectedUELO.username;

		case "userPrivilege":
			if (typeof(this.connectedLMS.getUserPrivilege) == "undefined") return ""; //pg2- if there is no such a method...
			return this.connectedLMS.getUserPrivilege();

		case "lmsName":
			return (this.connectedLMS) ? this.connectedLMS.name : "online";

		case "resourcesStatus":
			if (typeof(this.connectedLMS.resourcesStatus) == "undefined") return "offline"; //pg2- if there is no such a method...
			return (this.connectedLMS && this.connectedLMS.name != "lmsOffline") ? this.connectedLMS.resourcesStatus() : "online";

		case "resourcesURL":
			if (typeof(this.connectedLMS.resourcesURL) == "undefined") return resourcesURL; //pg2- if there is no such a method...
			return (this.connectedLMS && this.connectedLMS.name != "lmsOffline") ? this.connectedLMS.resourcesURL() : resourcesURL;

		case "getPageMarkers":
			return this.connectedUELO.GetPageMarkers(this.connectedPage.p_globalIndex);

		case "getMarkersFromCourse":
			var markersArray = new Array();
			var markers = "";
			for (var i = 0; i < this.connectedUELO.pages.length; i++) {
				var ueloPage = this.connectedUELO.pages[i];
				if (ueloPage) {
					markers = this.connectedUELO.GetPageMarkers(ueloPage.globalIndex);
					markersArray.push(markers);
				};
			};
			return markersArray;

		case "findYellowCard":
			var ueloPage = this.connectedUELO.FindPage(this.connectedPage.p_globalIndex);
			if (ueloPage) return ueloPage.FindYellowCard(arguments[1]);
			break;

		case "getYellowCardsArray":
			var courseYellowCardsArray = new Array();
			var uyc = null;

			for (var i = 0; i < this.connectedUELO.pages.length; i++) {
				var ueloPage = this.connectedUELO.pages[i];
				if (ueloPage && ueloPage.yellowCards) {
					for (var j = 0; j < ueloPage.yellowCards.length; j++) {
						uyc = ueloPage.yellowCards[j];
						courseYellowCardsArray.push(uyc);
					};
				};
			};
			return courseYellowCardsArray;
			break;

		case "getYellowCardsFromPage":
			var pageYellowCardsArray = new Array();
			var uyc = null;
			var ueloPage = this.connectedUELO.FindPage(this.connectedPage.p_globalIndex);

			if (ueloPage && ueloPage.yellowCards) {
				for (var j = 0; j < ueloPage.yellowCards.length; j++) {
					uyc = ueloPage.yellowCards[j];
					pageYellowCardsArray.push(uyc);
				};
			};
			return pageYellowCardsArray;
			break;

		case "pageTryNumber":
			var pageTryNumber;
			if (typeof(this.connectedLMS.getTryNumber) != "undefined") pageTryNumber = this.connectedLMS.getTryNumber();
			var valType = typeof(pageTryNumber);
			if (pageTryNumber == -1 || pageTryNumber == "" || (valType != "string" && valType != "number")) { //pg2- completion -check if == "" or type is undefined - not number nor string (NaN) -as sometimes in case of ultiSCO
				pageTryNumber = this.connectedUELO.getPageTryNumber(this.connectedPage.p_globalIndex);
			};
			return pageTryNumber;
			break;

		case "dynamicContent":
			if (typeof(this.connectedLMS.getDynamicContent) == "undefined") return null; //pg2-do not call it if there is no such a method (for example multiSCO)
			return (config.allowDynamicContent) ? this.connectedLMS.getDynamicContent() : null;
			break;

		case "getTextMarkers":
			return this.textMarkers;
			break;

		case "getPageVisited":
			var res; //pg2-ewspa
			if (this.connectedLMS && this.connectedLMS.name == "lmsExam" && this.connectedLMS.getPageVisited) {
				res = this.connectedLMS.getPageVisited();
			} else {
				res = this.connectedUELO.getPageVisited(this.connectedPage.p_globalIndex);//pg2-todo -.pageVisited
			};
			return  res;
			break;

		case "getPagePassedFromUELO":
			return this.connectedUELO.getPagePassed(this.connectedPage.p_globalIndex);
			break;

		case "getDebugMode":
			return this.connectedPlayer.getDebugMode();

		default:
			try {
				eval('error("' + formatString(this.EC_INTERFACE_NOT_SUPPROT_MOP_GET, "GetValue", name) + '");');
			} catch(e) {
				if (typeof(page) != "undefined" && page.state == psView) alert('WBTPlayerInterface.GetValue(), "switch->default:" section eval error\nMessage:\n' + e.message); //pg2
			};
			return null;
	};
	return null;
};

WBTPlayerInterface.prototype.SetValue = function(name, value)
{
	if (!this.checkInterface()) return false;
	switch (name) {
		case "setPoints":
			//do uelo
			if (typeof(arguments[1]) != "undefined") {
				this.connectedLMS.setPoints(arguments[1]);
				this.connectedUELO.setPageScore(this.connectedPage.p_globalIndex, arguments[1]);
				this.SetValue("setTextMarkers");
				for (var i in page.children) page.children[i].invokeEvent("SetPoints");
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setPoints", arguments[1], "The second argument must exist."));
				return false;
			};

		case "setStatus":
			//do uelo
			if (typeof(arguments[1]) != "undefined" && typeof(arguments[1]) == "string") {
				if (this.connectedLMS.name == "LMSApp" && this.connectedLMS.LMSSetValue) { //pg2-check if exists such a method
					this.connectedLMS.LMSSetValue(this.connectedPage.p_globalIndex, "status", arguments[1]);
				} else {
					if (this.connectedLMS.setStatus) this.connectedLMS.setStatus(arguments[1]); //pg2-if
				};
				var item = this.connectedStruct.findItem(this.connectedPage.p_globalIndex);
				this.connectedPlayer.updateTemplateTree();
				this.connectedPlayer.updateTemplateProgress(item);
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setStatus", arguments[1], "The second argument must be string."));
				return false;
			};

		case "setUELOStatus":
			//do uelo
			if (this.connectedUELO.resetOverride) { //pg2-courseReport_af
				if (this.connectedUELO.currentUELOPage.lockPageScore) return true;
				//if (this.connectedPage.pageStatus == 'passed') this.connectedUELO.currentUELOPage.lockPageScore = true;
			};
			if (typeof(arguments[1]) != "undefined" && typeof(arguments[1]) == "string") {
				this.connectedUELO.setPageStatus(this.connectedPage.p_globalIndex, arguments[1]);
				this.connectedUELO.setUELOData();
				//this.connectedUELO.setPageVisited(this.connectedPage.p_globalIndex); //pg2-ewspa -moved to .SetValue("setPageVisited")
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setUELOStatus", arguments[1], "The second argument must be string."));
				return false;
			};

		case "setPageVisited": //pg2-ewspa
			var res = true;
			if (this.connectedLMS && this.connectedLMS.name == "lmsExam" && this.connectedLMS.setPageVisited) {
				res = this.connectedLMS.setPageVisited(); //pg2-exam passes no suspend data etc
			};
			res = (this.connectedUELO.setPageVisited(this.connectedPage.p_globalIndex) && res);
			return  res;

		case "setPagePassedInUELO":
			//do uelo
			if (this.connectedUELO.resetOverride) { //pg2-courseReport_af
				if (this.connectedUELO.currentUELOPage.lockPageScore) return true;
				//if (this.connectedPage.pageStatus == 'passed') this.connectedUELO.currentUELOPage.lockPageScore = true;
			};
			if (typeof(arguments[1]) != "undefined") {
				this.connectedUELO.setPagePassed(this.connectedPage.p_globalIndex, arguments[1]);
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setPagePassedInUELO", arguments[1], "The second argument must be boolean."));
				return false;
			};

		case "resetInteractionsInUELO":
			//do uelo
			this.connectedUELO.resetInteractionsforPage(this.connectedPage.p_globalIndex);
			return true;

		case "setLastUserAnswer":
			//do uelo
			if (typeof(arguments[1]) != "undefined") {
				var hardSet = (typeof(arguments[2]) != "undefined" && arguments[2] == true);
				var ans = (arguments[1] == null) ? this.connectedUELO.GetPageStudentAnswer(this.connectedPage.p_globalIndex) : arguments[1];
				if (ans != "" || hardSet) {
					if (this.connectedLMS.setLastUserAnswer) this.connectedLMS.setLastUserAnswer(ans); //pg2-check if such a method exists
					if (this.connectedPage.pageType != 'Exercise') {
						this.connectedUELO.SetPageStudentAnswer(this.connectedPage.p_globalIndex, ans);
					};
				};
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setLastUserAnswer", arguments[1], "The second argument must exist."));
				return false;
			};

		case "setTryNumber":
			if ((typeof(arguments[1]) != "undefined") || (!isNaN(arguments[1]))) {
				if (this.connectedLMS.setTryNumber) this.connectedLMS.setTryNumber(arguments[1]); //pg2-if
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setTryNumber", arguments[1], "The second argument must exist."));
				return false;
			};

		case "setCourseVersion":
			if ((typeof(arguments[1]) != "undefined") || (!isNaN(arguments[1]))) {
				this.connectedPlayer.setCourseVersion(parseInt(arguments[1]));
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setCourseVersion", arguments[1], "The second argument must exist."));
				return false;
			};

		case "setLessonLocation":
			if ((typeof(arguments[1]) != "undefined") || (!isNaN(arguments[1]))) {
				if (this.connectedLMS.lessonLocation) {
					this.connectedLMS.lessonLocation(parseInt(arguments[1]));
					return true;
				} else {
					return false;
				};
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setLessonLocation", arguments[1], "The second argument must be integer."));
				return false;
			};

		case "setPageMarkers":
			if (typeof(arguments[1]) != "undefined") {
				this.connectedUELO.SetPageMarkers(this.connectedPage.p_globalIndex, arguments[1]);
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "SetValue.setPageMarkers", arguments[1], "The second argument must exist."));
				return false;
			};

		case "setTextMarkers":
			var gix = this.connectedPage.p_globalIndex;
			if (this.connectedPage.pageExtrasType == 'none' && !this.connectedPage.is_hidden_page) { //pg2-if hidden page is loaded (for example in an iframe), then course is closed- start would be from hidden page
				this.connectedPlayer.gix = gix;
			};
			if (this.connectedPage.visibleItemsIndex == -1) this.connectedPage.visibleItemsIndex = this.connectedPlayer.getVisibleItemsIndex(); //pg2-UR_miniStatistics -todo -check with QuizRandomizer, perhaps some trigger method within a page?
			var pageNo = this.connectedPage.visibleItemsIndex;
			this.textMarkers["PAGE_NO"] = pageNo;
			
			if (this.connectedPage.visibleItemsCount == -1) this.connectedPage.visibleItemsCount = this.connectedPlayer.getVisibleItemsCount(); //pg2-UR_miniStatistics -todo just as above
			var pageTotal = this.connectedPage.visibleItemsCount;
			this.textMarkers["PAGES_COUNT"] = pageTotal;

			if (this.connectedPage.getTotalScore == -1) this.connectedPage.getTotalScore = this.connectedPlayer.getTotalScore(); //pg2-UR_miniStatistics
			this.textMarkers["TOTAL_SCORE"] = this.connectedPage.getTotalScore;
			
			this.textMarkers["MASTERY_SCORE"] = 100;
			
			if (this.connectedPage.possibleScore == -1) this.connectedPage.possibleScore = this.connectedPlayer.getPossibleScore(); //pg2-UR_miniStatistics
			this.textMarkers["POSSIBLE_SCORE"] = this.connectedPage.possibleScore;
			
			this.textMarkers["STUDENT_NAME"] = "John Doe";
			this.textMarkers["COMPUTER_NAME"] = "Computer name";
			this.textMarkers["COMPUTER_NAME"] = "";
			this.textMarkers["PAGE_NAME"] = this.connectedPage.p_pageName; //pg2-in case of multiversions and page that is the same in both (or more)- standard (static) 'PAGE_NAME' wasn't replaced correctly (during export)

			//pg2-BI_BM_AKA -dynamic pages within chapters numbering
			if (this.connectedPage.chapterNumbering == -1) this.connectedPage.chapterNumbering = this.connectedPlayer.getChapterNumbering(this.connectedPage.p_globalIndex); //pg2-UR_miniStatistics
			var chapterNumbering = this.connectedPage.chapterNumbering;
			this.textMarkers["PAGE_NO_IN_CHAPTER"] = chapterNumbering[0];
			this.textMarkers["PAGES_COUNT_IN_CHAPTER"] = chapterNumbering[1];
			//...
			//pg2-PGA -progress perc of completed pages
			if (this.connectedPage.currentCompletionProgress == -1) this.connectedPage.currentCompletionProgress = this.connectedStruct.getCurrentCompletionProgress(); //pg2-UR_miniStatistics
			var ccp = this.connectedPage.currentCompletionProgress;
			//alert(ccp);
			var currentCompletionProgress = parseInt(Math.floor(ccp[0]*100)/ccp[1]);
			this.textMarkers["PAGES_PROGRESS_COMPLETED_PERC"] = currentCompletionProgress;
			this.textMarkers["PAGES_PROGRESS_COMPLETED_TO_GO_PERC"] = 100-currentCompletionProgress;
			
			var currPerc = parseInt((pageNo*100)/pageTotal); //var currPerc = parseInt(Math.floor(pageNo*100)/pageTotal);
			this.textMarkers["PAGES_PROGRESS_CURRENT_PERC"] = currPerc;
			this.textMarkers["PAGES_PROGRESS_CURRENT_TO_GO_PERC"] = 100-currPerc;
			//...

			if (this.connectedLMS.getCurrentPageNumber) {
				if (this.connectedPage.currentPageNumber == -1) this.connectedPage.currentPageNumber = this.connectedLMS.getCurrentPageNumber(); //pg2-UR_miniStatistics
				this.textMarkers["PAGES_CURRENT"] = this.connectedPage.currentPageNumber;
			} else {
				this.textMarkers["PAGES_CURRENT"] = pageNo;
			};
			if (this.connectedLMS.getTotalPagesNumber) {
				if (this.connectedPage.totalPagesNumber == -1) this.connectedPage.totalPagesNumber = this.connectedLMS.getTotalPagesNumber(); //pg2-UR_miniStatistics
				this.textMarkers["PAGES_TOTAL"] = this.connectedPage.totalPagesNumber;
			} else {
				this.textMarkers["PAGES_TOTAL"] = pageTotal;
			};
			if (this.connectedLMS.getStudentName) {
				if (this.connectedPage.studentName == '') this.connectedPage.studentName = this.connectedLMS.getStudentName(); //pg2-UR_miniStatistics
				this.textMarkers["STUDENT_NAME"] = this.connectedPage.studentName;
			};
			if (this.connectedLMS.getComputerName) {
				if (this.connectedPage.computerName == '') this.connectedPage.computerName = this.connectedLMS.getComputerName(); //pg2-UR_miniStatistics
				this.textMarkers["COMPUTER_NAME"] = this.connectedPage.computerName;
			};
			if (this.connectedLMS.getPoints) {
				if (this.connectedPage.points == -1) this.connectedPage.points = this.connectedLMS.getPoints(); //pg2-UR_miniStatistics
				this.textMarkers["PAGE_SCORE"] = this.connectedPage.points;
			};
			if (this.connectedLMS.getPassingScore) {
				if (this.connectedPage.passingScore == -1) this.connectedPage.passingScore = this.connectedLMS.getPassingScore(); //pg2-UR_miniStatistics
				this.textMarkers["PASSING_SCORE"] = this.connectedPage.passingScore;
			};
			break;

		case "setStudentActive":
			this.connectedPlayer.studentIsActive(arguments[1]);
			break;

		case "setStudentLessonBreak":
			this.connectedPlayer.setStudentLessonBreak();
			return true;

		case "studentActive":
			this.connectedPlayer.studentActive();
			//if (this.connectedPage && this.connectedPage.inactivityPopup != null) this.connectedPage.inactivityPopup.hide(); //pg2-inactivity_control
			break;

		default:
			try {
				eval('error("' + formatString(this.EC_INTERFACE_NOT_SUPPROT_MOP_SET, "SetValue", name) + '");');
			} catch(e) {
				if (typeof(page) != "undefined" && page.state == psView) alert('WBTPlayerInterface.SetValue(), "switch->default:" section eval error\nMessage:\n' + e.message); //pg2
			};
	};
	return false;
};

WBTPlayerInterface.prototype.Execute = function(name)
{
	if (!this.connectedUELO) this.initUELO(); //pg2-bsh-hidden_pages
	if (!this.checkInterface()) return false;
	switch (name) {
		case "loadLMS":
			if (this.connectedLMS.name == "LMSApp" && this.connectedLMS._doLoad && this.connectedLMS.getCourseData) { //pg2-check if 'this.connectedLMS._doLoad / getCourseData' exists
				this.connectedLMS._doLoad();
				var ueloStr = unescape(this.connectedLMS.getCourseData("uelo"));
				if (ueloStr != "") {
					this.connectedUELO.loadFromString(ueloStr);
				};
			};
			return true;

		case "unloadLMS":
			if (this.connectedLMS.name == "LMSApp" && this.connectedLMS._doUnload && this.connectedLMS.setCourseData) { //pg2-completion to 'if'
				this.connectedLMS._doUnload();
				this.connectedLMS.setCourseData("uelo", escape(this.connectedUELO.toWBTSString()));
			};
			return true;

		case "initializeYellowCards":
			this.connectedPage.removeYellowCards();
			var ueloPage = this.connectedUELO.FindPage(this.connectedPage.p_globalIndex);
			var myYellowCardType = 'private';
			if (ueloPage && ueloPage.yellowCards) {
				for (var i=0; i < ueloPage.yellowCards.length; i++) {
					var uyc = ueloPage.yellowCards[i];

					if (uyc) {
						var cardDiv = document.getElementById(uyc.id); //pg2-test_yellowcard
						var cardExists = (typeof(cardDiv) != "undefined"); //pg2-test_yellowcard
						var newObj = PageInterface.GetValue('getChild', uyc.id+"_mini"); //pg2-test_yellowcard
						var miniCard = PageInterface.GetValue('getChild', uyc.id); //pg2-test_yellowcard
						var yc = null;
						if (!cardExists || newObj == null || miniCard == null) { //pg2-test_yellowcard
							//var newObj = PageInterface.Execute("createChild", "componentImage", uyc.id+"_mini"); //pg2-test_yellowcard-removed
							//var miniCard = PageInterface.Execute("addChild", newObj); //pg2-test_yellowcard-removed
							newObj = PageInterface.Execute("createChild", "componentImage", uyc.id + "_mini"); //pg2-test_yellowcard
							miniCard = PageInterface.Execute("addChild", newObj); //pg2-test_yellowcard
							miniCard.src = uyc.minimalizedMyCard;
							miniCard.x = uyc.left;
							miniCard.y = uyc.top;
							miniCard.canDragging = true;
							miniCard.hide();

							//var newObj = PageInterface.Execute("createChild", "__componentYellowCard", uyc.id); //pg2-test_yellowcard-removed
							//var yc = PageInterface.Execute("addChild", newObj); //pg2-test_yellowcard-removed
							newObj = PageInterface.Execute("createChild", "__componentYellowCard", uyc.id); //pg2-test_yellowcard
							yc = PageInterface.Execute("addChild", newObj); //pg2-test_yellowcard

							yc.cardType = uyc.cardType;
							yc.date = unescape(uyc.date);
							yc.author = unescape(uyc.author);
							yc.x = uyc.left;
							yc.y = uyc.top;
							yc.title = unescape(uyc.title);
							yc.note = unescape(uyc.note);
							yc.buttonAdd = uyc.buttonAdd; 
							yc.showUserName = uyc.showUserName;
							yc.pageName = uyc.pageName;
							yc.pageGI = uyc.pageGI;
							yc.defaultMinimalize = uyc.defaultMinimalize;
							if (uyc.isMaximalize) yc.isMaximalize = uyc.isMaximalize;
							else yc.isMaximalize = false;
							yc.step = (sys.yellowCards) ? 0 : STEPS_HIDDEN;
						} else {
							miniCard = PageInterface.GetValue('getChild', uyc.id+"_mini"); //pg2-test_yellowcard
							yc = PageInterface.GetValue('getChild', uyc.id); //pg2-test_yellowcard
						};
						var button = PageInterface.GetValue('getChild', uyc.buttonAdd);
						if (button) {
							miniCard.w = button.minimalizedCardW;
							miniCard.h = button.minimalizedCardH;
							miniCard.onDblClick = button.onDblClickMiniCard;
							miniCard.endDrag = button.endDragMiniCard;
							miniCard.beginDrag = button.beginDragMiniCard;
							switch (yc.cardType) {
								case 'public' : 
									yc.setResImages(
										button.bckgSrc, // bg
										button.buttonTrashOver, //remove_ov
										button.buttonTrashOut, //remove_ou
										button.buttonMiniOver, //mini_ov
										button.buttonMiniOut, //mini_ou
										button.buttonHideOver, //clos_ov
										button.buttonHideOut, //clos_ou
										button.minimalizedAllCard, //small
										button.allDot, //dot
										button.personGraphic, //personImg
										button.clockGraphic, //timeImg
										button.spaceBetweenButtons, //button space
										button.offsetTop, //offset left
										button.offsetLeft, //offset top
										button.bckgW, //card W
										button.bckgH //card H
									);
									break;

								case 'private' : 
									yc.setResImages(
										button.bckgSrc, // bg
										button.buttonTrashOver, //remove_ov
										button.buttonTrashOut, //remove_ou
										button.buttonMiniOver, //mini_ov
										button.buttonMiniOut, //mini_ou
										button.buttonHideOver, //clos_ov
										button.buttonHideOut, //clos_ou
										button.minimalizedMyCard, //small
										button.myDot, //dot
										button.personGraphic, //personImg
										button.clockGraphic, //timeImg
										button.spaceBetweenButtons, //button space
										button.offsetTop, //offset left
										button.offsetLeft, //offset top
										button.bckgW, //card W
										button.bckgH //card H
									);
									break;

								case 'tutor' : 
									yc.setResImages(
										button.bckgSrc, // bg
										button.buttonTrashOver, //remove_ov
										button.buttonTrashOut, //remove_ou
										button.buttonMiniOver, //mini_ov
										button.buttonMiniOut, //mini_ou
										button.buttonHideOver, //clos_ov
										button.buttonHideOut, //clos_ou
										button.minimalizedTutorCard, //small
										button.tutorDot, //dot
										button.personGraphic, //personImg
										button.clockGraphic, //timeImg
										button.spaceBetweenButtons, //button space
										button.offsetTop, //offset left
										button.offsetLeft, //offset top
										button.bckgW, //card W
										button.bckgH //card H
									);
									break;

								default : 
									yc.setResImages(
										button.bckgSrc, // bg
										button.buttonTrashOver, //remove_ov
										button.buttonTrashOut, //remove_ou
										button.buttonMiniOver, //mini_ov
										button.buttonMiniOut, //mini_ou
										button.buttonHideOver, //clos_ov
										button.buttonHideOut, //clos_ou
										button.minimalizedAuthorCard, //small
										button.authorDot, //dot
										button.personGraphic, //personImg
										button.clockGraphic, //timeImg
										button.spaceBetweenButtons, //button space
										button.offsetTop, //offset left
										button.offsetLeft, //offset top
										button.bckgW, //card W
										button.bckgH //card H
									);
									break;
							};
						} else {
							//ueloPage.updateYellowCard(yc.id, yc.date, yc.author, yc.x, yc.y, yc.title, yc.note, yc.src, yc.miniBckg, yc.buttonTrashOver, yc.buttonTrashOut, yc.buttonMiniOver, yc.buttonMiniOut, yc.buttonHideOver, yc.buttonHideOut, yc.authorDot, yc.personImg, yc.timeImg, yc.defaultMinimalize, yc.showMouseOver, yc.isMaximalize)
						};
						this.connectedPage.steps[0][1] += "pc." + yc.id + "." + ((sys.yellowCards == true || sys.yellowCards == "true") ? "show();" : "hide();");
					};
				};
			};
			return true;

		case "addYellowCard":
			var ueloPage = this.connectedUELO.FindPage(this.connectedPage.p_globalIndex);
			if (ueloPage) {
				var uyc = ueloPage.AddYellowCard(arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],
													arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16],
													arguments[17],arguments[18],arguments[19],arguments[20],arguments[21],arguments[22],arguments[23],arguments[24],
													arguments[30], arguments[31], arguments[32]);
				if (uyc) {
					var newObj = PageInterface.Execute("createChild", "__componentYellowCard", uyc.id);
					var yc = PageInterface.Execute("addChild", newObj);
					yc.cardType = uyc.cardType;
					yc.date = uyc.date;
					yc.author = uyc.author;
					yc.x = uyc.left;
					yc.y = uyc.top;
					yc.title = uyc.title;
					yc.note = uyc.note;
					yc.buttonAdd = uyc.buttonAdd;
					yc.showUserName = uyc.showUserName;
					yc.pageName = uyc.pageName;
					yc.pageGI = uyc.pageGI;
					yc.defaultMinimalize = uyc.defaultMinimalize;
					if (uyc.isMaximalize) yc.isMaximalize = uyc.isMaximalize;
					else yc.isMaximalize = false;
					yc.step = 0;
					yc.setResImages(
							arguments[9], // bg
							arguments[10], //remove_ov
							arguments[11], //remove_ou
							arguments[12], //mini_ov
							arguments[13], //mini_ou
							arguments[14], //clos_ov
							arguments[15], //clos_ou
							arguments[16], //small
							arguments[17], //dot
							arguments[18], //personImg
							arguments[19], //timeImg
							arguments[25], //button space
							arguments[26], //offset left
							arguments[27], //offset top
							arguments[28], //card W
							arguments[29] //card H
					);
					try {
						eval('pc.' + yc.id + '.show();');
					} catch(e) {
						if (typeof(page) != "undefined" && page.state == psView) alert('WBTPlayerInterface.Execute(), "addYellowCard" section eval error\nMessage:\n' + e.message); //pg2
					};
				};
				return true;
			} else {
				error(this.UELO_NOT_INITIALIZED);
			};
			break;

		case "deleteYellowCard":
			var ueloPage = this.connectedUELO.FindPage(this.connectedPage.p_globalIndex);
			if (ueloPage.DeleteYellowCard(arguments[1])) {
				this.connectedPage.deleteChild(arguments[2]);
				try { //pg2-test_yellowcard
					var arg1 = arguments[1];
					var obj = document.getElementById(arg1 + "");
					var parentObj = null;
					if (obj) {
						parentObj = obj.parentNode;
						if (parentObj) {
							parentObj.removeChild(obj);
						};
					};
					//remove 'mini' too
					var miniDeleted = false;
					for (var i=0; i<this.connectedPage.children.length; i++) {
						var child = this.connectedPage.children[i];
						if (child && child.type == "componentImage" && child.id == arg1 + "_mini") {
							this.connectedPage.deleteChild(child);
							miniDeleted = true;
							break;
						};
					};
					if (miniDeleted) {
						obj = document.getElementById(arg1 + "_mini");
						if (obj) {
							parentObj = obj.parentNode;
							if (parentObj) {
								parentObj.removeChild(obj);
							};
						};
					};
				} catch(e) {};
				return true;
			};
			return false;
			break;

		case "updateYellowCard":
			var ueloPage = this.connectedUELO.FindPage(this.connectedPage.p_globalIndex);
			return ueloPage.updateYellowCard(arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],
												arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],
												arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],
												arguments[16],arguments[17],arguments[18],arguments[19],arguments[20],
												arguments[21]);
			break;

		case "updateNoteInUELO":
			var ueloPage = this.connectedUELO;
			return ueloPage.updateNotepad(arguments[1], arguments[2]);
			break;

		case "makeNoteInUELO":
			var ueloPage = this.connectedUELO;
			return ueloPage.addNotepad(arguments[1], arguments[2]);
			break;

		case "getNoteFromUELO":
			var ueloPage = this.connectedUELO;
			return ueloPage.findNotepad(arguments[1]);
			break;

		case "initializeUELOVars":
			if (typeof(arguments[1]) != "undefined") {
				var u_vars = "";
				if (this.connectedUELO.getUserVars) u_vars = this.connectedUELO.getUserVars();
				if (u_vars != "") {
					vars.set(me, u_vars);
				};
			};
			break;

		case "initializeUELO":
			if (typeof(arguments[1]) != "undefined") {
				/*
				var u_vars = "";
				if (this.connectedUELO.getUserVars) u_vars = this.connectedUELO.getUserVars();
				if (u_vars != "") {
					vars.set(me, u_vars);
				}
				*/
				var dateObj = new Date();
				if (arguments[1] == true) {
					for (var i in pc) {
						var o = pc[i];
						if (o.interactions && typeof(o.className) != "undefined" && o.className == "element" && o.id.indexOf("WBTObject") != 0) { //pg2-test_inter
							var ia = this.connectedUELO.AddInteractionToPage(this.connectedPage.p_globalIndex, o.id, o.type);
							if (ia) {
								ia.latency = null;
								ia.timestamp = formatTime("timestamp", dateObj, "-");// this.connectedUELO.getDate();
								if (isNaN(ia.tryNumber)) { //pg2-profiles_exe
									ia.tryNumber = 0;
								};
								this.connectedPage.countAnswers = this.connectedPage._countAnswers - ia.tryNumber;
								if (this.connectedPage.countAnswers < 0) this.connectedPage.countAnswers = 0;
							};
						};
					};
				};
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "Execute.initializeUELO", arguments[1], "The second argument must exist."));
				return false;
			};
			return true;
		
		case "sendDataToUELO":
			if (this.connectedUELO.resetOverride) { //pg2-courseReport_af
				if (this.connectedUELO.currentUELOPage.lockPageScore) return true;
				//if (this.connectedPage.pageStatus == 'passed') this.connectedUELO.currentUELOPage.lockPageScore = true;
			};
			
			if (typeof(arguments[1]) != "undefined") {
				this.connectedUELO.setUELOData();
				if (this.connectedUELO.setUserVars) this.connectedUELO.setUserVars(vars.get(me));
				if (this.connectedPage.saveYellowCards) this.connectedPage.saveYellowCards();
				this.connectedUELO.setPageVisited(this.connectedPage.p_globalIndex);
				/* //pg2-removed -it went by elements not by interactions, so order was wrong and...if there is one interaction, invoke function only one time not several times
				var sendInterFn = function(owner,o) {
					if (o.interactions && typeof(o.className) != "undefined" && o.className == "element" && o.id.indexOf("WBTObject") != 0) { //pg2-additional conditions - className must be 'element' to eliminate entering the block for some sub-components used in components (like writeQuestion) //pg2-test_inter
						var ia = owner.connectedUELO.AddInteractionToPage(owner.connectedPage.p_globalIndex, o.id, o.type);
						if (ia) {
							ia.question = ia.getVersionQuestion(owner.connectedPlayer.courseVersion);
							ia.solveVersion = owner.connectedPlayer.courseVersion;
							ia.studentResponse = o.interactionsStudentResponse();
							var c = o.interactionsCorrectResponsesCount();
							var cras_res = "";
							for (var j=0; j<c; j++) {
								if (cras_res != "") cras_res += ":";
								cras_res += o.interactionsCorrectResponsesAsText(j);
							}
							ia.correctResponsesAsText = cras_res;
							ia.studentResponseAsText = o.interactionsStudentResponseAsText();
							//kr - special for DKosc
							//ia.setResult(o.parseCheckAnswer(o));
							ia.setResult(o.parseCheckAnswer(o), o.interactionsStudentScore);
							//
							ia.tryNumber = owner.connectedPage._countAnswers - owner.connectedPage.countAnswers;
							var d = new Date();
							if (ia.latency == null) ia.latency =  d.subtractTimeToString(owner.connectedPage.startTime);
							ia.timestamp = owner.connectedUELO.getDate();
						};
					};
				};
				if (arguments[1] == true) {
					for (var i in pc) {
						sendInterFn(this,pc[i]);
					};
				};*/

				var sendInterFn_ByOrder = function(owner, ia) { //pg2
					if (!ia) return;
					var o = null;
					eval('o = pc.' + ia.elementId);
					//additional conditions - className must be 'element' to eliminate entering the block for some sub-components used in components (like writeQuestion) 
					if (o && typeof(o.className) != "undefined" && o.className == "element" && o.id.indexOf("WBTObject") != 0) {
						ia.question = ia.getVersionQuestion(owner.connectedPlayer.courseVersion);
						ia.solveVersion = owner.connectedPlayer.courseVersion;
						ia.studentResponse = o.interactionsStudentResponse();
						var c = o.interactionsCorrectResponsesCount();
						var cras_res = "";
						for (var j=0; j<c; j++) {
							if (cras_res != "") cras_res += ":";
							cras_res += o.interactionsCorrectResponsesAsText(j);
						};
						ia.correctResponsesAsText = cras_res;
						ia.studentResponseAsText = o.interactionsStudentResponseAsText();
						//kr - special for DKosc
						//ia.setResult(o.parseCheckAnswer(o));
						ia.setResult(o.parseCheckAnswer(o), o.interactionsStudentScore);
						//
						ia.tryNumber = owner.connectedPage._countAnswers - owner.connectedPage.countAnswers;
						var d = new Date();
						if (ia.latency == null) ia.latency =  d.subtractTimeToString(owner.connectedPage.startTime);
						ia.timestamp = owner.connectedUELO.getDate();
					};
				};
				if (arguments[1] == true && this.connectedUELO && this.connectedUELO.currentUELOPage && this.connectedUELO.currentUELOPage.interactions) {
					for (var i=0; i<this.connectedUELO.currentUELOPage.interactions.length; i++) {
						sendInterFn_ByOrder(this, this.connectedUELO.currentUELOPage.interactions[i]);
					};
				};

				this.connectedUELO.setPageTitle(this.connectedPage.p_globalIndex, this.connectedPlayer.courseVersion);
				if (this.connectedUELO.saveUelo == 1 && typeof(window.external) != "undefined") {
					if (typeof(window.external.writeUELO) != "undefined") {
						if (uelo) {
							var str = escape(this.connectedUELO.toWBTSString());
							window.external.writeUELO(escape(this.connectedUELO.toWBTSString()));
						};
					};
				};
				return true;
			} else {
				if (this.showErrors) error(formatString(this.EC_EXECUTION_INSTRUCTION, "Execute.sendDataToUELO", arguments[1], "The second argument must exist."));
				return false;
			};

		case "pageReady":
			if (this.connectedLMS.pageReady) this.connectedLMS.pageReady(); //pg2-if
			return true;

		case "pageLoaded":
			this.connectedPlayer.pageLoaded(this.connectedPage.p_globalIndex);
			return true;

		case "setUserAnswer":
			//prevent to setAnswer in SLW Simulation
			if (!config.rememberAnswers || this.connectedPage.SLWSimulation || typeof(this.connectedLMS.getLastUserAnswer) == "undefined") return true; //pg2- if completion
			if (this.connectedPage.pageType == "Exercise" || this.connectedPage.pageType == "Poll") {
				//var lmsUserAnswerArr = this.connectedLMS.getLastUserAnswer().split('#|#');
				var userLastAnswer = this.connectedLMS.getLastUserAnswer(); //pg2-to prevent from .spli(...) on null vaule
				if (userLastAnswer != null && userLastAnswer != "") {
					userLastAnswer += ""; //pg2- in case of an number - otherwise an exception will be invoked
					
					//var lmsUserAnswerArr = userLastAnswer.split((this.connectedPage.pageType=="Poll")?'¦':'~'); //'#|#':'~'); //pg2- in new version of uelo, separator is a different char: "¦"
					var lmsUserAnswerArr = userLastAnswer.split((this.connectedPage.pageType=="Poll")?'#|#':'~'); //pg2-do wyjasnienia, dlaczego sie zmienilo...
					
					var lmsUserAnswerIndex = 0;
					
					//pg2-new -in case of some situations, prev answers are set to wrong components (ex. 3 radio and textarea- in textarea there are 1:0:0)
					var ueloPage = this.connectedUELO.currentUELOPage;
					if (ueloPage) {
						for (var i=0; i<ueloPage.interactions.length; i++) {
							var interaction = ueloPage.interactions[i];
							if (interaction) {
								var objStr = interaction.elementId;
								var o = pc[objStr];
								if (o) {
									var userAnswer = this.connectedUELO.GetStudentAnswer(this.connectedPage.p_globalIndex, o.id);
									var interVer = this.connectedUELO.getInteractionSolveVersion(this.connectedPage.p_globalIndex, o.id);
									if (interVer != this.connectedPlayer.courseVersion) return;
									if (userAnswer == "" && checkExportType(config.exportDetails, "multi")) { //pg2-added 'multi' - in poll, scorm, html- 'cause it '#' were appeared during navigation (back to prev page)
										//jesli UELO nie posiada informacji o zadaniu (np MultiSCO) to sprawdz suspendData
										userAnswer = (typeof(lmsUserAnswerArr[lmsUserAnswerIndex]) != 'undefined')?lmsUserAnswerArr[lmsUserAnswerIndex]:"";
									};
									if (userAnswer && userAnswer != "") {
										if (typeof(o.setLastAnswer) != 'undefined') o.setLastAnswer(userAnswer);
										if (!config.resetExercisePages) o.setAnswer(userAnswer, false);
									};
									lmsUserAnswerIndex++;
								};
							};
						};
						
					};/* else { //old
						for (var i in pc) {
							var o = pc[i];
							if (o.interactions && typeof(o.className) != "undefined" && o.className == "element" && o.id.indexOf("WBTObject") != 0) { //pg2-test_inter

								var userAnswer = this.connectedUELO.GetStudentAnswer(this.connectedPage.p_globalIndex, o.id);
								var interVer = this.connectedUELO.getInteractionSolveVersion(this.connectedPage.p_globalIndex, o.id);
								if (interVer != this.connectedPlayer.courseVersion) return;
								if (userAnswer == "") {
									//jesli UELO nie posiada informacji o zadaniu (np MultiSCO) to sprawdz suspendData
									userAnswer = (typeof(lmsUserAnswerArr[lmsUserAnswerIndex]) != 'undefined')?lmsUserAnswerArr[lmsUserAnswerIndex]:"";
								};
								if (userAnswer && userAnswer != "") {
									if (typeof(o.setLastAnswer) != 'undefined') o.setLastAnswer(userAnswer);
									if (!config.resetExercisePages) o.setAnswer(userAnswer, false);
								};
								lmsUserAnswerIndex++;
							};
						};
					};*/
				};
			} else {
				var ans = this.connectedUELO.GetPageStudentAnswer(this.connectedPage.p_globalIndex);
				this.connectedPage.setAnswer(ans);
			};
			return true;

		case "gotoPage":
			if (this.connectedLMS.gotoPage) this.connectedLMS.gotoPage(arguments[1]); //pg2-if
			return true;

		case "nextPage":
			if (this.connectedPage && this.connectedPage.pageExtrasType == 'none' && this.connectedPlayer) this.connectedPlayer.gix = this.connectedPage.p_globalIndex; //pg2-bps -if extras was loaded, gix==1 and .nextPage goes to gix='2'
			if (this.connectedLMS.nextPage) this.connectedLMS.nextPage(); //pg2-if
			return true;

		case "prevPage":
			if (this.connectedPage && this.connectedPage.pageExtrasType == 'none' && this.connectedPlayer) this.connectedPlayer.gix = this.connectedPage.p_globalIndex; //pg2-bps -if extras was loaded, gix==1 and .nextPage goes to gix='2'
			if (this.connectedLMS.prevPage) this.connectedLMS.prevPage(); //pg2-if
			return true;

		case "nextSCO":
			if (this.connectedLMS.nextSCO) this.connectedLMS.nextSCO(); //pg2-if
			return true;

		case "prevSCO":
			if (this.connectedLMS.prevSCO) this.connectedLMS.prevSCO(); //pg2-if
			return true;

		case "closeCourse":
			if (is.moz && this.connectedLMS.name == "lmsOffline" && (top.window.opener == null)) { //pg2-added 'top.'
				error(MESSAGE_AUTO_CLOSE_COURSE_ALERT);
				return false;
			};
			if (this.connectedLMS.closeCourse) this.connectedLMS.closeCourse();
			return true;

		case "sendSubDataToLMS":
			this.connectedUELO.sendSubDataToServer();
			return true;

		case "debugCourse":
			return this.connectedPlayer.debugCourse();

		default:
			try {
				eval('error("' + formatString(this.EC_INTERFACE_NOT_SUPPROT_MOP_SET, "Execute", name) + '");');
			} catch(e) {
				if (typeof(page) != "undefined" && page.state == psView) alert('WBTPlayerInterface.Execute(), "switch->default" section eval error\nMessage:\n' + e.message); //pg2
			};
	};
	return false;
};

WBTPlayerInterface.prototype.Commit = function(obj)
{
	if (!this.checkInterface()) return false;
	return true;
};

WBTPlayerInterface.prototype.Terminate = function(obj)
{
	if (obj) obj.connected = false;
	this.connectedPlayer = null;
	this.connectedSW = null;
	this.connectedUELO = null;
	this.connectedLMS = null;
	this.connectedProject = null;
	this.connectedPage = null;
};

WBTPlayerInterface.prototype.createPopup = function(obj)
{
	var t = "";
	t += "<div id='playerInterfacePopup' ";
	t += "style='position: absolute; z-index: 10000 !important; left: 200px; top: 200px;";
	t += "border: 2px solid red; width: 500px; height: 400px; overflow: auto;";
	t += "'>";
	t += "<table width='100%'>";
	t += "<tr><td>";
	t += "<h3>Error:</h3>"
	t += "</td><td style='vertical-align: top; text-align: right;'>";
	t += "<a href='#' onclick='document.location.reload();'>Reload</a>";
	t += "</td></tr>";
	t += "</table>";
	t += "</div>";
	document.write(t);
	return document.getElementById("playerInterfacePopup");
};

WBTPlayerInterface.prototype.showMessegeInPopup = function(msgText)
{
	var plIntPopup = document.getElementById("playerInterfacePopup");
	if (!plIntPopup) {
		plIntPopup = this.createPopup();
	};
	plIntPopup.innerHTML += msgText + "<hr>";
};

PlayerInterface = new WBTPlayerInterface();
