/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentVideo = function(name)
{
	//inherited
	this.componentAudio = componentAudio;
	this.componentAudio(name);

	this.nextStepWaitToEnd = false;
	this.showPlayer = true;
	this.stopTimer = null;
};

componentVideo.prototype = new componentAudio;
componentVideo.prototype.type = "componentVideo";

componentVideo.prototype.unload = function()
{
	if (is.moz) {
		var inner = this.findContentObj();
		if (inner) {
			inner.innerHTML = "";
		};
	};
};

componentVideo.prototype.findContentObj = function()
{
	return document.getElementById(this.id);
};

componentVideo.prototype.editorPaint = function()
{
	var t = "";
	t += '<img width="100%" height="100%" src="'+ lms.mediaURL() + this.iconSrc +'" />';
	return t;
};

componentVideo.prototype.hide = function()
{
	if (this.allowMediaStopEvent) { //pg2-bi_test_iPad - media onOff -within hidden video audio didn't stop
		this.allowMediaStopEvent = false;
		this.doStop();
	};
	
	if (this.isPlaying()) this.doStop(); //pg2-restored    //this.doStop(); //pg2- nie moze byc, poniewaz przy ukryciu (na starcie) i tak video jest za3mane a przy akcji OnStop->Hide robi sie zapetlenie
	this.setVisible(this.isVisible(false));

	if (this.timer != null) window.clearTimeout(this.timer); //pg2- on hide, clear timer (it could be plain hide, or- hiding components while page unload)
	this.timer = null;
};

componentVideo.prototype.prepareNextStep = function()
{
	var res = false;
	var player = document.getElementById(this.id + "MediaPlayer");
	if (player) {
		if ((this.pvWMP7up || is.moz) && !this.isSafariMobileVideo) { //pg2-otherwise, timer is invoked indefinitely //pg2-bi_test_iPad
			res = (player.playState == 1 || player.playState == 10);
		} else
		if (this.pvWMP64) {
			res = (player.PlayState == 0);
		} else
		if (this.isSafariMobileVideo) {
			res = (player.paused || player.ended); //res = (!player.paused && !player.ended);
			//top.window.document.title = getDateStr() + ', paused: ' + player.paused + ', ended: ' + player.ended; //pg2-bi_test_iPad
			if (player.ended) this.allowMediaStopEvent = true; //pg2-avOnStopPopup -iPad
		};
	} else {
		res = true;
	};
	
	//top.window.document.title = getDateStr() + ', res=' + res; //pg2-bi_test_iPad

	if (!res) {
		this.timer = window.setTimeout('var o=pc.' + this.id + '; if(o) {o.prepareNextStep();}', 100);
	} else {
		if (this.allowMediaStopEvent) { //pg2-audio_onStop -VIDEO
			this.invokeEvent("MediaStop"); //pg2-old, 'standalone' line
			this.allowNextStep = true; //pg2-bi_test_iPad -stop steps 'till video is played
			this.allowMediaStopEvent = false;

			//pg2-avOnStopPopup -find it and show if not visible
			if (this.avOnStopPopup) {
				var avOnStopPopup = getComponentByPartialId('avOnStopPopup');
				if (avOnStopPopup && !avOnStopPopup.visible) avOnStopPopup.show();
			};
		};
	};
	return res;
};

componentVideo.prototype.noDisplay = function()
{
	return;
};
