/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentSLWListView = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);
	
	this.pagesArr = new Array();
	this.imagesCompleteInfo = new Array();
	this.menu = "";
	this.foucusedItem = null;
};

componentSLWListView.prototype = new componentElement();
componentSLWListView.prototype.type = "componentSLWListView";

componentSLWListView.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);
	this.setCompleteArrayInfo( this.completeImagesInfo );
};

componentSLWListView.prototype.onPaint = function()
{
	var maxItemW = 0;
	var maxItemH = 0;
	var iconItemH = 0;
	
	var iconsArr = unescape(this.content).split('||');
	var font = getProjectFont(this.globalFormating, this.fontFamily, this.fontSize, this.fontColor);
	var fontSize = getFontSize(font.size, 'px');

	for (var i=0; i < iconsArr.length; i++)
	{
		var actionArr = iconsArr[i].split('#!#');
		
 		var item = new SLWListViewItem(
						this.id,
						eval(i+1), //page index
						actionArr[3],//title
						actionArr[1],//out
						actionArr[2],//over
						this.resourcesURL,
						font.family,
						fontSize,
						font.color,
						actionArr[5]
					);
		item.dir = this.dir;
		this.pagesArr[eval(i+1)] = item;
		var captWidth = this.getCaptionWidth(actionArr[3], font.family, getFontSize(font.size, 'px'));
		if (maxItemW < captWidth) maxItemW = captWidth;
		
		var captWidth = this.getCaptionHeight(actionArr[3], font.family, getFontSize(font.size, 'px'));
		if (maxItemH < captWidth) maxItemH = captWidth;
		
		var iconHeight = this.getImageHeight(actionArr[1]);
		if (iconItemH < iconHeight) iconItemH = iconHeight;
	};
	
	var k = 0;
	var j = 0;
	var itemLeft = 0;
	var itemTop = 0;
	var itemPadding = 30;
	
	for (var i in this.pagesArr)
	{
		this.menu += this.pagesArr[i].toString(itemTop, itemLeft, maxItemW+itemPadding, maxItemH, iconItemH);
		var itemLeft = ++k*(maxItemW+itemPadding);
		if ((itemLeft+maxItemW+itemPadding) > this.w)
		{
			k = 0;
			itemLeft = 0;
			itemTop = ++j*eval(maxItemH+iconItemH+35);
		};
	};

	this.setHTML(this.menu);
}

componentSLWListView.prototype.setCompleteArrayInfo = function( buttons )
{
	var imagesStr = buttons;
	
	var imgArr = imagesStr.split('||');
	for (var i = 0; i < imgArr.length; i++){
		var oneImg = imgArr[i].split(';');
		if (!this.imagesCompleteInfo[oneImg[0]]){
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];		
		};
	};
};

componentSLWListView.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
};

componentSLWListView.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
};

componentSLWListView.prototype.getCaptionHeight = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.id+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		obj.style.whiteSpace = 'nowrap';
		return obj.offsetHeight;
	};
	return 0;
}

componentSLWListView.prototype.getCaptionWidth = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.id+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		obj.style.whiteSpace = 'nowrap';
		return obj.offsetWidth;
	};
	return 0;
}

componentSLWListView.prototype.setClearItem = function( item )
{
	if (item){
		var img = document.getElementById(item.id+'_image');
		var capt = document.getElementById(item.id+'_caption');
		
		if (img) img.src = this.resourcesURL + item.iconOut;
		if (capt) capt.style.background = 'transparent';
	}
}

componentSLWListView.prototype.mouseClick = function( index, ID, iconClick )
{
	if (this.foucusedItem) this.setClearItem(this.foucusedItem);
	var item = this.pagesArr[index];
	if (item) this.foucusedItem = item;
	
	var img = document.getElementById(ID+'_image');
	var capt = document.getElementById(ID+'_caption');
	
	if (img) img.src = this.resourcesURL + iconClick;
	if (capt) capt.style.background = '#'+this.highlightCaption;
	
	try{	
		eval('pc.'+item.action+';');	
	}catch(e){}
}

function SLWListViewItem(compName, index, title, iconOut, iconClick, resourcesURL, fontFamily, fontSize, fontColor, action )
{
	this.compName = compName;
	this.id = compName+'-item-'+index;
	this.index = index;
	this.title = title;
	this.action = action;
	
	this.resourcesURL = resourcesURL;
	this.iconOut = iconOut;
	this.iconClick = iconClick;
	
	this.fontFamily = fontFamily;
	this.fontSize = fontSize;
	this.fontColor = fontColor;
	
	this.children = new Array();
};

SLWListViewItem.prototype.toString = function (itemTop, itemLeft, titleWidth, titleHeight, iconHeight)
{
	var str = '';
//	str += '<div id="'+this.id+'_div" style="position: relative; border: 0px; position: absolute; left: '+itemLeft+'px; top: '+itemTop+'px; width: '+titleWidth+'px; height: '+eval(titleHeight+iconHeight+15)+'px; clip: rect(0px '+titleWidth+'px '+eval(titleHeight+iconHeight+15)+'px 0px)"';
	str += '<div id="'+this.id+'_div" style="float: '+((this.dir == "rtl")?"right":"left")+'; position: relative; border: 1px; width: '+titleWidth+'px; height: '+eval(titleHeight+iconHeight+15)+'px; clip: rect(0px '+titleWidth+'px '+eval(titleHeight+iconHeight+15)+'px 0px)"';
	str += ' onClick=\"page.all[\''+this.compName+'\'].mouseClick( '+this.index+', \''+this.id+'\', \''+this.iconClick+'\' );\"';
	str += '>';
	str += '<table border="0" height="100%" width="100%">';	
	str += '<tr><td align="center" valign="top" style="height:'+iconHeight+'px;">';	
	str += '<img id="' + this.id + '_image" src="' + this.resourcesURL + this.iconOut + '">';
	str += '</td></tr>';	
	str += '<tr><td align="center" valign="bottom">';	
	str += '<span id="' + this.id + '_caption" style="font-family: '+this.fontFamily+'; font-size:'+this.fontSize+'; color: '+this.fontColor+'; text-align: center;" ';
	str += '>' + this.title + '</span>';
	str += '</td></tr>';	
	str += '</table>';
	str += '</div>';
	
	return str;
};

















