/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentButton = function(name)
{
	//inherited
	this.__componentImage = __componentImage;
	this.__componentImage(name);

	this.confirmAnswer = false;
	this.orgCursor = null;
	this.isMouseOver = false;
};

componentButton.prototype = new __componentImage();
componentButton.prototype.type = "componentButton";

componentButton.prototype.onBaseCreate = function(obj)
{
    if (!this.mouseOverSrc) this.mouseOverSrc = this.src;
    if (!this.clickSrc) this.clickSrc = this.src;
    if (!this.lockedSrc) this.lockedSrc = this.src;
    if (!this.mouseOverLockedSrc) this.mouseOverLockedSrc = this.src;

    this.resourcesURL = unescape(this.resourcesURL);
	this.captureMouseEvents();
};
componentButton.prototype.componentButtonBaseOnCreate = componentButton.prototype.onCreate;
componentButton.prototype.onCreate = function(obj)
{
	this.componentButtonBaseOnCreate();
	this.toggleName = this.formatNames(this.toggleName);
	this.orgCursor = this.cursor;
};

componentButton.prototype.componentButtonBaseshow = componentButton.prototype.show;
componentButton.prototype.show = function()
{
	this.componentButtonBaseshow();
	this.eventMouseOut();
};

componentButton.prototype.componentButtonBaseLock = componentButton.prototype.lock;
componentButton.prototype.lock = function()
{
	if (!this.standardButton) {
		if (this.lockedSrc) this.setValue(this.resourcesURL + this.lockedSrc);
	};
	this.setCursor("default");
	this.componentButtonBaseLock();
};

componentButton.prototype.componentButtonBaseUnLock = componentButton.prototype.unlock;
componentButton.prototype.unlock = function()
{
	if (!this.standardButton) {
		if (this.standardSrc) this.setValue(this.resourcesURL + this.standardSrc);
	};
	this.setCursor(this.orgCursor);
	this.componentButtonBaseUnLock();
};

componentButton.prototype.componentButtonBaseEventClick = componentButton.prototype.eventClick;
componentButton.prototype.eventClick = function(e)
{
	if (this.locked) return false;
	var pageType = PageInterface.GetValue("pageType");

	if (this.toggleName != "") {
		var o = pc[this.toggleName];
		if (o) {
			o.toggleVisible();
		};
	};

	if (this.confirmAnswer) {
		PageInterface.Execute("checkAnswer", this);
		return true;
	} else {
		return this.componentButtonBaseEventClick(e);
	};
};

componentButton.prototype.componentButtonBaseEventMouseDown = componentButton.prototype.eventMouseDown;
componentButton.prototype.eventMouseDown = function(e)
{
	if (this.locked) return false;
	if (!this.standardButton) {
		if (this.clickSrc) this.setValue(this.resourcesURL + this.clickSrc); else
		if (this.standardSrc) this.setValue(this.resourcesURL + this.standardSrc);
	};
	return this.componentButtonBaseEventMouseDown(e);
};

componentButton.prototype.componentButtonBaseEventMouseUp = componentButton.prototype.eventMouseUp;
componentButton.prototype.eventMouseUp = function(e)
{
	if (this.locked) return false;
	if (!this.standardButton) {
		if (this.locked && this.mouseOverSrc) this.setValue(this.resourcesURL + this.mouseOverSrc); else 
		if (this.standardSrc) this.setValue(this.resourcesURL + this.standardSrc);
		if (this.isMouseOver) {
			this.eventMouseOver(e);
		} else {
			this.eventMouseOut(e);
		};
	};
	return this.componentButtonBaseEventMouseUp(e);
};

componentButton.prototype.componentButtonBaseEventMouseOver = componentButton.prototype.eventMouseOver;
componentButton.prototype.eventMouseOver = function(e)
{
	this.isMouseOver = true;
	if (!this.standardButton) {
		if (this.locked && this.mouseOverLockedSrc) this.setValue(this.resourcesURL + this.mouseOverLockedSrc); else
		if (this.mouseOverSrc) this.setValue(this.resourcesURL + this.mouseOverSrc);
	};
	return this.componentButtonBaseEventMouseOver(e);
};

componentButton.prototype.componentButtonBaseEventMouseOut = componentButton.prototype.eventMouseOut;
componentButton.prototype.eventMouseOut = function(e)
{
	this.isMouseOver = false;
	if (!this.standardButton) {
		if (this.locked && this.lockedSrc) this.setValue(this.resourcesURL + this.lockedSrc); else
		if (this.standardSrc) this.setValue(this.resourcesURL + this.standardSrc);
	};
	return this.componentButtonBaseEventMouseOut(e);
};
