/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentLexiconContent = function(name)
{
	this.componentSimplePopup = componentSimplePopup;
	this.componentSimplePopup(name);

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;

	this.key = null;
	this.description = null;
	this.imagesCompleteInfo = new Array();

	this.headerHeight = 50;
	this.borderWidth = 0;
	this.contentPadding = 0;
	this.closeButtonOffsetTop = 0;
	this.closeButtonOffsetRight = 0;
	this.headerTextOffsetTop = 0;
	this.headerTextOffsetLeft = 0;
	this.headerTextOffsetRight = 0;
	this.textAreaOffsetTop = 0;
	this.textAreaOffsetDown = 0;
	this.textAreaOffsetLeft = 0;
	this.textAreaOffsetRight = 0;
};

componentLexiconContent.prototype = new componentSimplePopup;
componentLexiconContent.prototype.type = "componentLexiconContent";

componentLexiconContent.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [ this.src, this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();

	this.setCompleteArrayInfo(this.completeInfoStyleImages);
	this.captureMouseEvents();
};

componentLexiconContent.prototype.componentLexiconContentBaseOnPaint = componentLexiconContent.prototype.onPaint;
componentLexiconContent.prototype.onPaint = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) {
		this.reFillComponent(lexicon.items[0]);
	};
	this.componentLexiconContentBaseOnPaint();
};

componentLexiconContent.prototype.componentLexiconContentBaseSetHTMLObiects = componentLexiconContent.prototype.setHTMLObiects;
componentLexiconContent.prototype.setHTMLObiects = function(obj)
{
	this.componentLexiconContentBaseSetHTMLObiects();

	var titlePointerImg = document.getElementById(this.id + "_titlePointerImg");
	var titlePointer = document.getElementById(this.id + "_titlePointer");
	var titleText = document.getElementById(this.id + "_titleText");
	var contentText = document.getElementById(this.id + "_tableDiv");
	var sizeDiv = document.getElementById(this.id + "_sizeDiv");

	titlePointerImg.src = this.resourcesURL + this.src;

	var dotH = getImageHeight(this.src);
	var dotW = getImageWidth(this.src);

	var font = this.getProjectFont(this.allowGF, this.fontFamily, this.fontSize, this.fontColor );
	var titleHeight = parseInt(getFontSize(font.size, 'px')*1.5);

	sizeDiv.style.width = this.w - dotW - 25;

	var topPadding = Math.max(dotH, titleHeight, sizeDiv.offsetHeight)+ (is.ie11up?20:15); //pg2-ie11_lexContent -title wrapped, content over some title's text, there was value 15
	this.headerHeight = topPadding;
	titleText.style.width = this.w - dotW - 25;
	titleText.style.height = topPadding;
	titleText.style.top = 10;
	titleText.style.left = 15+dotW;
	titleText.style.clip = 'rect(0px '+eval(this.w - dotW - 20)+'px '+topPadding+'px 0px)';

	titlePointer.style.width = dotW;
	titlePointer.style.height = dotH;
	titlePointer.style.top = 15;//10 + topPadding/2 - dotH/2;
	if (this.dir == "rtl") {
		titlePointer.style.left = this.width - 10;
	} else {
		titlePointer.style.left = 10;
	};
	titlePointer.style.clip = 'rect(0px '+dotW+'px '+dotH+'px 0px)';

	if (this._scrollable) {
		contentText.owner = null;
	};

	contentText.style.width = this.w - 25;
	contentText.style.height = this.h - topPadding;
	contentText.style.top = topPadding*(is.ie11up?2:1); //pg2-ie11_lexContent
	contentText.style.left = 10;
	contentText.style.clip = 'rect(0px '+eval(this.w - 20)+'px '+eval(this.h - topPadding*(is.ie11up?2:1))+'px 0px)'; //pg2-ie11_lexContent - ie11- use 2
	if (is.ie11up) this.textAreaOffsetTop = Math.floor(topPadding / 3); //pg2-ie11_lexContent

	var titleContentObj = document.getElementById(this.id + "_titleContentObj");
	var contentContentObj = document.getElementById(this.id + "_contentObj");
	var font = this.getProjectFont(this.allowGF, this.fontFamily, this.fontSize, this.fontColor)

	titleContentObj.style.fontFamily = font.family;
	titleContentObj.style.fontSize = getFontSize(font.size, 'px');
	titleContentObj.style.color = font.color;

	contentContentObj.style.fontFamily = font.family;
	contentContentObj.style.fontSize = getFontSize(font.size, 'px');
	contentContentObj.style.color = font.color;
};

componentLexiconContent.prototype.setScrollTop = function(obj)
{
	var	tableDiv = document.getElementById(this.id + "_tableDiv");
	var	trackDiv = document.getElementById(this.id + "_trackDiv");
	tableDiv.scrollTop = 0;
	trackDiv.style.top = this.sliderLowOffset;
};

componentLexiconContent.prototype.reFillComponent = function(obj)
{
	this.setScrollTop();
	if (obj) {
		this.setPhraseTitle(obj.key);
		this.setPhraseContent(obj.description);
	} else {
		this.setPhraseTitle("");
		this.setPhraseContent("");
	};
	this.getTextHeight();
	this.setHTMLObiects();
	this.placeHTMLObiects();

	this.playFilters();
};

componentLexiconContent.prototype.setPhraseTitle = function(text)
{
	this.key = text;
	var titleContentObj = document.getElementById(this.id + "_titleContentObj");
	var sizeDiv = document.getElementById(this.id + "_sizeDiv");

	if (this.boldPhrase) {
		titleContentObj.innerHTML = '<b>'+text+'</br>';
		sizeDiv.innerHTML = '<b>'+text+'</br>';
	} else {
		titleContentObj.innerHTML = text;
		sizeDiv.innerHTML = text;
	};
};

componentLexiconContent.prototype.setPhraseContent = function(text)
{
	this.description = text;
	text = text.replace(/\\n/ig, "<br>");
	var contentContentObj = document.getElementById(this.id + "_contentObj");
	contentContentObj.innerHTML = text;
};

componentLexiconContent.prototype.isReady = function()
{
	return preloadImage(this, "_0");
};

componentLexiconContent.prototype.print = function()
{
	var d_setting = "toolbar=no,location=no,directories=no,menubar=no,"
		+ "scrollbars=yes,width=640, height=480, left=0, top=0";
	var content = '<p><b>' + this.key + '</b></p>';
	content += '<p>' + this.description + '</p>';

	var printWin = window.open("", "", d_setting);
	printWin.document.open();
	printWin.document.write('<html><head><title>' + project.pageName + '</title>'); 
	printWin.document.write('</head><body onload="self.print();">');
	printWin.document.write(content);
	printWin.document.write('</body></html>');
	printWin.document.close();
	printWin.focus();
};
