/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentTextRollover = function(name)
{
	this.componentText = __componentText;
	this.componentText(name);

	if (arguments[1]) {
	} else {
		this.image     = this.addChild(new componentRollover(null));
		this.textOut   = this.addChild(new __componentText(null));
		this.textOver  = this.addChild(new __componentText(null));
	};
	this.timer = null;
	this.tableId = '';
};

componentTextRollover.prototype = new __componentText();
componentTextRollover.prototype.type = "componentTextRollover";

componentTextRollover.prototype.onBaseCreate = function(obj)
{
	this.resourcesURL = resourcesURL;
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};

		this.resourcesURL = unescape(this.resourcesURL);
		this.imagesNameArr = [ this.imageSrcOut, this.imageSrcIn ];
		this.getPreloadImagesArr();
	};
	this.captureMouseEvents();
};

componentTextRollover.prototype.onCreate = function(obj) 
{
	this.captureMouseEvents();
	if (this.execution) {
		document.getElementById(this.id + "_textOutDIV").style.visibility = 'inherit';
		document.getElementById(this.id + "_textOverDIV").style.visibility = 'hidden';
		document.getElementById(this.id + "_image_contentObj").src = this.resourcesURL + this.imageSrcOut;
		document.getElementById(this.id + "_contentObj").src = this.resourcesURL + this.src;
	} else {
		this.image.p_checkMarkers = this.p_checkMarkers;
		this.image.p_checkPNG = this.p_checkPNG;
		this.image.pngFix = this.pngFix;

		this.textOut.p_checkMarkers = this.p_checkMarkers;
		this.textOut.p_checkPNG = this.p_checkPNG;
		this.textOut.pngFix = this.pngFix;

		this.textOver.p_checkMarkers = this.p_checkMarkers;
		this.textOver.p_checkPNG = this.p_checkPNG;
		this.textOver.pngFix = this.pngFix;

		this.textOut.setVisible(true);
		this.textOver.setVisible(false);
		this.image.w    = this.w - eval(this.borderWidth*2);
		this.image.h    = this.h - eval(this.borderWidth*2);
		this.textOut.w  = this.w - eval(this.borderWidth*2);
		this.textOut.h  = this.h - eval(this.borderWidth*2);
		this.textOver.w = this.w - eval(this.borderWidth*2);
		this.textOver.h = this.h - eval(this.borderWidth*2);
	};
};

componentTextRollover.prototype.componentTextRolloverEventOnPaint = componentTextRollover.prototype.onPaint;
componentTextRollover.prototype.onPaint = function(obj) 
{
	if (this.execution) {
		if (!this.displayImage) {
			document.getElementById(this.id + "_imageDIV").style.visibility = 'hidden';
		};
	} else {
		if (!this.displayImage) this.image.setVisible(false);
	};
	//this.componentTextRolloverEventOnPaint();
};

componentTextRollover.prototype.componentTextRolloverBaseSetSizeScaledElement = componentTextRollover.prototype.setSizeScaledElement;
componentTextRollover.prototype.setSizeScaledElement = function (x, y, w, h)
{
	if (this.execution) {
		document.getElementById(this.id + "_imageDIV").style.width = w;
		document.getElementById(this.id + "_imageDIV").style.height = h;
		document.getElementById(this.id + "_imageDIV").style.clip = 'rect(0px '+w+' '+h+' 0px)';
		document.getElementById(this.id + "_textOutDIV").style.width = w;
		document.getElementById(this.id + "_textOutDIV").style.height = h;
		document.getElementById(this.id + "_textOutDIV").style.clip = 'rect(0px '+w+' '+h+' 0px)';
		document.getElementById(this.id + "_textOverDIV").style.width = w;
		document.getElementById(this.id + "_textOverDIV").style.height = h;
		document.getElementById(this.id + "_textOverDIV").style.clip = 'rect(0px '+w+' '+h+' 0px)';
		document.getElementById(this.id + "_textOutTable").width = w;
		document.getElementById(this.id + "_textOutTable").height = h;
		document.getElementById(this.id + "_textOverTable").width = w;
		document.getElementById(this.id + "_textOverTable").height = h;
	} else {
		this.image.w = w;
		this.image.h = h;
		this.textOut.w = w;
		this.textOut.h = h;
		this.textOver.w = w;
		this.textOver.h = h;
	};
	this.componentTextRolloverBaseSetSizeScaledElement(x, y, w, h);
};

componentTextRollover.prototype.componentTextRolloverBaseEventMouseOut = componentTextRollover.prototype.eventMouseOut;
componentTextRollover.prototype.eventMouseOut = function(e) 
{
	if (this.execution) {
		document.getElementById(this.id + "_textOutDIV").style.visibility = 'inherit';
		document.getElementById(this.id + "_textOverDIV").style.visibility = 'hidden';
		this.setImageSrc(this.resourcesURL + this.imageSrcOut, document.getElementById(this.id + "_image_contentObj"));
	} else {
		this.textOut.setVisible(true);
		this.textOver.setVisible(false);
		this.image.setValue(this.resourcesURL + this.image.srcOut);
		this.textOut.obj.style.cursor = this.cursor;
	};
	return this.componentTextRolloverBaseEventMouseOut();
};

componentTextRollover.prototype.componentTextRolloverBaseEventMouseOver = componentTextRollover.prototype.eventMouseOver;
componentTextRollover.prototype.eventMouseOver = function(e) 
{
	if (this.execution) {
		document.getElementById(this.id + "_textOverDIV").style.visibility = 'inherit';
		document.getElementById(this.id + "_textOutDIV").style.visibility = 'hidden';
		this.setImageSrc(this.resourcesURL + this.imageSrcIn, document.getElementById(this.id + "_image_contentObj"));
	} else {
		this.textOut.setVisible(false);
		this.textOver.setVisible(true);
		this.image.setValue(this.resourcesURL + this.image.srcIn);
		this.textOver.obj.style.cursor = this.image.cursor;
		if (this.tableId == '') this.changeCursor(this.textOver.obj);
	};
	return this.componentTextRolloverBaseEventMouseOver();
};

componentTextRollover.prototype.changeCursor = function(obj) 
{
	obj.style.cursor = this.cursor;
	obj.childNodes[0].style.cursor = this.cursor;
	this.tableId = obj.childNodes[0].id;
};

componentTextRollover.prototype.isReady = function()
{
	if (this.execution) {
		this.isLoaded = preloadImage(this, "_1") && preloadImage(this, "_2");
		this.eventMouseOut();
		return this.isLoaded;
	} else {
		return(((this.image.isReady)?this.image.isReady():true));
	}
};
