/*
 * Copyright ÄŹĹĽËť 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentTextarea = function(name) 
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.isChanged = false;

	this.correctAnswersList = new Array();
	this.interactions = true;
	this.interactionsType = "fill-in";
};

componentTextarea.prototype = new componentElement;
componentTextarea.prototype.type = "componentTextarea";

componentTextarea.prototype.onCreate = function(obj)
{
	this.correctAnswersList = this.correctAnswer.split("||");
	if (this.disabled == true) this.obj.disabled = true;
};

componentTextarea.prototype._getStyleDef = function()
{
	var styleDef = ""
	var scroll = '';
	if (is.ie || is.moz) {
		var borderStyle = (this.borderColor != null ? ("border-color:" + this.borderColor + "; border-style: solid;") : "");
		styleDef = " style='overflow-x: hidden; overflow-y: " + this.showScrollbars + "; width:" + this.w + "; height:" + (this.h - 2) + 
					"; background-color:" + this.bgColor + ";" + borderStyle + "width:100%;" + 
					"font-family: " + this.fontFamily + "; font-size: " + getFontSize(this.fontSize, 'px') + "px; color: " + this.fontColor + ";" + //pg2-4 aka
					"'";
	};
	return styleDef;
};

componentTextarea.prototype._setHTMLDef = function(valStr) 
{
	valStr = (valStr ? valStr : "");

	//if (!this.execution) { //pg2- 4 aka
		var t = "<form name='" + this.id + "Form' id='" + this.id + "Form'>"
		t += "<textarea id='" + this.id + "_contentObj' name='txtarea' value='" + valStr + "'";
		t += this._getStyleDef();

		t += ' onfocus="WBTObject.all[\'' + this.id + '\'].invokeEvent(\'FocusIn\')"';
		t += ' onblur="WBTObject.all[\'' + this.id + '\'].invokeEvent(\'FocusOut\')"';
		t += ' onkeydown="WBTObject.all[\'' + this.id + '\'].invokeEvent(\'KeyDown\')"';
		t += ' onkeyup="WBTObject.all[\'' + this.id + '\'].fnOnKeyUp()"';
		t += ' onkeypress="WBTObject.all[\'' + this.id + '\'].fnOnKeyPress()"';
		t += ' onchange="WBTObject.all[\'' + this.id + '\'].fnOnChange()"';
		if (this.disabled == true) t += ' disabled="disabled"';

		t += ">";
		t += this.value;
		t += "</textarea>"
		t += "</form>";
		this.setHTML(t);
	//};
};

componentTextarea.prototype.getAnswer = function() 
{
	var valStr  = "";
	var form = page.doc.forms[this.id + "Form"];
	if (form) {
		if (config && config.exportDetails == 'exam' && !this.caseSensitive) { //pg2-otherwise in exam answer always would be incorrect (it is checked at lms side)
			valStr = form[0].value;
			var tmpAns = valStr.toLowerCase();
			if (this.correctAnswersList.length > 0) {
				for (var i=0; i<this.correctAnswersList.length; i++) {
					var corrAnsNLowerCases = this.correctAnswersList[i].toLowerCase();
					if (corrAnsNLowerCases == tmpAns) {
						valStr = this.correctAnswersList[i];
						break;
					};
				};
			};
		} else {
			if (this.caseSensitive == false) valStr = form[0].value.toLowerCase(); else valStr = form[0].value;
		};
	};
	return valStr;
};

componentTextarea.prototype.setAnswer = function(valStr) 
{
	var form = page.doc.forms[this.id + "Form"];
	if (valStr != '') {
		var correctArr = valStr.split('||');
		if (form) form[0].value = correctArr[0];
	};
	return valStr;
};

componentTextarea.prototype.componentTextareaBaseResetElement = componentTextarea.prototype.resetElement;
componentTextarea.prototype.resetElement = function()
{
	this.componentTextareaBaseResetElement();

	var form = page.doc.forms[this.id + "Form"];
	if (form) form[0].value = "";
};

componentTextarea.prototype.onPaint = function(obj) 
{
	if (this.bgColor == null) this.bgColor = is.ns4 ? null : 'transparent';

	if ((this.borderColor == null) || (this.borderColor == "null") || (this.borderColor == "" )) {
		this.borderColor = null;
	};

	var w = this.w;
	var h = this.h;

	this.w = ( ( w == null ) ? this.w : ( w < 0 ? 0 : w ) );
	this.h = ( ( h == null ) ? this.h : ( h < 0 ? 0 : ( !is.ns4 ? h : 40 ) ) );

	if ((this.w == null) && (this.h == null)) { } else //pg2-why empty block? investigation leave for later
    if (this.style != null) {
		if (is.ns4) {
			this.style.clip.width = this.w;
			this.style.clip.height = this.h;
		} else {
			this.style.width = this.w;
			this.style.height = this.h;
			this.style.clip = 'rect(0px ' + (this.w||0) + 'px ' + (this.h||0) + 'px 0px)';
		};
	};
	this._setHTMLDef(this.getAnswer());

	var contObj = this.findContentObj(); //pg2-prevent from resize (Firefox 9, Chrome, Safari, etc)
	if (contObj) contObj.style.resize = 'none';

	if (this.caseSensitive == false) this.correctAnswer = this.correctAnswer.toLowerCase();
};

componentTextarea.prototype.componentTextareaBaseSetSizeScaledElement = componentTextarea.prototype.setSizeScaledElement;
componentTextarea.prototype.setSizeScaledElement = function(x, y, w, h)
{
	this.componentTextareaBaseSetSizeScaledElement(x, y, w, h);
	if (this.execution) {
		document.getElementById(this.id + "Form").style.width = w;
		document.getElementById(this.id + "Form").style.height = h;		
	};
};

componentTextarea.prototype.setAnswersProps = function(doAnswers, answers) 
{
	this.setDoCheckAnswers(doAnswers);
	this.setAnswers(answers);
};

componentTextarea.prototype.setDoCheckAnswers = function(doAnswers) 
{
	this.doCheckAnswers = doAnswers;
};

componentTextarea.prototype.splitAnswer = function(s) 
{
	var ans = new Array();
	if (s.charAt(0) == '"') s = s.substr(1, s.length);
	if (s.charAt(s.length-1) == '"') s = s.substr(0, s.length-1);
	ans = s.split('||');
	//
	for(var i=0; i < ans.length; i++) {
		ans[i] = ans[i].replace(new RegExp('#&034', "g"), '"');
	};
	return(ans);
};

componentTextarea.prototype.checkAnswer = function() 
{
	return(this.parseCheckAnswer(this));
};

componentTextarea.prototype.parseCheckAnswer = function(obj)
{
	if (!obj) return(false);
	var splitStr = "||";
	var actAnswer = this.getAnswer().toString();
	var ans = "";
	var arrCorrAns = new Array();
	arrCorrAns = unquotedString(this.correctAnswer).split(splitStr);  

	if (!this.caseSensitive) actAnswer = actAnswer.toLowerCase();

	for(var i = 0; i < arrCorrAns.length; i++) {
		ans = (this.caseSensitive) ? arrCorrAns[i]:arrCorrAns[i].toLowerCase();
		if (actAnswer == ans) return (true);
	};
	return (false);
};

componentTextarea.prototype.onLock = function() 
{
	var form = page.doc.forms[this.id + "Form"];
	if (form) valStr = form[0].disabled = true;
	return(true);
};

componentTextarea.prototype.onUnLock = function() 
{
	var form = page.doc.forms[this.id + "Form"];
	if (form) valStr = form[0].disabled = false;
};

componentTextarea.prototype.unselectable = function()
{
};

componentTextarea.prototype.fnOnKeyPress = function()
{
	this.invokeEvent("KeyPress", window.event);
	//if (window.event.keyCode == 13) window.event.returnValue = false;
};

componentTextarea.prototype.fnOnKeyUp = function()
{
	this.invokeEvent("KeyUp", window.event);
	if (this.controlAnswer) this.checkElementAnswer();
};

componentTextarea.prototype.fnOnChange = function()
{
	this.isChanged = true;
	this.invokeEvent("Change");
};

componentTextarea.prototype.checkIsChanged = function()
{
	return(this.isChanged);
};

componentTextarea.prototype.checkElementAnswer = function()
{
	if (this.checkAnswer()) {
		this.invokeEvent("CorrectAnswer");
	} else {
		this.invokeEvent("IncorrectAnswer");
	}  ;
};

componentTextarea.prototype.onClear = function() 
{
	if (!this.checkAnswer()) {
		var form = getForm(this.id + "Form");
		if (form) form[0].value = "";
	};
};

componentTextarea.prototype.focus = function() 
{
	var form = getForm(this.id + "Form");
	if (form && this.visible) {
		form[0].focus();		
		form[0].value = form[0].value;		
	};
};

componentTextarea.prototype.checkIsFocused = function() 
{
	var form = getForm(this.id + "Form");
	return (form[0] == document.activeElement);
};

componentTextarea.prototype.interactionsCorrectResponsesCount = function()
{
	return this.correctAnswersList.length;
};

componentTextarea.prototype.interactionsCorrectResponses = function(index)
{
	return this.correctAnswersList[index];
};

componentTextarea.prototype.interactionsStudentResponse = function()
{
	if (this.ignoreAnswer && config && config.exportDetails == 'exam') { //pg2-open answer in case of exam
		return this.correctAnswersList[0];
	} else {
		return this.getAnswer();
	};
};

componentTextarea.prototype.interactionsCorrectResponsesAsText = function(index)
{
	if (this.ignoreAnswer && config && config.exportDetails == 'exam') { //pg2-open answer in case of exam
		return escape(this.getAnswer());
	} else {
		return escape(this.interactionsCorrectResponses(index)); //pg2-escape
	};
};

componentTextarea.prototype.interactionsStudentResponseAsText = function()
{
	if (this.ignoreAnswer && config && config.exportDetails == 'exam') { //pg2-open answer in case of exam
		return escape(this.getAnswer());
	} else {
		return escape(this.interactionsStudentResponse()); //pg2-escape
	};
};
