/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentResolution = function (name)
{
	this.componentPopup = componentPopup;
	if (arguments[1]){
		this.componentPopup(name, arguments[1]);
	} else {
		this.componentPopup(name);
	};
};

componentResolution.prototype = new componentPopup();
componentResolution.prototype.type = "componentResolution";

componentResolution.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();

	this.resourcesStatus = (page.allowCommunication()) ? PlayerInterface.GetValue("resourcesStatus") : PageInterface.GetValue("resourcesStatus");
	this.resourcesURL = (this.disableOnlineOfflineMix) ? resourcesURL : ((page.allowCommunication()) ? PlayerInterface.GetValue("resourcesURL") : PageInterface.GetValue("resourcesURL"));

	this.resourcesURL = unescape(this.resourcesURL);
};

componentResolution.prototype.componentResolutionBaseOnCreate = componentResolution.prototype.onCreate;
componentResolution.prototype.onCreate = function (obj)
{
	var x = 0, y = 0;
	var s = "";
	var text = "";

	if (this.userResX == 0 || this.userResY == 0) {
		var array = this.resolution.split("x");
		x = array[0];
		y = array[1];
	} else {
		x = this.userResX;
		y = this.userResY;
	};

	s = x + " x " + y;
	if (screen.width < x || screen.height < y) {
		text = this.resAreaTextFalse.replace( "[RES]", s );
		this.step = 0;
	} else {
		text = this.resAreaTextTrue.replace( "[RES]", s );
		if (this.popupCorrectVisible == true) { 
			this.step = 0;
		};
	};

	if (this.execution) {
		document.getElementById(this.id + "_textDIV_contentObj").innerHTML = text;
	} else {
		this.text.text = text;
	};

	this.imagesNameArr = [ this.buttonCrossSrc, this.buttonSrc ];
	this.getPreloadImagesArr();
	this.componentResolutionBaseOnCreate();
};

componentResolution.prototype.isReady = function()
{
	if (this.execution) {
		var isLoaded = false
		for (var i=0; i < this.imagesNameArr.length; i++) {
			isLoaded = preloadImage(this, "_"+i);
			if (!isLoaded) return false;
		};
		this.isLoaded = isLoaded;
		return this.isLoaded;
	} else {
		return(((this.buttonCrossSrc)?this.button.isReady():true) 
			&& ((this.buttonSrc)?this.buttonCross.isReady():true));
	};
};

componentResolution.prototype.onAfterLoad = function (obj) {
	if (!this.step) this.setVisible(true);
};
