var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ChooseDifficulty;
(function (ChooseDifficulty) {
    var ChooseDifficultyState = (function (_super) {
        __extends(ChooseDifficultyState, _super);
        function ChooseDifficultyState() {
            _super.call(this);
        }
        ChooseDifficultyState.prototype.create = function () {
            _super.prototype.create.call(this);
            var lvls = ["very_easy", "easy", "medium", "hard"];
            var positions = [{ x: 760, y: 45 }, { x: 280, y: 74 }, { x: 590, y: 380 }, { x: 154, y: 506 }];
            var lvlsLen = lvls.length;
            for (var i = 0; i < lvlsLen; i++) {
                var temp = this.game.add.button(positions[i].x, positions[i].y, lvls[i], this.setDifficulty, this, 1, 0, 2, 0);
                temp.scale.x = 0.85;
                temp.scale.y = 0.85;
            }
            var gd = this.game.add.image(1200, this.game.height * 0.45, "guide2");
            gd.scale.x = 0.85;
            gd.scale.y = 0.85;
            this.game.world.sort('z', Phaser.Group.SORT_ASCENDING);
        };
        ChooseDifficultyState.prototype.preload = function () {
            this.load.spritesheet("very_easy", "Images/GUI/very_easy.png", 350, 350, 3, 0, 0);
            this.load.spritesheet("easy", "Images/GUI/easy.png", 420, 420, 3, 0, 0);
            this.load.spritesheet("medium", "Images/GUI/medium.png", 410, 410, 3, 0, 0);
            this.load.spritesheet("hard", "Images/GUI/hard.png", 349, 349, 3, 0, 0);
            /// loading help
            this.load.image("guide2", "Images/GUI/guide2.png");
            this.game.load.image("cloud", "Images/GUI/instr_bg.png");
        };
        ChooseDifficultyState.prototype.setDifficulty = function (sprite) {
            DIFFICULTY = sprite.key;
            this.game.state.start("MainGameState", true, false);
        };
        return ChooseDifficultyState;
    })(BasicModule.BasicState);
    ChooseDifficulty.ChooseDifficultyState = ChooseDifficultyState;
})(ChooseDifficulty || (ChooseDifficulty = {}));
//# sourceMappingURL=ChooseDifficultyState.js.map