﻿declare var EXUT;
declare var createInputElements;

module MainGame {
    export class MainGameState extends BasicModule.BasicState {
        container: Phaser.Sprite;
        dragElements: any;
        game: Phaser.Game;
        constructor() {
            super();
        }
        preload() {
            super.preload();
            this.load.image("frame", "Images/Games/frame.png");
            this.load.image("card", "Images/Games/card_0.png");
            this.load.image("C_0_0", "Images/Games/C_0_0.png");
            this.load.image("O_0_0", "Images/Games/O_0_0.png");
            this.load.image("O_1_1", "Images/Games/O_1_1.png");
            this.load.image("O_2_2", "Images/Games/O_2_2.png");
            this.load.image("O_3_3", "Images/Games/O_3_3.png");
            this.load.image("O_4_4", "Images/Games/O_4_4.png");
            this.load.image("O_5_5", "Images/Games/O_5_5.png");
            this.load.image("O_6_6", "Images/Games/O_6_6.png");
            this.load.image("O_7_7", "Images/Games/O_7_7.png");
        }

        create() {
            super.create();
            var card = this.game.add.image(this.game.width, this.game.height, "card");
            card.scale.x = 0.75;
            card.scale.y = 0.75;
            card.x = this.game.width / 2 - card.width / 2;
            card.y = this.game.height / 2 - card.height / 2;
            card.z = 4;
            var frame = this.game.add.image(this.game.width, this.game.height, "frame");
            frame.scale.x = 0.8;
            frame.scale.y = 0.8;
            frame.x = this.game.width / 2 - frame.width / 2;
            frame.y = this.game.height - frame.height;
            this.container = this.game.add.sprite(this.game.width, this.game.height, "C_0_0");
            this.container.x = this.game.width / 4+ 30;
            this.container.y = this.game.height / 4;
            this.container.scale.x = 0.8;
            this.container.scale.y = 0.8;
            this.container.z = 4;
            this.loadImages(frame);
        }
        loadImages(frame) {
            this.dragElements = [];
            for (var i = 0; i < 8; i++) {
                var tmp = this.game.add.sprite(this.game.width, this.game.height, "O_" + i + "_" + i);
                tmp.x = frame.x + i * (tmp.width * 0.9) + 17;
                tmp.inputEnabled = true;
                tmp.input.enableDrag();
                tmp.overlap(this.container);
                tmp.events.onInputUp.add(this.InputUP, this);
                tmp.scale.x = 0.8;
                tmp.scale.y = 0.8;
                tmp.y = frame.y + tmp.width / 5;
                tmp.z = 6;
                this.dragElements.push({ "el": tmp, "startPos": { x: tmp.x, y: tmp.y } });
            }
        }
        InputUP(sprite, pointer) {
            if (!sprite.overlap(this.container)) {
                for (var i = 0; i < this.dragElements.length; i++) {
                    if (this.dragElements[i].el === sprite) {
                        sprite.x = this.dragElements[i].startPos.x;
                        sprite.y = this.dragElements[i].startPos.y;
                        break;
                    }
                }
                createInputElements(sprite);
            }
            else {
                sprite.x = this.container.x;
                sprite.y = this.container.y;
                sprite.inputEnabled = false;
                for (var i = 0; i < this.dragElements.length; i++) {
                    if (this.dragElements[i].el !== sprite) {
                        this.dragElements[i].el.x = this.dragElements[i].startPos.x;
                        this.dragElements[i].el.y = this.dragElements[i].startPos.y;
                        this.dragElements[i].el.inputEnabled = true;
                     
                    }
                }
            }
        }
       


    }
} 