﻿module SelectElement {
    export class SelectElementState extends BasicModule.BasicState {
        game: Phaser.Game;
        Elements: any;
        next: Phaser.Button;
        help: Phaser.Button;
        guideGroup: Phaser.Group;
        guide: Phaser.Sprite;
        text: Phaser.Text;
        cloud: Phaser.Sprite;
        constructor() {
            super();
        }
        preload() {
            super.preload();
            this.load.image("0_0", "Images/Games/1/0_0.png");
            this.load.image("1_0", "Images/Games/1/1_0.png");
            this.load.image("2_1", "Images/Games/1/2_1.png");
            this.load.image("3_0", "Images/Games/1/3_0.png");
            this.load.image("4_0", "Images/Games/1/4_0.png");
            this.load.image("guide", "Images/GUI/guide.png");
            this.load.image("dymek", "Images/GUI/dymek.png");
            this.load.spritesheet("help", "Images/GUI/help.png", 130, 134, 2);
            this.load.spritesheet("next", "Images/GUI/next.png",120, 120, 2);
        }
        create() {
            super.create();
            this.Elements = [];       
            this.LoadElements();


            this.next = this.game.add.button(this.game.width, this.game.height * 0.66, "next", this.NextGame, this, 1, 0, 2, 1);
            this.next.x = this.game.width - this.next.width - 20;
            this.next.y = this.game.height - this.next.height - 20;
            this.help = this.game.add.button(this.game.width, this.game.height * 0.66, "help", this.Help, this, 1, 0, 2, 1);
            this.help.x = this.game.width - this.help.width - 20;
            this.help.y = 20;


            this.next.visible = false;
            this.guide = this.game.add.sprite(this.game.width, this.game.height, "guide");
            this.guide.x = this.game.width - this.guide.width;
            this.guide.y = this.game.height - this.guide.height;
            this.cloud = this.game.add.sprite(50, 0, "dymek");
            
            this.cloud.scale.x = 0.8;
            this.cloud.scale.y = 0.8;
            this.cloud.y = 20 - this.cloud.height;
            
            this.text = this.game.add.text(0, this.cloud.height / 2, "Zaznacz poprawną wizytówkę!", { font: "30px Arial", fill: "#000000" });
            this.text.x = this.cloud.width / 2- this.text.width/2 + 50;
            this.cloud.addChild(this.text);
            this.guide.addChild(this.cloud);
            audio = new Audio("Sounds/OB_g_I_11_1.mp3");
            audio.play();

        }
        NextGame(next, pointer) {
            this.AudioStop();
            audio = new Audio("Sounds/page.mp3");
            audio.play();
            this.game.state.start("DragGameState", true, false);
         
        }
        Help(help, pointer) {
            this.AudioStop();
            audio = new Audio("Sounds/OB_g_I_11_1.mp3");
            audio.play();          
          
        }
        AudioStop() {
            try {
                audio.pause();
                audio.currentTime = 0;              
            }
            catch (e) {
            }

        }
        LoadElements() {
            for (var i = 0; i < 5; i++) {
                var temp;
                if (i === 2) {
                    temp = this.game.add.sprite(this.game.width, this.game.height, i + "_" + "1");
                    this.Elements.push({ "el": temp, "correct": true });
                    temp.inputEnabled = true;
                    temp.events.onInputUp.add(this.correctInput, this);
                }
                else {
                    temp = this.game.add.sprite(this.game.width, this.game.height, i + "_" + "0");
                    this.Elements.push({ "el": temp, "correct": false });
                    temp.inputEnabled = true;
                    temp.events.onInputUp.add(this.incorrectInput, this);
                }
                temp.scale.x = 0.8;
                temp.scale.y = 0.8;
            }
            for (var i = 0; i < 3; i++) {             
                this.Elements[i].el.x = this.game.width / 10;
                this.Elements[i].el.y = this.game.height / 3 - this.Elements[i].el.height + i*(this.Elements[i].el.height+10);
            }
            var tmp = 0;
            for (var i = 3; i < this.Elements.length; i++) {
                this.Elements[i].el.x = this.game.width / 10 + this.Elements[i].el.width+20;         
                this.Elements[i].el.y = this.game.height / 5 + tmp *( this.Elements[i].el.height + 20);
                tmp++;
            }
        }
        correctInput(sprite, pointer) {
            sprite.tint = 0x6dc066;
            this.next.visible = true;    
            this.text.setText("Gratulacje!"); 
            this.text.x = this.cloud.width / 2 - this.text.width / 2 + 50; 
            this.AudioStop();
            audio = new Audio("Sounds/win.mp3");
            audio.play();
            for (var i = 0; i < this.Elements.length; i++) {
                this.Elements[i].el.inputEnabled = false;
            }
            var Timer = this.game.time.events.add(Phaser.Timer.SECOND * 2, this.PlayCongratulations, this);
        }
     
        incorrectInput(sprite, pointer) {
            sprite.tint = 0xb3001e;
            this.AudioStop();
            audio = new Audio("Sounds/err.mp3");
            audio.play();
            setTimeout(function () {
                sprite.tint = 0xFFFFFF;
            }, 1000);
        }
        PlayCongratulations() {
            this.AudioStop();
            audio = new Audio("Sounds/gratulacje.mp3");
            audio.play();
        }
    }
} 