﻿module TitleScreen {
    export class TitleScreenState extends BasicModule.BasicState {
        game: Phaser.Game;
        titleScreenImage: Phaser.Sprite;

        constructor() {
            super();
        }

        create() {
            super.create();

            var introBox =  this.game.add.image(this.game.width / 5, this.game.height / 10, "box");
            var spons = this.game.add.image(0, this.game.height * 0.83, "sponsors");
            spons.scale.y = 0.9;
            var guide = this.game.add.image(this.game.width * 0.65, this.game.height * 0.35, "introGuide");
            guide.z = 4;         
            var play = this.game.add.button(this.game.width * 0.26, this.game.height * 0.53, "play", this.playDown, this, 1, 0, 2, 1);
            this.game.world.sort();
        }

        preload() {
            super.preload();       
            this.load.spritesheet("play", "Images/GUI/play_btn.png", 215, 215, 2);
            this.load.image("box", "Images/GUI/intro_box.png");
            this.load.image("sponsors", "Images/GUI/sponsors.png");
            this.load.image("introGuide", "Images/GUI/guide.png");
        }

        playDown(play, pointer) {
            audio = new Audio("Sounds/page.mp3");
            audio.play();
            this.game.state.start("SelectElementState", true, false);
          
        }
    }
}