﻿/*
 * Copyright ?1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentCourseReport = function(name)
{
	this.componentDetailedReport = componentDetailedReport;
	this.componentDetailedReport(name);

	this.studentScore = 0;
	this.maxScore = 0;
	this.interactionsColls = 0;
	this.chaptersArr = new Array();
	this.mailReportText = '';
	this.ieFixX = 0;
	this.ieFixY = 0;
};

componentCourseReport.prototype = new componentDetailedReport;
componentCourseReport.prototype.type = "componentCourseReport";

componentCourseReport.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [ this.printBtnOut, this.printBtnOver, this.mailBtnOut, this.mailBtnOver, this.srcOk, this.srcNotOk, this.srcReview, this.srcNotAtt, this.srcBullet, this.srcVisited, this.srcNotVisited ];

	this.getPreloadImagesArr();

	if (is.ie) {
		this.ieFixX = 2;
		this.ieFixY = 2;
	} else {
		this.ieFixX = 0;
		this.ieFixY = 0;
	};
	this.captureMouseEvents();
};

componentCourseReport.prototype.onCreate = function(obj)
{
	this.setImagesIntoObiects();
	this.placeHTMLObiects();
	this.getChaptersFromStruct();
	this.setLegendIcons();
	this.setGlobalInformationsRows();
	this.setBulletsIcon();
	this.createInteractionsColls();
};

componentCourseReport.prototype.setGlobalInformationsRows = function(obj)
{
	/* //pg2-removed, ain't working in IE (addidtional borders of hidden rows)
	var courseTitleCb = document.getElementById(this.id + "courseTitleCb");
	var courseDescCb = document.getElementById(this.id + "courseDescCb");
	var studentCb = document.getElementById(this.id + "studentCb");
	var startTimeCb = document.getElementById(this.id + "startTimeCb");
	var endTimeCb = document.getElementById(this.id + "endTimeCb");
	var sesionTimeCb = document.getElementById(this.id + "sesionTimeCb");
	var courseStatusCb = document.getElementById(this.id + "courseStatusCb");
	var coursePointsCb = document.getElementById(this.id + "coursePointsCb");
	var passPercCb = document.getElementById(this.id + "passPercCb");
	var passLevelCb = document.getElementById(this.id + "passLevelCb");
	var gainedPointsCb = document.getElementById(this.id + "gainedPointsCb");

	if (!this.courseTitleCb) displayHTMLElement(courseTitleCb, "none");
	if (!this.courseDescCb) displayHTMLElement(courseDescCb, "none");
	if (!this.studentCb) displayHTMLElement(studentCb, "none");
	if (!this.startTimeCb) displayHTMLElement(startTimeCb, "none");
	if (!this.endTimeCb) displayHTMLElement(endTimeCb, "none");
	if (!this.sesionTimeCb) displayHTMLElement(sesionTimeCb, "none");
	if (!this.courseStatusCb) displayHTMLElement(courseStatusCb, "none");
	if (!this.coursePointsCb) displayHTMLElement(coursePointsCb, "none");
	if (!this.passPercCb) displayHTMLElement(passPercCb, "none");
	if (!this.passLevelCb) displayHTMLElement(passLevelCb, "none");
	if (!this.gainedPointsCb) displayHTMLElement(gainedPointsCb, "none");*/

	//pg2-new
	var tabl = document.getElementById("courseReport1courseInfo");
	if (tabl) {
		if (!this.courseTitleCb) this.deleteRow(tabl, this.id+"courseTitleCb");
		if (!this.courseDescCb) this.deleteRow(tabl, this.id+"courseDescCb");
		if (!this.studentCb) this.deleteRow(tabl, this.id+"studentCb");
		if (!this.startTimeCb) this.deleteRow(tabl, this.id+"startTimeCb");
		if (!this.endTimeCb) this.deleteRow(tabl, this.id+"endTimeCb");
		if (!this.sesionTimeCb) this.deleteRow(tabl, this.id+"sesionTimeCb");
		if (!this.courseStatusCb) this.deleteRow(tabl, this.id+"courseStatusCb");
		if (!this.coursePointsCb) this.deleteRow(tabl, this.id+"coursePointsCb");
		if (!this.passPercCb) this.deleteRow(tabl, this.id+"passPercCb");
		if (!this.passLevelCb) this.deleteRow(tabl, this.id+"passLevelCb");
		if (!this.gainedPointsCb) this.deleteRow(tabl, this.id+"gainedPointsCb");
	};
};

componentCourseReport.prototype.deleteRow = function(tableObj, id) //pg2
{
	if (typeof(id) == 'undefined' || id == '' || typeof(tableObj) == 'undefined' || tableObj == null) return -1;

	var index = this.getRowIndex(tableObj, id);
	if (index > -1) tableObj.deleteRow(index);
};

componentCourseReport.prototype.getRowIndex = function(tableObj, id) //pg2
{
	if (typeof(id) == 'undefined' || id == '' || typeof(tableObj) == 'undefined' || tableObj == null) return -1;

	for (var i=0; i<tableObj.rows.length; i++) {
		var row = tableObj.rows[i];
		if (id == row.id) return i;
	};
	return -1;
};

componentCourseReport.prototype.onPaint = function(obj)
{
	var interactionsColls = document.getElementById(this.id + "interactionsColls");
	var interactionsTableDIV = document.getElementById(this.id + "interactionsTableDIV");

	var headerH = (interactionsColls.offsetHeight == 0) ? 41 : interactionsColls.offsetHeight;
	interactionsTableDIV.style.height = this.h - (this.detailsLegendHeight + 75);

	this.setSumaryCell();
};

componentCourseReport.prototype.deleteInteractionRows = function(obj)
{
	var interactionsTable = document.getElementById(this.id + "interactionsTable");
	if (interactionsTable) {
		var length = interactionsTable.rows.length;
		for (var i=0; i < length; i++){
			interactionsTable.deleteRow(0);
		};
	};
};

componentCourseReport.prototype.onAfterLoad = function(obj)
{
	if (PageInterface.GetValue("state") != psDesigning && page.getUELO()) {
		var UELO = page.getUELO();

		if (UELO){
			this.deleteInteractionRows();

			this.getScoresFromUELO(UELO);

			var courseID = document.getElementById(this.id + "_courseID");
			var courseDesc = document.getElementById(this.id + "_courseDesc");
			var studentName = document.getElementById(this.id + "_studentName");
			var startTime = document.getElementById(this.id + "_startTime");
			var endTime = document.getElementById(this.id + "_endTime");
			var sesionTime = document.getElementById(this.id + "_sesionTime");
			var courseStatus = document.getElementById(this.id + "_courseStatus");
			var score = document.getElementById(this.id + "_score");
			var courseScore = document.getElementById(this.id + "_courseScore");
			var scorePerc = document.getElementById(this.id + "_scorePerc");
			var passLevel = document.getElementById(this.id + "_passLevel");
			var gainedPoints = document.getElementById(this.id + "_gainedPoints");

			//pg2-IF (OBJECT_EXISTS) !!!!!!
			if (courseID) courseID.innerHTML = this.getCourseID(UELO);
			if (courseDesc) courseDesc.innerHTML = this.getCourseDesc(UELO);
			if (studentName) studentName.innerHTML = this.getUserName(UELO);
			if (startTime) startTime.innerHTML = this.getStartTime(UELO);
			if (endTime) endTime.innerHTML = this.getEndTime(UELO);
			if (sesionTime) sesionTime.innerHTML = this.getSesionTime(UELO);
			if (courseStatus) courseStatus.innerHTML = this.getCourseStatus(UELO);
			if (score) score.innerHTML = this.getScore();
			if (courseScore) courseScore.innerHTML = this.getScore();
			if (scorePerc) scorePerc.innerHTML = this.getScorePercString();
			if (passLevel) passLevel.innerHTML = this.getPassLevel(UELO);
			if (gainedPoints) gainedPoints.innerHTML = this.getGainedPoints();

			this.putExercisesStatusIntoTable(UELO);
		};	

		if (parseInt(this.getScorePerc()) >= UELO.passThreshold) {
			this.invokeEvent('Passed');
		} else {
			this.invokeEvent('Failed');
		};
	};
};

componentCourseReport.prototype.setImagesIntoObiects = function(UELO)
{
	var buttonMailImg = document.getElementById(this.id + "_buttonMailImg");
	var buttonPrintImg = document.getElementById(this.id + "_buttonPrintImg");

	if (buttonMailImg) {
		buttonMailImg.src = this.resourcesURL + this.mailBtnOut;
	};
	if (buttonPrintImg) {
		buttonPrintImg.src = this.resourcesURL + this.printBtnOut;
	};
};

componentCourseReport.prototype.placeHTMLObiects = function(UELO)
{
	var buttonMail = document.getElementById(this.id + "_buttonMail");
	var buttonPrint = document.getElementById(this.id + "_buttonPrint");
	var notAttIco = document.getElementById(this.id + "_notAttIco");
	var reviewIco = document.getElementById(this.id + "_reviewIco");
	var visitedIco = document.getElementById(this.id + "_visitedIco");
	var notVisitedIco = document.getElementById(this.id + "_notVisitedIco");

    var legend = document.getElementById(this.id + "legend");
    var globalInfo = document.getElementById(this.id + "globalInfo");
    var header = document.getElementById(this.id + "header");
    var courseInfoDIV = document.getElementById(this.id + "courseInfoDIV");

    var legend = document.getElementById(this.id + "legend");
    var interactionsDIV = document.getElementById(this.id + "interactionsDIV");

	legend.style.height = this.detailsLegendHeight;
	courseInfoDIV.style.height = this.detailsLegendHeight - 17;
	interactionsDIV.style.top = this.detailsLegendHeight + 5;

    var buttonPrntLeft = 0;
    if (!this.showLegend) {
        displayHTMLElement(legend, "none");

		globalInfo.style.width = this.w;
		header.width = this.w; 
		courseInfoDIV.style.width = this.w;
    };
	if (buttonMail) {
		buttonMail.style.top = this.h - this.mailBtnHeight;
		buttonMail.style.left = 0;
		buttonMail.style.width = this.mailBtnWidth;
		buttonMail.style.height = this.mailBtnHeight;
		buttonMail.style.clip = 'rect(0px '+this.mailBtnWidth+'px '+this.mailBtnHeight+'px 0px)';
		if (!this.mailBtnVisible) {
			displayHTMLElement(buttonMail, "none");
			buttonPrntLeft = 0;
		} else {
			buttonPrntLeft = this.mailBtnWidth + 5;
		};
	};
	if (buttonPrint) {
		buttonPrint.style.top = this.h - this.printBtnHeight;
		buttonPrint.style.left = buttonPrntLeft;
		buttonPrint.style.width = this.printBtnWidth;
		buttonPrint.style.height = this.printBtnHeight;
		buttonPrint.style.clip = 'rect(0px '+this.printBtnWidth+'px '+this.printBtnHeight+'px 0px)';
		if (!this.printBtnVisible) {
			displayHTMLElement(buttonPrint, "none");
		};
	};
	if (!this.srcNotAttVisible) {
		displayHTMLElement(notAttIco, "none");
	};
	if (!this.srcReviewVisible) {
		displayHTMLElement(reviewIco, "none");
	};

	if (!this.showIconsVisibleNotVisible) {
		displayHTMLElement(visitedIco, "none");
		displayHTMLElement(notVisitedIco, "none");
	};

	if (is.moz) {
		legend.style.width = 198;
		courseInfoDIV.style.width = this.w - 207;
		var interactionsTableDIV = document.getElementById(this.id + "interactionsTableDIV");
		interactionsTableDIV.style.width = this.w - 2;
	};
};

componentCourseReport.prototype.changeImage = function(objName, fileName)
{
	if (objName) this.setImageSrc(this.resourcesURL + fileName, objName);
};

componentCourseReport.prototype.findPosX = function (obj)
{
	var curleft = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curleft += obj.offsetLeft;
			obj = obj.offsetParent;
		};
	} else
	if (obj.x) {
		curleft += obj.x;
	};
	return curleft;
};

componentCourseReport.prototype.findPosY = function(obj)
{
	var curtop = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop;
			obj = obj.offsetParent;
		};
	} else
	if (obj.y) {
		curtop += obj.y;
	};
	return curtop;
};

componentCourseReport.prototype.setSumaryCell = function(UELO)
{
	var courseScore = document.getElementById(this.id + "_courseScore");
	if (!this.points){
		courseScore.style.display = 'none';
	} else {
		var tdPoints = document.getElementById(this.id + "_tdPoints");
		var interactionsDIV = document.getElementById(this.id + "interactionsDIV");

		var x = this.findPosX(tdPoints)-this.x;
		var y = this.findPosY(interactionsDIV)-this.y;

		courseScore.style.left = x-1;
		courseScore.style.top = y + interactionsDIV.offsetHeight; - this.mailBtnHeight;
		courseScore.style.width = tdPoints.offsetWidth-1+this.ieFixX;
		courseScore.style.height = tdPoints.offsetHeight-5+this.ieFixY;
	};
};

componentCourseReport.prototype.createInteractionsColls = function(UELO)
{
	var interactionsColls = document.getElementById(this.id + "interactionsColls");
	var interactionsTable = document.getElementById(this.id + "interactionsTable");
	var collGR = document.getElementById(this.id+'collGR');
	var collGRInt = document.getElementById(this.id+'collGRInt');
	var cell = null;
	var cellNumber = 0;

	var row = interactionsColls.insertRow(0);
	var th = document.createElement("TH");
	th.setAttribute("colSpan", 7);
	th.innerHTML = this.exercisesInfo;
	row.appendChild(th);

	var row = interactionsColls.insertRow(1);
	if (!collGR) {
		var collGR = document.createElement("COLGROUP");
		collGR.setAttribute("id", this.id+'collGR');
	};

	var i = 0;
	while (interactionsColls.childNodes[i].tagName != "TBODY") i++;
	interactionsColls.insertBefore(collGR, interactionsColls.childNodes[i]);
	if (!collGRInt) {
		collGRInt = document.createElement("COLGROUP");	
		collGRInt.setAttribute("id", this.id+'collGRInt');
		interactionsTable.appendChild(collGRInt);
	};

	var col = document.createElement("COL");
	col.setAttribute("width", '20px');
	collGR.appendChild(col);
	cell = row.insertCell(cellNumber++);
	cell.innerHTML = this.exerciseLpCaption;

	col = document.createElement("COL");
	col.setAttribute("width", '20px');
	collGRInt.appendChild(col);

	col = document.createElement("COL");
	collGR.appendChild(col);
	cell = row.insertCell(cellNumber++);
	cell.innerHTML = this.exerciseQuestionCaption;

	col = document.createElement("COL");
	collGRInt.appendChild(col);

	if (this.answer) {
		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGR.appendChild(col);
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = this.exerciseAnswerCaption;

		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGRInt.appendChild(col);
	};
	if (this.tryPoints) {
		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGR.appendChild(col);
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = this.exerciseTrycountCaption;

		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGRInt.appendChild(col);
	};
	if (this.points) {
		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGR.appendChild(col);
		cell = row.insertCell(cellNumber++);
		cell.id = this.id+'_tdPoints';
		cell.innerHTML = this.exercisePointCaption;

		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGRInt.appendChild(col);
	};
	if (this.correct) {
		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGR.appendChild(col);
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = this.statusCaption;

		col = document.createElement("COL");
		col.setAttribute("width", '75px');
		collGRInt.appendChild(col); 
	};

	col = document.createElement("COL");
	col.setAttribute("width", 16+'px');
	collGR.appendChild(col);
	cell = row.insertCell(cellNumber++);
	cell.innerHTML = '&nbsp;';

	var interactionsTableDIV = document.getElementById(this.id + "interactionsTableDIV");
	interactionsTableDIV.style.height = this.h - interactionsColls.offsetHeight - 195;
};

componentCourseReport.prototype.putExercisesStatusIntoTable = function(UELO)
{
	var interactionsTable = document.getElementById(this.id + "interactionsTable");
	var p = null;
	var foundChosenPage = false;
	var row = null;
	var cell = false;
	var sResponse = '';
	var score = 0;
	var maxScore = 0;
	var rowNo = 1;

	var stPageInfoArr = this.startPageName.split(':');
	var endPageInfoArr = this.endPageName.split(':');

	var pStartGix = -1;
	var pEndGix = -1;		

	if (typeof(stPageInfoArr[1]) != 'undefined') {
		pStartGix = parseInt(stPageInfoArr[0]);
		var pStartName = stPageInfoArr[1];
	} else {
		var pStartName = stPageInfoArr[0];
	};

	if (typeof(endPageInfoArr[1]) != 'undefined'){
		pEndGix = parseInt(endPageInfoArr[0]);
		var pEndName = endPageInfoArr[1];
	} else {
		var pEndName = endPageInfoArr[0];		
	};
	var isStronglyInfo = false;
	var pageType = "";
	var pagesInteractionArr = new Array();	
	var pageInteraction = new Array();	

	//for multiSCO report
	var isMulti = checkExportType(config.exportDetails, 'multi');
	var pageIndex = -1;
	var struct = getStruct();
	var structPage = null;
	// end

	var player = getPlayer(); //pg2-qr -in raport there is displayed current structure, but if course has mixed structure but wasn't solved in this session, repaint previous structure
	var isCourseMixedAndNotSolvetDuringThisSession = (player && struct.isCourseMixed && !player.checkExamWasSolved() && UELO.previousMixedStructure != '' && !UELO.pageInAssessmentCheckAnswerInSession);

	for (var i = 0; i < UELO.pages.length; i++) {
		p = UELO.pages[i];
		isStronglyInfo = false;
		
		if (pStartName == '' || (p.title == pStartName && pStartGix == -1) || p.globalIndex == pStartGix){ //pg2-knf_qr_mix -moved here, otherwise page could be not found
			foundChosenPage = true;
		};
		
		if (p.isAssessment == 0) isStronglyInfo = true;

		//if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment && !p.previouslyVisible) continue; //pg2-qr -new
		if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) { //pg2-pkf_qr -new
			if (!p.previouslyVisible) {
				if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) break; else continue;
			};
		} else { //pg2-pkf_qr + //pg2-lean_om - hidden exercise pages
			if (p.visible == 0) {
				if (!config.sendDataFromHiddenPages) { //pg2-lean_om - hidden exercise pages
					if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) {
						break;
					} else {
						continue;
					};
				};
			};
		};

		//if (pStartName == '' || (p.title == pStartName && pStartGix == -1) || p.globalIndex == pStartGix){
			//foundChosenPage = true;
		//};
		
		//pg2-pkf_qr -moved here, otherwise in case of drawing pages it might happen that 'continue' would be invoked and pages of raport-raport2 will be displayed
		if ((p.visible == 0 && !config.sendDataFromHiddenPages) && //pg2-lean_om -hidden exercise pages
			!isCourseMixedAndNotSolvetDuringThisSession) continue; //pg2-qr -modyfied, some previously visible, but now invisible page could be included into score calculation -from previous session
		
		if (foundChosenPage) {
			if (this.chapterPages && this.isInArray(p.globalIndex, this.chaptersArr)) {
				row = interactionsTable.insertRow(interactionsTable.rows.length);
				this.insertChapterRow(p, row);
			} else {
				pageType = p.pageType;
				if (isStronglyInfo) pageType = 'Information';
				if (isMulti) {
					structPage = struct.findItem(p.globalIndex);
					pageIndex = structPage.index;

					switch (pageType){
						case 'Information' :
							if (this.informationPages) {
								row = interactionsTable.insertRow(interactionsTable.rows.length);
								var multiPage = this.createInteractionFromMultiInformation(p, pageIndex);
								this.getInteractionsFromInformation(multiPage, rowNo++, row);
							};						
							break;
						case 'Exercise':
							pagesInteractionArr = this.createTempPageInteractionArray();								
							pageInteraction = this.createInteractionFromMultiExercise(p, pageIndex);								
							pagesInteractionArr = this.makePageInteractionsGroup(pagesInteractionArr, pageInteraction, p.title);

							var interactions = this.getGroupedInteractions(pagesInteractionArr);
							row = interactionsTable.insertRow(interactionsTable.rows.length);
							this.getInteractionsFromExercise(interactions, p.globalIndex, p.status, rowNo++, row, 1, p.title); //pg2-page title
							break;
						case 'Poll':
							pagesInteractionArr = this.createTempPageInteractionArray();								
							pageInteraction = this.createInteractionFromMultiPoll(p, pageIndex);								
							pagesInteractionArr = this.makePageInteractionsGroup(pagesInteractionArr, pageInteraction, p.title);

							var interactions = this.getGroupedInteractions(pagesInteractionArr);
							row = interactionsTable.insertRow(interactionsTable.rows.length);
							this.getInteractionsFromPoll(interactions, p.globalIndex, rowNo++, row);
							break;
					};
				} else {				
					switch (pageType) {
						case 'Information':
							if (this.informationPages) {
								row = interactionsTable.insertRow(interactionsTable.rows.length);
								this.getInteractionsFromInformation(p, rowNo++, row);
							};
							break;
						case 'Exercise':
							if (p.interactions.length > 0) {
								//pg2-pkf -concider not separate interactions, but entire exercises from page
								var addInteraction = false;
								if (this.show_all_ex) addInteraction = true; else
								if (p.status == 'P' && this.show_passes_ex) addInteraction = true; else
								if ((p.status == 'F' || p.status == 'C' || p.status == 'N') && this.show_failed_ex) addInteraction = true;
								if (!addInteraction) break;
								//...
								if (this.groupPageInteractions) {
									pagesInteractionArr = this.createTempPageInteractionArray();
								};

								var interactionAdded = false;
								//var addInteraction = false;
								var interactionsCount = p.interactions.length;
								for (var j=0; j<interactionsCount; j++) {
									//addInteraction = false; //pg2-pkf -removed
									var maxScore = 0;
									var action = '';	
									
									score = (p.interactions[j].result.toString() == "true") ? p.interactions[j].score : 0;									
									maxScore = p.interactions[j].maxScore;

									/* //pg2-pkf -removed -concider entire page, not single interactions
									if (this.show_all_ex){
										addInteraction = true;
									} else
									if (this.show_passes_ex && score == maxScore){
										addInteraction = true;
									} else
									if (this.show_failed_ex && score != maxScore){
										addInteraction = true;
									};*/
									if (addInteraction){
										if (this.groupPageInteractions) {
											pagesInteractionArr = this.makePageInteractionsGroup(pagesInteractionArr, p.interactions[j], p.title);
										} else {
											row = interactionsTable.insertRow(interactionsTable.rows.length);
											this.getInteractionsFromExercise(p.interactions[j], p.globalIndex, p.status, rowNo++, row, interactionsCount, p.title); //pg2-page title
										};
									};
								};
								if (this.groupPageInteractions) {
									var interactions = this.getGroupedInteractions(pagesInteractionArr);
									row = interactionsTable.insertRow(interactionsTable.rows.length);
									this.getInteractionsFromExercise(interactions, p.globalIndex, p.status, rowNo++, row, 1, p.title); //pg2-page title
								};
							};
							break;
						case 'Poll':
							if (p.interactions.length > 0) {
								for (var j=0; j<p.interactions.length; j++) {
									row = interactionsTable.insertRow(interactionsTable.rows.length);
									this.getInteractionsFromPoll(p.interactions[j], p, rowNo++, row);
								};
							};
							break;						
					};
				};
			};
		};
		if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix){
			break;
		};			
	};
};

componentCourseReport.prototype.isInArray = function(value, array)
{
	if (!this.chaptersArr[value]) {
		return false;
	} else {
		return true;
	};
};

componentCourseReport.prototype.insertChapterRow = function(page, row)
{
	var cellNumber = 0;
	var colsNo = 2;
	var cell = null;

	if (this.answer) colsNo++;
	if (this.tryPoints) colsNo++;
	if (this.points) colsNo++;
	if (this.correct) colsNo++;

	cell = row.insertCell(cellNumber++);
	cell.colSpan = colsNo;
	cell.align = 'left';
	cell.innerHTML = '<span class="'+this.id+'spanMargin">'+page.title+'</span>';
};

componentCourseReport.prototype.getGroupedInteractions = function(tempPageInterArr)
{
	var interactions = new Object();

	interactions.question = tempPageInterArr[0];
	interactions.studentResponse = tempPageInterArr[1].join("<br>");
	interactions.studentResponseAsText = tempPageInterArr[2].join("<br>");
	interactions.correctResponses = tempPageInterArr[3].join("<br>");
	interactions.correctResponsesAsText = tempPageInterArr[4].join("<br>");

	interactions.result = tempPageInterArr[5];

	tempPageInterArr[6].sort(function sortNumber(a, b){return a - b;});
	var tNL = tempPageInterArr[6].length;

	interactions.tryNumber = tempPageInterArr[6][tNL-1];
	/*
	var uScore = 0;
	var interL = tempPageInterArr[7].length;
	for (var i=0; i<interL; i++)
	{
		uScore += (tempPageInterArr[7][i]/interL);
	}
	*/
	interactions.score = (interactions.result)?1:0;

	interactions.maxScore = 1;
	return interactions;
};

componentCourseReport.prototype.getValueFromSCO = function(valueParam, pageIndex)
{
	return (lms)?lms.getValueForSco(valueParam, pageIndex):"";	
};

componentCourseReport.prototype.getSCOStatus = function(pageIndex)
{
	var SCOStatus = "";
	var isExam = PageInterface.GetValue("isExam");

	if (isExam) {
		SCOStatus = lms.getValueForSco(pageIndex-2);
	} else {
		SCOStatus = this.getValueFromSCO('cmi.core.lesson_status', pageIndex-2);
	};
	if (SCOStatus == null || SCOStatus.toString() == "null") {
		SCOStatus = this.getValueFromSCO('cmi.success_status', pageIndex-2);
		if (SCOStatus == 'unknown') {
			SCOStatus = this.getValueFromSCO('cmi.completion_status', pageIndex-2);
		};
	};
	return SCOStatus;
};

componentCourseReport.prototype.createInteractionFromMultiInformation = function(ueloPage, pageIndex)
{
	var multiPage = new Object();
	multiPage.title = ueloPage.title;
	multiPage.versionTitle = ueloPage.versionTitle;
	var structPageStatus = this.getSCOStatus(pageIndex);
	multiPage.status = convertStatusToLetter(structPageStatus);

	return multiPage;
};

componentCourseReport.prototype.createInteractionFromMultiExercise = function(ueloPage, pageIndex)
{	
	var result = "";
	var interactions = new Object();

	interactions.question = ueloPage.title;//ptitle

	var lRes = this.getValueFromSCO("cmi.interactions.0.learner_response", pageIndex-2);
	if (lRes != null && lRes != "null" && lRes != "") {
		result = lRes;
	} else {
		var lRes = this.getValueFromSCO("cmi.interactions.0.student_response", pageIndex-2);
		if (lRes != null && lRes != "null" && lRes != "") {
			lRes = lRes.replace(/_/ig, " ");
			lRes = lRes.replace(/\[,\]/ig, "<br>");		
			result = lRes;
		} else {
			result = "";
		};
	};
	interactions.studentResponse = result;//answer
	interactions.studentResponseAsText = new Array();//answer as text

	var cRes = this.getValueFromSCO("cmi.interactions.0.correct_responses.0.pattern", pageIndex-2);
	if (cRes != null && cRes != "null" && cRes != "") {
		cRes = cRes.replace(/_/ig, " ");
		cRes = cRes.replace(/\[,\]/ig, "<br>");		
		result = cRes;
	} else { 
		result = "";
	};
	interactions.correctResponses = result;//correct
	interactions.correctResponsesAsText = new Array();//correct as text

	var sd = this.getValueFromSCO("cmi.suspend_data", pageIndex-2);
	if (sd != null && sd != "") {
		var sdArr = sd.split("_tn=");
		if (typeof(sdArr[1]) != 'undefined') {
			result = sdArr[1].split("|")[0];
		} else {
			result = 0;
		};
	} else {
		result = 0;
	};
	interactions.tryNumber = result;//trycount	

	var structPageStatus = this.getSCOStatus(pageIndex);
	result = (structPageStatus == "passed");
	interactions.result = result;//result
	interactions.score = (interactions.result)?1:0;//score
	interactions.maxScore = 1;

	return interactions;
};

componentCourseReport.prototype.createInteractionFromMultiPoll = function(ueloPage, pageIndex)
{	
	var result = "";
	var interactions = new Object();
	interactions.question = ueloPage.title;//ptitle

	var lRes = this.getValueFromSCO("cmi.interactions.0.learner_response", pageIndex-2);
	if (lRes != null && lRes != "null" && lRes != "") {
		result = lRes;
	} else {
		var lRes = this.getValueFromSCO("cmi.interactions.0.student_response", pageIndex-2);
		if (lRes != null && lRes != "null" && lRes != "") {
			lRes = lRes.replace(/_/ig, " ");
			lRes = lRes.replace(/\[,\]/ig, "<br>");		
			result = lRes;
		} else {
			result = "";
		};
	};
	interactions.studentResponse = result;//answer
	interactions.studentResponseAsText = new Array();//answer as text

	interactions.correctResponses = new Array();;//correct
	interactions.correctResponsesAsText = new Array();//correct as text
	interactions.tryNumber = "";//trycount	
	interactions.result = "";//result
	interactions.score = "";//score
	interactions.maxScore = "";
	return interactions;
};

componentCourseReport.prototype.createTempPageInteractionArray = function()
{
	var tempPageInterArr = new Array();
	tempPageInterArr[0] = new Array();//ptitle
	tempPageInterArr[1] = new Array();//answer
	tempPageInterArr[2] = new Array();//answer as text
	tempPageInterArr[3] = new Array();//correct
	tempPageInterArr[4] = new Array();//correct as text
	tempPageInterArr[5] = true;//result
	tempPageInterArr[6] = new Array();//trycount
	tempPageInterArr[7] = new Array();//points
	tempPageInterArr[8] = new Array();//status

	return tempPageInterArr;
};

componentCourseReport.prototype.makePageInteractionsGroup = function(tempPageInterArr, interactions, pTitle)
{
	tempPageInterArr[0] = pTitle;//ptitle

	tempPageInterArr[1].push(interactions.studentResponse);//answer
	tempPageInterArr[2].push(unescape(interactions.studentResponseAsText));//answer as text

	tempPageInterArr[3].push(interactions.correctResponses);//correct
	tempPageInterArr[4].push(unescape(interactions.correctResponsesAsText));//correct as text

	tempPageInterArr[5] = (interactions.result.toString() == "true" && tempPageInterArr[5]);//result
	tempPageInterArr[6].push(interactions.tryNumber);//trycount

	var score = (interactions.result.toString() == "true") ? 1 : 0;
	var maxScore = interactions.maxScore;

	tempPageInterArr[7].push(score);//points
	tempPageInterArr[8].push(((score == maxScore)?1:0));//status

	return tempPageInterArr;
};

componentCourseReport.prototype.getInteractionsFromExercise = function(interactions, pGix, pStatus, index, row, interactionsCount, pageTitle)
{
	var cellNumber = 0;
	var score = 0;
	var maxScore = 0;
	var action = '';	
	var questionMargin = 'class="' + this.id + 'spanMarginImg"'; //'class="'+this.id+'spanMargin"'; //pg2-pkf -replaced -style 'Img' has smaller margin that this without image(!)
	var reviewImg = '';
	var cell = null;	

	//score = (interactions.result.toString() == "true") ? 1 : 0;
	//score = (score / interactionsCount).toFixed(3);
	//maxScore = interactions.maxScore;
	score = interactions.score;
	if (score == 0 && (interactions.result.toString() == 'true' || interactions.status == 'P')) score = 1; //pg2-pkf_qr - do not group interactions
	maxScore = (interactions.maxScore/interactionsCount).toFixed(3);

	cell = row.insertCell(cellNumber++);
	cell.innerHTML = index;
	cell.className = 'center';		

	if (this.solved && pStatus == 'P') { //pg2-pkf
		action = 'onClick=\"if (!opener) PlayerInterface.Execute(\'gotoPage\', ' + pGix + ');"';
		if (this.srcReviewVisible) {
			reviewImg = '<img src="' + this.resourcesURL + this.srcReview + '" />';
			questionMargin = ' class="' + this.id + 'spanMargin" ';
		};
		questionMargin += ' style="text-decoration:underline; cursor:pointer;" ';
	};

	/*if (this.solved && score == maxScore){ //pg2-pkf -removed
		action = 'onClick=\"if (!opener) PlayerInterface.Execute(\'gotoPage\', '+pGix+');"';
		if (this.srcReviewVisible) {
			reviewImg = '<img src="' + this.resourcesURL + this.srcReview + '" />';
			questionMargin = 'class="' + this.id + 'spanMarginImg"';
		}
	};*/

	if (this.unsolved && pStatus == 'F') { //pg2-pkf
		action = 'onClick=\"if (!opener) PlayerInterface.Execute(\'gotoPage\', ' + pGix + ');"';
		if (this.srcReviewVisible) {
			reviewImg = '<img src="' + this.resourcesURL + this.srcReview + '" />';
			questionMargin = 'class="' + this.id + 'spanMargin"';
		};
		questionMargin += ' style="text-decoration:underline; cursor:pointer;" ';
	};

	/*if (this.unsolved && score != maxScore){ //pg2-pkf -removed
		action = 'onClick=\"if (!opener) PlayerInterface.Execute(\'gotoPage\', '+pGix+');"';
		if (this.srcReviewVisible) {
			reviewImg = '<img src="' + this.resourcesURL + this.srcReview + '" />';
			questionMargin = 'class="' + this.id + 'spanMarginImg"';
		}
	};*/

	if (this.notAttemted && (pStatus == 'N' || pStatus == 'C' || pStatus == 'I')) { //pg2-pkf
		action = 'onClick=\"if (!opener) PlayerInterface.Execute(\'gotoPage\', ' + pGix + ');"';
		if (this.srcNotAttVisible) {
			reviewImg = '<img src="' + this.resourcesURL + this.srcNotAtt + '" />';
			questionMargin = 'class="' + this.id + 'spanMargin"';
		};
		questionMargin += ' style="text-decoration:underline; cursor:pointer;" ';
	};

	/*if (this.notAttemted && pStatus == 'N'){ //pg2-pkf -removed
		action = 'onClick=\"if (!opener) PlayerInterface.Execute(\'gotoPage\', '+pGix+');"';
		if (this.srcNotAttVisible) {
			reviewImg = '<img src="' + this.resourcesURL + this.srcNotAtt + '" />';
			questionMargin = 'class="' + this.id + 'spanMarginImg"';
		}
	};*/

	cell = row.insertCell(cellNumber++);

	if ((interactions.type == "matching" || interactions.type == "numeric") && (interactions.id.indexOf("DDBasket") > -1)) { //pg2-ddbasket & question
		cell.innerHTML = reviewImg + '<div '+questionMargin+' '+action+'>'+pageTitle+'</div>';
	} else {
		cell.innerHTML = reviewImg + '<div '+questionMargin+' '+action+'>'+interactions.question+'</div>';
	};

	if (this.answer) {
		cell = row.insertCell(cellNumber++);
		sResponse = unescape(interactions.studentResponseAsText);
		if (sResponse == "") sResponse = interactions.studentResponse;				
		cell.innerHTML = sResponse;
	};

	if (this.tryPoints) {
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = interactions.tryNumber;
		cell.className = 'center';	
	};

	if (this.points) {
		cell = row.insertCell(cellNumber++);
		score = (score != 0)?(score / interactionsCount).toFixed(3):0;
		score = new Number(score);
		maxScore = new Number(maxScore);
		cell.innerHTML = score+"/"+maxScore;
		cell.className = 'center';	
	};

	if (this.correct) {
		cell = row.insertCell(cellNumber++);
		if (interactions.result) {
			cell.innerHTML = '<img src="'+this.resourcesURL + this.srcOk+'" />';
		} else {
			cell.innerHTML = '<img src="'+this.resourcesURL + this.srcNotOk+'" />';
		};
		cell.className = 'center';	
	};
};

componentCourseReport.prototype.getInteractionsFromInformation = function(ueloPage, index, row)
{
	var pageTitle = ((ueloPage.versionTitle == "")?ueloPage.title:ueloPage.versionTitle);

	var cellNumber = 0;
	var cell = null;
	cell = row.insertCell(cellNumber++);
	cell.innerHTML = index;
	cell.className = 'center';

	cell = row.insertCell(cellNumber++);
	cell.innerHTML = '<span class="'+this.id+'spanMargin">'+pageTitle+'</span>';

	if (this.answer) {
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = '';
	};
	if (this.tryPoints) {
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = '';
	};
	if (this.points) {
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = '';
	};
	if (this.correct) {
		cell = row.insertCell(cellNumber++);
		if (this.showIconsVisibleNotVisible) {
			cell.innerHTML = ((ueloPage.status == 'N')?'<img src="'+this.resourcesURL + this.srcNotVisited+'" />':'<img src="'+this.resourcesURL + this.srcVisited+'" />');
		} else {
			cell.innerHTML = ((ueloPage.status == 'N')?this.pageNotVisited:this.pageVisited);
		};
		cell.className = 'center';
	};
};

componentCourseReport.prototype.getInteractionsFromPoll = function(interactions, page, index, row)
{
	var cellNumber = 0;
	var cell = null;
	cell = row.insertCell(cellNumber++);
	cell.innerHTML = index;
	cell.className = 'center';

	cell = row.insertCell(cellNumber++);
	cell.innerHTML = '<span class="'+this.id+'spanMargin">'+interactions.question+'</span>';

	if (this.answer) {
		cell = row.insertCell(cellNumber++);
		var sResponse = unescape(interactions.studentResponseAsText);
		if (sResponse == "") sResponse = unescape(interactions.studentResponse);
		if (sResponse.indexOf("||[%Open%]:") > -1) {
			sResponse = sResponse.replace("||[%Open%]:","/");
		};
		cell.innerHTML = sResponse;
	};

	if (this.tryPoints) {
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = '';
	};

	if (this.points) {
		cell = row.insertCell(cellNumber++);
		cell.innerHTML = '';
	};

	if (this.correct) {
		cell = row.insertCell(cellNumber++);
		if (this.showIconsVisibleNotVisible) {
			cell.innerHTML = ((page.status == 'N')?'<img src="'+this.resourcesURL + this.srcNotVisited+'" />':'<img src="'+this.resourcesURL + this.srcVisited+'" />');
		} else {
			cell.innerHTML = ((page.status == 'N')?this.pageNotVisited:this.pageVisited);
		};
		cell.className = 'center';		
	};
};

componentCourseReport.prototype.getChaptersFromStruct = function()
{
	var struct = getStruct();
	if (struct && this.chapterPages) {
		for (var i = 0; i < struct.m_list.length; i++) {
			if (struct.m_list[i]["parent"] == 1) {
				if (!this.chaptersArr[struct.m_list[i]["gix"]]) {
					this.chaptersArr[struct.m_list[i]["gix"]] = new Array();
					this.chaptersArr[struct.m_list[i]["gix"]][0] = struct.m_list[i]["title"];
					this.chaptersArr[struct.m_list[i]["gix"]][1] = struct.m_list[i]["index"];
				};
			};
		};
	};
};

componentCourseReport.prototype.getScoresFromUELO = function(UELO)
{
	var number = 0;
	var scores = 0;
	var maxScores = 0;
	var stPageInfoArr = this.startPageName.split(':');
	var endPageInfoArr = this.endPageName.split(':');

	var pStartGix = -1;
	var pEndGix = -1;		

	if (typeof(stPageInfoArr[1]) != 'undefined') {
		pStartGix = parseInt(stPageInfoArr[0]);
		var pStartName = stPageInfoArr[1];
	} else {
		var pStartName = stPageInfoArr[0];		
	};

	if (typeof(endPageInfoArr[1]) != 'undefined') {
		pEndGix = parseInt(endPageInfoArr[0]);
		var pEndName = endPageInfoArr[1];
	} else {
		var pEndName = endPageInfoArr[0];		
	};	
	var foundChosenPage = false;
	var isStronglyInfo = false;
	var uScore = 1;
	
	var player = getPlayer(); //pg2-pkf_qr -in raport there is displayed current structure, but if course has mixed structure but wasn't solved in this session, repaint previous structure
	if (typeof(struct) == 'undefined') var struct = getStruct();
	var isCourseMixedAndNotSolvetDuringThisSession = (player && struct && struct.isCourseMixed && !player.checkExamWasSolved() && UELO.previousMixedStructure != '' && !UELO.pageInAssessmentCheckAnswerInSession);

	for (var i = 0; i < UELO.pages.length; i++) {
		p = UELO.pages[i];
		isStronglyInfo = false;
	    //if (p.visible == 0 && !config.sendDataFromHiddenPages) continue; //pg2-lean_om - hidden exercise pages //pg2-pkf_qr -removed, handled below
		if (p.isAssessment == 0) isStronglyInfo = true;

		if (pStartName == '' || (p.title == pStartName && pStartGix == -1) || p.globalIndex == pStartGix) { //pg2-knf_qr_mix -moved here, otherwise page could be not found
			foundChosenPage = true;
		};
		
		if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) { //pg2-pkf_qr
			if (!p.previouslyVisible) {
				if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) break; else continue;
			};
		} else { //pg2-pkf_qr + //pg2-lean_om - hidden exercise pages
			if (p.visible == 0) {
				if (!config.sendDataFromHiddenPages) { //pg2-lean_om - hidden exercise pages
					if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) {
						break;
					} else {
						continue;
					};
				};
			};
		};
		
		//pg2-pkf_qr -moved here, otherwise in case of drawing pages it might happen that 'continue' would be invoked and pages of raport-raport2 will be displayed
		if ((p.visible == 0 && !config.sendDataFromHiddenPages) && //pg2-lean_om -hidden exercise pages
			!isCourseMixedAndNotSolvetDuringThisSession) continue; //pg2-qr -modyfied, some previously visible, but now invisible page could be included into score calculation -from previous session
		
		if (p.pageType == 'Exercise' && foundChosenPage && !isStronglyInfo) {
			var interactionsCount = p.interactions.length;
			if (interactionsCount > 0) {
				//pg2-pkf_qr -removed, replaced with the block below
				// uScore = 1;
				// for (var j=0; j<interactionsCount; j++) {
					// if (p.interactions[j].result.toString() != "true") {
						// uScore = 0;
						// break;
					// }
				// };
				
				//pg2-pkf_qr -new
				uScore = 0;
				if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) {
					uScore += (p.previousStatus == 'P'?1:0);
				} else
				if (p.status == "P") uScore = 1;
				//...
				
				scores += uScore;
				maxScores++;
			};
		};
		if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) {
			break;
		};				
	};		
	this.studentScore = scores;
	this.maxScore = maxScores;
};

componentCourseReport.prototype.getScorePercString = function()
{
	return this.getScorePerc() +"%";
};

componentCourseReport.prototype.getScorePerc = function()
{
	var percent = ( (this.studentScore*100) / this.maxScore ).toFixed(2);
	return ((percent != "NaN") ? percent : 0 );	
};

componentCourseReport.prototype.getGainedPoints = function()
{
	return ((this.studentScore) ? this.studentScore : 0 )+ " (" + this.getScorePercString() +")";	
};

componentCourseReport.prototype.getPassLevel = function(UELO)
{
	var passPerc = parseInt(UELO.passThreshold);
	var passPoints = Math.ceil(this.maxScore * UELO.passThreshold / 100);
	return passPoints+"/"+((this.maxScore) ? this.maxScore : 0) + " " + this.exercisePointCaption.toLowerCase() + " (" + UELO.passThreshold +"%)";
};

componentCourseReport.prototype.getScore = function()
{
	return ((this.studentScore) ? this.studentScore : 0 )+"/"+((this.maxScore) ? this.maxScore : 0)
};

componentCourseReport.prototype.getCourseStatus = function(UELO)
{
	var percent = ( (this.studentScore*100) / this.maxScore ).toFixed(2);
	return (percent >= UELO.passThreshold) ? this.coursePassInfo : this.courseFailedInfo;
};

componentCourseReport.prototype.getSesionTime = function(UELO)
{
	var sessionTime = UELO.sessionTime;
	return sessionTime;
};

componentCourseReport.prototype.setBulletsIcon = function()
{
	var bulletsArr = document.getElementsByName(this.id + "bullet");
	
	for (var i = 0; i < bulletsArr.length; i++) {
		bulletsArr[i].src = this.resourcesURL + this.srcBullet;
	};
};

componentCourseReport.prototype.setLegendIcons = function()
{
	var pass = document.getElementById(this.id + "_pass");
	var fail = document.getElementById(this.id + "_fail");
	var notAtt = document.getElementById(this.id + "_notAtt");
	var review = document.getElementById(this.id + "_review");
	var visited = document.getElementById(this.id + "_visited");
	var notVisited = document.getElementById(this.id + "_notVisited");

	pass.src = this.resourcesURL + this.srcOk;
	fail.src = this.resourcesURL + this.srcNotOk;
	notAtt.src = this.resourcesURL + this.srcNotAtt;
	review.src = this.resourcesURL + this.srcReview;
	visited.src = this.resourcesURL + this.srcVisited;
	notVisited.src = this.resourcesURL + this.srcNotVisited;
};

componentCourseReport.prototype.getCourseID = function(UELO)
{
	var courseName = UELO.courseName;
	return courseName;
};

componentCourseReport.prototype.getCourseDesc = function(UELO)
{
	var courseDescription = UELO.courseDescription;
	return courseDescription;
};

componentCourseReport.prototype.getUserName = function(UELO)
{
	var username = UELO.username;
	return username ;
};

componentCourseReport.prototype.getStartTime = function(UELO)
{
	var startTObj = UELO.beginTime;
	var startDate = startTObj.toLocaleString(); 

	return startDate;
};

componentCourseReport.prototype.getEndTime = function(UELO)
{
	var endTObj = UELO.endTime;
	var endDate = endTObj.toLocaleString();
	return endDate;
};

componentCourseReport.prototype.getReport = function(obj)
{
	var btnMail = document.getElementById(this.id + "_buttonMail");
	var btnPrint = document.getElementById(this.id + "_buttonPrint");
	if (btnMail) btnMail.style.display = 'none';
	if (btnPrint) btnPrint.style.display = 'none';

	var obj = document.getElementById(this.id + "interactionsTable");
	var tableH = obj.offsetHeight;

	var interactionsTableDIV = document.getElementById(this.id + "interactionsTableDIV");
	var interactionsTableDIVLastH = interactionsTableDIV.offsetHeight;
	interactionsTableDIV.style.height = tableH+5;
//	interactionsTableDIV.style.overflowY = 'hidden';

	var obj = document.getElementById(this.id + "courseInfo");
	var tableH = obj.offsetHeight;

	var courseInfoDIV = document.getElementById(this.id + "courseInfoDIV");
	var courseInfoDIVLastH = courseInfoDIV.offsetHeight;
	courseInfoDIV.style.height = tableH;
	courseInfoDIV.style.overflowY = 'hidden';

	var legend = document.getElementById(this.id + "legend");
	var legendLastTop = legend.offsetHeight;
	legend.style.height = tableH+17;	

	var interactionsDIV = document.getElementById(this.id + "interactionsDIV");
	var interH = interactionsDIV.offsetHeight;
	var interactionsDIVLastTop = interactionsDIV.style.top;
	interactionsDIV.style.top = tableH+20;

	var courseScore = document.getElementById(this.id + "_courseScore");
	var lastScoreTop = courseScore.style.top;
	courseScore.style.top = tableH+interH+20;

	var report = this.obj.innerHTML;
	if (this.mailBtnVisible){
		if (btnMail) btnMail.style.display = 'inline';
	}
	if (this.printBtnVisible){
		if (btnPrint) btnPrint.style.display = 'inline';	
	};

	courseInfoDIV.style.height = courseInfoDIVLastH;
	courseInfoDIV.style.clip = 'rect(0px '+courseInfoDIV.offsetWidth+'px '+courseInfoDIVLastH+'px 0px)';
	courseInfoDIV.style.overflowY = 'scroll';	
	interactionsDIV.style.top = interactionsDIVLastTop;
	courseScore.style.top = lastScoreTop;
	legend.style.height = legendLastTop;
	interactionsTableDIV.style.height = interactionsTableDIVLastH;
	interactionsTableDIV.style.overflowY = 'scroll';	

	return report;
};

componentCourseReport.prototype.makePrintWindow = function(obj)
{
	if (PageInterface.GetValue("state") != psView) {
		var report = this.getReport();
		
		var win = window.open("","_blank","toolbar=no, location=no, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, copyhistory=no, width="+eval(this.w+20)+", height=600");
		
		var inner = '<html><head><title>' + project.pageName + '</title>';
		inner += '<link href="'+document.location+'" type="text/css" rel="stylesheet">';	
		inner += '</head><body onload="self.print();">';
		inner += report;
		inner += '</body></html>';
		inner += '</body></html>';

		win.document.write(inner);
		win.document.close();
		win.focus();	
	} else {
		showMessage("Print works fine only after course export");
	};
};

componentCourseReport.prototype.clearHTMLTags = function(inHTML)
{
	var regEx = '';
	var outText = '';
	regEx = /<[^>]*>/g;
	outText = inHTML.replace(regEx, "");
	regEx = /&nbsp;/g;	
	outText = outText.replace(regEx, "");
	return outText;
};

componentCourseReport.prototype.getTextsFromTable = function(tableID)
{
	var result = '';
	var sep = '';
	var row = '';
	var obj = document.getElementById(tableID);

	if (obj) {
		for (var i=0; i<obj.rows.length;i++) {
			sep = '';
			row = '';
			for (var j=0; j<obj.rows[i].cells.length;j++) {
				if (row != '') sep = ' : ';
				row += sep + this.clearHTMLTags(obj.rows[i].cells[j].innerHTML);
			};
			result += row + '%0D%0A';
		};
	};
	return result;
};

componentCourseReport.prototype.sendReportInMail = function(obj)
{
	var report = '';
	report += this.getTextsFromTable(this.id+'courseInfo');
	report += '----------------------------------------%0D%0A';
	report += this.getTextsFromTable(this.id+'interactionsColls');
	report += this.getTextsFromTable(this.id+'interactionsTable');
	report += this.getTextsFromTable(this.id+'summary');

	if (top && top.isWBTServer) {
		mailWindow = this.openWin("/4ses/servlet/MainServlet?method=lms.SendMail&email="+this.eMailAdress+"&title=" + escape("E-mail from "+this.replaceCharsInMail(page.getUELO().courseName)) + "&mailBody=" + unescape(this.replaceCharsInMail(report)),5,5,100,100,"resizable=yes","mailWindow");
	} else {
		window.location="mailto:" + this.eMailAdress + "?subject=" + escape("E-mail from "+this.replaceCharsInMail(page.getUELO().courseName)) + "&body=" + this.replaceCharsInMail(report),5,5,100,100,"resizable=yes","mailWindow";
	};
};

componentCourseReport.prototype.openWin = function(urlname,xpos,ypos,w,h,windowParam,windowName) 
{
	urlname = urlname.replace(/%0D%0A/gi, '\n');
	urlname = urlname.replace(/%20/gi, '&nbsp;');
	urlname = urlname.replace(/%/gi, 'perc');

	var newWindowPointer=null;
	x = xpos;
	y = ypos;

	if (!xpos) x = 100;
	if (!ypos) y = 100;
	if (!w) w = 400;
	if (!h) h = 300;

	if (!windowParam) windowParam = "resizable=yes";
	if (!windowName) windowName = "subWindow";

	if (newWindowPointer != null && newWindowPointer.closed == false) newWindowPointer.close();

	newWindowPointer=window.open(urlname,windowName,"width="+w+",height="+h+",screenX="+x+",screenY="+y+","+windowParam+"");
	newWindowPointer.moveTo(x,y);
	newWindowPointer.focus();
	return (newWindowPointer);
};
