﻿module BasicModule {
    export class BasicState extends Phaser.State {
        game: Phaser.Game;
        backgroundImage: Phaser.Sprite;
        foregroundGroup: Phaser.Group;

        constructor() {
            super();
        }

        create() {
            this.foregroundGroup = this.game.add.group();
            this.foregroundGroup.z = 5;

            this.backgroundImage = this.add.sprite(0, 0, "background");
            //this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            var book = this.add.sprite(0, 0, "book");
            this.foregroundGroup.add(book);

        }

        preload() {
            this.load.image("background", "Images/GUI/background.jpg");
            this.load.image("book", "Images/GUI/book.png");
        }
    }
}