﻿declare var DIFFICULTY;
module ChooseDifficulty {
    export class ChooseDifficultyState extends BasicModule.BasicState {
        game: Phaser.Game;

        constructor() {
            super();
        }

        create() {
            super.create();

            var lvls = ["very_easy", "easy", "medium", "hard"];
            var positions = [{ x: 760, y: 45 }, { x: 280, y: 74 }, { x: 590, y: 380 }, { x: 154, y: 506 }];
            var lvlsLen = lvls.length;
            for (var i = 0; i < lvlsLen; i++) {
                var temp = this.game.add.button(positions[i].x, positions[i].y, lvls[i], this.setDifficulty, this, 1, 0, 2, 0);
                temp.scale.x = 0.85;
                temp.scale.y = 0.85;
            }

            var gd = this.game.add.image(1200, this.game.height * 0.45, "guide2");
            gd.scale.x = 0.85;
            gd.scale.y = 0.85;

            this.game.world.sort('z', Phaser.Group.SORT_ASCENDING);
        }

        preload() {
            this.load.spritesheet("very_easy", "Images/GUI/very_easy.png", 350, 350, 3, 0, 0);
            this.load.spritesheet("easy", "Images/GUI/easy.png", 420, 420, 3, 0, 0);
            this.load.spritesheet("medium", "Images/GUI/medium.png", 410, 410, 3, 0, 0);
            this.load.spritesheet("hard", "Images/GUI/hard.png", 349, 349, 3, 0, 0);

            /// loading help
            this.load.image("guide2", "Images/GUI/guide2.png");
            this.game.load.image("cloud", "Images/GUI/instr_bg.png");
        }

        setDifficulty(sprite) {
            DIFFICULTY = sprite.key;
            this.game.state.start("MainGameState", true, false);
        }
    }
} 