﻿declare var audio;
module DragGame {
    export class DragGameState extends BasicModule.BasicState {
        game: Phaser.Game;
        cards: any;
        dragElements: any;
        containers: any;
        next: Phaser.Button;
        replay: Phaser.Button;
        help: Phaser.Button;
        guide: Phaser.Sprite;
        cloud: Phaser.Sprite;
        text: Phaser.Text;
        HelpGroup: Phaser.Group;
        CorrectAnswersCounter: any;

        constructor() {
            super();
        }
        destructor() {
            this.cards=null;
            this.dragElements = null;
            this.containers = null;
            this.next = null;
            this.replay = null;
            this.help = null;
            this.guide = null;
            this.cloud = null;
            this.text = null;          
            this.HelpGroup.removeAll();
            this.HelpGroup = null;
            this.CorrectAnswersCounter = null;
        }
        preload() {
            super.preload();
            this.load.image("card_0", "Images/Games/2/card_0.png");
            this.load.image("card_1", "Images/Games/2/card_1.png");
            this.load.image("card_2", "Images/Games/2/card_2.png");
            this.load.image("card_3", "Images/Games/2/card_3.png");
            this.load.image("C_0_0", "Images/Games/2/C_0_0.png");
            this.load.image("C_1_1", "Images/Games/2/C_1_1.png");
            this.load.image("C_2_2", "Images/Games/2/C_2_2.png");
            this.load.image("C_3_3", "Images/Games/2/C_3_3.png");
            this.load.image("C_4_4", "Images/Games/2/C_4_4.png");
            this.load.image("C_5_5", "Images/Games/2/C_5_5.png");
            this.load.image("C_6_6", "Images/Games/2/C_6_6.png");
            this.load.image("O_0_0", "Images/Games/2/O_0_0.png");
            this.load.image("O_1_1", "Images/Games/2/O_1_1.png");
            this.load.image("O_2_2", "Images/Games/2/O_2_2.png");
            this.load.image("O_3_3", "Images/Games/2/O_3_3.png");
            this.load.image("O_4_4", "Images/Games/2/O_4_4.png");
            this.load.image("O_5_5", "Images/Games/2/O_5_5.png");
            this.load.image("O_6_6", "Images/Games/2/O_6_6.png");
            this.load.image("guide", "Images/GUI/guide.png");
            this.load.image("dymek", "Images/GUI/dymek.png");        
            this.load.spritesheet("replay", "Images/GUI/replay.png",108,111,2);
            this.load.spritesheet("help", "Images/GUI/help.png", 130, 134, 2);
            this.load.spritesheet("next", "Images/GUI/next.png", 120, 120, 2);
        }
        create() {
            super.create();
            this.LoadCards();
            this.LoadContainers();
            this.loadImages();
            this.LoadGuide();
        }
        LoadGuide() {
            this.CorrectAnswersCounter = 0;
            this.next = this.game.add.button(this.game.width, this.game.height * 0.66, "next", this.Finish, this, 1, 0, 2, 1);
            this.next.x = this.game.width - this.next.width - 20;
            this.next.y = this.game.height - this.next.height - 20;
            this.help = this.game.add.button(this.game.width, this.game.height * 0.66, "help", this.HelpVisibility, this, 1, 0, 2, 1);
            this.help.x = this.game.width - this.help.width - 20;
            this.help.y = 20;

            this.replay = this.game.add.button(this.game.width, this.game.height * 0.66, "replay", this.Replay, this, 1, 0, 2, 1);
            this.replay.x = 20;
            this.replay.y = 20;
            
            var back;           
            var bmd = this.game.add.bitmapData(1920, 1080); 
                   
            bmd.ctx.rect(0, 0, 1920, 1080);
            bmd.ctx.fillStyle = '#000000';
            bmd.ctx.fill();            
            back = this.game.add.sprite(this.game.world.centerX, this.game.world.centerY, bmd);
            back.anchor.setTo(0.5, 0.5);
            back.alpha = 0.5;
            back.inputEnabled = true;
            back.events.onInputUp.add(this.HelpVisibility, this);

           
            this.next.visible = false;
            this.guide = this.game.add.sprite(this.game.width, this.game.height, "guide");
            this.guide.x = this.game.width - this.guide.width;
            this.guide.y = this.game.height - this.guide.height;
            this.cloud = this.game.add.sprite(50, 0, "dymek");

            this.cloud.scale.x = 0.8;
            this.cloud.scale.y = 0.8;
            this.cloud.y = 20 - this.cloud.height;

            this.text = this.game.add.text(0, this.cloud.height / 2, "Do błędnych wizytówek dodaj elementy których brakuje!", { font: "30px Arial", fill: "#000000" });
            this.text.wordWrapWidth = this.cloud.width;
            this.text.wordWrap = true;
            this.text.x = this.cloud.width / 2 - this.text.width / 2 + 50;
            this.cloud.addChild(this.text);
            this.guide.addChild(this.cloud);
            this.guide.inputEnabled = true;
            this.guide.events.onInputUp.add(this.HelpVisibility, this);

            this.HelpGroup = this.game.add.group(this.game, "gd", true, false, 0);
            this.HelpGroup.add(back, false);
            this.HelpGroup.add(this.guide, false);      
            this.HelpGroup.visible = true;
            this.ChangeDragElementsInput();
            audio = new Audio("Sounds/OB_g_I_11_2.mp3");
            audio.play();
            var Timer = this.game.time.events.add(Phaser.Timer.SECOND * 15, this.HideHelpVisibility, this);
           
            
        }
        AudioStop() {
            try {
                audio.pause();
                audio.currentTime = 0;
            }
            catch (e) {
            }

        }
        Replay() {
            this.destructor();
            this.game.state.restart(true, true);
         

        }
        HideHelpVisibility() {           
            if (this.HelpGroup.visible) {
                this.HelpGroup.visible = false;
                this.AudioStop();
                this.ChangeDragElementsInput();
            }
        }
        HelpVisibility() {
            if (!this.HelpGroup.visible) {
                this.AudioStop();
                audio = new Audio("Sounds/OB_g_I_11_2.mp3");
                audio.play();
            }
            else {
                this.AudioStop();
            }
            this.HelpGroup.visible = !this.HelpGroup.visible;    
            this.ChangeDragElementsInput();
        }
      
        ChangeDragElementsInput() {
            for (var i = 0; i < this.dragElements.length; i++)
                this.dragElements[i].el.inputEnabled = !this.dragElements[i].el.inputEnabled; 

        }
      
        Finish() {
            this.destructor();
            this.game.state.start("TitleScreenState", true, false);
        }
        LoadCards() {
            this.cards = [];
            var temp = 0;
            for (var i = 0; i < 4; i++) {
                var tmp = this.game.add.image(0, 0, "card_" + i);
                if (i < 2) {
                    tmp.x = this.game.width / 2 - (tmp.width) + i * tmp.width + i * 20;
                    tmp.y = this.game.height / 3 - tmp.height + 20;

                }
                else {
                    tmp.x = this.game.width / 2 - (tmp.width) + temp * tmp.width + temp * 20;
                    tmp.y = this.game.height / 3 + 30;
                    temp++;

                }
                this.cards.push(tmp);
            }
        }
        LoadContainers() {
            this.containers = [];
            var c_1_1 = this.game.add.image(0, 0, "C_1_1");
            c_1_1.x = 10;
            c_1_1.y = this.cards[0].height - c_1_1.height - 20;

            var c_2_2 = this.game.add.image(0, 0, "C_2_2");
            c_2_2.x = this.cards[0].width - c_2_2.width - 15;
            c_2_2.y = this.cards[0].height - c_1_1.height - 20;

            this.cards[0].addChild(c_1_1);
            this.cards[0].addChild(c_2_2);
            var c_0_0 = this.game.add.image(0, 0, "C_0_0");
            c_0_0.x = this.cards[1].width / 2 - c_0_0.width / 2;
            c_0_0.y = this.cards[1].height / 2 - c_0_0.height / 2;
            this.cards[1].addChild(c_0_0);

            var c_3_3 = this.game.add.image(0, 0, "C_3_3");
            c_3_3.x = 15;
            c_3_3.y = 15;
            this.cards[2].addChild(c_3_3);
            var c_4_4 = this.game.add.image(0, 0, "C_4_4");
            c_4_4.x = this.cards[3].width - c_4_4.width - 20;
            c_4_4.y = 15;
            var c_5_5 = this.game.add.image(0, 0, "C_5_5");
            c_5_5.x = this.cards[3].width / 2 - c_5_5.width / 2 + 15;
            c_5_5.y = this.cards[3].height / 2 - c_5_5.height / 2 - 30;
            var c_6_6 = this.game.add.image(0, 0, "C_6_6");
            c_6_6.x = this.cards[3].width / 2 - c_6_6.width / 2;
            c_6_6.y = this.cards[3].height / 2 - c_6_6.height / 2 + 65;
            this.cards[3].addChild(c_4_4);
            this.cards[3].addChild(c_5_5);
            this.cards[3].addChild(c_6_6);
            this.containers.push(c_0_0);
            this.containers.push(c_1_1);
            this.containers.push(c_2_2);
            this.containers.push(c_3_3);
            this.containers.push(c_4_4);
            this.containers.push(c_5_5);
            this.containers.push(c_6_6);

        }
        loadImages() {
            this.dragElements = [];
            for (var i = 0; i < 7; i++) {
                var tmp = this.game.add.sprite(this.game.width / 7, this.game.height, "O_" + i + "_" + i);          
                if (i > 0) {
                    tmp.x = this.dragElements[i - 1].el.x + this.dragElements[i - 1].el.width + 10;
                }
                else {
                    tmp.x = this.game.width / 15 + i * tmp.width;
                }              
                tmp.inputEnabled = true;
                tmp.input.enableDrag();
                tmp.events.onInputUp.add(this.InputUP, this);

                tmp.y = this.game.height - 120;
                tmp.z = 6;
                this.dragElements.push({ "el": tmp, "startPos": { x: tmp.x, y: tmp.y }, "container":this.containers[i] });
            }
        }

        CheckWhichElement(sprite) {
            for (var i = 0; i < this.dragElements.length; i++) {
                if (this.dragElements[i].el === sprite)
                    return this.dragElements[i].container;
            }
            return;
        }
        InputUP(sprite, pointer) {
            var container = this.CheckWhichElement(sprite);
               if (!sprite.overlap(container)) {
                   for (var i = 0; i < this.dragElements.length; i++) {
                       if (this.dragElements[i].el === sprite) {
                           sprite.x = this.dragElements[i].startPos.x;
                           sprite.y = this.dragElements[i].startPos.y;
                           this.PlayWrong();
                           break;
                       }
                   }                  
               }
               else {
                   this.CorrectAnswersCounter++;
                   sprite.x = container.world.x;
                   sprite.y = container.world.y;
                   sprite.inputEnabled = false;
                   this.PlayCorrect();
                   if (this.CorrectAnswersCounter == 7) {

                       this.text.setText("Gratulacje!");
                       this.text.x = this.cloud.width / 2 - this.text.width / 2 + 50;
                       this.HelpGroup.visible = true;
                       this.PlayCongratulations();
                       var Timer2 = this.game.time.events.add(6000, this.Finish, this);
                   }         
               }
        }
        PlayCongratulations() {
            this.AudioStop();
            audio = new Audio("Sounds/gratulacje.mp3");
            audio.play();
        }
        PlayCorrect() {
            this.AudioStop();
            audio = new Audio("Sounds/click.mp3");
            audio.play();
        }
        PlayWrong() {
            this.AudioStop();
            audio = new Audio("Sounds/err.mp3");
            audio.play();
        }
    }
}