﻿

function generatePositions(startPos, elementWidth, margin, amount) {
    var ret = [];

    for (var i = 0; i < amount; i++) {
        var t = startPos + i * (elementWidth + margin);
        ret.push(t);
    }

    return ret;
}

function shuffleArray(arr) {
    var t = arr.length;
    var temp = generateUniqueRandoms(0, t, t);
    var ret = [];
    for (var i = 0; i < t; i++) {
        ret.push(arr[temp[i]]);
    }
    return ret;
}

function generateGridPositions(cols, rows, width, height, marginX, marginY, startPosX, startPosY, upDown) {
    var xPos = generatePositions(startPosX, width, marginX, cols);
    var yPos = generatePositions(startPosY, height, marginY, rows);

    var ret = [];
    var xLen = xPos.length;
    var yLen = yPos.length;

    if (upDown) {
        for (var i = 0; i < xLen; i++) {
            for (var j = 0; j < yLen; j++) {
                var t = { x: xPos[i], y: yPos[j] };
                ret.push(t);
            }
        }
    } else {
        for (var i = 0; i < yLen; i++) {
            for (var j = 0; j < xLen; j++) {
                var t = { x: xPos[j], y: yPos[i] };
                ret.push(t);
            }
        }
    }

    return ret;
}

function generateUniqueRandoms(min, max, amount) {
    var ret = [];
    if ((amount > max - min || max < min) && min !== 0) {
        return -1;
    }

    for (var i = 0; i < amount; i++) {
        var maxIterations = 0;
        var s = min + Math.floor(Math.random() * max);
        while ($.inArray(s, ret) !== -1 && maxIterations < 500) {
            s = min + Math.floor(Math.random() * max);
            maxIterations++;
        }
        ret.push(s);
    }

    return ret;
}