﻿declare var shuffleArray;
declare var generateUniqueRandoms;
declare var generateGridPositions;
declare var generatePositions;

module MainGameState {
    var winner = null;
    var match = null;
    var goal = null;
    var grp = null;
    var task = null;

    export class MainGame extends BasicModule.BasicState {
        game: Phaser.Game;
        expos: any;
        exposLen: any;
        items: any;
        itemsLen: any;
        itms: any;

        ///groups
        expoGroup: Phaser.Group;
        itemGroup: Phaser.Group;
        frontGroup: Phaser.Group;
        helpGroup: Phaser.Group;

        constructor() {
            super();
        }

        create() {
            super.create();

            this.expoGroup = this.game.add.group();
            this.expoGroup.z = 6;
            this.itemGroup = this.game.add.group();
            this.itemGroup.z = 7;
            this.frontGroup = this.game.add.group();
            this.frontGroup.z = 8;
            this.helpGroup = this.game.add.group();
            this.helpGroup.z = 9;
            this.helpGroup.visible = false;

            /// create items
            this.items = [];
            var positions = generateGridPositions(5, 2, 200, 200, 50, 50, 400, 100, true);
            var len = this.itms.length;
            for (var i = 0; i < len; i++) {
                var l = generateUniqueRandoms(1, this.itms[i], 2);
                for (var j = 0; j < l.length; j++) {
                    var tm = this.add.image(0, 0, i + "_" + l[j]);
                    tm.inputEnabled = true;
                    tm.input.enableDrag();
                    tm.events.onDragStop.add(this.dragStop, this);
                    tm.events.onDragStart.add(this.dragStart, this);
                    this.itemGroup.add(tm);
                    if (i === 0) {
                        this.items.push({ drag: tm, used: true, defPos: {x: 0, y: 0} });
                    } else {
                        this.items.push({ drag: tm, used: false, defPos: { x: 0, y: 0 } });
                    }
                }
            }
            this.itemsLen = this.items.length;
            this.items = shuffleArray(this.items);
            for (var i = 0; i < this.itemsLen; i++) {
                this.items[i].drag.x = positions[i].x;
                this.items[i].drag.y = positions[i].y;
                this.items[i].defPos = { x: positions[i].x, y: positions[i].y};
                this.items[i].drag.scale.x = 0.8;
                this.items[i].drag.scale.y = 0.8;
            }

            /// create expos
            this.expos = [];
            var pos = generatePositions(250, 300, 100, 4);
            for (var i = 0; i < 4; i++) {
                var t = this.add.image(pos[i], 750, "t_" + (i + 1));
                this.expoGroup.add(t);
                this.expos.push(t);
            }
            this.exposLen = this.expos.length;

            this.game.add.button(this.game.width - 158, 50, "help", this.help, this, 0, 0, 1, 0);
            this.game.add.button(170, 50, "retry", this.retry, this, 0, 0, 1, 0);

            /// help
            var cloud = this.game.add.image(this.game.width * 0.6, 175, "cloud");
            var guide = this.game.add.image(this.game.width * 0.7, this.game.height - 462, "help_guide");
            guide.scale.x = 0.8;
            guide.scale.y = 0.8;
            task = this.game.add.text(this.game.width * 0.62, 325, "Do poszczególnych targów tematycznych\ndopasuj właściwe produkty.", "");
            this.helpGroup.add(cloud);
            this.helpGroup.add(guide);
            this.helpGroup.add(task);
            grp = this.helpGroup;
            this.game.world.sort('z', Phaser.Group.SORT_ASCENDING);

            this.help();
            $(goal).bind("ended", function () {
                grp.visible = false;
            });
        }

        preload() {
            super.preload();
            var expos = 4;
            for (var i = 0; i < expos; i++) {
                this.load.image("t_" + (i + 1), "Graphics/game/t_" + (i + 1) + ".png");
            }

            this.itms = [10, 5, 10, 10, 10];
            for (var i = 0; i < this.itms.length; i++) {
                for (var j = 1; j <= this.itms[i]; j++) {
                    this.load.image(i + "_" + j, "Graphics/game/" + i + "_" + j + ".png");
                }
            }

            ///loading buttons
            this.game.load.spritesheet("retry", "Graphics/gui/replay.png", 108, 111, 2, 0, 0);
            this.game.load.spritesheet("help", "Graphics/gui/help.png", 130, 133, 2, 0, 0);

            /// loading help
            this.game.load.image("help_guide", "Graphics/gui/guide.png");
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");

            goal = new Audio("./Sounds/objective.mp3");
            match = new Audio("./Sounds/win.mp3");
            winner = new Audio("./Sounds/applause.mp3");
        }

        dragStop(el) {
            this.itemGroup.add(el);
            var k1 = parseInt(el.key.split("_")[0]);
            var elm = null;

            for (var i = 0; i < this.itemsLen; i++) {
                if (this.items[i].drag === el) {
                    elm = this.items[i];
                }
            }

            if (k1 === 0) {
                el.x = elm.defPos.x;
                el.y = elm.defPos.y;
                return;
            }
            var collides = -1;
            for (var i = 0; i < this.exposLen; i++) {
                if (this.checkOverlap(el, this.expos[i])) {
                    collides = i;
                    break;
                }
            } 
            
            if (collides === -1) {
                el.x = elm.defPos.x;
                el.y = elm.defPos.y;
                return;
            }
            var k2 = parseInt(this.expos[i].key.split("_")[1]);
            if (k1 === k2) {
                el.x = this.expos[i].x;
                el.y = this.expos[i].y;
                el.visible = false;
                try {
                    match.pause();
                    match.currentTime = 0;
                } catch (ev) { }
                match.play();
            } else {
                el.x = elm.defPos.x;
                el.y = elm.defPos.y;
                return;
            }
            
            if (this.checkWin()) {
                try {
                    match.pause();
                    match.currentTime = 0;
                } catch (ev) { }
                winner.play();
                task.text = "                               Gratulacje!";
                task.
                grp.visible = true;
            }

        }

        dragStart(el) {
            this.frontGroup.add(el);
        }

        retry() {
            try {
                goal.pause();
                goal.currentTime = 0;
            } catch (e) { }
            try {
                winner.pause();
                winner.currentTime = 0;
            } catch (e) { }
            try {
                match.pause();
                match.currentTime = 0;
            } catch (e) { }

            this.game.state.restart(true, false);
        }

        help() {
            if (!goal.paused) {
                try {
                    goal.pause();
                    goal.currentTime = 0;
                } catch (e) { }
                this.helpGroup.visible = false;
            } else {
                this.helpGroup.visible = true;
                goal.play();
            }
        }

        checkWin() {
            for (var i = 0; i < this.itemsLen; i++) {
                var id = parseInt(this.items[i].drag.key.split("_"));
                if (id !== 0 && this.items[i].drag.visible) {
                    return false;
                }
            }

            return true;
        }

        checkOverlap(a, b) {
            var bA = a.getBounds();
            var bB = b.getBounds();
            return Phaser.Rectangle.intersects(bA, bB);
        }

    }
} 