﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentPageTitle = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.font = {};
	this.font.family = 'Arial';
	this.font.size = 2;
	this.font.color = "#000000";
	this.font.bold = false;
	this.font.italic = false;
	this.font.underline = false;
};

componentPageTitle.prototype = new __componentText();
componentPageTitle.prototype.type = "componentPageTitle";

componentPageTitle.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
    this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [this.leftTop, this.centerTop, this.rightTop];
	this.getPreloadImagesArr();
};

componentPageTitle.prototype.componentPageTitleBaseOnCreate = componentPageTitle.prototype.onCreate;
componentPageTitle.prototype.onCreate = function(obj)
{
	this.setImageToObiekt();
	this.componentPageTitleBaseOnCreate();
};

componentPageTitle.prototype.onPaint = function(obj)
{
	this.setDivElements();
};

componentPageTitle.prototype.setImageToObiekt = function(obj)
{
	var leftImg = document.getElementById(this.id + "_leftImg");
	var centerImg = document.getElementById(this.id + "_centerImg");
	var rightImg = document.getElementById(this.id + "_rightImg");

	leftImg.src = this.resourcesURL + this.leftTop;
	centerImg.src = this.resourcesURL + this.centerTop;
	rightImg.src = this.resourcesURL + this.rightTop;
};

componentPageTitle.prototype.setDivElements = function(obj)
{
	var leftDiv = document.getElementById(this.id + "_leftDiv");
	var centerDiv = document.getElementById(this.id + "_centerDiv");
	var rightDiv = document.getElementById(this.id + "_rightDiv");
	var textWidth = this.contentObj.offsetWidth+40;
	leftDiv.style.left = 0;
	var leftH = getImageHeight(this.leftTop);
	var leftW = getImageWidth(this.leftTop);
	leftDiv.style.left = this.w/2-textWidth/2-leftW;
	leftDiv.style.top = 0;
	leftDiv.style.height = this.h;
	leftDiv.style.width = leftW;
	leftDiv.style.clip = 'rect(0px '+leftW+'px '+this.h+'px 0px)';
	var rightH = getImageHeight(this.rightTop);
	var rightW = getImageWidth(this.rightTop);
	rightDiv.style.left = this.w/2+textWidth/2;
	rightDiv.style.top = 0;
	rightDiv.style.height = this.h;
	rightDiv.style.width = leftW;
	rightDiv.style.clip = 'rect(0px '+leftW+'px '+this.h+'px 0px)';
	var centerH = getImageHeight(this.centerTop);
	var centerW = getImageWidth(this.centerTop);
	centerDiv.style.left = this.w/2-textWidth/2;
	centerDiv.style.top = 0;
	centerDiv.style.height = this.h;
	centerDiv.style.width = textWidth;
	centerDiv.style.clip = 'rect(0px '+textWidth+'px '+this.h+'px 0px)';
};
