﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

__componentImage = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	this.__img_relay = true;
	this.preloadImg = null;
	this.waitingTryCount = 0;
	this.paintLocked = false;
	this.infoText = "";
	this.srcCaseSensitive = "default";
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
};

__componentImage.prototype = new componentElement;
__componentImage.prototype.type = "__componentImage";

__componentImage.prototype.onCreate = function()
{
	switch (this.srcCaseSensitive) {
		case "default": break;
		case "uppercase":
			this.src = this.src.toUpperCase();
			break;
		case "lowercase": 
			this.src = this.src.toLowerCase();
			break;
	};

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};

	this.resourcesURL = unescape(this.resourcesURL);
	this.src = unescape(this.src);
};

__componentImage.prototype.onFree = function()
{
	this.preloadImg = null;
};

__componentImage.prototype.onPaint = function()
{
	if (this.paintLocked) return;
	if (this.execution) {
		if (this.src == "" || this.src == "empty") {
			this.setHTML('<table width="' + this.w + '" height="' + this.h + '" border="0"><tr><td valign="middle" align="center"><span style="font-family: verdana; font-size: 10px; background-color: #eeeeee">[' + this.infoText +']</span></td></tr></table>');
		} else {
			if (!this.setValue(this.resourcesURL + this.src)) {
				this.setImageSrc(this.resourcesURL + this.src);
			};
		};
	} else {
		var s = '';
		if (this.src == "" || this.src == "empty") {
			s += '<table width="' + this.w + '" height="' + this.h + '" border="0"><tr><td valign="middle" align="center"><span style="font-family: verdana; font-size: 10px; background-color: #eeeeee">[' + this.infoText +']</span></td></tr></table>';
		} else {
			s += '<img id="' + this.id + '_contentObj" src="' + this.resourcesURL + this.src + '" width="100%" height="100%" border="0" />';
		};
		this.setHTML(s);
	};
};

__componentImage.prototype.isReady = function()
{
	if (this.paintLocked || this.isLoaded) return true;

	if (this.preloadImg == null) {
		this.preloadImg = new Image();
		this.preloadImg.src = this.resourcesURL + this.src;
	};

    if (this.src == "" || this.src == "empty" || page.state == psDesigning || page.state == psPreview) {
		this.isLoaded = true;
    } else {
        if (typeof(this.preloadImg.complete) == "undefined" || typeof(this.preloadImg.readyState) == "undefined") {
			this.isLoaded = true;
        } else {
            if (this.preloadImg.complete) {
				this.isLoaded = true;
			} else {
				if (++this.waitingTryCount > 50 && this.preloadImg.readyState == "uninitialized") {
					this.isLoaded = true;
				} else {
					this.isLoaded = false;
				};
			};
        };
    };

	return this.isLoaded;
};

__componentImage.prototype.getValue = function()
{
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		return this.contentObj.src;
	}
	return null;
};

__componentImage.prototype.setValue = function(value)
{
	return this.setImageSrc(value);
};
