﻿declare var createInputElements;
declare var audio;
module MainGame {
    export class MainGameState extends BasicModule.BasicState {
        container: Phaser.Sprite;     
        KEYBOARD: EU.Keyboard;
        dragElements: any;
        game: Phaser.Game;
        next: Phaser.Button;
        replay: Phaser.Button;
        help: Phaser.Button;
        guide: Phaser.Sprite;
        cloud: Phaser.Sprite;
        text: Phaser.Text;
        HelpGroup: Phaser.Group;
        constructor() {
            super();
        }
        preload() {
            super.preload();
            this.load.image("frame", "Images/Games/frame.png");
            this.load.image("card", "Images/Games/card_0.png");
            this.load.image("C_0_0", "Images/Games/C_0_0.png");
            this.load.image("O_0_0", "Images/Games/O_0_0.png");
            this.load.image("O_1_1", "Images/Games/O_1_1.png");
            this.load.image("O_2_2", "Images/Games/O_2_2.png");
            this.load.image("O_3_3", "Images/Games/O_3_3.png");
            this.load.image("O_4_4", "Images/Games/O_4_4.png");
            this.load.image("O_5_5", "Images/Games/O_5_5.png");
            this.load.image("O_6_6", "Images/Games/O_6_6.png");
            this.load.image("O_7_7", "Images/Games/O_7_7.png");
            this.load.spritesheet("key", "Images/Games/key.png", 110, 110, 3, 0, 0);
            this.load.image("guide", "Images/GUI/guide.png");
            this.load.image("dymek", "Images/GUI/dymek.png");     
            this.load.spritesheet("replay", "Images/GUI/replay.png", 108, 111, 2);
            this.load.spritesheet("help", "Images/GUI/help.png", 130, 134, 2);
            this.load.spritesheet("next", "Images/GUI/next.png", 120, 120, 2);  
            this.load.spritesheet("gotowe", "Images/GUI/gotowe.png", 242, 79, 2);   
            this.load.spritesheet("InputName", "Images/Games/Name.png", 900, 160,1);
            this.load.spritesheet("InputAddress", "Images/Games/Address.png", 540, 190, 1);
        }
        
        LoadGUI() {
            this.next = this.game.add.button(this.game.width, this.game.height * 0.66, "next", this.Finish, this, 1, 0, 2, 1);
            this.next.x = this.game.width - this.next.width - 20;
            this.next.y = this.game.height - this.next.height - 20;
            this.help = this.game.add.button(this.game.width, this.game.height * 0.66, "help", this.HelpVisibility, this, 1, 0, 2, 1);
            this.help.x = this.game.width - this.help.width - 20;
            this.help.y = 20;

            this.replay = this.game.add.button(this.game.width, this.game.height * 0.66, "replay", this.Replay, this, 1, 0, 2, 1);
            this.replay.x = 20;
            this.replay.y = 20;

            var back;
            var bmd = this.game.add.bitmapData(1920, 1080);

            bmd.ctx.rect(0, 0, 1920, 1080);
            bmd.ctx.fillStyle = '#000000';
            bmd.ctx.fill();
            back = this.game.add.sprite(this.game.world.centerX, this.game.world.centerY, bmd);
            back.anchor.setTo(0.5, 0.5);
            back.alpha = 0.5;
            back.inputEnabled = true;
            back.events.onInputUp.add(this.HelpVisibility, this);


            this.next.visible = false;
            this.guide = this.game.add.sprite(this.game.width, this.game.height, "guide");
            this.guide.x = this.game.width - this.guide.width;
            this.guide.y = this.game.height - this.guide.height;
            this.cloud = this.game.add.sprite(0, 0, "dymek");

            this.cloud.scale.x = 0.8;
            this.cloud.scale.y = 0.8;
            this.cloud.y = 20 - this.cloud.height;

            this.text = this.game.add.text(0, this.cloud.height / 2, "Przygotuj swoją wizytówkę! Wpisz dane oraz wybierz grafikę reprezentującą wybrany zawód i umieść ją na wizytówce.", { font: "30px Arial", fill: "#000000" });
            this.text.wordWrapWidth = this.cloud.width;
            this.text.wordWrap = true;
            this.text.x = this.cloud.width / 2 - this.text.width / 2 + 50;
            this.text.y = this.cloud.height / 2 - this.text.height/2+ 30;
            this.cloud.addChild(this.text);
            this.guide.addChild(this.cloud);
            this.guide.inputEnabled = true;
            this.guide.events.onInputUp.add(this.HelpVisibility, this);

            this.HelpGroup = this.game.add.group(this.game, "gd", true, false, 0);
            this.HelpGroup.add(back, false);
            this.HelpGroup.add(this.guide, false);
            this.HelpGroup.visible = true;         
            audio = new Audio("Sounds/OB_g_I_6.mp3");
            audio.play();
            var Timer = this.game.time.events.add(Phaser.Timer.SECOND * 16, this.HideHelpVisibility, this);



        

        }
        AudioStop() {
            try {
                audio.pause();
                audio.currentTime = 0;
            }
            catch (e) {
            }

        }
        Replay() {    
            this.game.state.restart(true, true);


        }
        Finish() { }
        HideHelpVisibility() {
            if (this.HelpGroup.visible) {
                this.HelpGroup.visible = false;
                this.AudioStop();
              
            }
        }
        HelpVisibility() {
            if (!this.HelpGroup.visible) {
                this.AudioStop();
                audio = new Audio("Sounds/OB_g_I_6.mp3");
                audio.play();
            }
            else {
                this.AudioStop();
            }
            this.HelpGroup.visible = !this.HelpGroup.visible;           
        }
       
        

        create() {
            super.create();
            var card = this.game.add.image(this.game.width, this.game.height, "card");
            //card.scale.x = 0.75;
            //card.scale.y = 0.75;
            card.x = this.game.width / 2 - card.width / 2;
            card.y = this.game.height / 2 - card.height / 2;
            card.z = 4;
            var frame = this.game.add.image(this.game.width, this.game.height, "frame");
            frame.scale.x = 0.8;
            frame.scale.y = 0.8;
            frame.x = this.game.width / 2 - frame.width / 2;
            frame.y = this.game.height - frame.height;
            this.container = this.game.add.sprite(this.game.width, this.game.height, "C_0_0");
            this.container.x = card.x +20;
            this.container.y = card.y +20;
            this.container.scale.x = 0.8;
            this.container.scale.y = 0.8;
            this.container.z = 4;
            this.loadImages(frame);
            this.LoadGUI();
            //Keyboard
            this.KEYBOARD = new EU.Keyboard();
            this.KEYBOARD.createKeyboard(this.game, 400, 100, "key", true, "key");
            this.KEYBOARD.initKeyboard(this.game);
            this.KEYBOARD.keyboard.x = (this.game.width - this.KEYBOARD.keyboard.width) / 2;
            var btn1 = this.game.add.button(this.container.width+50, 30, "InputName", function () { this.KEYBOARD.inputClick(this, this.Keyboard, btn1) }, this, 0, 0, 0, 0);

            var tst1 = this.game.add.text(0, 0, "Nazwa Firmy", {});
            tst1.x = btn1.width / 2;
            tst1.y = btn1.height / 2 - tst1.height / 2;
            tst1.align = "center";
            tst1.anchor.set(0.5, 0.5);
            btn1.addChild(tst1);
            var btn2 = this.game.add.button(20, 0, "InputAddress", function () { this.KEYBOARD.inputClick(this, this.Keyboard, btn2) }, this, 0, 0, 0, 0);
            btn2.y = card.height - (30 + btn2.height);
            var tst2 = this.game.add.text(0, 0, "Adres", {});
            tst2.wordWrap = true;
            tst2.wordWrapWidth = 540;
            btn2.addChild(tst2);
            card.addChild(btn2);
            card.addChild(btn1);
            var btn3 = this.game.add.button(this.container.width + 50, 100+btn1.height, "InputName", function () { this.KEYBOARD.inputClick(this, this.Keyboard, btn3) }, this, 0, 0, 0, 0);

            var tst3 = this.game.add.text(0, 0, "Imię i Nazwisko", {});
            btn3.addChild(tst3);
            tst3.wordWrap = true;
            tst3.wordWrapWidth = 900;
           
        
        
          
            
            card.addChild(btn3);

            tst3.anchor.set(0.5, 0.5);
            tst3.x = btn3.width / 2 ;
            tst3.y = btn3.height / 2 - tst3.height / 2;
            var btn4 = this.game.add.button(card.width, 0, "InputAddress", function () { this.KEYBOARD.inputClick(this, this.Keyboard, btn4) }, this, 0, 0, 0, 0);
            btn4.x = card.width - (30 + btn4.width);
            btn4.y = card.height - (30 + btn4.height);
            var tst4 = this.game.add.text(0, 0, "Dane Kontaktowe", {});
            btn4.addChild(tst4);
            card.addChild(btn4);
            tst4.wordWrap = true;
            tst4.wordWrapWidth = 540;
            tst4.align = "right";

            var ready = this.game.add.button(card.x + card.width, card.y + card.height - 100, "gotowe", this.ReadyClick, this, 1, 0, 1, 0);

        }
        ReadyClick() {
          
            this.HelpGroup.visible = !this.HelpGroup.visible; 
            this.text.setText("Gratulacje!");
            this.text.x = this.cloud.width / 2 - this.text.width / 2;
            audio = new Audio("Sounds/gratulacje.mp3");
            audio.play();
            var Timer = this.game.time.events.add(Phaser.Timer.SECOND * 5, this.FinishGame, this);

           
        }
        FinishGame() {
            this.HideHelpVisibility();
            this.game.state.start("TitleScreenState", true, true);
        }
        log() {
            console.log("click");
        }

    
        loadImages(frame) {
            this.dragElements = [];
            for (var i = 0; i < 8; i++) {
                var tmp = this.game.add.sprite(this.game.width, this.game.height, "O_" + i + "_" + i);
                tmp.x = frame.x + i * (tmp.width * 0.9) + 17;
                tmp.inputEnabled = true;
                tmp.input.enableDrag();
                tmp.overlap(this.container);
                tmp.events.onInputUp.add(this.InputUP, this);
                tmp.scale.x = 0.8;
                tmp.scale.y = 0.8;
                tmp.y = frame.y + tmp.width / 5;
                tmp.z = 6;
                this.dragElements.push({ "el": tmp, "startPos": { x: tmp.x, y: tmp.y } });
            }
        }
        InputUP(sprite, pointer) {
            if (!sprite.overlap(this.container)) {
                for (var i = 0; i < this.dragElements.length; i++) {
                    if (this.dragElements[i].el === sprite) {
                        sprite.x = this.dragElements[i].startPos.x;
                        sprite.y = this.dragElements[i].startPos.y;
                        break;
                    }
                }
               
            }
            else {
                sprite.x = this.container.x;
                sprite.y = this.container.y;
                sprite.inputEnabled = false;
                for (var i = 0; i < this.dragElements.length; i++) {
                    if (this.dragElements[i].el !== sprite) {
                        this.dragElements[i].el.x = this.dragElements[i].startPos.x;
                        this.dragElements[i].el.y = this.dragElements[i].startPos.y;
                        this.dragElements[i].el.inputEnabled = true;
                     
                    }
                }
            }
        }
       


    }
} 