var EU;
(function (EU) {
    function generatePositions(startPos, elementWidth, margin, amount) {
        var ret = [];
        for (var i = 0; i < amount; i++) {
            var t = startPos + i * (elementWidth + margin);
            ret.push(t);
        }
        return ret;
    }
    EU.generatePositions = generatePositions;
    function shuffleArray(arr) {
        var t = arr.length;
        var temp = generateUniqueRandoms(0, t, t);
        var ret = [];
        for (var i = 0; i < t; i++) {
            ret.push(arr[temp[i]]);
        }
        return ret;
    }
    EU.shuffleArray = shuffleArray;
    function generateGridPositions(cols, rows, width, height, marginX, marginY, startPosX, startPosY, upDown) {
        var xPos = generatePositions(startPosX, width, marginX, cols);
        var yPos = generatePositions(startPosY, height, marginY, rows);
        var ret = [];
        var xLen = xPos.length;
        var yLen = yPos.length;
        if (upDown) {
            for (var i = 0; i < xLen; i++) {
                for (var j = 0; j < yLen; j++) {
                    var t = { x: xPos[i], y: yPos[j] };
                    ret.push(t);
                }
            }
        }
        else {
            for (var i = 0; i < yLen; i++) {
                for (var j = 0; j < xLen; j++) {
                    var t = { x: xPos[j], y: yPos[i] };
                    ret.push(t);
                }
            }
        }
        return ret;
    }
    EU.generateGridPositions = generateGridPositions;
    function generateUniqueRandoms(min, max, amount) {
        var ret = [];
        if ((amount > max - min || max < min) && min !== 0) {
            return undefined;
        }
        for (var i = 0; i < amount; i++) {
            var maxIterations = 0;
            var s = min + Math.floor(Math.random() * max);
            while ($.inArray(s, ret) !== -1 && maxIterations < 500) {
                s = min + Math.floor(Math.random() * max);
                maxIterations++;
            }
            ret.push(s);
        }
        return ret;
    }
    EU.generateUniqueRandoms = generateUniqueRandoms;
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////                                     /////////////////////////////////////////////////////////////
    //////////////////////////////////////////             KEYBOARD CLASS          /////////////////////////////////////////////////////////////
    //////////////////////////////////////////                                     /////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    var Keyboard = (function () {
        function Keyboard() {
        }
        Keyboard.prototype.createKeyboard = function (game, x, y, buttonKey, isHidden, hiddenKey) {
            // Creating Keyboard
            this.keys = [];
            this.game = game;
            this.currElem = null;
            var letters = "0123456789.,:/-@ABCDEFGHIJKLMNOPQRSTUVWXYZĄĆĘŁŃÓŚŹŻ ".split("");
            var lettersLen = letters.length;
            var ey = 0;
            this.isVisible = true;
            this.nav = null;
            if (isHidden) {
                if (hiddenKey === undefined || hiddenKey === null) {
                    console.log("NAV Button has no texture");
                }
                else {
                    this.isVisible = false;
                    this.nav = game.add.button(0, 0, hiddenKey, this.navClick, this, 0, 0, 1);
                    this.nav.scale.y = 0.2;
                    ey = this.nav.height;
                }
            }
            var tem = game.add.button(0, 0, buttonKey, this.click, this, 0, 0, 1);
            var pos = EU.generateGridPositions(14, 4, tem.width * 0.5, tem.height * 0.5, 1, 1, 0, 0 + ey, false);
            tem.x = pos[0].x;
            tem.y = pos[1].y + ey;
            var t = game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), "<", { fill: "white", font: "normal 48pt Arial", align: "center", wordWrapWidth: tem.width });
            t.anchor.set(0.3, 0.3);
            tem.addChild(t);
            tem.scale.set(0.5, 0.5);
            this.keys.push(tem);
            this.isCapsOn = false;
            this.currElem = null;
            var i = 0;
            for (var i = 0; i < lettersLen; i++) {
                var tem = game.add.button(pos[i+1].x, pos[i+1].y + ey, buttonKey, this.click, this, 0, 0, 1);
                var t = game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), letters[i].toLowerCase(), { fill: "white", font: "normal 48pt Arial", align: "center", wordWrapWidth: tem.width });
                t.anchor.set(0.3, 0.3);
                tem.addChild(t);
                tem.scale.set(0.5, 0.5);
                this.keys.push(tem);
            }
            var tem = game.add.button(0, 0, buttonKey, this.click, this, 0, 0, 1);
            tem.x = pos[i].x;
            tem.y = pos[i].y + ey;
            var t = game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), "_", { fill: "white", font: "normal 48pt Arial", align: "center", wordWrapWidth: tem.width });
            t.anchor.set(0.3, 0.3);
            tem.addChild(t);
            tem.scale.set(0.5, 0.5);
            this.keys.push(tem);
			i++;
            var tem = game.add.button(0, 0, buttonKey, this.click, this, 0, 0, 1);
            tem.x = pos[i].x;
            tem.y = pos[i].y + ey;
            var t = game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), "/\\", { fill: "white", font: "normal 48pt Arial", align: "center", wordWrapWidth: tem.width });
            t.anchor.set(0.3, 0.3);
            tem.addChild(t);
            tem.scale.set(0.5, 0.5);
            this.keys.push(tem);
			i++;
            var tem = game.add.button(0, 0, buttonKey, this.click, this, 0, 0, 1);
            tem.x = pos[i].x;
            tem.y = pos[i].y + ey;
            var t = game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), "|", { fill: "white", font: "normal 48pt Arial", align: "center", wordWrapWidth: tem.width });
            t.anchor.set(0.3, 0.3);
            tem.addChild(t);
            tem.scale.set(0.5, 0.5);
            this.keys.push(tem);
            this.keyboard = game.add.group();
            this.keyboard.x = x;
            this.keyboard.y = y;
            if (isHidden) {
                this.keyboard.addChild(this.nav);
            }
            var len = this.keys.length;
            for (var i = 0; i < len; i++) {
                this.keyboard.addChild(this.keys[i]);
            }
            if (this.nav !== null) {
                this.nav.anchor.set(0.3, 0.3);
                this.nav.x = (this.keyboard.width) / 2;
            }
            if (!this.isVisible) {
                this.keyboard.y = this.game.world.height - this.nav.height;
            }
            return this.keyboard;
        };
        Keyboard.prototype.initKeyboard = function (game) {
            var bspace = game.input.keyboard.addKey(Phaser.Keyboard.BACKSPACE);
            var caps = game.input.keyboard.addKey(Phaser.Keyboard.SHIFT);
            var space = game.input.keyboard.addKey(Phaser.Keyboard.SPACEBAR);
			var enter = game.input.keyboard.addKey(Phaser.Keyboard.ENTER);
            game.input.keyboard.addKeyCapture(Phaser.Keyboard.BACKSPACE);
            game.input.keyboard.addKeyCapture(Phaser.Keyboard.SHIFT);
            game.input.keyboard.addKeyCapture(Phaser.Keyboard.SPACEBAR);
			game.input.keyboard.addKeyCapture(Phaser.Keyboard.ENTER);
            game.input.keyboard.addCallbacks(this, null, null, this.move);
            space.onDown.add(this.move, this);
            bspace.onDown.add(this.move, this);
            caps.onDown.add(this.move, this);
			enter.onDown.add(this.move, this);	
        };
        Keyboard.prototype.showKeyboard = function () {
            var tw = this.game.add.tween(this.keyboard);
            tw.to({ y: this.game.world.height - this.keyboard.height }, 800, Phaser.Easing.Default);
            tw.start();
            this.isVisible = true;
        };
        Keyboard.prototype.hideKeyboard = function () {
            var tw = this.game.add.tween(this.keyboard);
            tw.to({ y: this.game.world.height - this.nav.height }, 800, Phaser.Easing.Default);
            tw.start();
            this.isVisible = false;
        };
        Keyboard.prototype.inputClick = function (kb, sprite, btn) {
            if (this.currElem === btn.children[0]) {
                this.currElem = null;
                this.hideKeyboard();
            }
            else {
                if (this.currElem === null && !this.isVisible) {
                    this.showKeyboard();
                }
                this.currElem = btn.children[0];
                this.currElem.text = "";
            }
        };
        Keyboard.prototype.navClick = function () {
            if (this.isVisible) {
                this.currElem = null;
                this.hideKeyboard();
            }
            else {
                this.showKeyboard();
            }
        };
        Keyboard.prototype.move = function (ev) {
            var obj = this.keyboard.children;
            if (ev.length === undefined) {
                var id = parseInt(ev.keyCode);
                switch (id) {
                    case Phaser.Keyboard.BACKSPACE:
                        ev = "<";
                        break;
                    case Phaser.Keyboard.SPACEBAR:
                        ev = "_";
                        break;
                    case Phaser.Keyboard.SHIFT:
                        ev = "/\\";
                        break;
					case Phaser.Keyboard.ENTER:
                        ev = "|";
                        break;
                }
            }
            var len = this.keyboard.children.length;
            for (var i = 0; i < len; i++) {
                if (obj[i].children.length > 0 && obj[i].children[0].text.toLowerCase() === ev) {
                    obj[i].frame = 1;
                    this.click(obj[i]);
                    setTimeout(function () {
                        obj[i].frame = 0;
                    }, 100);
                    break;
                }
            }
        };
        Keyboard.prototype.click = function (sprite) {
            var text = sprite.children[0].text;
            if (this.currElem !== null) {
                switch (text) {
                    case "/\\":
                        if (this.isCapsOn) {
                            for (var i = 0; i < this.keys.length; i++) {
                                this.keys[i].children[0].text = this.keys[i].children[0].text.toLowerCase();
                            }
                            this.isCapsOn = false;
                        }
                        else {
                            for (var i = 0; i < this.keys.length; i++) {
                                this.keys[i].children[0].text = this.keys[i].children[0].text.toUpperCase();
                            }
                            this.isCapsOn = true;
                        }
                        break;
                    case "<":
                        if (this.currElem.text.length > 0) {
                            this.currElem.text = this.currElem.text.substring(0, this.currElem.text.length - 1);
                        }
                        break;
                    case "_":
                        this.currElem.text = this.currElem.text + " ";
                        break;
					case "|":
                        this.currElem.text = this.currElem.text + "\n";
                        break;
                    default:
                        this.currElem.text = this.currElem.text + text;
                        this.currElem.align = "center";
                        break;
                }
            }
        };
        Keyboard.prototype.setCurrentTarget = function (txtElem) {
            this.currElem = txtElem;
        };
        return Keyboard;
    })();
    EU.Keyboard = Keyboard;
})(EU || (EU = {}));
//# sourceMappingURL=ExtraUtilities.js.map