﻿module Maze {

    export class Maze extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        //map: Phaser.Tilemap;
        //cratesLayer: Phaser.TilemapLayer;

        player: Phaser.Sprite;
        cursors: Phaser.CursorKeys;
        map: Array<number>;
        wall: Phaser.Group;
        kran: Phaser.Sprite;
       

        ready: boolean = false;

        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);

        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();

            this.map = this.Elements.Tilemap[0].layers[0].data;

            this.game.load.spritesheet('player', 'Graphics/Games/OB_G_II_3/player.png', 31, 31, 4);
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);

            this.cursors = this.game.input.keyboard.createCursorKeys();
        }

        create() {
            if (this.json.isStandalone) {
                super.create();

            }

            this.game.physics.startSystem(Phaser.Physics.ARCADE);

            this.wall = this.game.add.group();
            this.addChild(this.wall);

            this.kran = this.game.add.sprite(1070, 560, 'tap');
            this.wall.add(this.kran);

            this.player = this.game.add.sprite(560, 64, 'player');
            this.player.animations.add('walk', [0, 1, 2, 3], 0, false);
            this.addChild(this.player);

            this.game.physics.enable([this.player, this.kran], Phaser.Physics.ARCADE);
 
            var idx = 0;
            for (var i = 0; i < 21; i++)
                for (var j = 0; j < 21; j++) {
                    if (this.map[idx++] == 1) var spr = this.game.add.sprite(500 + (j * 32),(i * 32), 'crate');
                    this.game.physics.enable(spr, Phaser.Physics.ARCADE);
                    this.addChild(spr);
                    this.wall.add(spr);
                }

            this.wall.setAll('body.immovable', true);
            this.ready = true;
        }

        soundButtonDown(button) {
            Global.Main.PlayMusic(new Audio(button.name));
        }

        update() {

            if (this.ready) {

                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;

                if (this.game.physics.arcade.collide(this.player, this.kran)) {

                    console.log('hit');
                    this.ready = false;
                }

                this.game.physics.arcade.collide(this.player, this.wall);

                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;

                if (this.cursors.left.isDown) {
                    this.player.body.velocity.x = -200;
                    this.player.animations.frame = 2;
                }


                if (this.cursors.right.isDown) {
                    this.player.body.velocity.x = 200;
                    this.player.animations.frame = 1;
                }

                if (this.cursors.up.isDown) {
                    this.player.body.velocity.y = -200;
                    this.player.animations.frame = 3;

                }


                if (this.cursors.down.isDown) {
                    this.player.body.velocity.y = 200;
                    this.player.animations.frame = 0;
                }

            }

        }


    }

}

