var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Fiche;
(function (_Fiche) {
    var Fiche = (function (_super) {
        __extends(Fiche, _super);
        function Fiche(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.currentFiche = 1;
        }
        Fiche.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        Fiche.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Fiche.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.Loader = new Phaser.Loader(this.game);
            var i = this.game.add.image(50, -150, "bck");
            this.addChild(i);
            var prev = this.game.add.button(200, 800, "prevF", this.prevFiche, this, 0, 0, 1, 0);
            this.addChild(prev);
            var next = this.game.add.button(400, 800, "nextF", this.nextFiche, this, 0, 0, 1, 0);
            this.addChild(next);
            this.FicheImage = this.game.add.image(200, 200, "prevF");
            this.addChild(this.FicheImage);
        };
        Fiche.prototype.nextFiche = function () {
            this.currentFiche++;
            this.loadFiche();
        };
        Fiche.prototype.prevFiche = function () {
            this.currentFiche--;
            this.loadFiche();
        };
        Fiche.prototype.loadFiche = function () {
            this.Loader.image(this.currentFiche + "", "Graphics/Games/OS_G_FI_I" + "/1_" + this.currentFiche + ".jpg");
            this.Loader.onLoadComplete.addOnce(this.setFiche, this);
            this.Loader.start();
        };
        Fiche.prototype.setFiche = function () {
            this.FicheImage.loadTexture(this.currentFiche, 0);
        };
        Fiche.prototype.loadGraphics = function () {
            this.game.load.image("bck", "Graphics/GUI/" + CardChooser.getModule() + "/" + "modul1.png");
            this.game.load.spritesheet("prevF", "Graphics/GUI/OS/prev1.png", 100, 100, 2);
            this.game.load.spritesheet("nextF", "Graphics/GUI/OS/next1.png", 100, 100, 2);
        };
        return Fiche;
    })(Base.BasicGroup);
    _Fiche.Fiche = Fiche;
})(Fiche || (Fiche = {}));
//# sourceMappingURL=Fiche.js.map