var game;
var Global;
(function (Global) {
    var Main = (function () {
        function Main() {
            this.game = new Phaser.Game(Main.dims.x, Main.dims.y, Phaser.CANVAS, 'exam', { create: this.start, preload: this.preload });
        }
        Main.prototype.preload = function () {
            this.game.stage.disableVisibilityChange = true;
        };
        Main.returnPage = function (index) {
            return Main.ts[index];
        };
        Main.PlayMusic = function (musicObject) {
            try {
                if (this.AudioObject) {
                    this.AudioObject.pause();
                    this.AudioObject.currentTime = 0;
                }
                this.AudioObject = musicObject;
                this.AudioObject.play();
            }
            catch (e) {
                EU.Log("Playback Error: " + e);
            }
        };
        Main.CountPoints = function () {
            var acquiredPoints = 0;
            var maxPoints = 0;
            for (var i = 1; i < Main.ts.length - 1; i++) {
                EU.Log("Game: " + i + " GameCompletion = " + Main.ts[i].gameCompletion + " MaxPoints = " + Main.ts[i].maxPoints);
                acquiredPoints += Main.ts[i].gameCompletion;
                maxPoints += Main.ts[i].maxPoints;
            }
            EU.Log(acquiredPoints / maxPoints);
            return acquiredPoints / maxPoints;
        };
        Main.getExamResult = function () {
            var acquiredPoints = 0;
            var maxPoints = 0;
            var wrongAnswers = [];
            for (var i = 1; i < Main.ts.length - 1; i++) {
                EU.Log("Game: " + i + " GameCompletion = " + Main.ts[i].gameCompletion + " MaxPoints = " + Main.ts[i].maxPoints);
                if (Main.ts[i].gameCompletion != Main.ts[i].maxPoints)
                    wrongAnswers.push(i);
                acquiredPoints += Main.ts[i].gameCompletion;
                maxPoints += Main.ts[i].maxPoints;
            }
            var result = {
                "Acquired": acquiredPoints,
                "MaxPoints": maxPoints,
                "Score": acquiredPoints / maxPoints,
                "WrongAnswers": wrongAnswers
            };
            return result;
        };
        Main.prototype.start = function () {
            var _this = this;
            Main.ts = [];
            Main.array = [];
            Main.array.push("test");
            Main.ts.push(new Base.BeginGroup(this.game, "beginGroup", 0, 0, ""));
            if (window['data'] !== undefined && window['data'] !== null) {
                Main.ts = JD.decode(Main.ts, window['data'], this.game);
                Main.ts.push(new Base.EndGroup(this.game, "endGroup", Main.ts.length * 1920, 0, ""));
                this.game.world.setBounds(0, 0, Main.dims.x * (Main.ts.length + 2), Main.dims.y);
                var t = this.game.state.add("State1", State1.State1, false);
                this.game.state.start("State1", false, false, Main.ts);
                this.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
                this.game.scale.pageAlignHorizontally = true;
                this.game.scale.pageAlignVertically = true;
                this.game.scale.windowConstraints.bottom = true;
                this.game.scale.refresh();
            }
            else {
                console.log("null");
                setTimeout(function (ctx) {
                    console.log("TIMEOUT");
                    Main.ts = JD.decode(Main.ts, window['data'], _this.game);
                    Main.ts.push(new Base.EndGroup(_this.game, "endGroup", Main.ts.length * 1920, 0, ""));
                    _this.game.world.setBounds(0, 0, Main.dims.x * (Main.ts.length + 2), Main.dims.y);
                    var t = _this.game.state.add("State1", State1.State1, false);
                    _this.game.state.start("State1", false, false, Main.ts);
                    _this.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
                    _this.game.scale.pageAlignHorizontally = true;
                    _this.game.scale.pageAlignVertically = true;
                    _this.game.scale.windowConstraints.bottom = true;
                    _this.game.scale.refresh();
                }, 1000);
            }
        };
        Main.dims = { x: 1920, y: 1080 };
        Main.mainContainerDims = { x: 120, y: 200, wd: 1800, hg: 950 };
        return Main;
    })();
    Global.Main = Main;
})(Global || (Global = {}));
//# sourceMappingURL=Global.js.map