﻿module SearchText {
    export class SearchText extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        SourceText: any[];
        
        numberOfChecked: any;
        numberOfCorrectChars: any;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }
        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            this.createStaticElements();
            this.numberOfChecked = 0;
            this.createSourceText();
            this.createTextToFind();
            
            
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createStaticElements() {
            for (var i= 0; i < this.Elements.StaticElements.length; i++) {
                var el = this.game.add.image(this.Elements.StaticElements[i].pos.x, this.Elements.StaticElements[i].pos.y, this.PREFIX + this.Elements.StaticElements[i].key);
                this.addChild(el);
            }

        }

        createTextToFind() {
            for (var k = 0; k < this.Elements.SourceText.length; k++) {
                this.SourceText[k].toFind = this.Elements.SourceText[k].TextToFind;             
            }
        }

        createSourceText() {
            this.SourceText = [];
            for (var k = 0; k < this.Elements.SourceText.length; k++) {
                var Text = [];
                var verses = this.Elements.SourceText[k].Text.split("@");
                var posX = this.Elements.SourceText[k].Position.x;
                var posY = this.Elements.SourceText[k].Position.y;
                var style = this.Elements.SourceText[k].Style;
                var counter = 0;
                for (var i = 0; i < verses.length; i++) {
                    var words = verses[i].split("");
                    words.push(' ');
                    counter++;
                    var el = this.game.add.text(0, 0, words[0], style);
                    var versePosY = posY + i * el.height;
                    el.position.set(posX, versePosY);
                    el.inputEnabled = true;
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    el.events.onInputDown.add(this.onWordClicked, this);
                    Text.push(el);
                    //this.SourceText[k].push(el);
                    this.addChild(el);
                    for (var j = 1; j < words.length; j++) {
                        el = this.game.add.text(0, 0, words[j], style);
                        el.position.set(
                            Text[counter - 1].position.x +
                            Text[counter - 1].width,
                            versePosY
                            );
                        el.inputEnabled = true;
                        el.events.onInputOver.add(this.onInputOver, this);
                        el.events.onInputOut.add(this.onInputOut, this);
                        el.events.onInputDown.add(this.onWordClicked, this);
                        Text.push(el);
                        this.addChild(el);
                        counter++;
                    }
                }
                this.SourceText.push({ "Text": Text, "toFind": null });
            }
        }
        //input

        private onInputOver(el: Phaser.Text, pointer) {
            el.alpha = 0.5;
        }

        private onInputOut(el: Phaser.Text, pointer) {
            el.alpha = 1.0;
        }

        private onWordClicked(el: Phaser.Text, pointer) {
            if (el.text != " ") {
                if (el.name == "checked") {
                    el.setShadow(0, 0, "black");
                    this.numberOfChecked--;
                    el.name = "unchecked";
                }
                else {
                    el.setShadow(el.height / 25, el.height / 25, "red");
                    this.numberOfChecked++;
                    el.name = "checked";
                }
                this.checkIfEverythingIsCorrect();
            }

        }

        private findIndexes(source, toFind) {
            var result = [];
            for (var i = 0; i < source.length; i++) {
                if (source.substring(i, i + toFind.length) == toFind) {
                    result.push(i);
                }
            }
            return result;
        }

        private markCorrectChars() {
            for (var i = 0; i < this.Elements.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].toFind.length; j++) {
                    var indexes = this.findIndexes(this.Elements.SourceText[i].Text, this.SourceText[i].toFind[j]);
                    for (var k = 0; k < indexes.length; k++) {
                        for (var l = 0; l < this.SourceText[i].toFind[j].length; l++) {
                            this.SourceText[i].Text[indexes[k] + l].setShadow(1, 1, "red");
                        }
                    }
                }
            }
        }

        private checkIfEverythingIsCorrect() {
            var srt = "Points: " + this.calculatePlayerPoints()
                + "/" + this.calculateMaxPoints();
            EU.Log(srt);
            EU.Log("Checked: " + this.numberOfChecked + "/" + this.numberOfCorrectChars);

            if (this.calculatePlayerPoints() == this.calculateMaxPoints()
                && this.numberOfChecked == this.numberOfCorrectChars) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        }

        private calculateMaxPoints() {
            this.numberOfCorrectChars = 0;
            var points = 0;
            for (var i = 0; i < this.Elements.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].toFind.length; j++) {
                    var indexes = this.findIndexes(this.Elements.SourceText[i].Text, this.SourceText[i].toFind[j]).length;
                    points += indexes;
                    this.numberOfCorrectChars += indexes * this.SourceText[i].toFind[j].length;
                }
            }
            return points;
        }

        private calculatePlayerPoints() {
            var points = 0;
            for (var i = 0; i < this.Elements.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].toFind.length; j++) {
                    var indexes = this.findIndexes(this.Elements.SourceText[i].Text, this.SourceText[i].toFind[j]);
                    for (var k = 0; k < indexes.length; k++) {
                        var allCharChecked = true;
                        for (var l = 0; l < this.SourceText[i].toFind[j].length; l++) {
                            if (this.SourceText[i].Text[indexes[k] + l].name != "checked") {
                                allCharChecked = false;
                            }
                        }
                        if (allCharChecked) points++;
                    } 
                }
            }
            return points;
        }

        /*
        private checkIfEverythingIsCorrect() {
            EU.Log("Points: " + this.calculatePlayerPoints()
                + "/" + this.calculateMaxPoints()
                + " Checked: " + this.numberOfChecked);

            var maxPoints = this.calculateMaxPoints()
            if (this.calculatePlayerPoints() == maxPoints
                && this.numberOfChecked == maxPoints) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        }

        
        private calculateMaxPoints() {
            var points = 0;
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 1; j < this.TextToFind.length; j++) {
                    if (this.SourceText[i].text == this.TextToFind[j])
                        points++;
                }
            }
            return points;
        }

        private calculatePlayerPoints() {
            var points = 0;
            for (var i = 0; i < this.SourceText.length; i++) {
                if (this.SourceText[i].name == "checked") {
                    for (var j = 1; j < this.TextToFind.length; j++) {
                        if (this.SourceText[i].text == this.TextToFind[j])
                            points++;
                    }
                }
            }
            return points;
        }*/

    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////            FORMAT JSONA           ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    JSON = {
//              completeText: "caly tekst do wyswietlenia",
//              searched: [["znak lub wyraz", (true/false || true szuka znaku lub wyrazu oddzielonego spacjami, kropka, myslnikiem lub cudzyslowiem; false szuka podciągu)], [], []]    
//           }
