var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Quiz;
(function (_Quiz) {
    var Quiz = (function (_super) {
        __extends(Quiz, _super);
        function Quiz(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Quiz.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Quiz.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Quiz.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.numberOfChecked = 0;
            this.createStaticGraphics();
            this.createStaticTexts();
            this.createQuestions();
        };
        Quiz.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Quiz.prototype.createStaticGraphics = function () {
            if (this.Elements.StaticGraphics) {
                for (var i = 0; i < this.Elements.StaticGraphics.length; i++) {
                    var el = this.game.add.image(this.Elements.StaticGraphics[i].pos.x, this.Elements.StaticGraphics[i].pos.y, this.PREFIX + this.Elements.StaticGraphics[i].key);
                    this.addChild(el);
                }
            }
        };
        Quiz.prototype.createStaticTexts = function () {
            for (var i = 0; i < this.Elements.StaticTexts.length; i++) {
                var el = this.game.add.text(0, 0, this.Elements.StaticTexts[i].Text, this.Elements.StaticTexts[i].Style);
                this.addChild(el);
                var posX = this.Elements.StaticTexts[i].Position.x;
                var posY = this.Elements.StaticTexts[i].Position.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.StaticTexts[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.StaticTexts[i].Position.JustY, el));
                el.align = (this.Elements.StaticTexts[i].Position.JustX).toLowerCase();
            }
        };
        Quiz.prototype.createQuestions = function () {
            this.Questions = [];
            for (var i = 0; i < this.Elements.Questions.length; i++) {
                var el = this.game.add.text(0, 0, this.Elements.Questions[i].QuestionText, this.Elements.Questions[i].QuestionStyle);
                this.addChild(el);
                var posX = this.Elements.Questions[i].Position.x;
                var posY = this.Elements.Questions[i].Position.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, el));
                el.align = (this.Elements.Questions[i].Just).toLowerCase();
                var Answers = [];
                for (var j = 0; j < this.Elements.Questions[i].Answers.length; j++) {
                    var ans = this.game.add.text(0, 0, this.Elements.Questions[i].Answers[j].Text, this.Elements.Questions[i].AnswerFont);
                    this.addChild(ans);
                    ans.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, ans), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, ans) + (j + 1) * this.Elements.Questions[i].Spacing + el.height + j * ans.height);
                    ans.inputEnabled = true;
                    ans.align = (this.Elements.Questions[i].Just).toLowerCase();
                    ans.events.onInputOver.add(this.onInputOver, this);
                    ans.events.onInputOut.add(this.onInputOut, this);
                    ans.events.onInputDown.add(this.onInputDown, this);
                    Answers.push({
                        "Element": ans,
                        "isTrue": this.Elements.Questions[i].Answers[j].isTrue
                    });
                }
                this.Questions.push({
                    "Text": this.Elements.Questions[i].QuestionText,
                    "Answers": Answers
                });
            }
        };
        Quiz.prototype.getJustedPositionX = function (just, element) {
            var posX = 0;
            switch (just) {
                case "Center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "Right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        };
        Quiz.prototype.getJustedPositionY = function (just, element) {
            var posY = 0;
            switch (just) {
                case "Center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "Bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            }
            return posY;
        };
        Quiz.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        Quiz.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Quiz.prototype.onInputDown = function (el, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";
            }
            else {
                el.setShadow(el.height / 25, el.height / 25, "red");
                this.numberOfChecked++;
                el.name = "checked";
            }
            this.checkIfEverythingIsCorrect();
        };
        Quiz.prototype.checkIfEverythingIsCorrect = function () {
            var srt = "Points: " + this.calculatePlayerPoints() + "/" + this.calculateMaxPoints();
            EU.Log(srt);
            EU.Log("Checked: " + this.numberOfChecked);
            if (this.calculatePlayerPoints() == this.calculateMaxPoints() && this.numberOfChecked == this.calculateMaxPoints()) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        Quiz.prototype.calculateMaxPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue == "true")
                        points++;
                }
            }
            return points;
        };
        Quiz.prototype.calculatePlayerPoints = function () {
            var points = 0;
            this.numberOfCorrect = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue && this.Questions[i].Answers[j].Element.name == "checked")
                        points++;
                }
            }
            return points;
        };
        return Quiz;
    })(Base.BasicGroup);
    _Quiz.Quiz = Quiz;
})(Quiz || (Quiz = {}));
//# sourceMappingURL=Quiz.js.map