var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var DragDrop;
(function (_DragDrop) {
    var Types;
    (function (Types) {
        Types[Types["OneToMany"] = 0] = "OneToMany";
        Types[Types["ManyToOne"] = 1] = "ManyToOne";
        Types[Types["OneToOne"] = 2] = "OneToOne";
        Types[Types["BigContainer"] = 3] = "BigContainer";
    })(Types || (Types = {}));
    var DragDrop = (function (_super) {
        __extends(DragDrop, _super);
        function DragDrop(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.isExam = false;
            this.allPaired = true;
            this.groupsEnabled = true;
        }
        DragDrop.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        DragDrop.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        DragDrop.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.createStaticElements();
            this.createContainerElements();
            this.createDragableElements();
            this.loadGroups();
            this.initOptions();
        };
        DragDrop.prototype.initOptions = function () {
            if (this.GameData.AllPaired === undefined || this.GameData.AllPaired === null) {
                this.allPaired = true;
            }
            else {
                this.allPaired = this.GameData.AllPaired;
            }
        };
        DragDrop.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Prefix + this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        DragDrop.prototype.createStaticElements = function () {
            if (this.GameData.StaticElements.Options.isGrid) {
                var opt = this.GameData.StaticElements.Options;
                var orientation;
                if (opt.Orientation === undefined || opt.Orientation === null) {
                    orientation = true;
                }
                else {
                    orientation = opt.Orientation;
                }
                var positions = EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, orientation);
                for (var i = 0; i < this.GameData.StaticElements.el.length; i++) {
                    var el = this.game.add.image(positions[i].x, positions[i].y, this.GameData.Prefix + this.GameData.StaticElements.el[i].key);
                    this.addChild(el);
                }
            }
            else {
                for (var i = 0; i < this.GameData.StaticElements.el.length; i++) {
                    var el = this.game.add.image(this.GameData.StaticElements.el[i].pos.x, this.GameData.StaticElements.el[i].pos.y, this.GameData.Prefix + this.GameData.StaticElements.el[i].key);
                    this.addChild(el);
                }
            }
        };
        DragDrop.prototype.createContainerElements = function () {
            this.containers = [];
            var el;
            var i = 0;
            if (this.GameData.ContainerElements.Options.isGrid) {
                var opt = this.GameData.ContainerElements.Options;
                var positions = EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, true);
                for (var i = 0; i < this.GameData.ContainerElements.el.length; i++) {
                    el = this.game.add.image(positions[i].x, positions[i].y, this.GameData.Prefix + this.GameData.ContainerElements.el[i].key);
                    el.name = this.GameData.ContainerElements.el[i].name;
                    this.containers.push({
                        "el": el,
                        "startPos": {
                            "x": el.position.x,
                            "y": el.position.y
                        },
                        "name": el.name,
                        "dragElementName": ""
                    });
                    this.addChild(el);
                }
            }
            else {
                for (i = 0; i < this.GameData.ContainerElements.el.length; i++) {
                    el = this.game.add.image(this.GameData.ContainerElements.el[i].pos.x, this.GameData.ContainerElements.el[i].pos.y, this.GameData.Prefix + this.GameData.ContainerElements.el[i].key);
                    el.name = this.GameData.ContainerElements.el[i].name;
                    this.containers.push({
                        "el": el,
                        "startPos": {
                            "x": el.position.x,
                            "y": el.position.y
                        },
                        "name": el.name,
                        "dragElementName": ""
                    });
                    this.addChild(el);
                }
            }
        };
        DragDrop.prototype.onInputUpBigContainer = function (el, pointer) {
            var index = this.getCorrespondingContainerIndex(el);
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    this.dragElements[index].paired = true;
                    this.dragElements[index].pairedWith = this.containers[i].name;
                    this.checkCompleted(this.allPaired);
                    return;
                }
            }
            this.dragElements[index].paired = false;
            this.dragElements[index].pairedWith = "";
            EU.Log("game completion set to 0");
            EU.setGameCompletion(this.parent, 0);
            var tw = this.game.add.tween(el);
            tw.to({ x: this.dragElements[index].startPos.x, y: this.dragElements[index].startPos.y }, 500, Phaser.Easing.Circular.InOut);
            tw.start();
        };
        DragDrop.prototype.createDragableElements = function () {
            this.dragElements = [];
            if (this.GameData.DragableElements.Options.isGrid) {
                var opt = this.GameData.DragableElements.Options;
                var positions = EU.shuffleArray(EU.generateGridPositions(opt.Columns, opt.Rows, opt.MaxWidth, opt.MaxHeight, opt.Spacing, opt.Spacing, opt.StartingPos.x, opt.StartingPos.y, true));
                for (var i = 0; i < this.GameData.DragableElements.el.length; i++) {
                    var el = this.game.add.image(positions[i].x, positions[i].y, this.GameData.Prefix + this.GameData.DragableElements.el[i].key);
                    el.inputEnabled = true;
                    el.name = this.GameData.DragableElements.el[i].name;
                    el.input.enableDrag();
                    switch (this.GameData.DragType) {
                        case "OneToOne":
                            el.events.onInputUp.add(this.onInputUp, this);
                            el.events.onInputDown.add(this.onInputDown, this);
                            break;
                        case "GroupsWithOrder":
                            el.events.onInputUp.add(this.onInputUpGroupsWithOrder, this);
                            el.events.onInputDown.add(this.onInputDownGroupsWithOrder, this);
                        case "BigContainer":
                            el.events.onInputDown.add(this.onInputDownBigContainer, this);
                            el.events.onInputUp.add(this.onInputUpBigContainer, this);
                    }
                    this.dragElements.push({
                        "el": el,
                        "startPos": {
                            "x": el.position.x,
                            "y": el.position.y
                        },
                        "paired": false,
                        "correctContainer": this.GameData.DragableElements.el[i].correctContainer,
                        "correctGroup": this.GameData.DragableElements.el[i].correctGroup,
                        "pairedWith": ""
                    });
                    this.addChild(el);
                }
            }
            else {
                for (var i = 0; i < this.GameData.DragableElements.el.length; i++) {
                    var el = this.game.add.image(this.GameData.DragableElements.el[i].pos.x, this.GameData.DragableElements.el[i].pos.y, this.GameData.Prefix + this.GameData.DragableElements.el[i].key);
                    el.inputEnabled = true;
                    el.name = this.GameData.DragableElements.el[i].name;
                    el.input.enableDrag();
                    switch (this.GameData.DragType) {
                        case "OneToOne":
                            el.events.onInputUp.add(this.onInputUp, this);
                            el.events.onInputDown.add(this.onInputDown, this);
                            break;
                        case "GroupsWithOrder":
                            el.events.onInputUp.add(this.onInputUpGroupsWithOrder, this);
                            el.events.onInputDown.add(this.onInputDownGroupsWithOrder, this);
                        case "BigContainer":
                            el.events.onInputDown.add(this.onInputDownBigContainer, this);
                            el.events.onInputUp.add(this.onInputUpBigContainer, this);
                        default:
                            el.events.onInputUp.add(this.onInputUp, this);
                            el.events.onInputDown.add(this.onInputDown, this);
                    }
                    this.dragElements.push({
                        "el": el,
                        "startPos": {
                            "x": el.position.x,
                            "y": el.position.y
                        },
                        "paired": false,
                        "correctContainer": this.GameData.DragableElements.el[i].correctContainer,
                        "correctGroup": this.GameData.DragableElements.el[i].correctGroup,
                        "pairedWith": ""
                    });
                    this.addChild(el);
                }
            }
        };
        DragDrop.prototype.loadGroups = function () {
            this.groupsEnabled = this.GameData.GroupsEnabled;
            if (this.groupsEnabled) {
                this.containersGroups = [];
                if (this.GameData.ContainerGroups != undefined)
                    ;
                for (var i = 0; i < this.GameData.ContainerGroups.length; i++) {
                    var tmp = [];
                    for (var x = 0; x < this.GameData.ContainerGroups[i].el.length; x++) {
                        tmp.push(this.getContainerByName(this.GameData.ContainerGroups[i].el[x].name));
                    }
                    var z = { "name": this.GameData.ContainerGroups[i].name, el: tmp };
                    this.containersGroups.push(z);
                }
            }
        };
        DragDrop.prototype.onInputDownGroupsWithOrder = function (el, pointer) {
            this.getDragElementByName(el.name).pairedWith = "";
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    this.containers[i].dragElementName = "";
                }
            }
            el.bringToTop();
        };
        DragDrop.prototype.onInputUpGroupsWithOrder = function (el, pointer) {
            var index = this.getCorrespondingContainerIndex(el);
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    if (this.containers[i].dragElementName === "") {
                        this.containers[i].dragElementName = el.name;
                    }
                    else {
                        var oldDrag = this.getDragElementByName(this.containers[i].dragElementName);
                        oldDrag.pairedWith = "";
                        oldDrag.el.bringToTop();
                        var returnTween = this.game.add.tween(oldDrag.el);
                        returnTween.to({ x: oldDrag.startPos.x, y: oldDrag.startPos.y }, 500, Phaser.Easing.Circular.InOut);
                        returnTween.start();
                        this.containers[i].dragElementName = el.name;
                    }
                    el.x = this.containers[i].startPos.x;
                    el.y = this.containers[i].startPos.y;
                    this.dragElements[index].paired = true;
                    this.dragElements[index].pairedWith = this.containers[i].name;
                    this.checkCompletedGroupsWithOrder(this.allPaired);
                    return;
                }
            }
            this.dragElements[index].paired = false;
            this.dragElements[index].pairedWith = "";
            EU.Log("game completion set to 0");
            EU.setGameCompletion(this.parent, 0);
            var tw = this.game.add.tween(el);
            tw.to({ x: this.dragElements[index].startPos.x, y: this.dragElements[index].startPos.y }, 500, Phaser.Easing.Circular.InOut);
            tw.start();
        };
        DragDrop.prototype.findCorrectOrders = function (el) {
            var arr = [];
            for (var i = 0; i < this.GameData.DragCorrectOrder.length; i++) {
                for (var j = 0; j < this.GameData.DragCorrectOrder[i].el.length; j++) {
                    if (el === this.GameData.DragCorrectOrder[i].el[j].name) {
                        arr.push(j);
                    }
                }
            }
            return arr;
        };
        DragDrop.prototype.findContainerCorrectOrder = function (el) {
            var arr = [];
            for (var i = 0; i < this.GameData.ContainerGroups.length; i++) {
                for (var j = 0; j < this.GameData.ContainerGroups[i].el.length; j++) {
                    if (el === this.GameData.ContainerGroups[i].el[j].name) {
                        arr.push(j);
                    }
                }
            }
            return arr;
        };
        DragDrop.prototype.checkCompletedGroupsWithOrder = function (allPaired) {
            EU.Log("game completion set to 0");
            EU.setGameCompletion(this.parent, 0);
            var i = 0;
            for (var i = 0; i < this.dragElements.length; i++) {
                console.log(this.dragElements[i].pairedWith);
            }
            if (allPaired)
                for (i = 0; i < this.dragElements.length; i++) {
                    if (!this.dragElements[i].paired)
                        return false;
                }
            for (var i = 0; i < this.dragElements.length; i++) {
                var x = this.findCorrectOrders(this.dragElements[i].el.name);
                var y = this.findContainerCorrectOrder(this.dragElements[i].pairedWith);
                console.log("x " + x);
                console.log("y " + y);
                for (var j = 0; j < x.length; j++)
                    if (x[j] !== y[j])
                        return false;
            }
            EU.setGameCompletion(this.parent, 1);
            EU.Log("completed");
        };
        DragDrop.prototype.onInputDownBigContainer = function (el, pointer) {
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    this.containers[i].dragElementName = "";
                }
            }
            el.bringToTop();
        };
        DragDrop.prototype.onInputDown = function (el, pointer) {
            this.getDragElementByName(el.name).pairedWith = "";
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    this.containers[i].dragElementName = "";
                }
            }
            el.bringToTop();
        };
        DragDrop.prototype.onInputUp = function (el, pointer) {
            var index = this.getCorrespondingContainerIndex(el);
            for (var i = 0; i < this.containers.length; i++) {
                if (this.overlap(el, this.containers[i].el)) {
                    if (this.containers[i].dragElementName === "") {
                        this.containers[i].dragElementName = el.name;
                    }
                    else {
                        var oldDrag = this.getDragElementByName(this.containers[i].dragElementName);
                        oldDrag.pairedWith = "";
                        oldDrag.el.bringToTop();
                        var returnTween = this.game.add.tween(oldDrag.el);
                        returnTween.to({ x: oldDrag.startPos.x, y: oldDrag.startPos.y }, 500, Phaser.Easing.Circular.InOut);
                        returnTween.start();
                        this.containers[i].dragElementName = el.name;
                    }
                    el.x = this.containers[i].startPos.x;
                    el.y = this.containers[i].startPos.y;
                    this.dragElements[index].paired = true;
                    this.dragElements[index].pairedWith = this.containers[i].name;
                    console.log(this.GameData.DragType);
                    if (this.GameData.DragType === "NotAllPaired")
                        this.checkCompletedFilledContainers();
                    else {
                        this.checkCompleted(this.allPaired);
                    }
                    return;
                }
            }
            this.dragElements[index].paired = false;
            this.dragElements[index].pairedWith = "";
            EU.Log("game completion set to 0");
            EU.setGameCompletion(this.parent, 0);
            var tw = this.game.add.tween(el);
            tw.to({ x: this.dragElements[index].startPos.x, y: this.dragElements[index].startPos.y }, 500, Phaser.Easing.Circular.InOut);
            tw.start();
        };
        DragDrop.prototype.checkCompleted = function (allPaired) {
            EU.Log("game completion set to 0");
            EU.setGameCompletion(this.parent, 0);
            var i = 0;
            if (allPaired)
                for (i = 0; i < this.dragElements.length; i++) {
                    if (!this.dragElements[i].paired)
                        return false;
                }
            if (this.groupsEnabled) {
                for (i = 0; i < this.dragElements.length; i++) {
                    if (!this.isElementInCorrectGroup(this.dragElements[i])) {
                        return false;
                    }
                }
            }
            else {
                for (i = 0; i < this.dragElements.length; i++) {
                    if (this.dragElements[i].correctContainer !== this.dragElements[i].pairedWith) {
                        return false;
                    }
                }
            }
            EU.setGameCompletion(this.parent, 1);
            EU.Log("completed");
        };
        DragDrop.prototype.checkCompletedFilledContainers = function () {
            EU.Log(this.containers);
            for (var i = 0; i < this.containers.length; i++) {
                if (this.containers[i].dragElementName === "") {
                    return false;
                }
            }
            for (var i = 0; i < this.containers.length; i++) {
                var temp = this.getDragElementByName(this.containers[i].dragElementName).correctContainer;
                EU.Log(temp);
                if (temp !== this.containers[i].name) {
                    return false;
                }
            }
            EU.setGameCompletion(this.parent, 1);
            EU.Log("completed");
            return true;
        };
        DragDrop.prototype.overlap = function (a, b) {
            var bA = a.getBounds();
            var bB = b.getBounds();
            return Phaser.Rectangle.intersects(bA, bB);
        };
        DragDrop.prototype.isElementInCorrectGroup = function (el) {
            for (var i = 0; i < this.containersGroups.length; i++) {
                if (el.correctGroup === "")
                    return true;
                if (this.containersGroups[i].name === el.correctGroup) {
                    for (var j = 0; j < this.containersGroups[i].el.length; j++) {
                        if (this.containersGroups[i].el[j].name === el.pairedWith)
                            return true;
                    }
                }
            }
            return false;
        };
        DragDrop.prototype.getContainerByName = function (name) {
            for (var i = 0; i < this.containers.length; i++)
                if (this.containers[i].el.name === name)
                    return this.containers[i].el;
        };
        DragDrop.prototype.getDragElementByName = function (name) {
            for (var i = 0; i < this.dragElements.length; i++)
                if (this.dragElements[i].el.name === name)
                    return this.dragElements[i];
        };
        DragDrop.prototype.getCorrespondingContainerIndex = function (el) {
            for (var i = 0; i < this.dragElements.length; i++) {
                if (el === this.dragElements[i].el)
                    return i;
            }
        };
        return DragDrop;
    })(Base.BasicGroup);
    _DragDrop.DragDrop = DragDrop;
})(DragDrop || (DragDrop = {}));
//# sourceMappingURL=DragDrop.js.map