var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Base;
(function (Base) {
    var BasicGroup = (function (_super) {
        __extends(BasicGroup, _super);
        function BasicGroup(game, name, x, y, json) {
            _super.call(this, game, null, name);
            this.x = x;
            this.y = y;
            this.init(json);
        }
        BasicGroup.prototype.init = function (json) {
            this.json = json;
        };
        BasicGroup.prototype.create = function () {
            this.gameCompletion = 0;
            if (this.json.MaxPoints)
                this.maxPoints = this.json.MaxPoints;
            else {
                this.maxPoints = 1;
            }
            this.width = 1920;
            this.height = 1080;
            this.backgroundImage = this.game.add.sprite(0, 0, "background");
            this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            this.addChild(this.backgroundImage);
            var page;
            if (TYPE === "wc") {
                page = this.game.add.image(36, 20, "page");
            }
            else {
                page = this.game.add.image(36, 20, "examPage");
            }
            this.addChild(page);
            if (!this.json.isFirst) {
                var prev = this.game.add.button(95, 960, "prev", this.prevTask, this, 0, 0, 1, 0);
                prev.scale.setTo(0.8, 0.8);
                this.addChild(prev);
            }
            this.nxtButton = this.game.add.button(this.game.width - 76 - 120, 960, "next", this.nextTask, this, 0, 0, 1, 0);
            this.nxtButton.scale.setTo(0.8, 0.8);
            this.addChild(this.nxtButton);
            var txt = this.game.add.text(0, 79, this.json.description, { wordWrap: true, wordWrapWidth: 1200 });
            txt.anchor.set(0.5, 0);
            txt.x = this.game.width / 2;
            this.addChild(txt);
            var spkr = this.game.add.button(1570, 79, "speaker", this.playLector, this, 0, 0, 1, 0);
            this.addChild(spkr);
            this.mainContainer = this.game.add.group(this, "mainContainer");
            this.mainContainer.x = Global.Main.mainContainerDims.x;
            this.mainContainer.y = Global.Main.mainContainerDims.y;
            this.mainContainer.width = Global.Main.mainContainerDims.wd;
            this.mainContainer.height = Global.Main.mainContainerDims.hg;
            this.addChild(this.mainContainer);
        };
        BasicGroup.prototype.showText = function () {
            console.log(this.description);
        };
        BasicGroup.prototype.preload = function () {
            this.game.load.image("background", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_background.jpg");
            this.game.load.spritesheet("prev", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_previous.png", 120, 120, 2);
            this.game.load.spritesheet("next", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_next.png", 120, 120, 2);
            this.game.load.spritesheet("speaker", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_glosnik.png", 68, 56, 2);
            this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_przewodnik_" + CardChooser.getModule() + ".png");
            this.game.load.image("title", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_tytul_" + CardChooser.getModule() + ".png");
            this.game.load.image("cloud", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_dymek_" + CardChooser.getModule() + ".png");
            this.game.load.image("page", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_kartka.png");
            this.game.load.image("examPage", "Graphics/GUI/ALL_sprawdzian_kartka.png");
            this.game.load.spritesheet("finish", "Graphics/GUI/ALL_sprawdzian_button_zakoncz.png", 280, 100, 2, 0, 0);
        };
        BasicGroup.prototype.playLector = function () {
            if (!this.lector) {
                this.lector = new Audio("Sounds/" + this.json.Lector);
            }
            Global.Main.PlayMusic(this.lector);
        };
        BasicGroup.prototype.nextTask = function () {
            if (this.gameCompletion < 1 && TYPE === "wc")
                return false;
            EU.Log("game completion: " + this.gameCompletion);
            this.game.input.enabled = false;
            var tw = this.game.add.tween(this.game.camera);
            tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
            tw.onComplete.add(function () {
                this.game.input.enabled = true;
            }, this);
            tw.start();
            Global.Main.currentPageNumber++;
            Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
            console.log(Global.Main.currentPageNumber);
        };
        BasicGroup.prototype.prevTask = function () {
            if (this.game.camera.x - Global.Main.dims.x > 0) {
                this.game.input.enabled = false;
                var tw = this.game.add.tween(this.game.camera);
                tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
                tw.onComplete.add(function () {
                    this.game.input.enabled = true;
                }, this);
                tw.start();
                Global.Main.currentPageNumber--;
                Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
                console.log(Global.Main.currentPageNumber);
            }
        };
        return BasicGroup;
    })(Phaser.Group);
    Base.BasicGroup = BasicGroup;
    var BeginGroup = (function (_super) {
        __extends(BeginGroup, _super);
        function BeginGroup(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        BeginGroup.prototype.create = function () {
            Global.Main.currentPageNumber = 0;
            this.backgroundImage = this.game.add.sprite(0, 0, "background");
            this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            this.addChild(this.backgroundImage);
            var page;
            if (TYPE === "wc")
                page = this.game.add.image(36, 20, "page");
            else {
                page = this.game.add.image(36, 20, "examPage");
            }
            this.addChild(page);
            var cloud = this.game.add.image(0, 0, "cloud", 0, this);
            cloud.position.setTo(this.width * 0.28, this.height * 0.25);
            var txt = this.game.add.text(0, 0, "Kliknij, aby rozpocząć.", { font: "42pt Arial", wordWrap: true, wordWrapWidth: cloud.width }, this);
            txt.anchor.set(0.55, 0.5);
            txt.position.setTo(cloud.width / 2, cloud.height / 2);
            cloud.addChild(txt);
            cloud.inputEnabled = true;
            cloud.events.onInputUp.add(this.begin, this);
            var guide = this.game.add.image(0, 0, "guide", 0, this);
            guide.position.setTo(this.width - 50 - guide.width, this.height - guide.height);
            this.gameCompletion = 1;
        };
        BeginGroup.prototype.preload = function () {
            this.game.load.image("background", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_background.jpg");
            this.game.load.image("cloud", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_dymek_" + CardChooser.getModule() + ".png");
            this.game.load.image("page", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_kartka.png");
            this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_przewodnik_" + CardChooser.getModule() + ".png");
        };
        BeginGroup.prototype.begin = function () {
            Global.Main.currentPageNumber = 0;
			Global.Main.start_date = new Date();
			console.log("data rozpoczęcia: "+Global.Main.start_date);
            this.nextTask();
        };
        return BeginGroup;
    })(Base.BasicGroup);
    Base.BeginGroup = BeginGroup;
    var EndGroup = (function (_super) {
        __extends(EndGroup, _super);
        function EndGroup(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        EndGroup.prototype.create = function () {
            this.backgroundImage = this.game.add.sprite(0, 0, "background");
            this.backgroundImage.scale.setTo(this.game.width / this.backgroundImage.width, this.game.height / this.backgroundImage.height);
            this.addChild(this.backgroundImage);
            var prev = this.game.add.button(95, 930, "prev", this.prevTask, this, 0, 0, 1, 0);
            prev.scale.setTo(0.8, 0.8);
            var page;
            if (TYPE === "wc") {
                page = this.game.add.image(36, 20, "page");
                this.FinishButton = this.game.add.button(page.width / 2, 920, "finish", this.finishWorkCard, this, 0, 0, 1, 0);
                this.FinishButton.anchor.set(0.5, 0.5);
            }
            else {
                page = this.game.add.image(36, 20, "examPage");
                this.FinishButton = this.game.add.button(page.width / 2, 920, "finish", this.finishExam, this, 0, 0, 1, 0);
                this.FinishButton.anchor.set(0.5, 0.5);
            }
            this.addChild(page);
            this.addChild(prev);
            this.cloud = this.game.add.image(0, 0, "cloud", 0, this);
            this.cloud.position.setTo(this.width * 0.28, this.height * 0.25);
            this.guide = this.game.add.image(0, 0, "guide", 0, this);
            this.guide.position.setTo(this.width - 50 - this.guide.width, this.height - this.guide.height);
            this.addChild(this.FinishButton);
            var txt;
            if (TYPE === "ex") {
                txt = this.game.add.text(0, 0, "To już koniec.Cofnij się by sprawdzić odpowiedzi lub kliknij zakończ", { font: "32pt Arial", wordWrap: true, wordWrapWidth: this.cloud.width - 80 }, this);
                txt.anchor.set(0.55, 0.5);
                txt.position.setTo(this.cloud.width / 2, this.cloud.height / 2);
            }
            else {
                txt = this.game.add.text(10, 0, "Kliknij 'ZAKOŃCZ', aby ukończyć kartę pracy.", { font: "32pt Arial", wordWrap: true, wordWrapWidth: this.cloud.width - 80 }, this);
                txt.anchor.set(0.55, 0.5);
                txt.position.setTo(this.cloud.width / 2, this.cloud.height / 2);
            }
            this.cloud.addChild(txt);
        };
        EndGroup.prototype.finishWorkCard = function () {
            var txt = this.game.add.text(this.game.width / 2, this.game.height / 2, "Ukończono kartę pracy! ", { font: "50pt Arial", wordWrap: true, wordWrapWidth: 1200 });
            txt.anchor.set(0.5, 0.5);
            txt.addColor("#2d842d", 0);
            this.addChild(txt);
            this.FinishButton.visible = false;
            this.cloud.visible = false;
            this.guide.visible = false;
            ScormHelper.ScormHelper.setWorkCardCompleted();
        };
        EndGroup.prototype.finishExam = function () {
            var result = Global.Main.getExamResult();
            var points = result.Score;
            var wrongAnswersString = "";
            for (var i = 0; i < result.WrongAnswers.length; i++) {
                if (i == result.WrongAnswers.length - 1)
                    wrongAnswersString += result.WrongAnswers[i] + " ";
                else {
                    wrongAnswersString += result.WrongAnswers[i] + ", ";
                }
            }
            var face;
            if (points > 0.7)
                face = "buzka1";
            else if (points > 0.5)
                face = "buzka2";
            else if (points === 0.5)
                face = "buzka3";
            else if (points > 0.3)
                face = "buzka4";
            else
                face = "buzka5";
            var txt = this.game.add.text(this.game.width / 2, 176, "Twój wynik to: ", { font: "50pt Arial", wordWrap: true, wordWrapWidth: 1200 });
            txt.anchor.set(0.5, 0);
            this.addChild(txt);
            var txt2 = this.game.add.text(this.game.width / 2, 342, Math.round(points * 100) + "%", { font: "136pt Arial", fontWeight: "bold", wordWrap: true, wordWrapWidth: 1200 });
            txt2.anchor.set(0.5, 0);
            txt2.addColor("#ff0000", 0);
            this.addChild(txt2);
            if (wrongAnswersString !== "") {
                var txt3 = this.game.add.text(this.game.width / 2, (this.game.height / 2) + 100, "Zadania które zostały wykonane z błędem:", { font: "42pt Arial", wordWrap: true, wordWrapWidth: 1200 });
                txt3.anchor.set(0.5, 0);
                this.addChild(txt3);
                var wrongAnswers = this.game.add.text(this.game.width / 2, (this.game.height / 2) + 200, wrongAnswersString, { color: "#ff0000", font: "42pt Arial", wordWrap: true, wordWrapWidth: 1200 });
                wrongAnswers.anchor.set(0.5, 0);
                wrongAnswers.addColor("#ff0000", 0);
                this.addChild(wrongAnswers);
            }
            var faceObject = this.game.add.sprite(1287, 236, face);
            this.addChild(faceObject);
            this.FinishButton.visible = false;
            this.cloud.visible = false;
            this.guide.visible = false;
            ScormHelper.ScormHelper.setExamCompleted("0", result.MaxPoints.toString(), result.Acquired.toString());
        };
        EndGroup.prototype.preload = function () {
            this.game.load.spritesheet("prev", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_button_previous.png", 120, 120, 2);
            this.game.load.image("background", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_background.jpg");
            this.game.load.image("cloud", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_dymek_" + CardChooser.getModule() + ".png");
            this.game.load.image("page", "Graphics/GUI/" + CardChooser.getModule() + "/" + CardChooser.getModule() + "_karta_pracy_kartka.png");
            this.game.load.image("guide", "Graphics/GUI/" + CardChooser.getModule() + "/SPR_tytulowa_przewodnik_" + CardChooser.getModule() + ".png");
            this.game.load.image("buzka1", "Graphics/GUI/ALL_sprawdzian_buzka1.png");
            this.game.load.image("buzka2", "Graphics/GUI/ALL_sprawdzian_buzka2.png");
            this.game.load.image("buzka3", "Graphics/GUI/ALL_sprawdzian_buzka3.png");
            this.game.load.image("buzka4", "Graphics/GUI/ALL_sprawdzian_buzka4.png");
            this.game.load.image("buzka5", "Graphics/GUI/ALL_sprawdzian_buzka5.png");
        };
        return EndGroup;
    })(Base.BasicGroup);
    Base.EndGroup = EndGroup;
})(Base || (Base = {}));
//# sourceMappingURL=Base.js.map