﻿module SelectText {
    export class SelectText extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;
        SourceText: any[];
        TextToFind: any[];
        numberOfChecked: any;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }
        loadGraphics() {
        
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }

            this.numberOfChecked = 0;
            this.createSourceText();
            this.createTextToFind()
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        createTextToFind() {
            this.TextToFind = this.Elements.TextToFind;
        }

        createSourceText() {
            this.SourceText = [];
            var verses = this.Elements.SourceText.Text.split("\n");
            var posX = this.Elements.SourceText.Position.x;
            var posY = this.Elements.SourceText.Position.y;
            var style = this.Elements.SourceText.Style;
            var counter = 0;
            for (var i = 0; i < verses.length; i++) {
                var words = verses[i].split(" ");
                counter++;
                var el = this.game.add.text(0, 0, words[0], style);
                var versePosY = posY + i * el.height;
                el.position.set(posX, versePosY);
                el.inputEnabled = true;
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                el.events.onInputDown.add(this.onWordClicked, this);
                this.SourceText.push(el);
                this.addChild(el);
                for (var j = 1; j < words.length; j++) {                  
                    el = this.game.add.text(0, 0, words[j], style);
                    el.position.set(
                        this.SourceText[counter - 1].position.x
                        + this.SourceText[counter - 1].width
                        + this.SourceText[counter - 1].height / 3,
                        versePosY
                        );
                    el.inputEnabled = true;
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    el.events.onInputDown.add(this.onWordClicked, this);
                    this.SourceText.push(el);
                    this.addChild(el);
                    counter++;
                }
            }
        }
        //input

        private onInputOver(el: Phaser.Text, pointer) {
            el.alpha = 0.5;
        }

        private onInputOut(el: Phaser.Text, pointer) {
            el.alpha = 1.0;
        }

        private onWordClicked(el: Phaser.Text, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";
            }
            else {
                el.setShadow(1, 1, "red");
                this.numberOfChecked++;
                el.name = "checked";
            }
            this.checkIfEverythingIsCorrect();
        }

        private checkIfEverythingIsCorrect() {
            EU.Log("Points: " + this.calculatePlayerPoints()
                + "/" + this.calculateMaxPoints()
                + " Checked: " + this.numberOfChecked); 

            var maxPoints = this.calculateMaxPoints()
            if (this.calculatePlayerPoints() == maxPoints
                && this.numberOfChecked == maxPoints) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        }


        private calculateMaxPoints() {
            var points = 0;
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 1; j < this.TextToFind.length; j++) {
                    if (this.SourceText[i].text == this.TextToFind[j])
                        points++;
                }
            }
            return points;
        }

        private calculatePlayerPoints() {
            var points = 0;
            for (var i = 0; i < this.SourceText.length; i++) {
                if (this.SourceText[i].name == "checked") {
                    for (var j = 1; j < this.TextToFind.length; j++) {
                        if (this.SourceText[i].text == this.TextToFind[j])
                            points++;
                    }
                }
            }
            return points;
        }

    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////            FORMAT JSONA           ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    JSON = {
//              completeText: "caly tekst do wyswietlenia",
//              searched: [["znak lub wyraz", (true/false || true szuka znaku lub wyrazu oddzielonego spacjami, kropka, myslnikiem lub cudzyslowiem; false szuka podciągu)], [], []]    
//           }
