﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
//-------------------------------------------------------------------------------------------
//pg2-limit time for some pages
function __LimitTimeForQuizTimer() //pg2-limit timer
{
	this.id = null;
	this.interval = 10000; //10 sec
	this.pageBeforeQuizGIX = -1;
	this.pageAfterQuizGIX = -1;
	this.pagesWithinQuiz = new Array();
	this.busy = 0;
	this.ready = 0;
	this.paramsSeparator = '||';
	this.correctParamsLength = 4;
	this.quizPagesSeparator = ',';

	this.subID = null;
	this.subBusy = 0;
	this.dateEnd = 0;
};

__LimitTimeForQuizTimer.prototype.onInterval = function()
{
	try {
		this.stop();
		this.ready = 0;
		this.busy = 0;
		if (!player) return;
		try {
			if (player.gotoPage) player.gotoPage(this.pageAfterQuizGIX);
			/*
			var frm = player.getFrame(player.gix).frame;//player.getFrame(player.gix).frame.PageInterface.connectedPage; //player.getFrame(player.gix).PlayerInterface.connectedPage;
			if (frm) {
				frm.pc.timerText.setHTML("bla");
			}*/
		} catch(e) {};
	} catch(e) {};
};

__LimitTimeForQuizTimer.prototype.subInterval = function()
{
	try {
		window.clearTimeout(this.subID);
		if (this.dateEnd == 0) {
			this.subBusy = 0;
			return;
		};
		var date2 = new Date();
		var ms2 = date2.getTime();

		var timeShift = this.dateEnd - ms2;
		if (timeShift < 0) { //pg2-bi_AKA_completion
			this.stop();
			if (player) player.gotoPage(this.pageAfterQuizGIX);
			return;
		};
		
		var str = calculateTimeIntToString(timeShift/1000, true);
		var dotPos = str.indexOf('.');
		if (dotPos > 0) str = str.substr(0, dotPos);

		var frm = null;
		if (player) { //pg2-bi_AKA_completion
			if (player.enablePagesPreloader) {
				frm = player.getFrame(player.gix).frame; //if on a page there is text component named 'timerText' - withing it will be displayed remaining time for a quiz
			} else {
				frm = player.findFrame("content");
			};
			if (frm) {
				if (frm.pc && frm.pc.timerText) {
					frm.pc.timerText.text = str; //pg2-bi_AKA -font
					frm.pc.timerText.orgText = str;
					frm.pc.timerText.paint();
					
					//frm.pc.timerText.setHTML(str);
					//frm.pc.timerText.show();
				};
			};
		};
		if (this.subBusy) this.subID = window.setTimeout('player.limitQuizTimeTimer.subInterval();', 500);
	} catch(e) {
		this.subBusy = 0;
	};
};

__LimitTimeForQuizTimer.prototype.start = function()
{
	if (!this.ready || this.busy) return;
	this.stop();
	try {
		this.id = window.setTimeout('player.limitQuizTimeTimer.onInterval();', this.interval);
	} catch(e) {
		this.busy = 0;
	};
	try { 
		var dt = new Date();
		this.dateEnd = dt.getTime() + this.interval;
		this.subID = window.setTimeout('player.limitQuizTimeTimer.subInterval();', 500);
		this.subBusy = 1;
		//
	} catch(e) {
		this.subBusy = 0;
	};
};

__LimitTimeForQuizTimer.prototype.stop = function()
{
	window.clearTimeout(this.id);
	this.id = null;
	this.busy = 0;
	this.dateEnd = 0;
	this.subBusy = 0;
	window.clearTimeout(this.subID);
	this.id = null;
	this.subID = null;
};

__LimitTimeForQuizTimer.prototype.notifyNavigateToPage = function(GIX)
{
	if (typeof(GIX) == "undefined") return;
	if (!this.ready) return;
	if (GIX == -1) {
		this.stop();
		return;
	};
	try {
		var pageGIX = parseInt(GIX);
		if (pageGIX == this.pageAfterQuizGIX && this.busy) {
			this.stop();
			return;
		};

		var pageInArray = false;
		var pageInArrayNo = -1;
		for (var i=0; i<this.pagesWithinQuiz.length; i++) {
			var pageGIXFromArray = this.pagesWithinQuiz[i];
			if (pageGIXFromArray == pageGIX) {
				pageInArray = true;
				pageInArrayNo = i;
				break;
			};
		};
		if (pageInArray && pageInArrayNo == 0) {
			this.start(); //1st quiz page, start timer
		};
		if (!pageInArray) this.stop();

	} catch(e) {
		//
	};
};

__LimitTimeForQuizTimer.prototype.setParameters = function(params) // pageBeforeQuizGIX || quizPage1, quizPage2, ..., guizPageN || pageAfterQuizGIX || interval
{
	if (this.busy) return;
	this.ready = 0;
	if (typeof(params) == "undefined") return;
	if (params == "") return;

	try {
		var paramsList = params.split(this.paramsSeparator);
		if (paramsList.length != this.correctParamsLength) return;

		//page before quiz
		var pageGIX = 0;
		try {
			pageGIX = parseInt(paramsList[0]);
		} catch(e) {
			pageGIX = -1;
		};
		if (pageGIX < 2) return;
		this.pageBeforeQuizGIX = pageGIX; //

		//page after quiz
		pageGIX = 0;
		try {
			pageGIX = parseInt(paramsList[2]);
		} catch(e) {
			pageGIX = -1;
		};
		if (pageGIX < 2) return;
		this.pageAfterQuizGIX = pageGIX;

		//timer interval - time to go through all quiz pages
		var interval = 0;
		try {
			interval = parseInt(paramsList[3]);
		} catch(e) {
			interval = -1;
		};
		if (interval < 1000) return;
		this.interval = interval;

		// remove all elements from array
		delete this.pagesWithinQuiz;
		this.pagesWithinQuiz = new Array();

		//quiz pages
		var quizPages = paramsList[1];
		var quizPagesArray = quizPages.split(this.quizPagesSeparator);
		if (quizPagesArray.length == 0) return;
		var parseError = 0;
		for (var i=0; i<quizPagesArray.length; i++) {
			try {
				pageGIX = parseInt(quizPagesArray[i]);
				if (pageGIX < 2) {
					parseError = 1;
					break;
				} else {
					this.pagesWithinQuiz.push(pageGIX);
				};
			} catch(e) {
				parseError = 1;
				break;
			};
		};
		if (parseError == 1) return;

		this.ready = 1;
	} catch(e) {
		this.ready = 0;
		this.busy = 0;
	};
};

//-------------------------------------------------------------------------------------------
function __Frame()
{
	this.locked = false;
	this.content = false;
	this.gix = -1;
	this.frame = null;
};

function __Timer()
{
	this.interval = 250;
	this.tryCounter = 0;
	this.id = null;
};

__Timer.prototype.onInterval = function()
{
	this.stop();
	var frm = player.getFrame(player.gix);
	if (!frm) {
		player.pgPreloaderLoad(player.gix);
		frm = player.getFrame(player.gix);
	};
	if (frm) {
		if (frm.frame.PlayerInterface 
			&& frm.frame.PlayerInterface.connectedPage 
			&& player.gix == frm.frame.PlayerInterface.connectedPage.p_globalIndex) 
		{ 
			if (!frm.frame.PlayerInterface.connectedPage.allowPreload) {
				return;
			};
			if ((frm.frame.PlayerInterface.connectedPage.waitingForRun) || (this.tryCounter > 20)) {
				this.tryCounter = 0;
				frm.frame.PlayerInterface.connectedPage.loadContent();
			} else 
			if (frm.frame.PlayerInterface.connectedPage.isRuning) {
				player.preloadPages(player.gix);
				return;
			};
		} else {
			try { //pg2-in case of https:// and a course in new window, there could be an exception- just intercept it, do nothing
				if (frm.frame.extContent) {
					if ((frm.frame.waitingForRun) || (this.tryCounter > 20)) {
						this.tryCounter = 0;
						frm.frame.loadContent();
					} else
					if (frm.frame.isReady) {
						player.preloadPages(player.gix);
						return;
					};
				};
			} catch(e) {};
		};
	};
	this.tryCounter++;
	this.run();
};

__Timer.prototype.run = function()
{
	this.stop();
	this.id = window.setTimeout('__timer.onInterval();', this.interval);
};

__Timer.prototype.stop = function()
{
	if (this.id != null) {
		window.clearTimeout(this.id);
		this.id = null;
	};
};

var __timer = new __Timer();

// debugger
var ___cool_timer_enabled = false;
var ___cool_timer_turn = false;
var ___cool_timer_last_gix = -1;
var ___cool_timer = null;
var ___cool_timer_interval = 1000;

function ___cool_timer_stop() {
	if (___cool_timer != null) {
		window.clearTimeout(___cool_timer);
		___cool_timer = null;
	};
};

function ___cool_timer_start() {
	___cool_time = window.setTimeout('___cool_timer_onInterval();', ___cool_timer_interval);
};

function ___cool_timer_onInterval() {
	___cool_timer_stop();
	if (!___cool_timer_turn) {
		if (player.further()) ___cool_timer_last_gix = -1;
	} else {
		player.backwards();
	};
	if (___cool_timer_last_gix == player.gix) {
		___cool_timer_turn = !___cool_timer_turn;
	};
	___cool_timer_last_gix = player.gix;
	___cool_timer_start();
};
// debugger end

var UserAPI = {
	set: function(k,v){},
	get: function(){return '';},
	eventGotoPage: function(g,b){}
};

function Player()
{
	// debugger
	this.gixF = -1;
	this.gixL = -1;
	// debugger end

	this.STATUS_NOT_ATTEMPTED = "not attempted";
	this.STATUS_INCOMPLETE = "incomplete";
	this.STATUS_COMPLETED = "completed";
	this.STATUS_UNKNOWN = "unknown";
	this.STATUS_PASSED = "passed";
	this.STATUS_FAILED = "failed";

	this.gix = 0;
	this.last_gix = 0;
	this.framesToLoad = 0;
	this.baseurl = location.href.split("?");
	this.naviPathToRoot = this.baseurl[0].substring(0, this.baseurl[0].lastIndexOf('/')) + '/';
	this.sid = this.createSID();

	this.isLightVersion = false;
	this.courseVersion = 0;

	if (this.naviPathToRoot == "") this.naviPathToRoot = location.href.substring(0, location.href.lastIndexOf('\\')) + '/';

	this.setupURIParams();

	this.enablePagesPreloader = false;
	this.pagesPreloaderFrame = null;
	this.pagesPreloaderContentFrame = null;
	//this.pgPreloaderSrc = this.naviPathToRoot;
	this.isLoaded = false;
	this.wasLoaded = false;
	this.passLevel = 100;

	this.gix_offset = 0;
	this.down_max = 1;
	this.up_max = 2;
	this.pg_max = 1;

	this.__frames = new Object();
	this.pageChanged = null;
	this.startTime = new Date();
	this.debugMode = false;
	this.lmsTimer = null;
	this.activTimer = null;
	this.updateLMSTimeInterval = 0; //co ile wysłać info do lms'a o: stronie na ktorej jestem
	this.lastActiveStudentTime = new Date(); //ostatnia atywnosc studenta
	this.activityTime = 0; //laczny czas aktywnosci studenta w tej sesji jako int w sek
	this.lessonBreak = false; //jesli true nie licz aktuwnosci i nie pokazuj warning popup
	//dbg course
	this.resetCourseData = false;  
	this.dbgCourseScore = -1;  
	this.dbgCourseStatus = ""; 
	this.reinitializeTree = false; //pg2-bsh -for repainting statuses of pages in template's tree

	this.openWindows = new Array();
	this.pageFirstStepListeners = new Array();
	this.pageLastStepListeners = new Array();

	this.courseHasInteractions = true; //pg2

	this.limitQuizTimeTimer = new __LimitTimeForQuizTimer(); //pg2-limit timer
	//this.limitQuizTimeTimer.setParameters("2||3,4,5,6,7||8||3000"); //pg2-limit timer test
	this.frameContent = null;
	this.chunkTime = ''; //pg2-knf
	this.knfControlGotoPage = false; //pg2-knf -if course is blocked (timeout), do not allow navigation
	this.lessonMode = "normal"; //pg2-knf-lesson_mode
	this.IsStudentActive = true; //pg2-knf -inactivity timer
	this.allowSendTime = true; //pg2-knf
	this.totalTime = 0;
	
	this.lastPageGIX = -1; //pg2-last page in the course
	this.eisLangCode = ''; //pg2-liag_multiversions
	this.directionForward = true; //pg2-mobile_pages
	this.deleteBackToPageAddress = false; //pg2-pga -back2PageReset

	this.sendingData2LMS_OK = true; //pg2-BI_iPad_connection
};

Player.prototype.getUserAPI = function() {
	return UserAPI;
}

Player.prototype.limitQuizTimeInit = function(params)
{
	if (typeof(params) == "undefined") params = "";
	if (this.limitQuizTimeTimer) this.limitQuizTimeTimer.setParameters(params);
};

Player.prototype.limitQuizTimeStart = function()
{
	if (!this.limitQuizTimeTimer) return;
	this.limitQuizTimeTimer.start();
};

Player.prototype.limitQuizTimeStop = function()
{
	if (!this.limitQuizTimeTimer) return;
	this.limitQuizTimeTimer.stop();
};

Player.prototype.limitQuizTimeNotifyNavigateToPage = function(params)
{
	if (!this.limitQuizTimeTimer) return;
	if (typeof(params) == "undefined") return;
	if (params == "") params = -1;
	this.limitQuizTimeTimer.notifyNavigateToPage(params);
};

Player.prototype.findTypeAndCallFunc = function(type, func)
{
	//this
	try {
		if (player) { //pg2
			var frm = player.getFrame(player.gix);
			if (frm && frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
				frm.frame.PlayerInterface.connectedPage.findTypeAndCallFunc(type, func);
			} else 
			if (typeof(page) == "object") {
				page.findTypeAndCallFunc(type, func);
			};
		};
	} catch(e) {};
	//child
	for (var i in this.openWindows) {
		try {
			var w = this.openWindows[i];
			w.page.findTypeAndCallFunc(type, func);
		} catch(e) {}
	};
	//parent
	try {
		if (opener) { //pg2
			if (typeof(opener.getPlayer) == "function") { //pg2- 'function' instead 'object'
				var p = opener.getPlayer();
				if (p) {
					p.findTypeAndCallFunc(type, func);
				};
			};
		};
	} catch(e) {};
};

Player.prototype.addSubWindowToList = function(winHandle) //pg2-close win when main window is closed
{
	if (typeof(winHandle) == 'undefined' || winHandle == null) return;
	
	this.openWindows[this.openWindows.length] = winHandle;
};

Player.prototype.closeAllSubWindows = function() //pg2-coig_page_print
{
	if (this.openWindows && this.openWindows.length > 0) {
		try {
			for (var i=0; i<this.openWindows.length; i++) {
				var win = this.openWindows[i];
				try {
					win.close();
				} catch(e) {};
			};
			delete this.openWindows;
			
			this.openWindows = new Array();
		} catch(e) {};
	};
};

Player.prototype.setupURIParams = function()
{
	var v = getURIParam("wbteLightVersion");
	if (v == "true" || v == "1") {
		this.isLightVersion = true;
	};
	var v = getURIParam("wbteVersion");
	if (v != "") {
		this.courseVersion = v;
	};
};

Player.prototype.setLightVersion = function(b)
{
	this.isLightVersion = (b == true);
	this.gotoPage(this.gix);
};

Player.prototype.getLightVersion = function()
{
	return this.isLightVersion;
};

//jk  move to uelo
Player.prototype.getLessonStatusWithoutSendIdPage = function(thisId)
{
	for (var i = 0; i < struct.length(); i++) {
		if ((struct.item(i)["visible"] == "1") && (struct.item(i)["index"] != thisId)) 
			if (struct.item(i)["status"] == "I" || struct.item(i)["status"] == "N") return this.STATUS_INCOMPLETE;
	};
	return this.STATUS_COMPLETED;
};

Player.prototype.getStatusPassedFailed = function(isCompleted) //pg2-bsh_score_if_completed -parameter
{
	var score = this.getTotalScore(isCompleted); //pg2-bsh_score_if_completed -parameter

	if (score == "") {
		return this.STATUS_UNKNOWN;
	} else {
		if (score >= uelo.passThreshold) { //pg2-there was another 'this.getTotalScore()' -what for? in case 3000 pages...
			return this.STATUS_PASSED;
		} else {
			return this.STATUS_FAILED;
		};
	};
};

Player.prototype.getPercCompletedFailedPassed = function()
{
	var allVisible = 0;
	var allCounted = 0;

	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0") continue;
		if (item["visible"] == "1") {
			if (item["status"] == "C" || item["status"] == "P" || item["status"] == "F") {
				allCounted++;
			};
			allVisible++;
		};
	};
	var prec = parseInt((allCounted/allVisible*100).toFixed(0));
	return prec;
};

Player.prototype.getAllPagesCount = function() //modyfication from MK
{
	var allVisible = 0;
	var allCounted = 0;

	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0" || item["visible"] == "0") continue; //pg2-item's visibility // || instead of &&
		if (item["visible"] == "1") {
			if (item["status"] == "C" || item["status"] == "P" || item["status"] == "F") {
				allCounted++;
			};
			allVisible++;
		};
	};
	return allVisible;
};

Player.prototype.getVisitedPagesCount = function() //modyfication from MK
{
	var allVisible = 0;
	var allCounted = 0;

	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0" || item["visible"] == "0") continue; //pg2-item's visibility // || instead of &&
		if (item["visible"] == "1") {
			if (item["status"] == "C" || item["status"] == "P" || item["status"] == "F") {
				allCounted++;
			};
			allVisible++;
		};
	};
	return allCounted;
};

Player.prototype.getStatusCompletedIncompleted = function()
{
	var wasSolved = false; //pg2-qr2 -fix to completion_status
	var wasReallyMixed = false;
	if (struct.isCourseMixed) {
		wasSolved = this.checkExamWasSolved();
		wasReallyMixed = uelo.wasReallyMixed();
	};

	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0") continue;
		if (item["visible"] == "1") {
			if (item["status"] == "I" || item["status"] == "N") {
				if (struct.isCourseMixed && wasReallyMixed) {
					var p = uelo.FindPage(item["gix"]); //pg2-qr2 -completion status in case of mixed course (singleSCO course->exam, or quizRandomizer)
					if (p) {
						if (p.isExamPage && !p.isAssessment) continue;
						if (p.isExamPage && p.isAssessment && uelo.previousMixedStructure == "") return this.STATUS_INCOMPLETE; else
						if (p.isExamPage && p.isAssessment && uelo.previousMixedStructure != "" && wasSolved) return this.STATUS_INCOMPLETE;
						if (p.isExamPage && p.isAssessment && uelo.previousMixedStructure != "" && !wasSolved) continue; else
						if (!p.isExamPage) return this.STATUS_INCOMPLETE; 
					};
				} else
				return this.STATUS_INCOMPLETE;
			};
		};
	};
	return this.STATUS_COMPLETED;
};

Player.prototype.getProgressMeasure = function()
{
	var pss = 0;
	var count = 0;
	
	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0" || item["visible"] == "0") continue; //pg2-bsh_score_if_completed -item's visibility
		count++
		if ((item["status"] == "C" && item["ms"] == "") || //pg2-bsh_score_if_completed - ("ms") if 10 exercise pages, 2 solved, 8 visited -> progress diff than 2 solved and 8 failed
			(item["status"] == "P" || item["status"] == "F") || //pg2-bsh_score_if_completed - ("Failed") -to adjust it to scorm2004 specs
			(!this.courseHasInteractions && item["status"] == "F")) //pg2-completion -if course has no interactions (but on some page answer was checked without exercise component...
		{
			pss++;
		};
	};

	if (pss == count) {
		return "1.0";
	} else if (pss == 0) {
		return "0.0";
	} else {
		if (config.progressMeasure3State) {
			return "0.5";
		} else {
			return (pss / count).toFixed(2);
		};
	};
};

Player.prototype.getLessonStatus = function()
{
	if (this.dbgCourseStatus != "") return this.dbgCourseStatus;

    if (config.sendPassedFailedToServer) {
		return this.getStatusPassedFailed();
    } else {
		return this.getStatusCompletedIncompleted();
    };
};

Player.prototype.getLessonCIPF = function(pf)
{
	if (pf) {
		var result = this.STATUS_UNKNOWN;
	} else {
		var result = this.STATUS_NOT_ATTEMPTED;
	};
	var stLen = struct.length();
	for (var i = 0; i < stLen; i++) {
		var item = struct.item(i);
		if (item["visible"] == "1") {
			var as = item["status"];
			if (pf) {
				if (as == "F") {
					return this.STATUS_FAILED;
				} else 
				if (as == "P") {
					result = this.STATUS_PASSED;
				};
			} else {
				if (as == "I" || as == "N") {
					return this.STATUS_INCOMPLETE;
				} else 
				if (as == "C") {
					result = this.STATUS_COMPLETED;
				};
			};
		};
	};
	return result;
};

//jk  move to uelo
Player.prototype.getItemStatus = function(index)
{
	if (index == null || index == "undefined") index = this.gix;
	var itemStatus = struct.findItem(index)["status"];
	switch (itemStatus) {
		case "N": return this.STATUS_NOT_ATTEMPTED; break;
		case "I": return this.STATUS_INCOMPLETE; break;
		case "C": return this.STATUS_COMPLETED; break;
		case "P": return this.STATUS_PASSED; break;
		case "F": return this.STATUS_FAILED; break;
	};
};

Player.prototype.checkPageStatus = function(index, status, checkChildren)
{
	if (index == null || index == "undefined") index = this.gix;
	var item = struct.findItem(index);
	var result = this.inArray(this.getItemStatus(item["gix"]), status.split(","));
	if (checkChildren) {
		for (var i=0; i < struct.length(); i++) {
			var childItem = struct.item(i);
			if (childItem["parent"] == item["index"]) {
				if (this.hasChildren(childItem["gix"])) {
					result = result + this.checkPageStatus(childItem["gix"], status, checkChildren);
				} else {
					result = result + this.inArray(this.getItemStatus(childItem["gix"]), status.split(","));
				};
			};
		};
	};
	return result;
};

Player.prototype.hasChildren = function(index)
{
	if (index == null || index == "undefined") index = this.gix;
	var item = struct.findItem(index);
	for (var i = 0; i < struct.length(); i++) {
		var childItem = struct.item(i);
		if (childItem["parent"] == item["index"]) return true;
	};
	return false;
};

Player.prototype.loadContent = function(gix)
{
	if (this.enablePagesPreloader) return;
	this.setSessionTime();
	this.gix = gix;

	var tree_frame = this.findFrame("tree");
	if (tree_frame && tree_frame.expandMyParents) tree_frame.expandMyParents(this.gix); //pg2-check if 'expandMyParents' exists as well
	var item = struct.findItem(gix);

	this.updateTemplateProgress(item);

	if (item) {
		var link = this.naviPathToRoot + item["href"];
		if (item["type"] == "0") {
			link += '_page.' + this.courseVersion;
			if (this.isLightVersion) {
				link += '.light';
			};
			link += '.html';
		};
		this.loadContentFrameset(link);
		this.setNaviHtml("_page_no_navi", struct.getVisibleItemsIndex(this.gix) + " / " + struct.getVisibleItemsCount());

		this.updateTemplateTitle(item);
	};
};

Player.prototype.resetCourseFrames = function()
{
	var course_frame = this.findFrame("course_frame");
	if (course_frame && course_frame.setFrames) {
		return course_frame.setFrames();
	};
	return false;
};

Player.prototype.getChapterNumbering = function(gix) //pg2-BI_BM_AKA -dynamic pages within chapters numbering
{
	if (checkExportType(config.exportDetails, "multi")) return [-1,-1];
	
	return struct.getChapterNumbering(gix);
}

Player.prototype.getVisibleItemsIndex = function()
{
	if (config && config.exportDetails == 'exam') { //pg2-in exam for =%PAGE_NO
		return parseInt(parent.currentIDSCOidx) + 1;
	} else {
		var page_no = struct.getVisibleItemsIndex(this.gix);
		//pg2-mobile_pages
		if (typeof(suspendData) != 'undefined' && typeof(suspendData.me) != 'undefined' &&
			typeof(suspendData.me.pagesMobile) != 'undefined' && typeof(suspendData.me.pagesPC) != 'undefined' &&
			suspendData.me.pagesMobile != '' && suspendData.me.pagesPC != '' && typeof(struct) != 'undefined')
		{
			var pMobile = suspendData.me.pagesMobile.split(',');
			var pPC = suspendData.me.pagesPC.split(',');
			
			var tableIndexOf = function(tab, value) { //in case of IE
				var result = -1;
				for (var i=0; i<tab.length; i++) {
					if (tab[i] == value) {
						result = i; break;
					};
				};
				return result;
			};
			//
			var baseCount = page_no;
			var subCount = 0;
			for (var i=0; i<struct.length(); i++) {
				var item = struct.m_list[i];
				if (item) {
					var i_pc = -1;
					var i_mobile = -1;
					if (is.ie) {
						i_mobile = tableIndexOf(pMobile, item['gix']);
						i_pc = tableIndexOf(pPC, item['gix']);
					} else {
						i_mobile = pMobile.indexOf(item['gix']);
						i_pc = pPC.indexOf(item['gix']);
					};
					if (i_pc != -1 || i_mobile != -1) subCount++;// baseCount--;
					if (item['gix'] == this.gix) break;
				};
			};
			//
			page_no -= parseInt(subCount/2);
			//page_no = baseCount;
			delete pMobile;
			delete pPC;
		};
		//...
		return page_no;
	};
};

Player.prototype.getVisibleItemsCount = function()
{
	if (config && config.exportDetails == 'exam') { //pg2-in exam for =%PAGES_COUNT
		var currentSCONo = parseInt(parent.currentIDSCOidx) + 1;
		if (typeof(top.KP_pagesCount) == 'undefined' || currentSCONo == 1) {
			top.KP_pagesCount = 0;
			var treeFrame = findFrame('Menu', top);
			if (treeFrame) {
				var pagesCount = 0;
				for (var i=0; i<1000; i++) {
					var trObj = null;
					try {
						trObj = treeFrame.document.getElementById('item_' + i);
						if (trObj) pagesCount++; else break;
					} catch(e) {};
				};
				top.KP_pagesCount = pagesCount;
			};
		};
		return top.KP_pagesCount;
	} else {
		var pages_count = struct.getVisibleItemsCount();
		//pg2-mobile_pages
		if (typeof(suspendData) != 'undefined' && typeof(suspendData.me) != 'undefined' &&
			typeof(suspendData.me.pagesMobile) != 'undefined' && typeof(suspendData.me.pagesPC) != 'undefined' &&
			suspendData.me.pagesMobile != '' && suspendData.me.pagesPC != '')
		{
			var pMobile = suspendData.me.pagesMobile.split(',');
			var newPagesCount = pages_count - pMobile.length;
			if (newPagesCount > 0) pages_count = newPagesCount;
			delete pMobile;
		};
		//...
		return pages_count;
	};
};

Player.prototype.getStartPage = function()
{
	var g = getCommandUrl('gix', player.findFirstPage());
	return g;
};

Player.prototype.findFirstPage = function(status)
{
	if (status != null && status != "undefined") {
		for (var i=0; i < struct.length(); i++) {
			var item = struct.item(i);
			var res = this.inArray(this.getItemStatus(item["gix"]), status.split(","));
			if (item["visible"] != "1") continue;
			if (item["href"] != "" && res) return item["gix"];
		};
	};
	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["visible"] != "1") continue;
		if (item["href"] != "") return item["gix"];
	};
	return null;
};

Player.prototype.findLastPageGIX = function() //pg2-moved from uelo and - fixed (it wasn't working in case of drawing pages)
{
	this.lastPageGIX = -1;
	if (!struct) return -1;
	if (struct.m_list.length == 0) return -1;
	for (var i=struct.m_list.length-1; i>=0; i--) {
		var item = struct.m_list[i];
		if (item && item["visible"] == '1') {
			this.lastPageGIX = parseInt(item['gix']);
			return this.lastPageGIX;
		};
	};
	return -1;
};

Player.prototype.setCourseCompletedAndPassed = function(updateTree) //pg2
{
	if (uelo) {
		for (var i=0; i<uelo.pages.length; i++) {
			var p = uelo.pages[i];
			if (p && p.visible) {
				if (p.pageType == 'Exercise') {
					p.status = 'P';
					p.score = 100;
				} else
				if (p.pageType == 'Information') {
					p.status = 'C';
				} else
				if (p.pageType == 'Poll') {
					p.status = 'C';
				};
			};
		};
	};
	
	if (struct) {
		for (var i=0; i<struct.m_list.length; i++) {
			var item = struct.m_list[i];
			if (item && item['visible']) {
				if (item['ms'] == '') item['status'] = 'C'; else item['status'] = 'P';
			};
		};
		try {
			if (typeof(updateTree) == 'undefined') updateTree = false;
			var treeFrame = findFrame('tree', top);
			if (treeFrame) treeFrame.initialize();
		} catch(e) {};
	};
};

Player.prototype.findParent = function(index)
{
	if (index == null || index == "undefined") index = this.gix;
	var currentItem = struct.findItem(index);

	for (var i=0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["href"] != "" && item["index"] == currentItem["parent"]) return item["gix"];
	};
	return null;
};

Player.prototype.restoreExitPage = function(gix)
{
	var isMixed = (struct.firstOffsetPages != 0 || struct.lastOffsetPages != 0 || struct.countShowPages != 0);

	var item = null;
	if (isMixed) {
		item = struct.findItem(gix);
		if (item) {
			if (item.isExamPage == 1) {
				this.gotoPage(struct.examParentGix);
			} else {
				this.gotoPage(gix);
			};
		} else {
			this.gotoPage(struct.examParentGix);
		};
	} else {
		this.gotoPage(gix);
	};
};

Player.prototype.getNotExcludedVersionOfPage = function(g) //pg2-NT_AKA -excluded pages
{
	if (typeof(suspendData) == 'undefined' || suspendData == null) suspendData = getSuspendData(); //pg2-in all conditions below added '== null'- 'cause it might be null and type is still an object- and not 'undefined'
	if (typeof(suspendData) == 'undefined' || suspendData == null) return g;
	if (typeof(suspendData.me) == 'undefined' || suspendData.me == null) return g;
	if (typeof(suspendData.me.userRole) == 'undefined') return g;
	if (typeof(struct) == 'unefined' || struct == null) struct = getStruct();
	if (typeof(struct) == 'undefined' || struct == null) return g;
	
	var userRole = suspendData.me.userRole;
	
	//alert('out: ' + g + ', ' + userRole); //pg2-test
	if (userRole == -1) return g;
	try {
		userRole = parseInt(userRole);
		var excludedGixNo;
		eval('excludedGixNo = suspendData.me.excludedGix' + userRole + ';');
		//alert(userRole + '\n\n' + excludedGixNo);
		if (!excludedGixNo || excludedGixNo == '') return g;
		excludedGixNo = '-' + excludedGixNo + '-'; //pg2-to avoid different way of searching through array in Firefox and IE, here- .indexOf() will be sufficient for both
		if (excludedGixNo.indexOf('-' + g + '-') != -1) {
			var index = uelo.getPageIndexInStruct(g);
			var GIX = g;
			if (this.directionForward) {
				for (var i=index+1; i<uelo.pages.length; i++) {
					GIX = uelo.pages[i].globalIndex;
					if (excludedGixNo.indexOf('-' + GIX + '-') == -1) return GIX;
				};
				GIX = uelo.pages[uelo.pages.length-1].globalIndex;
			} else {
				for (var i=index; i>=0; i--) {
					GIX = uelo.pages[i].globalIndex;
					if (excludedGixNo.indexOf('-' + GIX + '-') == -1) return GIX;
				};
				GIX = uelo.pages[0];
			};
			return GIX;
		};
		return g;
	} catch(e) {
		alert('ERROR: ' + e.message);
		return g;
	};
	return g;
};

Player.prototype.getMobileVersionOfPage = function(g) //pg2-mobile_pages -two arrays with mobile-pc equivalents of the pages
{
	if (typeof(suspendData) == 'undefined' || suspendData == null) suspendData = getSuspendData(); //pg2-in all conditions below added '== null'- 'cause it might be null and type is still an object- and not 'undefined'
	if (typeof(suspendData) == 'undefined' || suspendData == null) return g;
	if (typeof(suspendData.me) == 'undefined' || suspendData.me == null) return g;
	if (typeof(suspendData.me.pagesMobile) == 'undefined' || typeof(suspendData.me.pagesPC) == 'undefined' || suspendData.me.pagesPC == null) return g;
	if (typeof(struct) == 'unefined' || struct == null) struct = getStruct();
	if (typeof(struct) == 'undefined' || struct == null) return g;
	
	var pMobile = suspendData.me.pagesMobile.split(',');
	var pPC = suspendData.me.pagesPC.split(',');
	if (pPC.length != pMobile.length || suspendData.me.pagesMobile == '' || suspendData.me.pagesPC == '') {
		delete pMobile;
		delete pPC;
		return g;
	};
	
	var gix = g;
	var i_mobile = -1;
	var i_pc = -1;
	if (is.ie) { //check if IE11 handles array.indexOf
		for (var i=0; i<pMobile.length; i++) if (pMobile[i] == g) { i_mobile = i; break; }
		for (var i=0; i<pPC.length; i++) if (pPC[i] == g) { i_pc = i; break; }
	} else {
		i_mobile = pMobile.indexOf(g); // 3 , 5
		i_pc = pPC.indexOf(g); // 4 , 6
	};
	
	if (i_mobile != -1 || i_pc != -1) {
		if (is.mobile && i_pc != -1) {
			gix = pMobile[i_pc];
		} else
		if (!is.mobile && i_mobile != -1) {
			gix = pPC[i_mobile];
		};

		//alert('1.) ' + i_mobile + ', ' + i_pc + ' | ' + g + ', ' + gix);
		
		if (gix == this.gix && typeof(this.mobileRecurency) == 'undefined') {
			//alert('aaaaaaa');
			if (!this.directionForward) {//pg2-mobile_pages
				var prevItem = struct.getPreviousItem(gix);
				if (prevItem != null) {
					prevItem = struct.getPreviousItem(prevItem['gix']);
					if (prevItem != null) {
						this.mobileRecurency = true; //to avoid infinite loop
						gix = this.getMobileVersionOfPage(prevItem['gix']);
						delete this.mobileRecurency;
						this.directionForward = true;
					};
				};
			} else {
				var nextItem = struct.getNextItem(gix);
				if (nextItem != null) {
					nextItem = struct.getNextItem(nextItem['gix']);
					if (nextItem != null) {
						this.mobileRecurency = true; //to avoid infinite loop
						gix = this.getMobileVersionOfPage(nextItem['gix']);
						delete this.mobileRecurency;
						this.directionForward = true;
					};
				};
			};
		} else {
			if (typeof(this.mobileRecurency) != 'undefined') delete this.mobileRecurency;
			this.directionForward = true;
		};
	};
	
	//if (g == '6' && gix == '6') { alert('2.) ' + i_mobile + ', ' + i_pc + ' | ' + g + ', ' + gix + '\n\n' + pMobile + '\n\n' + pPC + '\n\n' + typeof(gix) + ',' + typeof(g)); };
	//alert('2.) ' + i_mobile + ', ' + i_pc + ' | ' + g + ', ' + gix);
	
	delete pMobile;
	delete pPC;
	
	return gix;
};

Player.prototype.gotoPage = function(g,b)
{
	// ograniczenie czasowe
	// trzeba gdzies wpisac w kodzie
	// np : player.expire = new Date(2005, 7, 18);
	
	try { //pg2-knf -if course is blocked (timeout), do not allow navigation
		var allow = parseInt(getSuspendData().me['lms_send_session_time']);
		if (isNaN(allow)) allow = true;
		if (!allow && this.knfControlGotoPage) return;
	} catch(e) {};
	this.knfControlGotoPage = true;
	
	//pg2-axa_OnUnload -it wasn't invoked during 'next/prev/gotoPage'
	if (checkExportType(config.exportDetails, "single")) {
		var p = getPage();
		if (typeof(p) != 'undefined' && p != null) p.invokeEvent("UnLoad");
	};
	//...
	
	if (typeof(this.expire) != "undefined" && typeof(this.expire.getTime) == "function") {
		var now = new Date();
		if (now.getTime() > this.expire.getTime()) {
			this.loadContentFrameset(this.naviPathToRoot + "pages/html/expire.html");
			return;
		};
	};
	
	g = this.getNotExcludedVersionOfPage(g); //pg2-NT_AKA -excluded pages
	g = this.getMobileVersionOfPage(g); //pg2-mobile_pages

	var item = struct.findItem(g);
	if (item == null) {
		item = struct.findItem(player.findFirstPage());
	};
	if (item) {
		if (typeof(isWBTE) != 'undefined' && isWBTE) { //pg2
			try {
				var ri = parseInt(item.index)-1; //pg2-AXA from MK+SP
				if (lms.LMSSetValue) lms.LMSSetValue('cmi.current.page.number', ri.toString()); //pg2-in case of AICC on wbts
			} catch(e) {};
		};

		if (item["href"] != "") {
			if (config && config.AutoChangeCourseVersion) this.switchCourseVersionToMatchEIS(); //pg2-liag_multiversions
			UserAPI.eventGotoPage(g,b);
			if (config.usePlayerPreloader && !is.ie10 && !(is.safari && is.mobile)) { //pg2-IE10 has problem with refreshing frameset //pg2-disable preloader in case of iPad
				this.pgPreloaderLoad(item["gix"]);
			} else {
				this.loadContentFramesetByGix(item["gix"]);
			};
			return;
		};
	};
};

Player.prototype.gotoBack = function()
{
	if (this.history.length > 0) {
		this.gotoPage(this.history.pop(), true);
	}
};

Player.prototype.gotoEncyclopedia = function(wordToSearch)
{
	if (lms.gotoEncyclopedia) {
		lms.gotoEncyclopedia(wordToSearch);
	};
	return;
};

Player.prototype.firstPage = function()
{
	this.directionForward = true; //pg2-mobile_pages
	this.gotoPage(0);
};

Player.prototype.lastPage = function()
{
	this.directionForward = false; //pg2-mobile_pages
	var p = uelo.pages[uelo.pagesCount - 1];
	this.gotoPage(p.globalIndex);
};

Player.prototype.nextPage = function(passInvisible, status) 
{
	this.directionForward = true; //pg2-mobile_pages
	if (passInvisible == null || passInvisible == "undefined") passInvisible = false;

	var i = this.gix;
	var item = null;

	if (suspendData.sys.repMode == "on") {
		this.nextPageRepeatMode();
		return;
	};

	if (status != null && status != "undefined") {
		while (item = struct.getNextItem(i)) {
			var res = this.inArray(this.getItemStatus(item["gix"]), status.split(","));
			if (item["href"] != "" && (!passInvisible && item["visible"] == "1") && res) {
				this.gotoPage(item["gix"]);
				return;
			};
			i = item["gix"];
		};
	} else {
		while (item = struct.getNextItem(i)) {
			if (item["href"] != "" && (!passInvisible && item["visible"] == "1")) {
				this.gotoPage(item["gix"]);
				return;
			};
			i = item["gix"];
	};
	};

	this.gotoPage(this.gix);
};

Player.prototype.nextPageRepeatMode = function()
{
	var p = uelo.FindPage(suspendData.sys.repBackPage);
	for (var i in p.pagesToRepeat) {
		if (this.gix == p.pagesToRepeat[i]) {
			if (i < p.pagesToRepeat.length - 1) {
				var ngix = p.pagesToRepeat[parseInt(i)+1];
				this.gotoPage(ngix);
				return;
			};
		};
	};
	this.exitRepeatMode();
};

Player.prototype.previousPage = function(passInvisible, status)
{
	this.directionForward = false; //pg2-mobile_pages
	if (passInvisible == null || passInvisible == "undefined") passInvisible = false;

	var i = this.gix;
	var item = null;

	if (suspendData.sys.repMode == "on") {
		this.prevPageRepeatMode();
		return;
	};

	if (status != null && status != "undefined") {
		while (item = struct.getPreviousItem(i)) {
			var res = this.inArray(this.getItemStatus(item["gix"]), status.split(","));
			if (item["href"] != "" && (!passInvisible && item["visible"] == "1") && res) {
				this.gotoPage(item["gix"]);
				return;
			};
			i = item["gix"];
		};
	} else {
		while (item = struct.getPreviousItem(i)) {
			if (item["href"] != "" && (!passInvisible && item["visible"] == "1")) {
				this.gotoPage(item["gix"]);
				return;
			};
			i = item["gix"];
	};
	};

	this.gotoPage(this.gix);
};

Player.prototype.prevPageRepeatMode = function()
{
	var p = uelo.FindPage(suspendData.sys.repBackPage);
	for (var i in p.pagesToRepeat) {
		if (this.gix == p.pagesToRepeat[i]) {
			if (i > 0) {
				var ngix = p.pagesToRepeat[parseInt(i)-1];
				this.gotoPage(ngix);
				return;
			};
		};
	};
};

Player.prototype.nextSCO = function()
{
	if (typeof(lms) != "undefined" && typeof(lms.nextSCO) != "undefined") lms.nextSCO();
};

Player.prototype.prevSCO = function()
{
	if (typeof(lms) != "undefined" && typeof(lms.prevSCO) != "undefined") lms.prevSCO();
};

Player.prototype.runRepeatMode = function()
{
	if (typeof(suspendData) == 'undefined') return;
	var p = uelo.FindPage(this.gix);
	if (p) {
		if (p.pagesToRepeat.length > 0) {
			suspendData.sys.repMode = "on";
			suspendData.sys.repBackPage = this.gix;
			this.gotoPage(p.pagesToRepeat[0]);
		};
	};
};

Player.prototype.exitRepeatMode = function()
{
	if (typeof(suspendData) == 'undefined') return;
	if (suspendData.sys.repMode == "on") {
		suspendData.sys.repMode = "return";
		var retPage = suspendData.sys.repBackPage;
		this.gotoPage(retPage);
	};
};

Player.prototype.reload = function()
{
	var item = struct.findItem(this.gix);
	if (item["href"] != "") {
		if (this.enablePagesPreloader) {
			this.pgPreloaderLoad(item["gix"]);
		} else {
			this.loadContentFramesetByGix(item["gix"]);
		};
		return;
	};
};

Player.prototype.further = function(passInvisible) 
{
	var result = false;
	if (this.enablePagesPreloader) {
		var frm = player.getFrame(player.gix);
		if (frm) {
			if (frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
				result = frm.frame.PlayerInterface.connectedPage.further();
			} else this.nextPage();
		} else this.nextPage();
	} else {
		var content_frame = this.findFrame("content");
		if (content_frame && content_frame.PlayerInterface
				&& content_frame.PlayerInterface.connectedPage) {
			result = content_frame.PlayerInterface.connectedPage.further();
		} else this.nextPage();
	};
	return result;
};

Player.prototype.backwards = function(passInvisible)
{
	this.previousPage(passInvisible);
};

Player.prototype.findFrame = function(name, frame)
{
	try { //pg2-2iframe when some online page is loaded into it and it's visible, and 'prev/nextPage' action is performed- for some time ('till unloading iframe content) "access denied" is invoked
		if (name == "content" && this.frameContent != null) {
			 return this.frameContent;
		};

		if (typeof(frame) == "undefined") {
			frame = frames;
		};
		for (var i = 0; i < frame.length; i++) {
			if (frame[i].name == name) {
				if (name == "content") {
					this.frameContent = frame[i];
				};
				return frame[i];
			} else {
				var result = this.findFrame(name, frame[i]);
				if (result) return(result);
			};
		};
	} catch(e) {
		if (typeof(log) != 'undefined') log.error("classPlayer.findFrame: " + e.description); //pg2-condition
		return null; //pg2-now in the methods which use it and exception 'access denied' will occure
	};
	return(null);
};

Player.prototype.loadContentFrameset = function(href) 
{
	if (this.enablePagesPreloader) return;

	var content_frame = this.findFrame("content");
	if (content_frame) { //pg2
		content_frame.location.href = href;
	};
	this.updateTemplateTree();
};

Player.prototype.loadContentFramesetByGix = function(gix) 
{
	if (this.enablePagesPreloader) return;
	if (uelo.getPageAccess(gix) == false) {
		alert(MESSAGE_NOT_HAVE_PERMISSION_TO_ACCESS_THIS_PAGE);
		return;
	};
	if (suspendData != null && suspendData.sys.repMode == "return" && suspendData.sys.repBackPage != gix) { //pg2- if suspendData exists
		suspendData.sys.repMode = "off";
	};

	//pg2-block moved here, before frame timer will be started
	this.limitQuizTimeNotifyNavigateToPage(gix); //pg2-limit timer
	this.loadContentFrameset(this.naviPathToRoot + "navi/html/loadcontent.html?gix=" + gix);
};

Player.prototype.checkWerePagesSolved = function(rangeBegin, rangeEnd)
{
	var complete = false;

	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (parseInt(item['index']) < rangeBegin || parseInt(item['index']) > rangeEnd) {
			continue;
		};
		if (item["visible"] == "1") {
			if (item["status"] == "P" || item["status"] == "F") {
				complete = true;
				break;
			};
		};
	};
	return complete;
};

//jk  move to uelo
//Player.prototype.getScoreMaxScore = function()

Player.prototype.getScoreDataState = function()
{
	var maxScore = 0;
	var possibleScore = 0;
	var score = 0;
	var courseHasInteractions = false;

	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0") continue;
		var pageMS = parseInt(item["ms"]);
		if (!isNaN(pageMS)) {
			if (item["visible"] == "1" || (item["visible"] == "0" && config.sendDataFromHiddenPages)) { //pg2-lean_om - hidden exercise pages
				var p = uelo.FindPage(item["gix"]);
				if (p && p.pageType == PAGETYPE_EXERCISE && p.isAssessment) { //pg2-qr -get score only from pages in assessment
					var scaleCutoff = (isNaN(parseFloat(p.scaleCutoffScore)))?1.0:parseFloat(p.scaleCutoffScore);
					maxScore += 100;
					if (!isNaN(p.score)) {
						if (p.lockPageScore) p.score = 100; //pg2-courseReport_af
						var pageScore = (p.score == ""?0:parseInt(p.score) * scaleCutoff);
						score += pageScore;//p.score; //pg2-fixed
					};
					if (p.status != PAGESTATUS_NOT_ATTEMPTED) possibleScore += 100;
					if (p.interactions.length > 0) courseHasInteractions = true;
				};
			};
		};
	};
	this.courseHasInteractions = courseHasInteractions;
	return [score, maxScore, possibleScore];
};

Player.prototype.getTotalScore = function(isCompleted) //pg2-qr fixed //pg2-bsh_score_if_completed -parameter -send gained score in case result will be send if course would be completed only
{
	if (this.dbgCourseScore != -1) return this.dbgCourseScore;

	var scoreDS = this.getScoreDataState();

	//pg2-qr
	var score = scoreDS[0];
	var maxScore = scoreDS[1];
	var res = Math.ceil(((100 / maxScore) * score));
	//
	if (struct.isCourseMixed) {
		//pg2-qr
		var wasSolved = this.checkExamWasSolved();
		var reallyMixedAndInAssessment = uelo.wasCourseReallyMixedAndPagesInAssessment();

		if (!wasSolved && reallyMixedAndInAssessment[0] && reallyMixedAndInAssessment[1]) return uelo.courseOryginalScore; else //
		if (!wasSolved && !reallyMixedAndInAssessment[0] && !reallyMixedAndInAssessment[1] && !uelo.pageInAssessmentCheckAnswerInSession) {
			//pg2-qr fixed //pg2-bsh_score_if_completed -parameter
			if (config.SendScoreIfCourseIsCompleted) {
				if (isCompleted === true) return isNaN(res) ? "":res; else return uelo.courseOryginalScore;
			};
			//...
			return uelo.courseOryginalScore; //pg2-default, before the block above
		};
		//pg2-qr fixed //pg2-bsh_score_if_completed -parameter
		if (config.SendScoreIfCourseIsCompleted) {
			if (isCompleted === true) return isNaN(res) ? "":res; else return uelo.courseOryginalScore;
		};
		return isNaN(res) ? "":res; //pg2-default, before the block above
		//
	} else {
		/* //pg2-qr removed
		score = scoreDS[0];
		maxScore = scoreDS[1];
		var res = Math.ceil(((100 / maxScore) * score)); */
		return isNaN(res) ? "":res;
	};
};

Player.prototype.getPossibleScore = function() //pg2-qr fixed
{
	if (this.dbgCourseScore != -1) return this.dbgCourseScore;

	var scoreDS = this.getScoreDataState();

	var maxScore = scoreDS[1];
	var possibleScore = scoreDS[2];
	var res = Math.ceil(((100 / maxScore) * possibleScore));

	if (struct.isCourseMixed) {
		//pg2-qr
		var wasSolved = this.checkExamWasSolved();
		var reallyMixedAndInAssessment = uelo.wasCourseReallyMixedAndPagesInAssessment();

		if (!wasSolved && reallyMixedAndInAssessment[0] && reallyMixedAndInAssessment[1]) return uelo.courseOryginalScore; else
		if (!wasSolved && !reallyMixedAndInAssessment[0] && !reallyMixedAndInAssessment[1] && !uelo.pageInAssessmentCheckAnswerInSession) return uelo.courseOryginalScore;
		return isNaN(res) ? "":res;
		//
	} else {
		/* //pg2-qr removed
		maxScore = scoreDS[1];
		possibleScore = scoreDS[2];
		var res = Math.ceil(((100 / maxScore) * possibleScore));*/
		return isNaN(res) ? "":res;
	};
};

Player.prototype.checkExamWasSolved = function()
{
	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (item["iss"] == "0") continue;
		var pageMS = parseInt(item["ms"]);
		if (!isNaN(pageMS)) {
			if (item["visible"] == "1") {
				if (item["isExamPage"] == "1" && item["status"] != "N") {
					return true;
				};
			};
		};
	};
	return false;
};

Player.prototype.setNaviHtml = function(obj_name, value)
{
	var navigation = this.findFrame("navigation");
	if (navigation != undefined) {
		var obj = navigation.document.getElementById(obj_name);
		if (obj != undefined) obj.innerText = value;
	};
};

Player.prototype.contentDestroy = function()
{
	if (this.enablePagesPreloader) {
		this.pgPreloaderUnloadContent();
	} else {
		var f = findFrame("content");
		if (f) {
			try { //pg2-in case of https:// and a course in new window, there could be an exception- just intercept it, do nothing
				if (f.PlayerInterface) {
					f.PlayerInterface.connectedPage.unloadContent();
				} else 
				if (f.extContent) f.unloadContent();
			} catch(e) {};
		};
	};
	this.clearActivityTimer();
	this.clearLessonTimerTimer();
};

Player.prototype.createSID = function ()
{
	var d = new Date();
	return d.getTime();
};

//jk  move to uelo
Player.prototype.resetPagesStatus = function ()
{
	for (var i = 0; i < struct.length(); i++) {
		struct.item(i)["status"] = "N";
	};
};

Player.prototype.getPagesCountInChapter = function(root) {
	var result = 0;
	for (var i = 0; i < struct.length(); i++) {
		var item = struct.item(i);
		if (parseInt(item["parent"]) == parseInt(root["index"])) result++;
	};
	return result;
};

Player.prototype.getPageNoInChapter = function(root, item) {
	var result = 0;
	for (var i = 0; i < struct.length(); i++) {
		var item_s = struct.item(i);
		if (parseInt(item_s["parent"]) == parseInt(root["index"])) {
			result++;
			if (item_s["gix"] == item["gix"]) return result;
		};
	};
	return result;
};

Player.prototype.nextPageInChapter = function(passInvisible, status)
{
	if (passInvisible == null || passInvisible == "undefined") passInvisible = false;
	var i = this.gix;
	var root = struct.findItem(this.gix);
	var item = null;

	if (status != null && status != "undefined") {
		if (this.hasChildren()) {
			while (item = struct.getNextItem(i)) {
				var res = this.inArray(this.getItemStatus(item["gix"]), status.split(","));
				if (item["href"] != "" 
						&& (!passInvisible && item["visible"] == "1")
						&& item["parent"] == root["index"]
						&& res) {
					if (this.enablePagesPreloader) {
						this.pgPreloaderLoad(item["gix"]);
					} else {
						this.loadContentFramesetByGix(item["gix"]);
					};
					return;
				};
				i = item["gix"];
			};
		};
	} else {
		if (this.hasChildren()) {
			while (item = struct.getNextItem(i)) {
				if (item["href"] != "" && (!passInvisible && item["visible"] == "1")
						&& item["parent"] == root["index"]) {
					if (this.enablePagesPreloader) {
						this.pgPreloaderLoad(item["gix"]);
					} else {
						this.loadContentFramesetByGix(item["gix"]);
					};
					return;
				};
				i = item["gix"];
			};
		};
	};

	var idx = this.findParent(this.gix);
	if (idx != null) {
		if (this.enablePagesPreloader) {
			this.pgPreloaderLoad(idx);
		} else {
			this.loadContentFramesetByGix(idx);
		};
	} else {
		idx = this.findFirstPage();
		if (idx != null) {
			if (this.enablePagesPreloader) {
				this.pgPreloaderLoad(idx);
			} else {
				this.loadContentFramesetByGix(idx);
			};
		};
	};
};

Player.prototype.previousPageInChapter = function(passInvisible, statuses)
{
	if (passInvisible == null || passInvisible == "undefined") passInvisible = false;
	var i = this.gix;
	var root = struct.findItem(this.gix);
	var item = null;

	if (status != null && status != "undefined") {
		if (this.hasChildren()) {
			while (item = struct.getPreviousItem(i)) {
				var res = this.inArray(this.getItemStatus(item["gix"]), status.split(","));
				if (item["href"] != "" 
						&& (!passInvisible && item["visible"] == "1")
						&& item["parent"] == root["index"]
						&& res) {
					if (this.enablePagesPreloader) {
						this.pgPreloaderLoad(item["gix"]);
					} else {
						this.loadContentFramesetByGix(item["gix"]);
					};
					return;
				};
				i = item["gix"];
			};
		};
	} else {
		if (this.hasChildren()) {
			while (item = struct.getPreviousItem(i)) {
				if (item["href"] != "" && (!passInvisible && item["visible"] == "1")
						&& item["parent"] == root["index"]) {
					if (this.enablePagesPreloader) {
						this.pgPreloaderLoad(item["gix"]);
					} else {
						this.loadContentFramesetByGix(item["gix"]);
					};
					return;
				};
				i = item["gix"];
			};
		};
	};

	var idx = this.findParent(this.gix);
	if (idx != null) {
		if (this.enablePagesPreloader) {
			this.pgPreloaderLoad(idx);
		} else {
			this.loadContentFramesetByGix(idx);
		};
	} else {
		idx = this.findFirstPage();
		if (idx != null) {
			if (this.enablePagesPreloader) {
				this.pgPreloaderLoad(idx);
			} else {
				this.loadContentFramesetByGix(idx);
			};
		};
	};
};

Player.prototype.setTitle = function(item, frameName, objName)
{
	if (!item) item = struct.findItem(this.gix);
	var header = this.findFrame(frameName);

	if (header && item) {
		var obj = header.document.getElementById(objName);
		if (obj != undefined) obj.innerText = item["title"];
	};
};

Player.prototype.setNumber = function(item, format, frameName, objName)
{
	var clear = false;
	var header = this.findFrame(frameName);
	if (!item) {
		item = struct.findItem(this.gix);
	};
	var item_parent = struct.findItemByParent(parseInt(item["parent"]));
	if (!item_parent || parseInt(item["parent"]) == 1) {
		clear = true;
		format = "";
	} else {
		var count = this.getPagesCountInChapter(item_parent);
		var page_no = this.getPageNoInChapter(item_parent, item);
		format = format.replace("%1", page_no);
		format = format.replace("%2", count - 1);
	};

	if (header && item) {
		var obj = header.document.getElementById(objName);
		if (obj != undefined) obj.innerText = format;
	};
};

Player.prototype.setPageHidden = function(index)
{
	if (index == null || index == "undefined") return false;
	var item = struct.findItem(index);
	if (item) item["visible"] = "0";
	if (uelo) {
		uPage=uelo.FindPage(index);
		if (uPage) uPage.pageType = 'Hidden';
	};
};

Player.prototype.setPageVisible = function(index,type)
{
	if (index == null || index == "undefined") return false;
	var item = struct.findItem(index);
	if (item) item["visible"] = "1";
	if (uelo) {
		uPage=uelo.FindPage(index);
		if (uPage) uPage.pageType=type;
	};
};

Player.prototype.setPagesInStruct = function(type)
{
	for (var i = 1; i < struct.length(); i++) {
		if (type == 'hidden') this.setPageHidden(i);
		else this.setPageVisible(i,type);
	};
};

Player.prototype.getLMS = function()
{
	return lms;
};

Player.prototype.setCourseVersion = function(vindex)
{
	if (!struct.existsVersionItem(vindex)) return;

	this.courseVersion = vindex;
	var treeFrame = this.findFrame("tree", top); //pg2-added 'top'
	if (treeFrame) {
		treeFrame.setCourseVersion(this.courseVersion);
		//treeFrame.document.location.reload(); //pg2-new -allows to update hint (title) on page's name in the tree //pg2-removed, in BSH templates itsn't working
	};

	if (this.enablePagesPreloader) this.resetFrames();
	this.gotoPage(this.gix);
};

Player.prototype.switchCourseVersionToMatchEIS = function() //pg2-liag_multiversions
{
	if (this.eisLangCode == '' || !struct) return;
	try {
		var courseVersionLangCode = struct.versionsItems["_" + this.courseVersion].langCode;
		if (courseVersionLangCode != '') {
			courseVersionLangCode = courseVersionLangCode.toLowerCase();
			if (courseVersionLangCode != this.eisLangCode) {
				for (var i in struct.versionsItems){
					if (struct.versionsItems[i].langCode.toLowerCase() == this.eisLangCode) {
						this.setCourseVersion(struct.versionsItems[i].index);
						break;
					};
				};
			};
		};
	} catch(e) {};
};

Player.prototype.getFrame = function(id, base)
{
	if (typeof(base) != "undefined") {
		for (var k in this.__frames) {
			if (this.__frames[k] && k == id) {
				return this.__frames[k];
			};
		};
	} else {
		for (var k in this.__frames) {
			if (this.__frames[k] && this.__frames[k].gix == id) {
				return this.__frames[k];
			};
		};
	};
	return null;
};

Player.prototype.getFreeFrame = function()
{
	for (var k in this.__frames) {
		if (this.__frames[k].locked == false && this.__frames[k].content == false) {
			return this.__frames[k];
		};
	};
	return null;
};

Player.prototype.getIndex = function(gix)
{
	var item = struct.findItem(gix);
	if (item) {
		return parseInt(item["index"]);
	};
	return -1;
};

Player.prototype.getGIX = function(idx)
{
	var item = struct.findItemBy(idx, "index");
	if (item) {
		return parseInt(item["gix"]);
	};
	return -1;
};

Player.prototype.getFirstVisible = function(gix, prev)
{
	if (prev) {
		var item = struct.findPrevVisibleItem(gix);
		if (item) {
			return parseInt(item["gix"]);
		};
	} else {
		var item = struct.findNextVisibleItem(gix);
		if (item) {
			return parseInt(item["gix"]);
		};
	};
	return -1;
};

Player.prototype.preloadPages = function(gix)
{
	if (config.useMicroPreloader) {
		this.preloadPagesMicro(gix);
	} else {
		this.preloadPagesFull(gix);
	};
};

Player.prototype.preloadPagesFull = function(gix)
{
	this.updateTemplateTree();

	var prev = false;
	var next1 = false;
	var next2 = false;

	var idx = this.getIndex(gix);

	var gix_prev = this.getFirstVisible(gix, true);
	var gix_next1 = this.getFirstVisible(gix);
	var gix_next2 = -1;
	if (gix_next1 != -1) {
		var gix_next2 = this.getFirstVisible(gix_next1);
	};

	var idx_prev = this.getIndex(gix_prev);
	var idx_next1 = this.getIndex(gix_next1);
	var idx_next2 = this.getIndex(gix_next2);

	for (var k in this.__frames) {
		if (this.__frames[k].gix == gix) {
			this.__frames[k].locked = true;
		} else 
		if (gix_prev != -1 && this.__frames[k].gix == gix_prev) {
			this.__frames[k].locked = true;
			prev = true;
		} else 
		if (gix_next1 != -1 && this.__frames[k].gix == gix_next1) {
			this.__frames[k].locked = true;
			next1 = true;
		} else 
		if (gix_next2 != -1 && this.__frames[k].gix == gix_next2) {
			this.__frames[k].locked = true;
			next2 = true;
		};
	};

	//z ofsetem
	if (!prev && gix_prev != -1) {
		var frm = this.getFreeFrame();
		if (frm) {
			frm.locked = true;
			frm.gix = gix_prev;
			frm.frame.location = this.prepareFrameSrc(gix_prev);
		};
	};

	if (!next1 && gix_next1 != -1) {
		var frm = this.getFreeFrame();
		if (frm) {
			frm.locked = true;
			frm.gix = gix_next1;
			frm.frame.location = this.prepareFrameSrc(gix_next1);
		};
	};

	if (!next2 && gix_next2 != -1) {
		var frm = this.getFreeFrame();
		if (frm) {
			frm.locked = true;
			frm.gix = gix_next2;
			frm.frame.location = this.prepareFrameSrc(gix_next2);
		};
	};
};

Player.prototype.preloadPagesMicro = function(gix)
{
	this.updateTemplateTree();

	//var prev = false;
	var next1 = false;
	//var next2 = false;

	var idx = this.getIndex(gix);

	//var gix_prev = this.getFirstVisible(gix, true);
	var gix_next1 = this.getFirstVisible(gix);
	/*
	var gix_next2 = -1;
	if (gix_next1 != -1) {
		var gix_next2 = this.getFirstVisible(gix_next1);
	}
	*/
	/*var gix_prev = this.getGIX(idx - 1);
	var gix_next1 = this.getGIX(idx + 1);
	var gix_next2 = this.getGIX(idx + 2, new Array(gix_next1));*/

	//var idx_prev = this.getIndex(gix_prev);
	var idx_next1 = this.getIndex(gix_next1);
	//var idx_next2 = this.getIndex(gix_next2);

	for (var k in this.__frames) {
		if (this.__frames[k].gix == gix) {
			this.__frames[k].locked = true;
		} /* else if (gix_prev != -1 && this.__frames[k].gix == gix_prev) {
			this.__frames[k].locked = true;
			prev = true;
		} */
		else 
		if (gix_next1 != -1 && this.__frames[k].gix == gix_next1) {
			this.__frames[k].locked = true;
			next1 = true;
		}; /*else if (gix_next2 != -1 && this.__frames[k].gix == gix_next2) {
			this.__frames[k].locked = true;
			next2 = true;
		}*/
	};

	//z ofsetem
	/*
	if (!prev && gix_prev != -1) {
		var frm = this.getFreeFrame();
		if (frm) {
			frm.locked = true;
			frm.gix = gix_prev;
			frm.frame.location = this.prepareFrameSrc(gix_prev);
		}
	}
	*/
	if (!next1 && gix_next1 != -1) {
		var frm = this.getFreeFrame();
		if (frm) {
			frm.locked = true;
			frm.gix = gix_next1;
			frm.frame.location = this.prepareFrameSrc(gix_next1);
		};
	};
	/*
	if (!next2 && gix_next2 != -1) {
		var frm = this.getFreeFrame();
		if (frm) {
			frm.locked = true;
			frm.gix = gix_next2;
			frm.frame.location = this.prepareFrameSrc(gix_next2);
		}
	}
	*/
};

Player.prototype.prepareFrameSrc = function(gix)
{
	var result = "";
	var item = struct.findItem(gix);
	if (item) {
		if (item["href"] != "") {
			if (item["type"] == "0") {
				result = this.naviPathToRoot + item["href"] + "_page." + this.courseVersion + ".html";
			} else {
				result = this.naviPathToRoot + item["href"];
			};
		};
	};
	if (result == "") {
		result = this.naviPathToRoot + "pages/html/blank.html";
	};
	return result;
};

Player.prototype.prepareFrame = function(gix, name)
{
	var frm = null;
	if (typeof(name) != "undefined") {
		frm = this.getFrame(name, true);
		if (frm) {
			frm.gix = gix;
			frm.frame.location = this.prepareFrameSrc(gix);
		};
	} else {
		frm = this.getFrame(gix);
		if (!frm) {
			frm = this.getFreeFrame(gix);
			if (frm) {
				frm.gix = gix;
				frm.frame.location = this.prepareFrameSrc(gix);
			};
		};
	};
	return frm;
};

Player.prototype.pgPreloaderUnloadContent = function()
{
	var frm = this.getFrame(this.gix);
	if (frm) {
		try {
			if (frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
				frm.frame.PlayerInterface.connectedPage.unloadContent();
			} else
			if (frm.frame.extContent) {
				frm.frame.unloadContent();
			};
		} catch(e) {};
	};
};

Player.prototype.pgPreloaderLoad = function(gix)
{
	if (uelo.getPageAccess(gix) == false) {
		alert(MESSAGE_NOT_HAVE_PERMISSION_TO_ACCESS_THIS_PAGE);
		return;
	};

	__timer.stop();

	if (suspendData.sys.repMode == "return" && suspendData.sys.repBackPage != gix) {
		suspendData.sys.repMode = "off";
	};

	var item = struct.findItem(gix);
	if (item) {
		var frm = this.getFrame(this.gix);
		if (frm) {
			try {
				if (frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
					frm.frame.PlayerInterface.connectedPage.unloadContent();
				} else
				if (frm.frame.extContent) {
					frm.frame.unloadContent();
				};
			} catch(e) {};
		};

		this.setSessionTime();
		this.gix = gix;

		for (var k in this.__frames) {
			this.__frames[k].locked = false;
			this.__frames[k].content = false;
		};

		var frm = this.getFrame(this.gix);
		if (!frm) {
			frm = this.prepareFrame(this.gix, "p1000");
		};

		frm.content = true;
		var cols = "";

		for (var k in this.__frames) {
			if (this.__frames[k].content) {
				cols += "*,"
			} else {
				cols += "0px,"
			};
		};

		cols = cols.substr(0, cols.length - 1);
		this.pagesPreloaderFrame.cols = cols;

		if (this.reinitializeTree) this.repaintTemplateTree();
		this.updateTemplateTree();
		this.updateTemplateExpand(item);
		this.updateTemplateProgress(item);
		this.updateTemplateTitle(item);

		//pg2-block moved here, before frame timer will be started
		this.limitQuizTimeNotifyNavigateToPage(gix); //pg2-limit timer

		__timer.run();
	};
};

Player.prototype.resetFrames = function()
{
	for (var k in this.__frames) {
		this.__frames[k].locked = false;
		this.__frames[k].content = false;
		this.__frames[k].gix = -1;
	};
};

Player.prototype.initFrames = function()
{
	if (!this.pagesPreloaderFrame) {
		alert("Pages preloader error.\nPlease contact your course developer.");
		return;
	};

	this.pagesPreloaderFrame.cols = "0px,*,0px,0px";

	var content_frame = this.findFrame("content");

	if (content_frame) { //pg2
		for (var i=0; i<content_frame.frames.length; i++) {
			var frm = content_frame.frames[i];
			this.__frames[frm.name] = new __Frame();
			this.__frames[frm.name].frame = frm;
		};
	} else {
		//?? -pg2-why it's empty block???
	};
	//?? -aw wtf? this.pgPreloaderLoad(this.getGIX(2));
};

Player.prototype._doLoad = function()
{
	this.doLoad(this.pagesPreloaderFrame);
	// debugger
	if (is.moz) {
		___cool_timer_stop();
		if (___cool_timer_enabled) {
			___cool_timer_start();
		};
	};
	// debugger end
};

Player.prototype.doLoad = function(obj)
{
	this.enablePagesPreloader = config.usePlayerPreloader && !is.ie10 && !(is.safari && is.mobile); //pg2-IE10 has problem with refreshing frameset //pg2-disable preloader in case of iPad
	this.pg_max = struct.length();
	this.pagesPreloaderFrame = obj;
	if (!this.pagesPreloaderFrame) this.enablePagesPreloader = false;
	if (this.enablePagesPreloader) {
		if (is.opera) {
			this.initFrames();
		} else
		if ((is.moz) && !this.wasLoaded) {
			//?? -pg2-why it's empty block???
		} else {
			this.initFrames();
		};
	};
	this.resetCourseFrames();
	// debugger
	if (is.ie) {
		___cool_timer_stop();
		if (___cool_timer_enabled) {
			___cool_timer_start();
		};
	};
	// debugger end
	this.runStudentActivityTimer();
	this.isLoaded = true;
	return false;
};

Player.prototype.runStudentActivityTimer = function(item)
{
	this.runStudentActiveTimer();

	if (top && typeof(top.dailySessionUpdateTimeInterval ) != 'undefined') {
			this.updateLMSTimeInterval = top.dailySessionUpdateTimeInterval ;
			this.lmsTimer = setTimeout("player.updateAvtivityToLMS();", this.updateLMSTimeInterval*1000);
	};

	if (config.lessonTimeEnabled && this.lessonTimer == null) {
		var timeFromLastBreak  = 0;
		if (top && typeof(top.timeFromLastBreak  ) != 'undefined') {
			timeFromLastBreak  = top.timeFromLastBreak;
		};
		if (config.lessonTime < timeFromLastBreak) timeFromLastBreak = 0;
		this.lessonTimer = setTimeout("player.showEndLessonPopup();", config.lessonTime*60*1000-timeFromLastBreak*60*1000);
	};
};

Player.prototype.updateTemplateExpand = function(item)
{
	var tree_frame = null;
	try {
		tree_frame = this.findFrame("tree");
	} catch(e) {
		tree_frame = null;
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateExpand#1: " + e.description);
	};
	try {
		if (item && item["visible"] == "1" && tree_frame && tree_frame.expandMyParents) tree_frame.expandMyParents(this.gix);
	} catch(e) {
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateExpand#2: " + e.description);
	};
};

Player.prototype.updateTemplateTree = function()
{
	var iGix = this.gix; //wl -config.temp_BSH201401
	var tree_frame = null;
	try {
		tree_frame = this.findFrame("tree");
	} catch(e) {
		tree_frame = null;
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateTree#1: " + e.description);
	};

	if (config.temp_BSH201401){ //wl -config.temp_BSH201401
		if (uelo.isPageInRandomizerRange(this.gix)){	
			iGix=uelo.getPageRandomizerParent(this.gix);
		} else
		if (tree_frame.pageParentIsRandomizerParent(uelo,this.gix)){
			var iIdx = this.findParent(this.gix);
			iGix=iIdx;
		};
	};
	try {
		var item = struct.findItem(iGix);

		if (item && item["visible"] == "1" && tree_frame && tree_frame.selectedNode) {
			tree_frame.selectedNode(iGix);			
		};
	} catch(e) {
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateExpand#2: " + e.description);
		alert(e.message);
	};

};

Player.prototype.repaintTemplateTree = function() {
	var tree_frame = this.findFrame("tree");
	if (tree_frame != null) {
		this.reinitializeTree = true;
		tree_frame.document.location.reload();
	};
};

Player.prototype.updateTemplateTitle = function(item)
{
	var tF = null;
	try {
		tF = this.findFrame("title");
	} catch(e) {
		tF = null;
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateTitle#1: " + e.description);
	};
	try {
		if (tF && tF.update) {
			tF.update(item);
		};
	} catch(e) {
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateTitle#2: " + e.description);
	};
};

Player.prototype.updateTemplateProgress = function(item)
{
	var navigation_frame = null;
	try {
		navigation_frame = this.findFrame("navigation");
	} catch(e) {
		navigation_frame = null;
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateProgress#1: finding navigation_frame " + e.description);
	};

	var content_frame = null;
	try {
		content_frame = this.findFrame("content");
	} catch(e) {
		content_frame = null;
		if (typeof(log) != 'undefined') log.error("classPlayer.updateTemplateProgress#2: finding content_frame " + e.description);
	};

	if (navigation_frame != null && content_frame != null) {
		if (navigation_frame.templateProgress) {
			//var content_frame = this.findFrame("content");
			navigation_frame.updateProgress(content_frame, item['index']);
		};
		if (navigation_frame.hideShowPrevNextButton) {
			//var content_frame = this.findFrame("content");
			navigation_frame.showHideButtons(content_frame, this.gix);
		};
	};
};

Player.prototype.pageLoaded = function(gix)
{
};

Player.prototype.contentLoaded = function()
{
};

Player.prototype.isActiveContent = function(srch)
{
	var result = false;
	var item = struct.findItem(this.gix);
	if (item) {
		var i_srch = item["href"];
		if (i_srch != "") {
			i_srch = i_srch.split("?")[1];
			i_srch = "?" + i_srch.replace(new RegExp('&amp;', "g"), '&');
			srch = srch.replace(new RegExp('&amp;', "g"), '&');
			if (i_srch == srch) {
				result = true;
			};
		};
	};
	return result;
};

Player.prototype.clearAllData = function()
{
	if (uelo && struct) { //pg2-invoked in page preview in wbte
		uelo.clearInteractions();
		struct.setNewStatus("N");
	};
};

Player.prototype.setSessionTime = function()
{
	var item = struct.findItem(this.gix);
	if (item) {
		var t;
		if (config.inactivityEnabled) {
			t = Math.floor(this.activityTime); //pg2-inactivity time -exe
		} else {
			t = stampInSec(this.startTime, new Date());
		};
		item["sessionTime"] += t;
	};
	this.startTime = new Date();
};

Player.prototype.getDebugMode = function()
{
	if (this.debugMode) {
		return true;
	} else {
		var debugF = this.findFrame("debug", top);
		if (debugF) {
			this.debugMode = true;
			return true;
		};
	};
	return false;
};

Player.prototype.debugCourse = function()
{
	var debugF = this.findFrame("debug", top);
	if (debugF && debugF.updateDebugInformations) {
		debugF.updateDebugInformations();
	};
};

Player.prototype.calculateTimeIntToString = function(timeInt)
{
	//tools.js
	return calculateTimeIntToString(timeInt);
};

Player.prototype.updateAvtivityToLMS = function()
{
	var updateEnabled = false;
	if (top && typeof(top.sendLearnTime ) != 'undefined') {
		top.sendLearnTime(player.activityTime);
		updateEnabled = true;
	};
	if (top && typeof(top.sendLearnTime ) != 'undefined') {
		var pageName = "";
		var pageGix = "";
		var frm = this.getFrame(this.gix);
		if (frm) {
			if (frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
				pageName = frm.frame.PlayerInterface.connectedPage.p_pageName;
				pageGix = frm.frame.PlayerInterface.connectedPage.p_globalIndex;
			};
		};
		top.setCurrentLearnPage(pageName, pageGix);
		updateEnabled = true;
	};
	if (updateEnabled) this.lmsTimer = setTimeout("player.updateAvtivityToLMS();", this.updateLMSTimeInterval);
};

Player.prototype.runStudentActiveTimer = function()
{
	if ((!config.lessonTimeEnabled || this.lessonBreak) && (!config.inactivityEnabled)) return;  //pg2-knf -inactivity timer -second condition -we want inactivity, but lesson time isn't required

	window.clearTimeout(this.activTimer);
	this.activTimer = null;
	this.activTimer = setTimeout("player.studentIsInactive(new Date());", config.inactivityTime*1000); //config.inactivityTime*60*1000); //pg2-knf -inactivity timer -it was in minutes instead of seconds
};

Player.prototype.studentExitSCO = function()
{
	var curentDate = new Date
	var inactivTime = curentDate.getMilisecondsBetweenDates(this.lastActiveStudentTime, curentDate);
	var activeTimeInt = (inactivTime / 1000);

	this.activityTime += activeTimeInt;
	return this.activityTime;
};

Player.prototype.studentIsActive = function(curentDate)
{
	this.lastActiveStudentTime = curentDate;
	this.runStudentActiveTimer();
};

Player.prototype.studentIsInactive = function(curentDate)
{
	this.IsStudentActive = false; //pg2-knf -inactivity timer
	var inactivTime = curentDate.getMilisecondsBetweenDates(this.lastActiveStudentTime, curentDate);
	var activeTimeInt = (inactivTime / 1000);

	this.activityTime += activeTimeInt;
	this.lastActiveStudentTime = null; //pg2-inactivity time

	var frm = this.getFrame(this.gix);
	if (frm) {
		if (frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
			frm.frame.PlayerInterface.connectedPage.showWarningPopup();
		};
	} else { //pg2-in case that frame won't be found
		var p = getPage();
		if (p) p.showWarningPopup();
	};
};

Player.prototype.studentActive = function()
{
	this.IsStudentActive = true; //pg2-knf -inactivity timer
	if (!config.inactivityEnabled) return;
	
	//pg2-inactivity time
	var currentDate = new Date();
	if (this.lastActiveStudentTime == null) this.lastActiveStudentTime = currentDate;
	var activityTime = currentDate.getMilisecondsBetweenDates(this.lastActiveStudentTime, currentDate);
	var activeTimeInt = (activityTime/1000);
	this.lastActiveStudentTime = currentDate;
	this.activityTime += activeTimeInt;
	//...
	
	if (top && typeof(top.setUserExecuteAction ) != 'undefined') { //pg2-knf-notify WBTS about it
		top.setUserExecuteAction();
	};
	this.runStudentActiveTimer();
};

Player.prototype.clearActivityTimer = function()
{
	window.clearTimeout(this.activTimer);
	this.activTimer = null;
};

Player.prototype.clearLessonTimerTimer = function()
{
	window.clearTimeout(this.lessonTimer);
	this.lessonTimer = null; delete this.lessonTimer;
};

Player.prototype.setLessonBreak = function(lessonBreak)
{
	this.lessonBreak = lessonBreak;
};

Player.prototype.setStudentLessonBreak = function()
{
	this.clearActivityTimer();
	this.setLessonBreak(true);
	this.activTimer = setTimeout("player.setLessonBreak(false);player.runStudentActiveTimer();", 15*60*1000);
	this.lessonTimer = setTimeout("player.showEndLessonPopup();", 15*60*1000 + config.lessonTime*60*1000);
};

Player.prototype.showEndLessonPopup = function()
{
	this.clearActivityTimer();
	this.clearLessonTimerTimer();

	var frm = this.getFrame(this.gix);
	if (frm) {
		if (frm.frame.PlayerInterface && frm.frame.PlayerInterface.connectedPage) {
			frm.frame.PlayerInterface.connectedPage.showEndLessonPopup();
		};
	};
};

Player.prototype.eventPageFirstStep = function() 
{
	for (var i in this.pageFirstStepListeners) {
		try {
			this.pageFirstStepListeners[i]();
		} catch(e) {};
	};
};

Player.prototype.eventPageLastStep = function() 
{
	for (var i in this.pageLastStepListeners) {
		try {
			this.pageLastStepListeners[i]();
		} catch(e) {};
	};
};

Player.prototype.isAvailablePlayerObject = function() //pg2-audioOnOff_new
{
	return true;
};

function stampInSec(dateStart, dateEnd)
{
	if (typeof(dateEnd) == "undefined") dateEnd = new Date();
	var d = Math.abs(dateEnd.getTime() - dateStart.getTime());
	return d;
};

player = new Player();
