var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ListenAndWrite;
(function (_ListenAndWrite) {
    var ListenAndWrite = (function (_super) {
        __extends(ListenAndWrite, _super);
        function ListenAndWrite(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        ListenAndWrite.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        ListenAndWrite.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        ListenAndWrite.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.json.isFirst == true) {
                EU.loadVocabulary(this);
            }
            ;
            this.createFillQuestion();
            this.createButtons();
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        };
        ListenAndWrite.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        ListenAndWrite.prototype.createFillQuestion = function () {
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex].en;
                EU.Log(question);
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
            this.json.Lector = EU.groups[this.categoryIndex].vocabulary[this.wordIndex].lec;
            this.Elements.FillElements.el.push({
                "pos": this.Elements.Position,
                "Answer": question
            });
        };
        ListenAndWrite.prototype.createButtons = function () {
            var el = this.game.add.text(1200, 770, "NEXT WORD", { font: "60px Arial", fill: 'blue', });
            el.setShadow(5, 5, "lightblue");
            el.inputEnabled = true;
            el.events.onInputDown.add(this.nextTask, this);
            this.addChild(el);
            if (this.json.isFirst != true) {
                var el2 = this.game.add.text(100, 770, "PREVIOUS WORD", { font: "60px Arial", fill: 'blue', });
                el2.setShadow(5, 5, "lightblue");
                el2.inputEnabled = true;
                el2.events.onInputDown.add(this.prevTask, this);
                this.addChild(el2);
            }
            var el3 = this.game.add.text(670, 200, "SAY AGAIN", { font: "60px Arial", fill: 'blue', });
            el3.setShadow(5, 5, "lightblue");
            el3.inputEnabled = true;
            el3.events.onInputDown.add(this.playLector, this);
            this.addChild(el3);
        };
        ListenAndWrite.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this))
                EU.Log("Correct!!!");
        };
        return ListenAndWrite;
    })(Base.BasicGroup);
    _ListenAndWrite.ListenAndWrite = ListenAndWrite;
})(ListenAndWrite || (ListenAndWrite = {}));
//# sourceMappingURL=ListenAndWrite.js.map