var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var head_good = 1;
var Creator;
(function (_Creator) {
    var Creator = (function (_super) {
        __extends(Creator, _super);
        function Creator(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Creator.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.loadSpriteSheets();
            this.game.load.start();
        };
        Creator.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Creator.prototype.loadSpriteSheets = function () {
            for (var i = 0; i < this.Elements.SpriteSheets.length; i++)
                this.game.load.spritesheet(this.PREFIX + this.Elements.SpriteSheets[i].key, this.Elements.SpriteSheets[i].src, this.Elements.SpriteSheets[i].width, this.Elements.SpriteSheets[i].height);
        };
        Creator.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            this.createButtons();
			console.log("head_good = "+head_good);
        };
        Creator.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Creator.prototype.createButtons = function () {
            this.currentElements = [];
            for (var i = 0; i < this.Elements.Arrays.length; i++) {
                var prevButton = this.game.add.button(0, 0, this.PREFIX + this.Elements.Arrays[i].PrevButton.key, this.prevElement.bind(this, i), this, 0, 1);
                var nextButton = this.game.add.button(0, 0, this.PREFIX + this.Elements.Arrays[i].NextButton.key, this.nextElement.bind(this, i), this, 0, 1);
                this.addChild(prevButton);
                this.addChild(nextButton);
                var posX = 0;
                var posY = 0;
                var el = this.game.add.image(0, 0, this.PREFIX + this.Elements.Arrays[i].Elements[0]);
                if (this.Elements.Arrays[i].Just) {
                    switch (this.Elements.Arrays[i].Just.x) {
                        case "center":
                            posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                            prevButton.anchor.x = 0.5;
                            nextButton.anchor.x = 0.5;
                            el.anchor.x = 0.5;
                            break;
                        case "right":
                            posX += Global.Main.mainContainerDims.wd - 120;
                            prevButton.anchor.x = 1;
                            nextButton.anchor.x = 1;
                            el.anchor.x = 1;
                            break;
                    }
                    switch (this.Elements.Arrays[i].Just.y) {
                        case "center":
                            posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                            prevButton.anchor.y = 0.5;
                            nextButton.anchor.y = 0.5;
                            el.anchor.y = 0.5;
                            break;
                        case "bottom":
                            posY += Global.Main.mainContainerDims.hg - 65;
                            prevButton.anchor.y = 1;
                            nextButton.anchor.y = 1;
                            el.anchor.y = 1;
                            break;
                    }
                }
                prevButton.position.set(posX + this.Elements.Arrays[i].PrevButton.pos.x, posY + this.Elements.Arrays[i].PrevButton.pos.y);
                nextButton.position.set(posX + this.Elements.Arrays[i].NextButton.pos.x, posY + this.Elements.Arrays[i].NextButton.pos.y);
                el.position.set(posX + this.Elements.Arrays[i].Position.x, posY + this.Elements.Arrays[i].Position.y);
                el.alpha = 0;
                this.currentElements.push({
                    "key": null,
                    "index": 0,
                    "el": el,
                });
                this.addChild(this.currentElements[i].el);
            }
        };
        Creator.prototype.nextElement = function (ind) {
			if (ind == 0){
				head_good = 0;
				console.log("head_good = "+head_good);
			}
            EU.Log(ind);
            this.currentElements[ind].index++;
            this.currentElements[ind].el.alpha = 1;
            var i = this.currentElements[ind].index % this.Elements.Arrays[ind].Elements.length;
            this.currentElements[ind].el.loadTexture(this.PREFIX + this.Elements.Arrays[ind].Elements[i]);
            this.currentElements[ind].key = this.Elements.Arrays[ind].Elements[i];
            this.checkIfEverythingIsCorrect();
        };
        Creator.prototype.prevElement = function (ind) {
            if (ind == 0){
				head_good = 0;
				console.log("head_good = "+head_good);
			}
			this.currentElements[ind].index--;
            if (this.currentElements[ind].index < 0)
                this.currentElements[ind].index = this.Elements.Arrays[ind].Elements.length - 1;
            this.currentElements[ind].el.alpha = 1;
            var i = this.currentElements[ind].index % this.Elements.Arrays[ind].Elements.length;
            this.currentElements[ind].el.loadTexture(this.PREFIX + this.Elements.Arrays[ind].Elements[i]);
            this.currentElements[ind].key = this.Elements.Arrays[ind].Elements[i];
            this.checkIfEverythingIsCorrect();
        };
        Creator.prototype.checkIfEverythingIsCorrect = function () {
            if (head_good == 0){
				for (var i = 0; i < this.Elements.Arrays.length; i++) {
					var points = 0;
					var correct = false;
					for (var j = 0; j < this.Elements.Arrays[i].CorrectElements.length; j++) {
						if (this.Elements.Arrays[i].CorrectElements[j] == this.currentElements[i].key) {
							correct = true;
						}
					}
					if (correct == false) {
						EU.Log("NotCorrect:<");
						EU.setGameCompletion(this.parent, 0);
						return false;
					}
				}
				EU.Log("Correct!!!");
				EU.setGameCompletion(this.parent, 1);
				return true;
			};
			if (head_good == 1){
				for (var i = 1; i < this.Elements.Arrays.length; i++) {
					var points = 0;
					var correct = false;
					for (var j = 0; j < this.Elements.Arrays[i].CorrectElements.length; j++) {
						if (this.Elements.Arrays[i].CorrectElements[j] == this.currentElements[i].key) {
							correct = true;
						}
					}
					if (correct == false) {
						EU.Log("NotCorrect:<");
						EU.setGameCompletion(this.parent, 0);
						return false;
					}
				}
				EU.Log("Correct!!!");
				EU.setGameCompletion(this.parent, 1);
				return true;
			};
        };
        return Creator;
    })(Base.BasicGroup);
    _Creator.Creator = Creator;
})(Creator || (Creator = {}));
//# sourceMappingURL=Creator.js.map