var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var SelectText;
(function (_SelectText) {
    var SelectText = (function (_super) {
        __extends(SelectText, _super);
        function SelectText(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        SelectText.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        SelectText.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        SelectText.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.numberOfChecked = 0;
            this.createSourceText();
            this.createTextToFind();
        };
        SelectText.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        SelectText.prototype.createTextToFind = function () {
            this.TextToFind = this.Elements.TextToFind;
        };
        SelectText.prototype.createSourceText = function () {
            this.SourceText = [];
            var verses = this.Elements.SourceText.Text.split("\n");
            var posX = this.Elements.SourceText.Position.x;
            var posY = this.Elements.SourceText.Position.y;
            var style = this.Elements.SourceText.Style;
            var counter = 0;
            for (var i = 0; i < verses.length; i++) {
                var words = verses[i].split(" ");
                counter++;
                var el = this.game.add.text(0, 0, words[0], style);
                var versePosY = posY + i * el.height;
                el.position.set(posX, versePosY);
                el.inputEnabled = true;
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                el.events.onInputDown.add(this.onWordClicked, this);
                this.SourceText.push(el);
                this.addChild(el);
                for (var j = 1; j < words.length; j++) {
                    el = this.game.add.text(0, 0, words[j], style);
                    el.position.set(this.SourceText[counter - 1].position.x + this.SourceText[counter - 1].width + this.SourceText[counter - 1].height / 3, versePosY);
                    el.inputEnabled = true;
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    el.events.onInputDown.add(this.onWordClicked, this);
                    this.SourceText.push(el);
                    this.addChild(el);
                    counter++;
                }
            }
        };
        SelectText.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        SelectText.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        SelectText.prototype.onWordClicked = function (el, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";
            }
            else {
                el.setShadow(1, 1, "red");
                this.numberOfChecked++;
                el.name = "checked";
            }
            this.checkIfEverythingIsCorrect();
        };
        SelectText.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Points: " + this.calculatePlayerPoints() + "/" + this.calculateMaxPoints() + " Checked: " + this.numberOfChecked);
            var maxPoints = this.calculateMaxPoints();
            if (this.calculatePlayerPoints() == maxPoints && this.numberOfChecked == maxPoints) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        SelectText.prototype.calculateMaxPoints = function () {
            var points = 0;
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 1; j < this.TextToFind.length; j++) {
                    if (this.SourceText[i].text == this.TextToFind[j])
                        points++;
                }
            }
            return points;
        };
        SelectText.prototype.calculatePlayerPoints = function () {
            var points = 0;
            for (var i = 0; i < this.SourceText.length; i++) {
                if (this.SourceText[i].name == "checked") {
                    for (var j = 1; j < this.TextToFind.length; j++) {
                        if (this.SourceText[i].text == this.TextToFind[j])
                            points++;
                    }
                }
            }
            return points;
        };
        return SelectText;
    })(Base.BasicGroup);
    _SelectText.SelectText = SelectText;
})(SelectText || (SelectText = {}));
//# sourceMappingURL=SelectText.js.map