﻿/*
 * Copyright � 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentStatistics = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.radiosArr = new Array();
	this.progressArr = new Array();
	this.progressTextArr = new Array();

	this.pageParentsNames = new Array();
	this.chaptersArr = new Array();

	this.chapterLength = 0;
	this.chapterProgress = 0;

	this.lessonLength = 0;
	this.lessonProgress = 0;

	this.pageLength = 0;
	this.pageProgress = 0;

	this.choosenProgress = '';
	this.myMiniStatistic = new Array();
	this.imagesCompleteInfo = new Array();
};

componentStatistics.prototype = new componentElement();
componentStatistics.prototype.type = "componentStatistics";

componentStatistics.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [this.bckgTop, this.bckgMiddle, this.bckgBottom, this.bckgSeparator, this.buttonCloseOut, this.buttonCloseOver, this.iconChapter, this.iconLesson, this.iconVisible, this.iconPage, this.iconTitle, this.radioOff, this.radioOn, this.chapterProgressBckg, this.lessonProgressBckg, this.pageProgressBckg];
	this.getPreloadImagesArr();
	this.setCompleteArrayInfo(this.completeInfoStyleImages, this.completeInfoButtonsImages);
};

componentStatistics.prototype.setCompleteArrayInfo = function(style, buttons)
{
	var imagesStr = style + buttons;
	var imgArr = imagesStr.split(';');
	for (var i = 0; i < imgArr.length; i++) {
		var oneImg = imgArr[i].split(',');
		if (!this.imagesCompleteInfo[oneImg[0]]){
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];
		};
	};
};

componentStatistics.prototype.onPaint = function(obj)
{
	this.setImageToObiekt();

	var statisticTitle = document.getElementById(this.id + "_statisticTitle");

	if (this.allowGF && project.globalFormating) {
		statisticTitle.style.fontFamily = project.font.family;
		statisticTitle.style.fontSize = getFontSize(project.font.size, 'px');
		statisticTitle.style.color = project.font.color;
	};
	var chapterProgressDiv = document.getElementById(this.id + "_chapterProgressDiv");
	var lessonProgressDiv = document.getElementById(this.id + "_lessonProgressDiv");
	var pageProgressDiv = document.getElementById(this.id + "_pageProgressDiv");

	this.progressArr = [chapterProgressDiv, lessonProgressDiv, pageProgressDiv];

	this.setDivElements();
}

componentStatistics.prototype.onAfterLoad = function(obj)
{
	var st = getStruct();
	this.getChapters(st);
	this.getPagesInChapter();

	this.getPageNames();
	this.setPercentage();
};

componentStatistics.prototype.setImageToObiekt = function(obj)
{
	var bckgTopImg = document.getElementById(this.id + "_bckgTopImg");
	var bckgMiddleImg = document.getElementById(this.id + "_bckgMiddleImg");
	var bckgBottomImg = document.getElementById(this.id + "_bckgBottomImg");
	var separatorImg = document.getElementById(this.id + "_separatorImg");
	var buttonCloseImg = document.getElementById(this.id + "_buttonCloseImg");
	var titleImg = document.getElementById(this.id + "_titleImg");
	var iconChapterImg = document.getElementById(this.id + "_iconChapterImg");
	var iconLessonImg = document.getElementById(this.id + "_iconLessonImg");
	var iconPageImg = document.getElementById(this.id + "_iconPageImg");
	var iconVisibleImg = document.getElementById(this.id + "_iconVisibleImg");
	var radio1Img = document.getElementById(this.id + "_radio1Img");
	var radio2Img = document.getElementById(this.id + "_radio2Img");
	var radio3Img = document.getElementById(this.id + "_radio3Img");
	var chapterProgressBckgImg = document.getElementById(this.id + "_chapterProgressBckgImg");
	var lessonProgressBckgImg = document.getElementById(this.id + "_lessonProgressBckgImg");
	var pageProgressBckgImg = document.getElementById(this.id + "_pageProgressBckgImg");

	bckgTopImg.src = this.resourcesURL + this.bckgTop;
	bckgMiddleImg.src = this.resourcesURL + this.bckgMiddle;
	bckgBottomImg.src = this.resourcesURL + this.bckgBottom;
	separatorImg.src = this.resourcesURL + this.bckgSeparator;
	buttonCloseImg.src = this.resourcesURL + this.buttonCloseOut;
	titleImg.src = this.resourcesURL + this.iconTitle;
	iconChapterImg.src = this.resourcesURL + this.iconChapter;
	iconLessonImg.src = this.resourcesURL + this.iconLesson;
	iconPageImg.src = this.resourcesURL + this.iconPage;
	iconVisibleImg.src = this.resourcesURL + this.iconVisible;
	radio1Img.src = this.resourcesURL + this.radioOff;
	radio2Img.src = this.resourcesURL + this.radioOff;
	radio3Img.src = this.resourcesURL + this.radioOff;
	this.radiosArr = [radio1Img, radio2Img, radio3Img];
	chapterProgressBckgImg.src = this.resourcesURL + this.chapterProgressBckg;
	lessonProgressBckgImg.src = this.resourcesURL + this.lessonProgressBckg;
	pageProgressBckgImg.src = this.resourcesURL + this.pageProgressBckg;
};

componentStatistics.prototype.setDivElements = function(obj)
{
	var bckgTopDiv = document.getElementById(this.id + "_bckgTopDiv");
	var bckgMiddleDiv = document.getElementById(this.id + "_bckgMiddleDiv");
	var bckgBottomDiv = document.getElementById(this.id + "_bckgBottomDiv");
	var separatorDiv = document.getElementById(this.id + "_separatorDiv");
	var buttonCloseDiv = document.getElementById(this.id + "_buttonCloseDiv");
	var titleImgDiv = document.getElementById(this.id + "_titleImgDiv");
	var iconChapterDiv = document.getElementById(this.id + "_iconChapterDiv");
	var iconLessonDiv = document.getElementById(this.id + "_iconLessonDiv");
	var iconPageDiv = document.getElementById(this.id + "_iconPageDiv");
	var iconVisibleDiv = document.getElementById(this.id + "_iconVisibleDiv");
	var radio1Div = document.getElementById(this.id + "_radio1Div");
	var radio2Div = document.getElementById(this.id + "_radio2Div");
	var radio3Div = document.getElementById(this.id + "_radio3Div");
	var chapterProgressBckgDiv = document.getElementById(this.id + "_chapterProgressBckgDiv");
	var lessonProgressBckgDiv = document.getElementById(this.id + "_lessonProgressBckgDiv");
	var pageProgressBckgDiv = document.getElementById(this.id + "_pageProgressBckgDiv");
	var chapterProgressDiv = document.getElementById(this.id + "_chapterProgressDiv");
	var lessonProgressDiv = document.getElementById(this.id + "_lessonProgressDiv");
	var pageProgressDiv = document.getElementById(this.id + "_pageProgressDiv");
	var chapterProgressTextDiv = document.getElementById(this.id + "_chapterProgressTextDiv");
	var lessonProgressTextDiv = document.getElementById(this.id + "_lessonProgressTextDiv");
	var pageProgressTextDiv = document.getElementById(this.id + "_pageProgressTextDiv");
	var chapterTitleTextDiv = document.getElementById(this.id + "_chapterTitleTextDiv");
	var lessonTitleTextDiv = document.getElementById(this.id + "_lessonTitleTextDiv");
	var pageTitleTextDiv = document.getElementById(this.id + "_pageTitleTextDiv");
	var statisticTitleDiv = document.getElementById(this.id + "_statisticTitleDiv");

	var topH = this.getImageHeight('bckgTop');
	bckgTopDiv.style.height = topH;
	bckgTopDiv.style.clip = 'rect(0px '+this.w+'px '+topH+'px 0px)';

	bckgMiddleDiv.style.top = topH;
	var middH = this.h-this.getImageHeight('bckgTop')-this.getImageHeight('bckgBottom');
	bckgMiddleDiv.style.height = middH;
	bckgMiddleDiv.style.clip = 'rect(0px '+this.w+'px '+middH+'px 0px)';

	var bottH = this.getImageHeight('bckgBottom');
	bckgBottomDiv.style.top = topH + middH;
	bckgBottomDiv.style.height = bottH;
	bckgBottomDiv.style.clip = 'rect(0px '+this.w+'px '+bottH+'px 0px)';

	var sepH = this.getImageHeight('bckgSeparator');
	separatorDiv.style.top = topH + 30;
	separatorDiv.style.height = sepH;
	separatorDiv.style.clip = 'rect(0px '+this.w+'px '+sepH+'px 0px)';

	var sepH = this.getImageHeight('buttonCloseOut');
	var sepW = this.getImageWidth('buttonCloseOut');
	if (this.dir == "rtl") {
		buttonCloseDiv.style.left = 10;
	} else {
		buttonCloseDiv.style.left = this.w - 10 - sepW;
	};
	buttonCloseDiv.style.height = sepH;
	buttonCloseDiv.style.width = sepW;
	buttonCloseDiv.style.clip = 'rect(0px '+sepW+'px '+sepH+'px 0px)';

	var imgH = this.getImageHeight('iconTitle');
	var imgW = this.getImageWidth('iconTitle');
	var topH = this.getImageHeight('bckgTop');
	if (this.dir == "rtl") {
		titleImgDiv.style.left = this.width - 5 - imgW;
	} else {
		titleImgDiv.style.left = 5;
	};
	titleImgDiv.style.top = parseInt(topH/2)-parseInt(imgH/2);
	titleImgDiv.style.height = imgH;
	titleImgDiv.style.width = imgW;
	titleImgDiv.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

	if (this.dir == "rtl") {
		statisticTitleDiv.style.left = parseInt(buttonCloseDiv.style.left) + sepW;
		statisticTitleDiv.style.width = this.width - parseInt(buttonCloseDiv.style.left) - (this.width - parseInt(titleImgDiv.style.left)) - sepW;
	} else {
		statisticTitleDiv.style.left = parseInt(titleImgDiv.style.left) + imgW;
		statisticTitleDiv.style.width = this.width - (this.width - parseInt(buttonCloseDiv.style.left)) - parseInt(titleImgDiv.style.left) - imgW;
	};
	statisticTitleDiv.style.top = 0;
	statisticTitleDiv.style.height = topH;
	statisticTitleDiv.style.clip = 'rect(0px '+eval(this.w - 15)+'px '+topH+'px 0px)';

	var rowH = this.getTextRowHeight(65, bottH);

	var imgH = this.getImageHeight('iconChapter');
	var imgW = this.getImageWidth('iconChapter');
	if (this.dir == "rtl") {
		iconChapterDiv.style.left = this.width - imgW - 15;
	} else {
		iconChapterDiv.style.left = 15;
	};
	iconChapterDiv.style.top = 65;
	iconChapterDiv.style.height = imgH;
	iconChapterDiv.style.width = imgW;
	iconChapterDiv.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

	var imgH = this.getImageHeight('iconLesson');
	var imgW = this.getImageWidth('iconLesson');
	if (this.dir == "rtl") {
		iconLessonDiv.style.left = this.width - imgW - 15;
	} else {
		iconLessonDiv.style.left = 15;
	};
	iconLessonDiv.style.top = 65+rowH;
	iconLessonDiv.style.height = imgH;
	iconLessonDiv.style.width = imgW;
	iconLessonDiv.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

	var imgH = this.getImageHeight('iconPage');
	var imgW = this.getImageWidth('iconPage');
	if (this.dir == "rtl") {
		iconPageDiv.style.left = this.width - imgW - 15;
	} else {
		iconPageDiv.style.left = 15;
	};
	iconPageDiv.style.top = 65+rowH*2;
	iconPageDiv.style.height = imgH;
	iconPageDiv.style.width = imgW;
	iconPageDiv.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

	var progressH = this.getImageHeight('chapterProgressBckg');
	var progressW = this.getImageWidth('chapterProgressBckg');
	if (this.dir == "rtl") {
		chapterProgressBckgDiv.style.left = 60;
	} else {
		chapterProgressBckgDiv.style.left = this.w - progressW - 60;
	};
	chapterProgressBckgDiv.style.top = 70;
	chapterProgressBckgDiv.style.height = progressH;
	chapterProgressBckgDiv.style.width = progressW;
	chapterProgressBckgDiv.style.clip = 'rect(0px '+progressW+'px '+progressH+'px 0px)';

	if (this.dir == "rtl") {
		chapterProgressDiv.style.left = 60;
	} else {
		chapterProgressDiv.style.left = this.w - progressW - 60;
	};
	chapterProgressDiv.style.top = 70;
	chapterProgressDiv.style.height = progressH;
	chapterProgressDiv.style.width = progressW;
	chapterProgressDiv.style.clip = 'rect(0px '+progressW+'px '+progressH+'px 0px)';

	var progressH = this.getImageHeight('lessonProgressBckg');
	var progressW = this.getImageWidth('lessonProgressBckg');
	if (this.dir == "rtl") {
		lessonProgressBckgDiv.style.left = 60;
	} else {
		lessonProgressBckgDiv.style.left = this.w - progressW - 60;
	};
	lessonProgressBckgDiv.style.top = 70+rowH;
	lessonProgressBckgDiv.style.height = progressH;
	lessonProgressBckgDiv.style.width = progressW;
	lessonProgressBckgDiv.style.clip = 'rect(0px '+progressW+'px '+progressH+'px 0px)';

	if (this.dir == "rtl") {
		lessonProgressDiv.style.left = 60;
	} else {
		lessonProgressDiv.style.left = this.w - progressW - 60;
	};
	lessonProgressDiv.style.top = 70+rowH;
	lessonProgressDiv.style.height = progressH;
	lessonProgressDiv.style.width = progressW;
	lessonProgressDiv.style.clip = 'rect(0px '+progressW+'px '+progressH+'px 0px)';

	var progressH = this.getImageHeight('pageProgressBckg');
	var progressW = this.getImageWidth('pageProgressBckg');
	if (this.dir == "rtl") {
		pageProgressBckgDiv.style.left = 60;
	} else {
		pageProgressBckgDiv.style.left = this.w - progressW - 60;
	};
	pageProgressBckgDiv.style.top = 70+rowH*2;
	pageProgressBckgDiv.style.height = progressH;
	pageProgressBckgDiv.style.width = progressW;
	pageProgressBckgDiv.style.clip = 'rect(0px '+progressW+'px '+progressH+'px 0px)';

	if (this.dir == "rtl") {
		pageProgressDiv.style.left = 60;
	} else {
		pageProgressDiv.style.left = this.w - progressW - 60;
	};
	pageProgressDiv.style.top = 70+rowH*2;
	pageProgressDiv.style.height = progressH;
	pageProgressDiv.style.width = progressW;
	pageProgressDiv.style.clip = 'rect(0px '+progressW+'px '+progressH+'px 0px)';

	var imgH = this.getImageHeight('iconVisible');
	var imgW = this.getImageWidth('iconVisible');
	if (this.dir == "rtl") {
		iconVisibleDiv.style.left = progressW + 78;
	} else {
		iconVisibleDiv.style.left = this.w - progressW - imgW - 78;
	};
	iconVisibleDiv.style.top = 35;
	iconVisibleDiv.style.height = imgH;
	iconVisibleDiv.style.width = imgW;
	iconVisibleDiv.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

	if (this.showRadio) {
		var imgH = this.getImageHeight('radioOff');
		var imgW = this.getImageWidth('radioOff');
		if (this.dir == "rtl") {
			radio1Div.style.left = progressW + 70;
		} else {
			radio1Div.style.left = this.w - progressW - imgW - 70;
		};
		radio1Div.style.top = 65;
		radio1Div.style.height = imgH;
		radio1Div.style.width = imgW;
		radio1Div.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

		if (this.dir == "rtl") {
			radio2Div.style.left = progressW + 70;
		} else {
			radio2Div.style.left = this.w - progressW - imgW - 70;
		};
		radio2Div.style.top = 65+rowH;
		radio2Div.style.height = imgH;
		radio2Div.style.width = imgW;
		radio2Div.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';

		if (this.dir == "rtl") {
			radio3Div.style.left = progressW + 70;
		} else {
			radio3Div.style.left = this.w - progressW - imgW - 70;
		};
		radio3Div.style.top = 65+rowH*2;
		radio3Div.style.height = imgH;
		radio3Div.style.width = imgW;
		radio3Div.style.clip = 'rect(0px '+imgW+'px '+imgH+'px 0px)';
	} else {
		radio1Div.style.visibility = 'hidden';
		radio2Div.style.visibility = 'hidden';
		radio3Div.style.visibility = 'hidden';
	};

	if (this.dir == "rtl") {
		chapterProgressTextDiv.style.left = 5;
	} else {
		chapterProgressTextDiv.style.left = this.w - 60;
	};
	chapterProgressTextDiv.style.top = 70;
	chapterProgressTextDiv.style.height = 20;
	chapterProgressTextDiv.style.width = 55;
	chapterProgressTextDiv.style.clip = 'rect(0px 55px 20px 0px)';

	if (this.dir == "rtl") {
		lessonProgressTextDiv.style.left = 5;
	} else {
		lessonProgressTextDiv.style.left = this.w - 60;
	};
	lessonProgressTextDiv.style.top = 70+rowH;
	lessonProgressTextDiv.style.height = 20;
	lessonProgressTextDiv.style.width = 55;
	lessonProgressTextDiv.style.clip = 'rect(0px 55px 20px 0px)';

	if (this.dir == "rtl") {
		pageProgressTextDiv.style.left = 5;
	} else {
		pageProgressTextDiv.style.left = this.w - 60;
	};
	pageProgressTextDiv.style.top = 70+rowH*2;
	pageProgressTextDiv.style.height = 20;
	pageProgressTextDiv.style.width = 55;
	pageProgressTextDiv.style.clip = 'rect(0px 55px 20px 0px)';

	var imgW = this.getImageWidth('radioOff');
	if (this.dir == "rtl") {
		chapterTitleTextDiv.style.left = progressW + 70 + imgW + 5;
	} else {
		chapterTitleTextDiv.style.left = 35;
	};
	chapterTitleTextDiv.style.top = 67;
	chapterTitleTextDiv.style.height = rowH;
	chapterTitleTextDiv.style.width = this.w - progressW - imgW - 110;
	chapterTitleTextDiv.style.clip = 'rect(0px '+eval(this.w - progressW - imgW - 100)+'px '+rowH+'px 0px)';

	if (this.dir == "rtl") {
		lessonTitleTextDiv.style.left = progressW + 70 + imgW + 5;
	} else {
		lessonTitleTextDiv.style.left = 35;
	};
	lessonTitleTextDiv.style.top = 67+rowH;
	lessonTitleTextDiv.style.height = rowH;
	lessonTitleTextDiv.style.width = this.w - progressW - imgW - 110;
	lessonTitleTextDiv.style.clip = 'rect(0px '+eval(this.w - progressW - imgW - 100)+'px '+rowH+'px 0px)';

	if (this.dir == "rtl") {
		pageTitleTextDiv.style.left = progressW + 70 + imgW + 5;
	} else {
		pageTitleTextDiv.style.left = 35;
	};
	pageTitleTextDiv.style.top = 67+rowH*2;
	pageTitleTextDiv.style.height = rowH;
	pageTitleTextDiv.style.width = this.w - progressW - imgW - 110;
	pageTitleTextDiv.style.clip = 'rect(0px '+eval(this.w - progressW - imgW - 100)+'px '+rowH+'px 0px)';
};

componentStatistics.prototype.getTextRowHeight = function(X, bottomH)
{
	var tableH = this.h - X - bottomH;

	return parseInt(tableH/3);
};

componentStatistics.prototype.changeImage = function(obj, imageName)
{
	obj.src = this.resourcesURL + imageName;
};

componentStatistics.prototype.changeRadioImg = function(obj, progressKind)
{
	for (var i=0; i < this.radiosArr.length; i++){
		this.radiosArr[i].src = this.resourcesURL + this.radioOff;
	};

	this.choosenProgress = progressKind;

	obj.src = this.resourcesURL + this.radioOn;
	lms.setCourseData('_statistic_progress', progressKind);

	for (var i=0; i < this.myMiniStatistic.length; i++){
		this.myMiniStatistic[i].setImageToObiekt(this.choosenProgress);
	};
};

componentStatistics.prototype.getPageNames = function(obj)
{
	var st = getStruct();
	if (st) {
		var item = st.findItem(PageInterface.GetValue('pageGix'));
		if (item) {
			var pageName = item['title'];
			var parentIndex = item['parent'];

			this.pageParentsNames.push(pageName);

			do {
				var par = this.getPageParentName(st, parentIndex);
				if (par) parentIndex = par['parent'];
			} while (par);

			var chapterTitleText = document.getElementById(this.id + "_chapterTitleText");
			var lessonTitleText = document.getElementById(this.id + "_lessonTitleText");
			var pageTitleText = document.getElementById(this.id + "_pageTitleText");

			if (typeof(this.pageParentsNames[this.pageParentsNames.length-1]) == 'undefined') 
				this.pageParentsNames[this.pageParentsNames.length-1] = '';
			chapterTitleText.innerHTML = this.pageParentsNames[this.pageParentsNames.length-1];
			if (typeof(this.pageParentsNames[this.pageParentsNames.length-2]) == 'undefined') 
				this.pageParentsNames[this.pageParentsNames.length-2] = '';
			lessonTitleText.innerHTML = this.pageParentsNames[this.pageParentsNames.length-2];
			pageTitleText.innerHTML = pageName;
		};
	};
};

componentStatistics.prototype.onStep = function()
{
	var pageProgressText = document.getElementById(this.id + "_pageProgressText");

	var stepsCount = (eval(page.steps.length-2) == 0)?0:eval(page.steps.length-2);
	pageProgressText.innerHTML = page.stepIndex+ '/'+stepsCount;

	var progressW = this.getImageWidth('chapterProgressBckg');

	var perc = (stepsCount == 0) ? 1 : page.stepIndex/stepsCount;
	if (this.progressArr[2]) this.progressArr[2].style.width = eval(parseInt(progressW)*perc);

	this.pageLength = stepsCount;
	this.pageProgress = page.stepIndex;
};

componentStatistics.prototype.getPageParentName = function(struct, parentInd)
{
	var pageParentGix = struct.findPageGixByIndex(parentInd);
	if (pageParentGix) {
		var pageParent = struct.findItem(pageParentGix);
	} else {
		return null;
	};
	if (pageParent){
		var pageName = pageParent['title'];
		this.pageParentsNames.push(pageName);
		return pageParent;
	} else {
		return null;
	};
};

componentStatistics.prototype.getChapters = function(struct)
{
	if (!struct) return;

	for (var i = 0; i < struct.m_list.length; i++) {
		if (struct.m_list[i]["parent"] == 1) {
			if (!this.chaptersArr[struct.m_list[i]["title"]]){
				this.chaptersArr[struct.m_list[i]["title"]] = new Array();
				this.chaptersArr[struct.m_list[i]["title"]][0] = struct.m_list[i]["gix"];
				this.chaptersArr[struct.m_list[i]["title"]][1] = struct.m_list[i]["index"];
			};
		};
	};
};

componentStatistics.prototype.getPagesInChapter = function()
{
	var uelo = page.getUELO();
	var arr = new Array();
	if (uelo) {
		for (var k in this.chaptersArr) {
			this.chaptersArr[k][2] = new Array();
			var chapterIndex = this.chaptersArr[k][1]-2;
			for (var i = chapterIndex; i < uelo.pages.length; i++) {
				var p = uelo.pages[i];
				if (p && p.chapterName == k) {
					var len = this.chaptersArr[k][2].length;
					this.chaptersArr[k][2][len] = new Array();
					this.chaptersArr[k][2][len][0] = p.title;
					this.chaptersArr[k][2][len][1] = p.globalIndex;
					this.chaptersArr[k][2][len][2] = i+2;
				};
			};
		};
	};
};

componentStatistics.prototype.setPercentage = function()
{
	var chapterName = this.pageParentsNames[this.pageParentsNames.length-1];
	var lessonName = this.pageParentsNames[this.pageParentsNames.length-2];
	var pageName = this.pageParentsNames[0];
	var progressW = this.getImageWidth('chapterProgressBckg');

	var visitedPagesInChapter = this.findCountVisitedPage(chapterName);
	var visitedPagesInLesson = this.findCountVisitedPageInLesson(chapterName, lessonName);

	var chapterProgressText = document.getElementById(this.id + "_chapterProgressText");
	var lessonProgressText = document.getElementById(this.id + "_lessonProgressText");
	var pageProgressText = document.getElementById(this.id + "_pageProgressText");

	var stepsCount = page.steps.length-2;
	var actualStep = eval(page.stepIndex-1);

	this.chapterLength = this.chaptersArr[chapterName][2].length;
	this.chapterProgress = visitedPagesInChapter;

	this.lessonLength = visitedPagesInLesson[0];
	this.lessonProgress = visitedPagesInLesson[1];

	chapterProgressText.innerHTML = visitedPagesInChapter+'/'+this.chaptersArr[chapterName][2].length;
	lessonProgressText.innerHTML = visitedPagesInLesson[1]+'/'+visitedPagesInLesson[0];
	pageProgressText.innerHTML = actualStep+'/'+stepsCount;

	
	if (this.progressArr.length > 0) { //pg2-itwl_bookmarks
		var divBy = this.chaptersArr[chapterName][2].length;
		if (divBy == 0) divBy = 1;
		//var perc = (this.chaptersArr[chapterName].length == 0)?1:visitedPagesInChapter/this.chaptersArr[chapterName][2].length;
		var perc = (this.chaptersArr[chapterName].length == 0)?1:visitedPagesInChapter/divBy;
		this.progressArr[0].style.width = eval(progressW*perc);

		var perc = (visitedPagesInLesson[0] == 0)?1:visitedPagesInLesson[1]/visitedPagesInLesson[0];
		this.progressArr[1].style.width = eval(progressW*perc);

		if (stepsCount == 0) stepsCount = 1; //pg2-itwl_test
		var perc = (stepsCount == 0) ? 1 : actualStep/stepsCount;
		this.progressArr[2].style.width = eval(progressW*perc);
	};
};

componentStatistics.prototype.findCountVisitedPageInLesson = function(chapName, lessName)
{
	var result = 0;
	var pagesCount = 0;
	var uelo = page.getUELO();

	if (uelo) {
		var chapterPagesArr = this.chaptersArr[chapName];
		var chapterGIX = this.chaptersArr[chapName][0];
		var chapterIndex = this.chaptersArr[chapName][1];

		for (var i=0; i < chapterPagesArr[2].length; i++) {
			if (chapterPagesArr[2][i][0] == lessName) {
				var subPageName = chapterPagesArr[2][i][0];
				var subPageIndex = chapterPagesArr[2][i][2];
				var nextLessonIndex = 0;

				if (chapterPagesArr[2][i+1]) {
					nextLessonIndex = chapterPagesArr[2][i+1][2];
				} else {
					for (var k in this.chaptersArr) {
						if (subPageIndex < this.chaptersArr[k][1]) {
							nextLessonIndex = this.chaptersArr[k][1];
							break;
						};
					};
				};
				for (var i = subPageIndex-1; i < nextLessonIndex-2; i++) {
					var p = uelo.pages[i];
					if (p.status != 'N') result++;
				};
				pagesCount = ((nextLessonIndex - subPageIndex -1)>0)?(nextLessonIndex - subPageIndex -1):0;
			};
		};
	};
	return [pagesCount, result];
};

componentStatistics.prototype.findCountVisitedPage = function(chapName)
{
	var result = 0;
	var uelo = page.getUELO();

	if (uelo && this.chaptersArr[chapName]) {
		var chapterPagesArr = this.chaptersArr[chapName];
		if (typeof(chapterPagesArr) != 'undefined') {
			var chapterGIX = this.chaptersArr[chapName][0];
			var chapterIndex = this.chaptersArr[chapName][1];

			for (var i=0; i < chapterPagesArr[2].length; i++){
				var subPageIndex = chapterPagesArr[2][i][2];
				var p = uelo.pages[subPageIndex-2];
				if (p.status != 'N') result++;
			};
		};
	};
	return result;
};

componentStatistics.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
};

componentStatistics.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
};
