﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentList = function(name) {
	//inherited
	this.componentCombo = componentCombo;
	this.componentCombo(name);
	this.size = 0;
	this.multiple = false;

	this.interactionsType = "fill-in";
	this.locked = false;
};

componentList.prototype = new componentCombo;
componentList.prototype.type = "componentList";

componentList.prototype.getSize = function() {
	if (is.ns4) {
		return ((this.h - 6) / 20);
	} else {
		return ((this.h - 6) / 16);
	};
};

componentList.prototype.convertStringValueToBoolean = function(val) //pg2-BSH -in old courses there might be a string value
{
	if (typeof(val) == 'undefined') return false;
	
	if (val == 'true' || val == '1') return true; else
	if (val == 'false' || val == '0') return false;
	
	return val;
};

componentList.prototype.onPaint = function(obj) {
	if (this.locked) return;

	var t = '<form id="' + this.id + 'Form" name="' + this.id + 'Form">';
	t += '<select dir="' + this.dir +'" style="width:' + this.w + 'px;" ';
	t += ' size="' + this.getSize() + '"';
	if (this.multiple) {
		t += ' multiple';
		t += ' title="mutliselect = Ctrl+ ..."';
	};

	if (this.disabled == true) {
		t += ' disabled="disabled"';
	};
	
	//pg2-BSH -in old courses there might be a string value
	this.textFontStyle = this.convertStringValueToBoolean(this.textFontStyle);
	this.textFontUnderline = this.convertStringValueToBoolean(this.textFontUnderline);
	this.textFontWeight = this.convertStringValueToBoolean(this.textFontWeight);
	//...
	
	var fontSize = this.textFontSize; //pg2-backward compability
	if (fontSize < 12) fontSize = getFontSize(this.textFontSize, 'px');

	t += ' onfocus="WBTObject.all[\''+this.id+'\'].invokeEvent(\'FocusIn\')"';
	t += ' onblur="WBTObject.all[\''+this.id+'\'].invokeEvent(\'FocusOut\')"';

	t += ' id="' + this.id + 'Select" ';
	//t += ' onChange="page.findChildByName(\'' + this.id + '\').eventOnChange();"';
	t += ' style="font-family: ' + this.textFontFamily + ';';
	//t += ' font-size: ' + this.textFontSize + 'px; color: ' + this.textFontColor + ';';
	//t += ' font-style: ' + this.textFontStyle + '; font-weight: ' + this.textFontWeight + ';"> ';
	t += ' font-size: ' + fontSize + 'px; color: ' + this.textFontColor + ';'; //pg2-new
	t += ' font-style: ' + (this.textFontStyle?'italic':'normal') + '; font-weight: ' + (this.textFontWeight?'bold':'normal') + ';'; //pg2-new
	t += ' text-decoration: ' + (this.textFontUnderline?'underline':'normal') + ';' //pg2-new-deleted -ain't supported
	t += '"> ';
	
	var styleText = 'style="font-family:' + this.textFontFamily + '; font-size:+' + fontSize + 'px; color:' + this.textFontColor + '; ';
	styleText += 'font-style:' + (this.textFontStyle?'italic':'normal') + '; font-weight:' + (this.textFontWeight?'bold':'normal') + '; ';
	styleText += 'text-decoration:' + (this.textFontUnderline?'underline':'normal') + ';';
	styleText += '"';

    var changed = unquotedString(this.listValues);
  
    var arrOpt 	= changed.split("||");
	this.optLength = arrOpt.length;
	for (var i = 0; i < arrOpt.length; i++) {
		var sel = "";
		if (i == this.selectedIndex) sel = "selected";
		t += '<option id="' + this.id + '_option' + i + '" value="' + i + '" ' + sel + '" ' + styleText + '>' + arrOpt[i] + '</option>'; //pg2-style
	};

	t += '</select><br><p id="' + this.id + 'Text" style="font-family: ' + this.textFontFamily + ';';
	t += ' font-size: ' + this.textFontSize + 'px; color: '+this.correctAnswersColor+';"></p>';

	t += "</form>";

	if (this.showHints && !this.hintShowInStep && ((this.hintWidth == 0 || this.hintHeight == 0))) {
		t += '<div id="'+this.id+'_textSize" style="position:absolute; visibility:hidden; left:0px; top:0px; border: solid #000000 0px;"></div>';
	};
	this.setHTML(t);
	this.onRepaint();
};

componentList.prototype.onRepaint = function(obj) {
	var obj = document.getElementById(this.id + "Select");
	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator){
		var correctAnswersList = this.correctAnswer.split("||");
		var index = 0;
		if (obj) {
			for (var i=0; i<obj.options.length; i++) {
				var optObj = obj.options[i];
				if (optObj.selected) {
					if (correctAnswersList[index] == i) {
						optObj.style.background = this.correctColor;
						if (index+1 < correctAnswersList.length) index++;
					} else {
						optObj.style.background = this.incorrectColor;
					};
				} else {
					if (correctAnswersList[index] == i) {
						optObj.style.background = this.incorrectColor;
						if (index+1 < correctAnswersList.length) index++;
					} else {
						//optObj.style.background = this.correctColor;
					};
				};
				optObj.selected = false;
				//optObj.style.background = this.incorrectColor;
			};
		};
	} else
	if (obj) {
		for (var i=0; i<obj.options.length; i++) {
			var optObj = obj.options[i];
			if (optObj) optObj.style.background = 'transparent';
		};
	};
};

componentList.prototype.checkAnswer = function() {
	var obj = document.getElementById(this.id + "Select");
	var ans = obj.selectedIndex;
	var ans2 = obj.value;
	return (this.parseCheckAnswer(this));
};

componentList.prototype.parseCheckAnswer = function(obj) {
	var result = true;
	var correctAnswersList = this.correctAnswer.split("||");
	var index = 0;
	var obj = document.getElementById(this.id + "Select");
	if (!obj) result = false; else
	if (this.multiple) {
		for (var i=0; i<obj.options.length; i++) {
			var optObj = obj.options[i];
			if (correctAnswersList[index] == i) {
				if (!optObj.selected) return false;
				if (index+1 < correctAnswersList.length) index++;
			} else {
				if (optObj.selected) return false;
			};
		};
	} else { //pg2-in case of few options and disabled multiselect, for the correct result all correct were required to be selected
		result = false;
		for (var i=0; i<obj.options.length; i++) {
			var optObj = obj.options[i];
			//if (optObj.selected && correctAnswersList.indexOf(i.toString()) > -1) result = true; //pg2-isn't working in IE
			if (optObj.selected && this.isAnswerOnCorrectOnesList(correctAnswersList, i.toString())) result = true; //pg2-in IE '.indexOf' doesn't work for table
		};
	};
	return result;
};

componentList.prototype.isAnswerOnCorrectOnesList = function(list, value)
{
	var result = false;
	for (var i=0; i<list.length; i++) {
		if (list[i] == value) return true;
	};
};

componentList.prototype.getAnswer = function() {
	var result = "";
	var sep = "";
	var obj = document.getElementById(this.id + "Select");
	if (obj){
		for (var i=0; i<obj.options.length; i++) {
			var optObj = obj.options[i];
			if (optObj.selected) result += sep + i;
			if (result != "") sep = "||";
		};
	};
	return result;
};

componentList.prototype.setAnswer = function(valStr, showCorrect) {
	if (typeof(showCorrect) == "undefined") showCorrect = true;
	if (typeof(valStr) == "undefined") valStr = "";
	if (showCorrect) valStr = this.correctAnswer;
	var answersList = valStr.split("||");
	var index = 0;
	var obj = document.getElementById(this.id + "Select");
	if (obj) {
		for (var i=0; i<obj.options.length; i++) {
			var optObj = obj.options[i];
			if (answersList[index] == i) {
				optObj.selected = true;
				if (index+1 < answersList.length) index++;
			} else {
				optObj.selected = false;
			};
		};
	};
	this.onRepaint();
	return;
};

componentList.prototype.onLock = function() 
{
	var form = page.doc.forms[this.id + "Form"];
	if (form) form[0].disabled = true;
	this.locked = true;
	return true;
};

componentList.prototype.lock = function() {
	return this.onLock();
};

componentList.prototype.onUnLock = function() 
{
	var form = page.doc.forms[this.id + "Form"];
	if (form) form[0].disabled = false;
	this.locked = false;
	return true;
};

componentList.prototype.unlock = function() {
	return this.onUnLock(); //pg2-was onUnlock instead onUnLock
};

componentList.prototype.interactionsCorrectResponsesCount = function()
{
	var corrAnsList = this.correctAnswer.split("||");
	return corrAnsList.length;
};

componentList.prototype.interactionsCorrectResponses = function()
{
	return this.correctAnswer;
};

componentList.prototype.interactionsStudentResponse = function()
{
	return this.getAnswer();
};

componentList.prototype.interactionsCorrectResponsesAsText = function()
{
	var changed = unquotedString(this.listValues);
	var textAnswersList = changed.split("||");
	var correctAnswersList = this.correctAnswer.split("||");
	var result = "";
	var sep = "";

	for (var i=0; i<correctAnswersList.length; i++) {
		var index = parseInt(correctAnswersList[i]);

		result += sep + textAnswersList[index];
		if (result != "") sep = '||';
	};
	return result;
};

componentList.prototype.interactionsStudentResponseAsText = function()
{
	var changed = unquotedString(this.listValues);
	var textAnswersList = changed.split("||");
	var answersList = this.getAnswer().split("||");
	var result = "";
	var sep = "";

	for (var i=0; i<answersList.length; i++) {
		var index = parseInt(answersList[i]);
		if (!isNaN(index)) {
			result += sep + textAnswersList[index];
			if (result != "") sep = '||';
		};
	};
	return result;
};
