﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

VersionsItem = function()
{
	this.name = "";
	this.index = 0;
};

Struct = function()
{
	this.m_list = new Array();
	this.m_root = new Array();
	this.firstOffsetPages = 0;
	this.lastOffsetPages = 0;
	this.countShowPages = 0;
	this.examParentGix = -1;
	this.flatStructure = false;
	this.isCourseMixed = false;
	this.drawingCriterions = "";
	this.versionsItems = new Object();
};

Struct.prototype.root = function(data)
{
	this.m_root = data;
};

Struct.prototype.rootItem = function()
{
	return this.m_root;
};

Struct.prototype.add = function(data)
{
	data["status"] = (data["href"] != "") ? "N" : "X";
	data["realParent"] = data["parent"];
	data["blockRestorePage"] = false;
	data["sessionTime"] = 0;
	data["lockPageScore"] = false; //pg2-courseReport_af
	this.m_list[this.m_list.length] = data;
};

Struct.prototype.firstItem = function()
{
	return this.m_list[0];
};

Struct.prototype.getNextItem = function(gix)
{
	for (var i = 0; i < this.m_list.length; i++) {
		if (gix == this.m_list[i]["gix"] && i < this.m_list.length) {
			return this.m_list[i + 1];
		};
	};
	return null;
};

Struct.prototype.findPageGixByIndex = function(index)
{
	for (var i = 0; i < this.m_list.length; i++) {
		if (index == this.m_list[i]["index"]) {
			return this.m_list[i]["gix"];
		};
	};
	return null;
};

Struct.prototype.getPreviousItem = function(gix)
{
	for (var i = 0; i < this.m_list.length; i++) {
		if (gix == this.m_list[i]["gix"] && i > 0) {
			return this.m_list[i - 1];
		};
	};
	return null;
};

Struct.prototype.findItem = function(gix)
{
	for (var i = 0; i < this.m_list.length; i++) {
		if (gix == this.m_list[i]["gix"]) {
			return this.m_list[i];
		};
	};
	return null;
};

Struct.prototype.findItemGixByArrIndex = function(index)
{
	if (typeof(this.m_list[index]) != 'undefined') {
		return this.m_list[index]['gix'];
	} else {
		return null;
	};
};

Struct.prototype.findItemBy = function(value, col)
{
	if (typeof(col) == "undefined" || col == "" || col == null) col = "gix";
	for (var i = 0; i < this.m_list.length; i++) {
		if (value == this.m_list[i][col]) {
			return this.m_list[i];
		};
	};
	return null;
};

Struct.prototype.findNextVisibleItem = function(gix)
{
	var item = this.findItem(gix);
	if (item) {
		var scan = false;
		for (var i = 0; i < this.m_list.length; i++) {
			if (scan) {
				if (this.m_list[i]["visible"] == "1") {
					return this.m_list[i];
				};
			};
			if (this.m_list[i] == item) scan = true;
		};
	};
	return null;
};

Struct.prototype.findPrevVisibleItem = function(gix)
{
	var item = this.findItem(gix);
	if (item) {
		var scan = false;
		for (var i = this.m_list.length; i>0; i--) {
			if (scan) {
				if (this.m_list[i - 1]["visible"] == "1") {
					return this.m_list[i - 1];
				};
			};
			if (this.m_list[i - 1] == item) scan = true;
		};
	};
	return null;
};

Struct.prototype.findItemByParent = function(index)
{
	for (var i = 0; i < this.m_list.length; i++) {
		if (index == this.m_list[i]["index"]) {
			return this.m_list[i];
		};
	};
	return null;
};

Struct.prototype.isFirstItem = function(gix)
{
	return false;
};

Struct.prototype.isLastItem = function(gix)
{
	return false;
};

Struct.prototype.item = function(index)
{
	var item = this.m_list[index];
	return item;
};

Struct.prototype.length = function(index)
{
	var len = this.m_list.length;
	return len;
};

Struct.prototype.getVisibleItemsCount = function()
{
	var count = 0;
	for (var i = 0; i < this.length(); i++) {
		if (this.m_list[i]["visible"] == "1") count++;
	};
	return count;
};

Struct.prototype.getChapterNumbering = function(gix) //pg2-BI_BM_AKA -dynamic pages within chapters numbering
{
	var res1 = -1; //PAGE_NO_IN_CHAPTER
	var res2 = -1; //PAGES_COUNT_IN_CHAPTER

	var item = this.findItem(gix);
	if (item) {
		var pageNo = 0;
		var pagesCount = 0;
		var parentGix = item['parent'];
		var currPageFound = false;
		for (var i=0; i<this.length(); i++) {
			var subItem = this.m_list[i];
			if (subItem && subItem['visible'] == '1' && subItem['parent'] == parentGix) {
				pagesCount++;
				if (!currPageFound) pageNo++;
				if (subItem['gix'] == gix) currPageFound = true;
			};
		};
		res1 = pageNo;
		res2 = pagesCount;
	};

	return [res1,res2];
};

Struct.prototype.getCurrentCompletionProgress = function() //pg2-PGA -progress perc of completed pages
{
	var allPages = 0;
	var countPages = 0;
	for (var i=0; i<this.length(); i++) {
		var item = this.m_list[i];
		if (item['visible'] == '1') {
			allPages++;
			if (item['status'] != 'N') {
				countPages++;
				res = i;
			};
		};
	};
	return [countPages,allPages];
};

Struct.prototype.getVisibleItemsIndex = function(gix)
{
	var index = 0;
	for (var i = 0; i < this.length(); i++) {
		var sItem = this.m_list[i];
		if (sItem) {
			if (sItem["visible"] == "1") index++;
			if (sItem["gix"] == gix) return index;
		};
	};
	return index;
};

Struct.prototype.getColToString = function(colName)
{
	var result = "";
	for (var i = 0; i < this.m_list.length; i++) {
		var v = this.m_list[i][colName];
		if (colName == 'status') {
			v = (this.m_list[i]['visible'] == '1') ? v:v.toLowerCase();
			if (this.m_list[i]['lockPageScore']) v = 'P'; //pg2-courseReport_af
		};
		result += v;
	};
	return result;
};

Struct.prototype.updateISSFromScoringString = function(v)
{
	var arr = v.split(',');
	var m_list_length = this.m_list.length; //pg2-knf_test
	for (var i = 0; i < arr.length; i++) {
		if (i >= m_list_length) break; //pg2-knf_test
		var v = arr[i];
		this.m_list[i]['iss'] = (v == 'X') ? 0:1;
	};
};

Struct.prototype.setColFromString = function(colName, v)
{
	var sep = "";
	if (v.indexOf(",") > -1) sep = ",";
	var arr = v.split(sep);
	for (var i = 0; i < arr.length; i++) {
		if (typeof(this.m_list[i])!="undefined" && !this.m_list[i]["blockRestorePage"]) {
			var v = arr[i];
			if (colName == 'status') {
				this.m_list[i]['visible'] = (v >= 'a' && v <= 'z') ? '0':'1';
				v = v.toUpperCase();
			};
			this.m_list[i][colName] = v;
		};
	};
};

Struct.prototype.setAllHidden = function(gix)
{
	for (var i = 0; i < this.m_list.length; i++) {
		this.m_list[i]["visible"] = 0;
	};
	return true;
};

Struct.prototype.setAllVisible = function(gix)
{
	for (var i = 0; i < this.m_list.length; i++) {
		this.m_list[i]["visible"] = 1;
	};
	return true;
};

Struct.prototype.Mixed = function()
{
	//pg2-if all are 0, there an exception occures and...nothing will working properly
	if (this.firstOffsetPages == 0 && this.lastOffsetPages == 0 && this.countShowPages == 0) {
		this.countShowPages = this.m_list.length;
	} else
	if (this.countShowPages == 0) { //pg2-also must be fixed
		if (this.m_list.length - this.firstOffsetPages - this.lastOffsetPages >= 1) {
			this.countShowPages = this.m_list.length - this.lastOffsetPages - this.firstOffsetPages;
		} else {
			this.countShowPages = this.m_list.length;
			this.lastOffsetPages = 0;
			this.firstOffsetPages = 0;
		};
	} else
	if (this.m_list.length - this.firstOffsetPages - this.lastOffsetPages < 1) { //pg2-and this too...
		this.countShowPages = this.m_list.length;
		this.lastOffsetPages = 0;
		this.firstOffsetPages = 0;
	};
	
	this.isCourseMixed = true;
	var tempList = new Array();
	this.examParentGix = this.m_list[0]['gix'];

	var draw = new Array();

	if (this.drawingCriterions != "") {
		var a = this.drawingCriterions.split(",");
		for (var i in a) {
			var vg = a[i].split("x");
			draw[draw.length] = new Array(vg[0], vg[1]);
		};
	} else {
		draw[draw.length] = new Array(this.countShowPages, "*");
	};

	for (var i = this.firstOffsetPages; i < this.m_list.length - this.lastOffsetPages; i++) {
		uelo.pages[i].visible = 0;
		uelo.pages[i].blockRestorePage = true;
		//
		uelo.pages[i].iss_old = uelo.pages[i].iss; //pg2-qr
		uelo.pages[i].iss = 0;
		//uelo.pages[i].score = 0; //pg2-qr -removed 4 test
	};

	for (var i = 0; i < this.firstOffsetPages; i++) {
		tempList[tempList.length] = this.m_list[i];
		tempList[tempList.length-1].isExamPage = 0;
		this.examParentGix = this.m_list[i]['gix'];
	};

	for (var drawIndex in draw) {
		var groupName = draw[drawIndex][1];
		var groupCount = draw[drawIndex][0];

		var indexList = new Array();
		for (var i = this.firstOffsetPages; i < this.m_list.length - this.lastOffsetPages; i++) {
			if (groupName == "*" || this.m_list[i]['group'] == groupName) {
				indexList[indexList.length] = i;
			};
		};

		var ueloPage = null;
		if (groupCount > indexList.length) groupCount = indexList.length;

		for (var i = 0; i < groupCount; i++) {
			var index = Math.round(Math.random() * (indexList.length - 1));
			tempList[tempList.length] = this.m_list[indexList[index]];
			tempList[tempList.length-1].isExamPage = 1;
			tempList[tempList.length-1].blockRestorePage = true;
			ueloPage = uelo.FindPage(this.m_list[indexList[index]]['gix']);
			ueloPage.visible = 1;
			//pg2-qr
			ueloPage.iss = ueloPage.iss_old;
			ueloPage.isExamPage = true;
			//
			indexList.splice(index, 1);
		};
	};

	for (var i = this.m_list.length - this.lastOffsetPages; i < this.m_list.length; i++) {
		tempList[tempList.length] = this.m_list[i];
		tempList[tempList.length-1].isExamPage = 0;
	};
	if (this.firstOffsetPages == 0) this.examParentGix = tempList[0]['gix'];
	this.m_list = tempList;
};

Struct.prototype.TreeToList = function()
{
	this.flatStructure = true;
	for (var i = 0; i < this.length(); i++) {
		this.item(i)["parent"] = 1;
	};
};

Struct.prototype.existsVersionItem = function(vindex)
{
	for (var k in this.versionsItems) {
		if (this.versionsItems[k].index == vindex) {
			return true;
		};
	};
	return false;
};

Struct.prototype.getRootVersion = function(vindex)
{
	if (this.m_root["title" + vindex]) {
		return this.m_root["title" + vindex];
	} else {
		return this.m_root["title"];
	};
};

Struct.prototype.addRootVersion = function(index, vindex, s, vname, langCode) //pg2-liag_multiversions -langCode
{
	if (typeof(langCode) == 'undefined') langCode = '';
	this.m_root["title" + vindex] = s;
	this.m_root["langCode" + vindex] = langCode; //pg2-liag_multiversions -operate on proper lang code, not the names
};

Struct.prototype.getVersionsCount = function() //pg2-bsh_qr_multiv
{
	var result = 0;
	if (typeof(this.versionsItems) == 'undefined') return 0;
	try {
		for (var i in this.versionsItems) result++;
	} catch(e) {
		return 0;
	};
	return result;
};

Struct.prototype.addVersionItem = function(vindex, vname, langCode) //pg2-liag_multiversions -langCode
{
	if (typeof(langCode) == 'undefined') langCode = '';
	if (!this.versionsItems["_" + vindex]) {
		this.versionsItems["_" + vindex] = new VersionsItem();
		this.versionsItems["_" + vindex].index = vindex;
		this.versionsItems["_" + vindex].name = vname;
		this.versionsItems["_" + vindex].langCode = langCode; //pg2-liag_multiversions
	};
};

Struct.prototype.addVersion = function(index, vindex, s, vname, langCode) //pg2-liag_multiversions -langCode
{
	if (typeof(langCode) == 'undefined') langCode = '';
	for (var i = 0; i < this.m_list.length; i++) {
		if (index == this.m_list[i]["index"]) {
			this.m_list[i]["title" + vindex] = s;
			this.m_list[i]["langCode" + vindex] = langCode; //pg2-liag_multiversions
			this.addVersionItem(vindex, vname, langCode);
		};
	};
};

Struct.prototype.getGIX = function(idx)
{
	var item = this.findItemBy(idx, "index");
	if (item) {
		return parseInt(item["gix"]);
	};
	return -1;
};

Struct.prototype.setNewStatus = function(newStatus)
{
	for (var i = 0; i < this.m_list.length; i++) {
		this.m_list[i]["status"] = newStatus;
	};
	return true;
};

Struct.prototype.setInformationsPagesCompleted = function()
{
	for (var i = 0; i < this.m_list.length; i++) {
		if (this.m_list[i]["status"] == "I" || this.m_list[i]["status"] == "N") {
			this.m_list[i]["status"] = "C";
		};
	};
	return true;
};

Struct.prototype.setPagesStatus = function(pageType, newStatus)
{
	//pageType = Exercise, Information, All
	if (pageType != 'Exercise' &&  pageType != 'Information' && pageType != 'All') {
		pageType = 'All';
	};

	for (var i = 0; i < this.m_list.length; i++) {
		if (
				(pageType == 'All') || 
				(pageType == 'Exercise' && this.m_list[i]["ms"] != "") || 
				(pageType == 'Information' && this.m_list[i]["ms"] == "")
			)
		{
			this.m_list[i]["status"] = newStatus;
		};
	};
};

Struct.prototype.getMainChapters = function()
{
	var item = null;
	var tmpItem = null;
	var itemInd = -1;
	var chapterName = "";

	for (var i = 0; i < this.m_list.length; i++) {
		item = this.m_list[i];
		if (item['parent'] == 1) {
			item['isMainChapter'] = true;
			item['chapterName'] = item['title'];
		} else {
			item['isMainChapter'] = false;
			itemInd = item['realParent']-2;
			tmpItem = this.m_list[itemInd];
			while (tmpItem) {
				itemInd = tmpItem['realParent']-2;
				chapterName = tmpItem['title'];
				tmpItem = this.m_list[itemInd];
			};
			item['chapterName'] = chapterName;	
		};
	};
};

Struct.prototype.resetPage = function(item) //pg2-bsh
{
	item["status"] = "N";
};

struct = new Struct();
