var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var WatchAndChoose;
(function (_WatchAndChoose) {
    var WatchAndChoose = (function (_super) {
        __extends(WatchAndChoose, _super);
        function WatchAndChoose(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        WatchAndChoose.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        WatchAndChoose.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        WatchAndChoose.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.json.isFirst == true) {
                EU.loadVocabulary(this);
            }
            ;
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            this.createQuestion();
            this.createAnswers();
            this.isCorrect = "isFalse";
        };
        WatchAndChoose.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        WatchAndChoose.prototype.createQuestion = function () {
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex].en;
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
            this.Qtext = this.game.add.text(0, 0, question, this.Elements.Style);
            var posX = this.Elements.Position.x;
            var posY = this.Elements.Position.y;
            if (this.Elements.Just) {
                switch (this.Elements.Just.x) {
                    case "center":
                        posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                        this.Qtext.anchor.x = 0.5;
                        break;
                    case "right":
                        posX += Global.Main.mainContainerDims.wd - 120;
                        this.Qtext.anchor.x = 1;
                        break;
                }
                switch (this.Elements.Just.y) {
                    case "center":
                        posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                        this.Qtext.anchor.y = 0.5;
                        break;
                    case "bottom":
                        posY += Global.Main.mainContainerDims.hg - 65;
                        this.Qtext.anchor.y = 1;
                        break;
                }
            }
            this.Qtext.position.set(posX, posY);
            this.addChild(this.Qtext);
        };
        WatchAndChoose.prototype.createAnswers = function () {
            this.usedAnswers = [];
            this.usedAnswers.push({
                "answer": EU.groups[this.categoryIndex].vocabulary[this.wordIndex].pl,
                "name": null
            });
            for (var i = 0; i < this.Elements.NumberOfAnswers - 1; i++) {
                var answer = { "answer": null, "name": null };
                var flag = false;
                while (flag == false) {
                    flag = true;
                    var answerIndex = this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                    answer.answer = EU.groups[this.categoryIndex].vocabulary[answerIndex].pl;
                    for (var j = 0; j < this.usedAnswers.length; j++) {
                        if (this.usedAnswers[j].answer == answer.answer) {
                            flag = false;
                            break;
                        }
                        flag = true;
                    }
                }
                answer.name = "isFalse";
                this.usedAnswers.push(answer);
            }
            this.usedAnswers[0].name = "isTrue";
            this.usedAnswers = EU.shuffleArray(this.usedAnswers);
            this.textAnswers = [];
            for (var i = 0; i < this.usedAnswers.length; i++) {
                var char = String.fromCharCode(97 + i) + ") ";
                var el = this.game.add.text(0, 0, char + this.usedAnswers[i].answer, this.Elements.AnswerStyle);
                el.position.set(this.Qtext.position.x, this.Qtext.position.y + 1.5 * this.Qtext.height + i * 1.5 * el.height);
                el.anchor = this.Qtext.anchor;
                el.name = this.usedAnswers[i].name;
                el.inputEnabled = true;
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                el.events.onInputDown.add(this.onInputDown, this);
                this.textAnswers.push(el);
                this.addChild(el);
            }
        };
        WatchAndChoose.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        WatchAndChoose.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        WatchAndChoose.prototype.clearAnswers = function () {
            for (var i = 0; i < this.textAnswers.length; i++) {
                this.textAnswers[i].removeChildren();
            }
        };
        WatchAndChoose.prototype.onInputDown = function (el, pointer) {
            this.clearAnswers();
            var rect = EU.drawRect("blue", el.width + 10, el.height, el.height / 10, el.height / 10, this);
            rect.position.x = -el.width / 2 - 5;
            el.addChild(rect);
            this.isCorrect = el.name;
            this.checkIfEverythingIsCorrect();
        };
        WatchAndChoose.prototype.checkIfEverythingIsCorrect = function () {
            if (this.isCorrect == "isTrue") {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            ;
            EU.setGameCompletion(this.parent, 0);
            EU.Log("NotCorrect!!! :<");
            return false;
        };
        return WatchAndChoose;
    })(Base.BasicGroup);
    _WatchAndChoose.WatchAndChoose = WatchAndChoose;
})(WatchAndChoose || (WatchAndChoose = {}));
//# sourceMappingURL=WatchAndChoose.js.map