﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
if (typeof(moduleDone) != "undefined") moduleDone("debug.js");
 
Log = function()
{
	this.beginDate = new Date();
	this.m_debugEnable = false;
	this.m_debugShow   = false;
	this.showDiff	   = true;
	this.showLogTimeOver = 0;
	this.m_debugLog    = new Array();
	this.m_blockOffset = 0;
	this.showError	   = true;
	this.showInfo      = true;
	this.showWarning   = true;
	this.showBegin     = true;
	this.showEnd       = true;
	this.showBlink     = true;
	this.m_mtError     = {"text":"Error", "color":"red"};
	this.m_mtInfo      = {"text":"Info", "color":"black"};
	this.m_mtWarning   = {"text":"Warning", "color":"blue"};
	this.m_mtBegin     = {"text":"Begin", "color":"green"};
	this.m_mtEnd       = {"text":"End", "color":"brown"};
	this.m_mtBlink     = {"text":"Blink", "color":"purple"};
	this.info("Log class - start");
};

Log.prototype.checkDbgShow = function()
{
	if (this.m_debugShow) {
		return this.m_debugShow;
	};
	if (typeof(getPlayer) == 'function') {
		return (getPlayer())?getPlayer().dbgWinShow:false;
	};
	return false;
};

Log.prototype.checkDbgEnabled = function()
{
	if (this.m_debugEnable) {
		return this.m_debugEnable;
	};
	if (typeof(getPlayer) == 'function') {
		return (getPlayer())?getPlayer().dbgWinEnabled:false;
	};
	return false;
};

Log.prototype.checkAddMSg = function(type)
{
	switch (type)
	{
		case 'Error':
			return this.showError;
			break;
		case 'Info':
			return this.showInfo;
			break;
		case 'Warning':
			return this.showWarning;
			break;
		case 'Begin':
			return this.showBegin;
			break;
		case 'End':
			return this.showEnd;
			break;
		case 'Blink':
			return this.showBlink;
			break;
		default:
			return true;
			break;
	};
};

Log.prototype._msg = function(type, msg, text)
{
	if (!this.checkDbgEnabled()) return;
	if (!this.checkAddMSg(type['text'])) return;

	//d = d - this.refDate;
	var s = "";
	var offset = ": ";
	var blink = "";
	s += "<p style=\"margin: 0px; color:" + type["color"] + ";\">"
	for (var i = 0; i < this.m_blockOffset; i++) {
		s += "-";
		offset = ">: ";
	};

	var d = new Date();
	var diffTime=this.calculateTimeToString(this.beginDate, d);
	if (parseInt(diffTime) < this.showLogTimeOver) return;
	this.beginDate = new Date();
	if (this.showDiff) {
		s += offset+diffTime+"| ";
	} else {
		var h = d.getHours();
		var m = d.getMinutes();
		m = ((m < 10) ? "0" : "") + m;
		var sec = d.getSeconds();
		sec = ((sec < 10) ? "0" : "") + sec;
		var msec = d.getMilliseconds();
		msec = ((msec < 10) ? "0" : "") + msec;
		//s += "<pre style=\"margin: 0px; color=" + type["color"] + ";\">" + type["text"] + (h + ":" + m + ":" + sec + "." +msec);
		s += offset+(h + ":" + m + ":" + sec + "." +msec)+"| ";
	};

	if (text) {
		s += msg + "\r\n<span style='color=#aaaaaa'>" + text + "</span>";//"</pre>";
	} else {
		s += msg;//+"</pre>";
	};
	s += "</p>";

	if (this.checkDbgShow()) {
		var o = window.open("","WBTAPIDebug","toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,left=0,top=0,width=300,height=" + (screen.height - 50));
		top.window.moveTo(310, 0);
		top.window.resizeTo(screen.width - 310, screen.height - 50);
		if (o && this.m_debugLog.length > 0 ) {
			for (var i = 0; i < this.m_debugLog.length; i++) {
				o.document.write(this.m_debugLog[i]);
			};
			delete (this.m_debugLog);
			this.m_debugLog = new Array();
		};
		if (o) o.document.write(s);
	} else {
		this.m_debugLog[this.m_debugLog.length] = s;
	};
};

Log.prototype.resetTime = function(msg, text)
{
	this.beginDate = new Date();
};

Log.prototype.error = function(msg, text)
{
	this._msg(this.m_mtError, msg, text);
};

Log.prototype.info = function(msg, text)
{
	this._msg(this.m_mtInfo, msg, text);
};

Log.prototype.warning = function(msg, text)
{
	this._msg(this.m_mtWarning, msg, text);
};

Log.prototype.begin = function(msg, text)
{
	this._msg(this.m_mtBegin, msg, text);
	this.m_blockOffset++;
};

Log.prototype.end = function(msg, text)
{
	this.m_blockOffset--;
	if (this.m_blockOffset < 0) this.m_blockOffset = 0;
	this._msg(this.m_mtEnd, msg, text);
};

Log.prototype.blink = function(msg, text)
{
	this._msg(this.m_mtBlink, "<blink>"+msg+"</blink>", text);
};

Log.prototype.showWindow = function()
{
	this.m_debugShow = true;
	this.info("Show debuger window");
};

Log.prototype.calculateTimeToString = function(dateStart, dateEnd)
{
	var dd = Math.abs( dateEnd.getTime() - dateStart.getTime() );
	var ds = ((dd < 10) ? "0" : "") + dd;
	ds = ((dd < 100) ? "0" : "") + ds;
	ds = ((dd < 1000) ? "0" : "") + ds;
	return (ds);
};

log = new Log();

AdminPanel = function()
{
	this.id = "AdminPanel";
	this.winTitle = "Panel Administracyjny";
	this.debugTable = null;
	this.autoStudentTimer = null;
	this.autoStudentNextParam = "";
	this.autoStudentEnabled = false;
	this.dragElement = null;
	this.dragElementOffsettop = 0;
};

AdminPanel.prototype.getStyles = function()
{
	var css = "";
	css += 'h4{text-align:center;padding: 0px; margin: 0px;}';
	css += 'hr{margin: 5px 0px 5px 0px;}';
	css += 'div, table{text-align:center;width:100%;font-size:10px;font-family:Verdana;}';
	css += 'table tr.odd{background-color: #A9A9A9;}';
	css += 'table tr.even{background-color: #E1E1E1;}';
	css += 'table td.left{text-align:left;}';
	css += 'div.left{text-align:left;}';
	css += 'div.short input{width:50px;}';
	css += 'input.button{width:200px;}';
	css += 'input.checkbox{width:20px;}';
	css += 'table{width:100%;}';
	css += 'table{border-collapse: collapse;}';
	css += 'table td{border:1px solid #003366;}';
	css += 'table td.header{border:1px solid #003366; background-color: #d2d2d2;}';
	css += '#debugTable a{text-decoration: underline; cursor: pointer;};';
	css += '.title{text-align:left;border:1px solid #000000; background-color: #d2d2d2;}';
	css += '.content{height: 100px;border:1px solid #000000;overflow-x:hidden;overflow-y:auto;}';
	css += '.dbgFooter{height: 10px;border:1px solid #000000;background-color:#e2e2e2;overflow:hidden;cursor:n-resize;}';

	return css;
};

AdminPanel.prototype.showWindow = function()
{
	var oWin = window.open("", "_blank", "toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,left=" + parseInt(screen.width/2-150) + ",top=" + parseInt(screen.height/2-150) + ",width=300,height=600");

	if (oWin) {
		windowPopup = oWin;
		windowPopup.document.write("<TITLE>"+this.winTitle+"</TITLE>");
		windowPopup.document.write("<script type='text/javascript' src='../api/debug.js'>");
		windowPopup.document.write("</script>");
		windowPopup.document.write("<script type='text/javascript' src='../api/tools.js'>");
		windowPopup.document.write("</script>");
		windowPopup.document.write("<style type='text/css'> ");
		windowPopup.document.write(this.getStyles());
		windowPopup.document.write("</style>");
		windowPopup.document.write("<BODY onload='adminPanel.showPanel();'>");
		windowPopup.document.write("<h4>"+this.winTitle+"</h4>");
		windowPopup.document.write("<hr>");
		windowPopup.document.write("</BODY>");
		windowPopup.document.write("</HTML>");
		windowPopup.document.close();
		windowPopup.focus();
		return true;
	} else {
		alert("Please turn on show popups in browser.");
		return false;
	};
};

AdminPanel.prototype.showPanel = function()
{
	var btn = null;
	btn = this.addInput("corrAns", "Correct Answer", "button", "", "left", "", null);
	this.addEvent(btn, "click", function(){ adminPanel.showCorrectAnswer();});

	btn = this.addInput("confAns", "Confirm Answer - OK", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.confirmAnswer();});

	this.addSeparator(null);

	btn = this.addInput("resetPage", "Reset Page - >*<", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.resetPage();});

	btn = this.addInput("refreshPage", "Refresh Page - >|<", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.refreshPage();});

	btn = this.addInput("nextPage", "Next Page - >>", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.nextPage();});

	btn = this.addInput("nextStep", "Next Step - >", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.nextStep();});

	btn = this.addInput("prevPage", "<< - Previous Page", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.prevPage();});

	btn = this.addInput("prevStep", "< - Previous Step", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.prevStep();});

	this.addSeparator(null);

	btn = this.addInput("pagesStatus", "Pages Status", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.pagesStatus();});

	btn = this.addInput("courseConfig", "Show Course Config", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.courseConfig();});

	btn = this.addInput("userVars", "Show User Variables", "button", "", "left","", null);
	this.addEvent(btn, "click", function(){ adminPanel.showUserVars();});

	this.addSeparator(null);

	btn = this.addInput("winDbgEnabled", "", "checkbox", "Debug Window Enabled", "right", "left", null);
	this.addEvent(btn, "click", function(){ adminPanel.winDbgEnabled("winDbgEnabled");});

	btn = this.addInput("winDbgShow", "", "checkbox", "Debug Window Show", "right", "left", null);
	this.addEvent(btn, "click", function(){ adminPanel.winDbgShow("winDbgShow");});

	btn = this.addInput("resetCourseData", "", "checkbox", "Reset Course Data", "right", "left", null);
	this.addEvent(btn, "click", function(){ adminPanel.resetCourseData("resetCourseData", "courseScore", "courseStatus");});

	btn = this.addInput("courseScore", "", "input", "Course Score (0-100)", "left", "left short", null);
	this.addEvent(btn, "blur", function(){ adminPanel.setCourseScore("courseScore");});

	select = this.addSelect("courseStatus", "Course Status", this.getCourseStatus(), "left", "left short", null);
	this.addEvent(select, "change", function(){ adminPanel.setCourseStatus("courseStatus");});

	select = this.addSelect("coursePagesStatus", "Course Pages Status", this.getCoursePagesStatus(), "left", "left short", null);
	this.addEvent(select, "change", function(){ adminPanel.setCoursePagesStatus("coursePagesStatus");});

	this.addSeparator(null);

	select = this.addSelect("autoStudent", "Auto Student", this.getAutoStudentOptions(), "left", "left short", null);
	this.addEvent(select, "change", function(){ adminPanel.autoStudentStart("autoStudent");});

	btn = this.addInput("stopOnExercise", "", "checkbox", "Stop on exercise page", "right", "left", null);
	this.addEvent(btn, "click", function(){ adminPanel.stopOnExercise("stopOnExercise");});

	select = this.addSelect("pagesList", "", this.getPagesList(), "left", "left short", null);
	this.addEvent(select, "change", function(){ adminPanel.changePage("pagesList");});

	this.addDiv("dbgDiv", "Debug", "content", "", null);
	var div = this.addDiv("dbgDivFooter", "", "dbgFooter", "****", null);

	this.addEvent(div, "mousedown", function(e){ adminPanel.divMousedown("dbgDiv");});
	this.addEvent(div, "mouseup", function(){ adminPanel.divMouseup();});
	this.addEvent(div, "mousemove", function(e){ adminPanel.divMousemove(e);});
	this.addEvent(document.getElementsByTagName("body")[0], "mousemove", function(e){ adminPanel.divMousemove(e);});
};

AdminPanel.prototype.addEvent = function(node, eventName, func)
{
	if (node.addEventListener) {
		node.addEventListener(eventName, func, false);
	} else {
		node.attachEvent('on' + eventName, func);
	};
};

AdminPanel.prototype.addSeparator = function(where)
{
	var hr = document.createElement('hr');
	this.addElement(hr, where);
};

AdminPanel.prototype.addDiv = function(id, name, cssClass, defaultContent, where)
{
	var div = document.createElement('div');

	var content = document.createElement('div');
	content.setAttribute('id', id);
	content.className = cssClass;

	if (name != "") {
		var title = document.createElement('div');
		title.className = 'title';
		title.innerHTML = name;
		this.addElement(title, div);
	};
	if (defaultContent != "") {
		var contentText = document.createTextNode(defaultContent);
		this.addElement(contentText, content);
	};
	this.addElement(content, div);
	this.addElement(div, where);

	return div;
};

AdminPanel.prototype.addInput = function(id, name, type, captionText, captionAlign, cssClass, where)
{
	var div = document.createElement('div');
	if (cssClass != "" ) div.className = cssClass;

	var caption = document.createElement('span');
	caption.innerHTML = captionText;

	var btn = document.createElement('input');
	btn.setAttribute('id', id);
	btn.setAttribute('type', type);
	btn.className = type;
	if (name != "") {
		btn.setAttribute('value', name);
	};
	if (captionAlign == "left") {
		this.addElement(caption, div);
		this.addElement(btn, div);
	} else {
		this.addElement(btn, div);
		this.addElement(caption, div);
	};
	this.addElement(div, where);

	return btn;
};

AdminPanel.prototype.addSelect = function(id, captionText, optionsArr, captionAlign, cssClass, where)
{
	var div = document.createElement('div');
	if (cssClass != "" ) div.className = cssClass;

	var caption = document.createElement('span');
	caption.innerHTML = captionText;

	var select = document.createElement('select');
	select.setAttribute("id", id);
	select.setAttribute("value", "4");
	var item = null;

	for (var i = 0; i < optionsArr.length; i++) {
		item = optionsArr[i];
		option = document.createElement("OPTION");

		option.value = item[0];
		option.text =  item[1]
		select.options.add(option);
	};
	if (captionAlign == "left") {
		this.addElement(caption, div);
		this.addElement(select, div);
	} else {
		this.addElement(select, div);
		this.addElement(caption, div);
	};
	this.addElement(div, where);
	return select;
};

AdminPanel.prototype.getAutoStudentOptions = function()
{
	var resultArr = new Array();
	resultArr.push(["break", "Do nothing"]);
	resultArr.push(["step|page|1|sec", "Step, Page 1 sec"]);
	resultArr.push(["step|page|2|sec", "Step, Page 2 sec"]);
	resultArr.push(["step|page|3|sec", "Step, Page 3 sec"]);
	resultArr.push(["step|page|4|sec", "Step, Page 4 sec"]);
	resultArr.push(["|page|1|sec", "Page 1 sec"]);
	resultArr.push(["|page|2|sec", "Page 2 sec"]);
	resultArr.push(["|page|3|sec", "Page 3 sec"]);
	resultArr.push(["|page|4|sec", "Page 4 sec"]);
	return resultArr;
};

AdminPanel.prototype.getCourseStatus = function()
{
	var resultArr = new Array();
//	resultArr.push(["not attempted", "Not attempted"]);
	resultArr.push(["---", "---"]);
	resultArr.push(["incomplete", "Incomplete"]);
	resultArr.push(["completed", "Completed"]);
	/*
	resultArr.push(["passed", "Passed"]);
	resultArr.push(["failed", "Failed"]);
	*/
	return resultArr;
};

AdminPanel.prototype.getCoursePagesStatus = function()
{
	var resultArr = new Array();
	resultArr.push(["---", "---"]);
	resultArr.push(["not attempted", "Not attempted"]);
	resultArr.push(["inpleted", "Incompleted"]);
	resultArr.push(["completed", "Completed"]);
	resultArr.push(["completedPassed", "Completed/Passed"]);
	resultArr.push(["inpletedPassed", "Incompleted/Passed"]);
	resultArr.push(["inpletedFailed", "Incompleted/Failed"]);
	resultArr.push(["not attemptedTCur", "Not attempted to current"]);
	resultArr.push(["inpletedTCur", "Incompleted to current"]);
	resultArr.push(["completedTCur", "Completed to current"]);
	resultArr.push(["completedPassedTCur", "Completed/Passed to current"]);
	resultArr.push(["inpletedPassedTCur", "Incompleted/Passed to current"]);
	resultArr.push(["inpletedFailedTCurTCur", "Incompleted/Failed to current"]);
	return resultArr;
};

AdminPanel.prototype.getPagesList = function()
{
	var uelo = getUELO();
	if (uelo) {
		var resultArr = new Array();
		var item = null;
		var option = null;
		var title = "";

		for (var i = 0; i < uelo.pages.length; i++) {
			item = uelo.pages[i];
			title = item.title;
			resultArr.push([item.globalIndex, title+" ["+item.globalIndex+"]"]);
		};
		return resultArr;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.addElement = function(theElement, where)
{
	if (!where) {
		where=document.getElementsByTagName('body')[0];
	};
	where.appendChild(theElement);
};

AdminPanel.prototype.showCorrectAnswer = function()
{
	var page = getPage();
	if (page) {
		page.showCorrectAnswer();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.confirmAnswer = function()
{
	var page = getPage();
	if (page) {
		page.actionCheckAnswer();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.resetPage = function()
{
	var page = getPage();
	if (page) {
		page.resetPage();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.refreshPage = function()
{
	var page = getPage();
	if (page) {
		page.refreshPage();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);;
	};
};

AdminPanel.prototype.prevStep = function()
{
	var page = getPage();
	if (page) {
		page.prevStep();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.prevPage = function()
{
	var player = getPlayer();
	if (player) {
		player.backwards();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.nextPage = function()
{
	var player = getPlayer();
	if (player) {
		player.further();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.nextStep = function()
{
	var page = getPage();
	if (page) {
		page.nextStep();
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.showUserVars = function(elemId)
{
	if (opener && opener.me) {
		var userVars = opener.me;

		this.clearDebugDiv();
		this.setDebugTableHeader(['Param Name', 'Value']);

		for (var k in userVars) {
			this.createDebugTable(k, userVars[k])
		};
		this.writeContentToWindow(this.getDebugTable());
	};
};

AdminPanel.prototype.winDbgEnabled = function(elemId)
{
	var player = getPlayer();
	if (player) {
		var obj = this.getElement(elemId);
		player.dbgWinEnabled = obj.checked;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.winDbgShow = function(elemId)
{
	var player = getPlayer();
	if (player) {
		var obj = this.getElement(elemId);
		player.dbgWinShow = obj.checked;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.resetCourseData = function(elemId, selectId, inputId)
{
	var player = getPlayer();
	if (player) {
		var obj = this.getElement(elemId);
		player.resetCourseData = obj.checked;

		var elem = this.getElement(selectId);
		elem.disabled = obj.checked;
		var elem = this.getElement(inputId);
		elem.disabled = obj.checked;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.setCourseScore = function(elemId)
{
	var player = getPlayer();
	if (player)	{
		var obj = this.getElement(elemId);
		var score = obj.value;
		if (isNaN(score) || score == "") {
			score = -1;
		} else
		if (score < 0) {
			score = 0;
		} else
		if (score > 100) {
			score = 100;
		};
		player.dbgCourseScore = score;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.setCourseStatus = function(elemId)
{
	var player = getPlayer();
	if (player)	{
		var value = "";
		var obj = this.getElement(elemId);
		if (obj.value != '---') value = obj.value;
		player.dbgCourseStatus = value;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.setCoursePagesStatus = function(elemId)
{
	var uelo = getUELO();
	var struct = getStruct();
	if (struct && uelo)	{
		if (struct.length() != uelo.pages.length) return;

		var currentPageGIX = 0;
		var infoPageStatus = '';
		var examPageStatus = '';
		var obj = this.getElement(elemId);

		infoPageStatus = (obj.value.indexOf("not attempted") > -1)?"N":infoPageStatus;
		infoPageStatus = (obj.value.indexOf("inpleted") > -1)?"I":infoPageStatus;
		infoPageStatus = (obj.value.indexOf("completed") > -1)?"C":infoPageStatus;

		examPageStatus = (obj.value.indexOf("Passed") > -1)?"P":examPageStatus;
		examPageStatus = (obj.value.indexOf("Failed") > -1)?"F":examPageStatus;

		examPageStatus = (examPageStatus == "")?infoPageStatus:examPageStatus;

		if (infoPageStatus == "" && examPageStatus == "") return;

		if (obj.value.indexOf("TCur") > -1) {
			var coursePage = getPage();
			if (coursePage) currentPageGIX = coursePage.p_globalIndex;
		};
		var item = null;
		var ueloPage = null;

		for (var i = 0; i < struct.length(); i++) {
			item = struct.item(i);
			ueloPage = uelo.pages[i];
			if (item["iss"] == "0") continue;
			if (item["visible"] == "1") {
				var pageMS = parseInt(item["ms"]);
				if (!isNaN(pageMS)) {
					item["status"] = examPageStatus;
					ueloPage.status = examPageStatus;
				} else {
					item["status"] = infoPageStatus;
					ueloPage.status = infoPageStatus;
				};
			};
			if (item["gix"] == currentPageGIX) return;
		};
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};
AdminPanel.prototype.stopOnExercise = function(elemId)
{
	var obj = this.getElement(elemId);
	this.stopExercisePage = obj.checked;
};

AdminPanel.prototype.autoStudentOnInterval = function(elemId)
{
	this.autoStudentStopTimer();
	if (!this.autoStudentEnabled) return;

	var coursePage = getPage();
	if (coursePage) {
		if (coursePage.pageType == 'Exercise') {
			if (this.stopExercisePage) {
				this.autoStudentStop(elemId);
				return;
			};
		};
		if (this.checkIsLastPage(coursePage.p_globalIndex) && this.checkIsPageCompleted(coursePage)) {
			this.autoStudentStop(elemId);
			return;
		};
		switch (this.autoStudentNextParam)
		{
			case 'page' :
				coursePage.nextPage();
				break;
			case 'steppage' :
				coursePage.further();
				break;
		};
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
		this.autoStudentStop(elemId);
		return;
	};
	this.autoStudentStart(elemId);
};

AdminPanel.prototype.autoStudentStop = function(elemId)
{
	this.autoStudentEnabled = false;
	this.autoStudentStopTimer();
	var obj = this.getElement(elemId);
	obj.selectedIndex = 0;
};

AdminPanel.prototype.autoStudentStopTimer = function(elemId)
{
	if (this.autoStudentTimer != null) {
		window.clearTimeout(this.autoStudentTimer);
		this.autoStudentTimer = null;
	};
};

AdminPanel.prototype.autoStudentStart = function(elemId)
{
	var obj = this.getElement(elemId);
	if (obj.value == 'break') {
		this.autoStudentStop(elemId);
	} else {
		var paramArr = obj.value.split('|'); //step|page|4|sec"
		this.autoStudentNextParam = paramArr[0]+paramArr[1];
		this.autoStudentEnabled = true;

		this.autoStudentTimer = window.setTimeout('adminPanel.autoStudentOnInterval("'+elemId+'");', parseInt(paramArr[2])*1000);
	};
};

AdminPanel.prototype.checkIsPageCompleted = function(coursePage)
{
	return ((coursePage.pageStatus == 'completed') || (autoStudentNextParam == 'nextPage'));
};

AdminPanel.prototype.checkIsLastPage = function(gix)
{
	var uelo = getUELO();
	if (uelo) {
		gix = parseInt(gix);
		var count = uelo.pages.length;
		var pGix = uelo.pages[count - 1].globalIndex;
		if (gix == pGix) return true; else return false;
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.getElement = function(elemId)
{
	return document.getElementById(elemId);
};

AdminPanel.prototype.pagesStatus = function(gix)
{
	if (!uelo) var uelo = getUELO();
	if (uelo) {
		this.clearDebugDiv();

		this.setDebugTableHeader(['Page Name', 'Status']);
		var pagesArr = uelo.getPagesArrWithStatus();
		var name = "";

		for (var i=0; i < pagesArr.length; i++) {
			name = '<a onclick="javascript: if(getPlayer())getPlayer().gotoPage('+pagesArr[i][0]+');">'+pagesArr[i][1]+'</a>';
			this.createDebugTable(name, pagesArr[i][2]);
		};
		this.writeContentToWindow(this.getDebugTable());
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.findConfigInFrame = function(frame)
{
	if (typeof(frame) == "undefined") {
		frame = frames;
	};
	var obj = frame.config
	if (obj) return obj;
	for (var i = 0; i < frame.length; i++) {
		var result = this.findConfigInFrame(frame[i]);
		if (result) return result;
	};
	return null;
};

AdminPanel.prototype.courseConfig = function()
{
	if (opener) {
		var config = this.findConfigInFrame(opener.top);
		if (config) {
			this.clearDebugDiv();
			this.setDebugTableHeader(['Param Name', 'Value']);

			for (var k in config) {
				this.createDebugTable(k, config[k])
			};
			this.writeContentToWindow(this.getDebugTable());
		} else {
			this.showMessage("Nie znaleziono 'configu' kursu.", false);
		};
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.changePage = function(elemId)
{
	var player = getPlayer();
	if (player) {
		var obj = this.getElement(elemId);
		var gix = obj.value;
		player.gotoPage(gix);
	} else {
		this.showMessage("Prosze uruchomić Panel ponownie.", true);
	};
};

AdminPanel.prototype.clearDebugDiv = function()
{
	var elem = document.getElementById('dbgDiv');
	elem.innerHTML = "";
	this.debugTable = null;
};

AdminPanel.prototype.getDebugTable = function()
{
	if (this.debugTable) {
		return this.debugTable;
	} else {
		return "";
	};
};

AdminPanel.prototype.createDebugTable = function(gix)
{
	this.debugTable.setAttribute('id', 'debugTable');
	var newRow = this.debugTable.insertRow(this.debugTable.rows.length);
	if (this.debugTable.rows.length % 2 == 0 ) {
		newRow.className = "odd";
	} else {
		newRow.className = "even";
	};
	var newCell = null;

	for (var i=0; i < arguments.length; i++) {
		newCell = newRow.insertCell(i);
		if (i == 0) newCell.className = "left";
		newCell.innerHTML = arguments[i];
	};
};

AdminPanel.prototype.setDebugTableHeader = function(headerNamesArr)
{
	if (!this.debugTable) {
		this.debugTable = document.createElement('table');
		this.debugTable.style.width = '100%';
	};
	var newRow = this.debugTable.insertRow(0);
	var newCell = null;

	for (var i=0; i < headerNamesArr.length; i++) {
		newCell = newRow.insertCell(i);
		newCell.className = 'header';
		newCell.innerHTML = headerNamesArr[i];
	};
};

AdminPanel.prototype.writeContentToWindow = function(theElement)
{
	var elem = document.getElementById('dbgDiv');
	this.addElement(theElement, elem);
};

AdminPanel.prototype.divMousedown = function(elemId)
{
	var obj = this.getElement(elemId);
	this.dragElement = obj;
	this.dragElementOffsettop = this.getDragElementOffsettop(obj);
};

AdminPanel.prototype.divMouseup = function()
{
	this.dragElement = null;
	this.dragElementOffsettop = 0;
};

AdminPanel.prototype.divMousemove = function(e)
{
	if (this.dragElement) {
		e = (e)?e:event;
		this.dragElement.style.height = parseInt(e.clientY - this.dragElementOffsettop - 10) + 'px';
	};
};

AdminPanel.prototype.getDragElementOffsettop = function(obj)
{
	var curtop = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop
			obj = obj.offsetParent;
		};
	} else
	if (obj.y) {
		curtop += obj.y;
	};
	return curtop;
};

AdminPanel.prototype.showMessage = function(message, closePanel)
{
	if (closePanel) message += message +"\n\nPanel zostanie zamknięty po naciśnięciu na OK."
	alert(message);
	if (closePanel) window.close();
};

adminPanel = new AdminPanel();
