﻿/*
 * Copyright © 1995-2005 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

ScormLMS = function()
{
	this.startTime = new Date();
  
	this.err;
	this.errDescription;
	
	// Define exception / error codes
	this._NoError = 0;
	this._GeneralException = 101;
	this._InvalidArgumentError = 201;
	this._NotInitialized = 301;
	this._NotImplementedError = 401;
	this._CompletedLock = false;

	this.STATUS_NOT_ATTEMPTED = "not attempted";
	this.STATUS_INCOMPLETE = "incomplete";
	this.STATUS_COMPLETED = "completed";
	this.STATUS_PASSED = "passed";
	this.STATUS_FAILED = "failed";
  
	this.apiHandle;
	
	this.LMSInitialize();
};

ScormLMS.prototype.name = "Scorm";

ScormLMS.prototype.setTime = function()
{
  this.LMSSetValue("cmi.core.session_time", this.calculateTimeToString(this.startTime, new Date()));
};

ScormLMS.prototype.setScore = function(score)
{
  this.LMSSetValue("cmi.core.score.raw", score);
};

ScormLMS.prototype.getScore = function()
{
  return this.LMSGetValue("cmi.core.score.raw");
};

ScormLMS.prototype.free = function()
{
	this.setTime();
	//this.LMSSetValue("cmi.core.exit", ""); //pg2- MK
	this.LMSCommit();        
	this.LMSFinish();
};

ScormLMS.prototype.LMSGetValue = function(command)
{
	if (typeof(log) != 'undefined') log.info("ScormLMS::LMSGetValue " + command); //pg2- added condition
	h = this.getAPIHandle();
	if (h) return h.LMSGetValue(command);
	this.err = this.getErrorHandler();
	return null;
};

ScormLMS.prototype.LMSSetValue = function(command, value)
{
	if (typeof(log) != 'undefined') log.info("ScormLMS::LMSSetValue " + command + " - " + value); //pg2- added condition
	h = this.getAPIHandle();
	if (h) h.LMSSetValue(command, value);
	this.err = this.getErrorHandler();
};

ScormLMS.prototype.LMSInitialize = function()
{
	if (this.getAPIHandle() == null) {
		//alert("Unable to locate the LMS's API Implementation.\nLMSInitialize was not successful.");
		//top.window.location.href="../html/lms_error.html";
		return false;
	};

	// call the LMSInitialize function that should be implemented by the API
	var initResult = this.getAPIHandle().LMSInitialize("");
	if (!initResult) {
		// LMSInitialize did not complete successfully.

		// Note: An assumption is made that if LMSInitialize returns a non-true
		//                   value, then and only then, an error was raised.

		// Note: Each function could define its own error handler, but we'll
		// just implement a generic one in this example.
		this.err = this.getErrorHandler();
	};

	return initResult;
};

ScormLMS.prototype.getAPIHandle = function()
{
	if(this.apiHandle == null)
		this.apiHandle = this.getAPI();
	return this.apiHandle;
};

ScormLMS.prototype.findAPI = function(win)
{
	// Search the window hierarchy for an object named "API"
	// Look in the current window (win) and recursively look in any child frames
	try {
		if (win && win.API != null) return win.API;
	} catch(e) {};
		
	if (win && win.length > 0 ) {
		for (var i = 0; i < win.length; i++) {
			var theAPI = this.findAPI( win.frames[i] );			
			if (theAPI != null) {
				return theAPI;
			};
		};
	};  
	return null;
};

ScormLMS.prototype.getAPI = function()
{
	// start at the topmost window - findAPI will recurse down through
	// all of the child frames
	var theAPI = this.findAPI( parent );
	var isOpener=false;
	if (theAPI == null) theAPI = this.findAPI(window.top);
	// the API wasn't found in the current window's hierarchy.  If the
	// current window has an opener (was launched by another window),
	// check the opener's window hierarchy.
	if (theAPI == null){		
		var tempWin = window.parent.opener;
		if(tempWin != null) isOpener = true;
		while(isOpener){
			if(tempWin.top) theAPI = this.findAPI(tempWin.top);
			if (theAPI != null) break;
			tempWin = tempWin.parent.opener;
			if(tempWin != null) isOpener = true;
			else isOpener = false;
		};
	};
	//alert('theAPI: '+theAPI);
	return theAPI;
};

ScormLMS.prototype.getErrorHandler = function()
{
	if (this.getAPIHandle() == null) {
		//alert("Unable to locate the LMS's API Implementation.\nCannot determine LMS error code.");
		return;
	};

	// check for errors caused by or from the LMS
	var errCode = this.getAPIHandle().LMSGetLastError().toString();
	if (errCode != this._NoError) {
		// an error was encountered so display the error description
		this.errDescription = this.getAPIHandle().LMSGetErrorString( errCode );
		if (typeof(log) != 'undefined') log.error("ScormLMS::getErrorHandler "+errCode+":"+this.errDescription);
	};

	return errCode;
};

ScormLMS.prototype.LMSCommit = function()
{
	if( this.getAPIHandle() != null ) {
		this.getAPIHandle().LMSCommit("");
		this.err = this.getErrorHandler();    
	};

	return;
};

ScormLMS.prototype.LMSFinish = function()
{
	if (this.getAPIHandle() != null) {
		this.getAPIHandle().LMSFinish("");
		var err = this.getErrorHandler();
	};
	return;
};

ScormLMS.prototype.gotoEncyclopedia = function(wordToSearch)
{
	var api = this.getAPIHandle();
	
	if (api) {
		if (typeof(api.goToEncyclopedia) == "function") {
			api.goToEncyclopedia(wordToSearch);
		} else {
			alert("Unable to locate 'gotoEncyclopedia' method.\n.");
		};
	} else {
		alert("Unable to locate the LMS's API Implementation.\nMethod defined only in WBTServer LMS.");
	};
	return;
};

ScormLMS.prototype.calculateTimeToString = function(dateStart, dateEnd)
{
	var dd = Math.abs( dateEnd.getTime() - dateStart.getTime() );
	var ts = Math.floor( ( ( (dd % (60 * 60 * 1000 * 24) ) % (60 * 60 * 1000) ) % ( 60 * 1000 ) ) / 1000 * 1 );
	var tm = Math.floor( (dd % (60 * 60 * 1000 * 24)) % ((60 * 60 * 1000)) / (60 * 1000) );
	var th = Math.floor( (dd % (60 * 60 * 1000 * 24)) / (60 * 60 * 1000) );

	var sh = ((th < 10) ? "0" : "") + th;
	var sm = ((tm < 10) ? "0" : "") + tm;
	var ss = ((ts < 10) ? "0" : "") + ts;

	return ("" + sh + ":" + sm + ":" + ss);
};

ScormLMS.prototype.calculateSessionTimeSecondsToString = function(seconds) //pg2-knf -inactivity
{
	var dd = seconds * 1000;
	var ts = Math.floor( ( ( (dd % (60 * 60 * 1000 * 24) ) % (60 * 60 * 1000) ) % ( 60 * 1000 ) ) / 1000 * 1 );
	var tm = Math.floor( (dd % (60 * 60 * 1000 * 24)) % ((60 * 60 * 1000)) / (60 * 1000) );
	var th = Math.floor( (dd % (60 * 60 * 1000 * 24)) / (60 * 60 * 1000) );

	var sh = ((th < 10) ? "0" : "") + th;
	var sm = ((tm < 10) ? "0" : "") + tm;
	var ss = ((ts < 10) ? "0" : "") + ts;

	return ("" + sh + ":" + sm + ":" + ss);
};

ScormLMS.prototype.getCMIValue = function(name)
{
	return this.LMSGetValue(name);
};

ScormLMS.prototype.timeToString = function(cDate)
{
  var dd = Math.abs( cDate.getTime() );
  var ts = Math.floor( ( ( (dd % (60 * 60 * 1000 * 24) ) % (60 * 60 * 1000) ) % ( 60 * 1000 ) ) / 1000 * 1 );
  var tm = Math.floor( (dd % (60 * 60 * 1000 * 24)) % ((60 * 60 * 1000)) / (60 * 1000) );
  var th = Math.floor( (dd % (60 * 60 * 1000 * 24)) / (60 * 60 * 1000) );

  var sh = ((th < 10) ? "0" : "") + th;
  var sm = ((tm < 10) ? "0" : "") + tm;
  var ss = ((ts < 10) ? "0" : "") + ts;

  return ("" + sh + ":" + sm + ":" + ss);
};

ScormLMS.prototype.getStudentName = function()
{
	return this.LMSGetValue("cmi.core.student_name");
};

var lms = new ScormLMS();
